/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.integrate.entity.EqEassModel;
import kd.mmc.mrp.integrate.entity.ResourcePlanScheme;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.res.RESErrorMessageUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class EqEassManger {
    private Map<Long, BigDecimal> orgAndTime = new HashMap<Long, BigDecimal>(1000);
    private Map<String, BigDecimal> matidDayAnduse = new HashMap<String, BigDecimal>(1000);
    private Map<String, Long> hastdfinish = new HashMap<String, Long>(1000);
    private ORM orm = ORM.create();

    public Boolean saveBill(AbstractResModelDataTable reqtable, AbstractResModelDataTable suptable, ResourcePlanScheme resourcePlanScheme, IMRPExecuteLogRecorder lr, Long logId) {
        List<EqEassModel> supMap = this.getSupMap(suptable, resourcePlanScheme.getFplanoutlook(), lr);
        if (supMap == null) {
            return false;
        }
        List<EqEassModel> reqMap = this.getReqMap(reqtable, lr);
        if (reqMap == null) {
            return false;
        }
        List<EqEassModel> mergerData = this.MergerData(reqMap, supMap);
        this.savebill(mergerData, resourcePlanScheme, lr, logId);
        return true;
    }

    public List<EqEassModel> getReqMap(AbstractResModelDataTable reqtable, IMRPExecuteLogRecorder lr) {
        GridData reqgd = reqtable.getSrcDatas();
        Map<String, Integer> reqcolIdx = reqtable.getColIdx();
        GridData.Grid datasreq = reqgd.getDatas();
        ArrayList<EqEassModel> lstreq = new ArrayList<EqEassModel>(500);
        if (!datasreq.isEmpty()) {
            long[] genLongIds = ORM.create().genLongIds("mrp_resassessbill", datasreq.size() + 10);
            int index = 0;
            for (Object[] data : datasreq) {
                EqEassModel item = new EqEassModel();
                item.setFentryid(genLongIds[index]);
                ++index;
                item.setFmaterial(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.RESOUCE")], 0L));
                item.setFreqbillid(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.BILLID")], 0L));
                item.setFreqentryid(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.BILLENTRYID")], 0L));
                Long sDate = MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.STARTDATE")], 0L);
                if (sDate <= 0L) continue;
                item.setFreqstime(this.formatDate(new Date(sDate)));
                Long eDate = MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.ENDDATE")], 0L);
                if (eDate <= 0L) continue;
                item.setFreqetime(this.formatDate(new Date(eDate)));
                item.setFreqorg(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.PRODUCTIONORGUNIT")], 0L));
                item.setFreqqty(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.DEMANDQTY")], BigDecimal.valueOf(0L)));
                item.setFunit(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.BASEUNIT")], 0L));
                item.setFcardid(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.MROCARD")], 0L));
                item.setFproject(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.PROJECTNUMBER")], 0L));
                item.setFrequsetime(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.DURATION")], BigDecimal.valueOf(0L)));
                item.setFreqbillno(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.BILLNUMBER")], ""));
                item.setFreqbilltagname(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.SOURCEBILLNAME")], ""));
                item.setFreqbilltag(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.SOURCEBILLTAG")], ""));
                item.setFsubtool(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.TOOLSUB")], 0L));
                item.setFcheckgbill(MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.CHECKEBILL")], 0L));
                item.setFisreq(true);
                lstreq.add(item);
            }
            if (!lstreq.isEmpty()) {
                Collections.sort(lstreq, (o1, o2) -> {
                    Integer i = o1.getFreqstime().compareTo(o2.getFreqstime());
                    if (i == 0) {
                        i = o1.getFreqetime().compareTo(o2.getFreqetime());
                    }
                    return i;
                });
            }
            return lstreq;
        }
        return null;
    }

    public List<EqEassModel> getSupMap(AbstractResModelDataTable suptable, Integer fplanoutlook, IMRPExecuteLogRecorder lr) {
        GridData supgd = suptable.getSrcDatas();
        Map<String, Integer> supcolIdx = suptable.getColIdx();
        GridData.Grid datassup = supgd.getDatas();
        HashSet<Long> orglst = new HashSet<Long>(100);
        for (Object[] data : datassup) {
            Long orgid = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.SUPPLYORGUNIT")], 0L);
            orglst.add(orgid);
        }
        if (!orglst.isEmpty() && !this.checkOrgHasCalendar(orglst, fplanoutlook, lr).booleanValue()) {
            return null;
        }
        List<EqEassModel> lstsup = new ArrayList<EqEassModel>(500);
        for (Object[] data : datassup) {
            EqEassModel item = new EqEassModel();
            item.setFsupqty(MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.USABLESTOQTY")], BigDecimal.valueOf(0L)));
            if (item.getFsupqty().compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
            item.setFsuporg(MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.SUPPLYORGUNIT")], 0L));
            item.setFsupbillid(MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.BILLID")], 0L));
            item.setFmaterial(MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.RESOUCE")], 0L));
            item.setFentryid(MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.BILLENTRYID")], 0L));
            item.setFsupbilltag(MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.SOURCEBILLTAG")], ""));
            item.setFsupbilltagname(MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.SOURCEBILLNAME")], ""));
            lstsup.add(item);
        }
        if (!lstsup.isEmpty()) {
            lstsup = lstsup.stream().collect(Collectors.toMap(EqEassModel::getFmaterial, a -> a, (o1, o2) -> {
                o1.setFsupqty(o1.getFsupqty().add(o2.getFsupqty()));
                return o1;
            })).values().stream().collect(Collectors.toList());
        }
        return lstsup;
    }

    private List<EqEassModel> MergerData(List<EqEassModel> req, List<EqEassModel> sup) {
        ArrayList<EqEassModel> lstres = new ArrayList<EqEassModel>(500);
        lstres.addAll(req);
        for (EqEassModel reqitem : req) {
            Long matid = reqitem.getFmaterial();
            for (EqEassModel supitem : sup) {
                List<EqEassModel> res;
                if (!matid.equals(supitem.getFmaterial()) || (res = this.getSupitem(reqitem, supitem)) == null) continue;
                lstres.addAll(res);
            }
        }
        return lstres;
    }

    private List<EqEassModel> getSupitem(EqEassModel reqitem, EqEassModel supitem) {
        ArrayList<EqEassModel> reslst = new ArrayList<EqEassModel>(500);
        int days = (int)this.daysBetween(reqitem.getFreqstime(), reqitem.getFreqetime());
        BigDecimal reqneedTime = reqitem.getFreqqty().multiply(reqitem.getFrequsetime());
        BigDecimal onedayhastime = this.orgAndTime.get(supitem.getFsuporg());
        if (onedayhastime != null && onedayhastime.compareTo(BigDecimal.valueOf(0L)) > 0) {
            BigDecimal maxSupTime = onedayhastime.multiply(supitem.getFsupqty());
            EqEassModel res = new EqEassModel();
            if (reqitem.getFreqqty().compareTo(supitem.getFsupqty()) < 0) {
                res.setFsupqty(reqitem.getFreqqty());
            } else {
                res.setFsupqty(supitem.getFsupqty());
            }
            res.setFsupstime(reqitem.getFreqstime());
            res.setFmaterial(reqitem.getFmaterial());
            res.setFcardid(reqitem.getFcardid());
            res.setFproject(reqitem.getFproject());
            res.setFsupbillid(supitem.getFsupbillid());
            res.setFsupbilltagname(supitem.getFsupbilltagname());
            res.setFsupbilltag(supitem.getFsupbilltag());
            res.setFentryid(reqitem.getFentryid());
            res.setFreqbillid(reqitem.getFreqbillid());
            res.setFsubtool(reqitem.getFsubtool());
            res.setFcheckgbill(reqitem.getFcheckgbill());
            StringBuilder finishkey = new StringBuilder();
            if (res.getFsubtool() > 0L) {
                finishkey.append(res.getFsubtool());
                finishkey.append("###");
                finishkey.append(res.getFproject());
                finishkey.append("###");
                finishkey.append(res.getFcheckgbill());
                if (this.hastdfinish.containsKey(finishkey.toString())) {
                    return null;
                }
            }
            BigDecimal supusetime = BigDecimal.valueOf(0L);
            for (int i = 0; i < days; ++i) {
                res.setFsupetime(this.dateAddDays(reqitem.getFreqstime(), i));
                BigDecimal onedaySup = onedayhastime.multiply(res.getFsupqty());
                BigDecimal usedDatetime = this.getUsedDatatoMap(res);
                BigDecimal remianDatetime = maxSupTime.subtract(usedDatetime);
                if (remianDatetime.compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                if (remianDatetime.compareTo(onedaySup) < 0) {
                    onedaySup = remianDatetime;
                }
                if (onedaySup.compareTo(reqneedTime) >= 0) {
                    supusetime = supusetime.add(reqneedTime);
                    this.AddUsedDatatoMap(res, reqneedTime);
                    res.setFresult("B");
                    reqitem.setFresult("B");
                    this.hastdfinish.put(finishkey.toString(), res.getFmaterial());
                    break;
                }
                reqneedTime = reqneedTime.subtract(onedaySup);
                supusetime = supusetime.add(onedaySup);
                this.AddUsedDatatoMap(res, onedaySup);
                res.setFresult("C");
                reqitem.setFresult("C");
            }
            res.setFsupusetime(supusetime);
            reslst.add(res);
        }
        if (reslst.isEmpty()) {
            return null;
        }
        return reslst;
    }

    private void AddUsedDatatoMap(EqEassModel res, BigDecimal remainuse) {
        StringBuilder usekey = new StringBuilder();
        usekey.append(res.getFmaterial());
        usekey.append("$$$");
        usekey.append(res.getFsupetime());
        BigDecimal usedtime = this.matidDayAnduse.get(usekey.toString());
        if (usedtime == null) {
            this.matidDayAnduse.put(usekey.toString(), remainuse);
        } else {
            this.matidDayAnduse.put(usekey.toString(), usedtime.add(remainuse));
        }
    }

    private BigDecimal getUsedDatatoMap(EqEassModel res) {
        StringBuilder usekey = new StringBuilder();
        usekey.append(res.getFmaterial());
        usekey.append("$$$");
        usekey.append(res.getFsupetime());
        return this.matidDayAnduse.getOrDefault(usekey.toString(), BigDecimal.valueOf(0L));
    }

    private Boolean checkOrgHasCalendar(Set<Long> orgids, Integer fplanoutlook, IMRPExecuteLogRecorder lr) {
        StringBuilder sb;
        QFilter qFilter = new QFilter("createorg", "in", orgids);
        qFilter.and(new QFilter("calendar", ">", (Object)0));
        qFilter.and(new QFilter("classsysteam", ">", (Object)0));
        Date lookdate = this.dateAddDays(new Date(), fplanoutlook);
        DynamicObjectCollection queryCalendar = QueryServiceHelper.query((String)"fmm_defaultorg", (String)"classsysteam,calendar,classsysteam.classsystemtime,calendar.expiringyearto,calendar.expiringmonthto,createorg,createorg.name ", (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> hasid = new HashSet<Long>(100);
        HashSet<String> errorgname = new HashSet<String>(100);
        for (DynamicObject obj : queryCalendar) {
            hasid.add(obj.getLong("createorg"));
            String year = obj.getString("calendar.expiringyearto");
            String month = obj.getString("calendar.expiringmonthto");
            if (this.comp(lookdate, year, month)) {
                errorgname.add(obj.getString("createorg.name"));
            }
            this.orgAndTime.put(obj.getLong("createorg"), obj.getBigDecimal("classsysteam.classsystemtime"));
        }
        if (!errorgname.isEmpty()) {
            sb = new StringBuilder();
            sb.append("\u3010");
            sb.append(String.join((CharSequence)",", errorgname));
            sb.append("\u3011");
            sb.append(RESErrorMessageUtil.getErrorCalendarDate());
            throw new MRPBizException(new ErrorCode("RESEXEC_NO_DEFAULTORG", sb.toString()));
        }
        orgids.removeAll(hasid);
        if (!orgids.isEmpty()) {
            errorgname = new HashSet(100);
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"name ", (QFilter[])new QFilter[]{new QFilter("id", "in", orgids)});
            for (DynamicObject item : orgs) {
                errorgname.add(item.getString("name"));
            }
        }
        if (!errorgname.isEmpty()) {
            sb = new StringBuilder();
            sb.append("\u3010");
            sb.append(String.join((CharSequence)"\uff0c", errorgname));
            sb.append("\u3011");
            sb.append(RESErrorMessageUtil.getErrorOrgCalendar());
            throw new MRPBizException(new ErrorCode("RESEXEC_NO_CALENDAR", sb.toString()));
        }
        return true;
    }

    private Boolean savebill(List<EqEassModel> item, ResourcePlanScheme resourcePlanScheme, IMRPExecuteLogRecorder lr, Long logId) {
        ArrayList<Long> reqbill = new ArrayList<Long>(1000);
        ArrayList<DynamicObject> lstob = new ArrayList<DynamicObject>();
        for (EqEassModel obj : item) {
            if (reqbill.contains(obj.getFreqbillid())) continue;
            ArrayList<EqEassModel> Onebill = new ArrayList<EqEassModel>(10);
            for (EqEassModel tosave : item) {
                if (!obj.getFreqbillid().equals(tosave.getFreqbillid())) continue;
                Onebill.add(tosave);
            }
            DynamicObject billobj = this.savebillsub(Onebill, resourcePlanScheme, logId);
            reqbill.add(obj.getFreqbillid());
            lstob.add(billobj);
        }
        if (lstob.size() > 0) {
            lr.createSubStepLog(1, String.format(RESErrorMessageUtil.getzypgbillCount(), lstob.size()), lr.getLogIdx());
            lr.updateSubStepLog(0, "entryresult", MRPExecuteStatus.FINISHED.getAlias());
            lr.saveStepLog(false);
            this.orm.insert(lstob);
            this.updateToolneedplan(lstob);
        }
        return true;
    }

    private void updateToolneedplan(List<DynamicObject> lstob) {
        String updateSql = "update t_msplan_tlneedplanentry set fresourcetd=?,fresult = ? where fid = ? and fentryid=? and fresource<>?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(20);
        for (DynamicObject obj : lstob) {
            DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entryentity");
            if (entrys == null) continue;
            for (DynamicObject entry : entrys) {
                long entid = entry.getLong("reqentryid");
                if (entid <= 0L) continue;
                StringBuilder finishkey = new StringBuilder();
                finishkey.append(entry.getLong("subtool"));
                finishkey.append("###");
                finishkey.append(entry.getLong("project"));
                finishkey.append("###");
                finishkey.append(entry.getLong("checkgbillid"));
                Long matid = this.hastdfinish.get(finishkey.toString());
                Object[] p = new Object[5];
                p[0] = 0;
                p[4] = 0;
                if (matid != null) {
                    p[0] = matid;
                    p[4] = matid;
                }
                p[1] = entry.getString("result");
                p[2] = entry.getLong("reqbillid");
                p[3] = entry.getLong("reqentryid");
                params.add(p);
            }
        }
        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updateSql, params);
    }

    private DynamicObject savebillsub(List<EqEassModel> item, ResourcePlanScheme resourcePlanScheme, Long logId) {
        DynamicObject obj = this.orm.newDynamicObject("mrp_resassessbill");
        obj.set("billno", (Object)item.get(0).getFreqbillno());
        obj.set("schemeid", (Object)resourcePlanScheme.getSchemeId());
        obj.set("log", (Object)logId);
        obj.set("org", (Object)item.get(0).getFreqorg());
        obj.set("billstatus", (Object)"A");
        obj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        obj.set("createtime", (Object)new Date());
        obj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        obj.set("modifytime", (Object)new Date());
        DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entryentity");
        DynamicObjectType sType = entrys.getDynamicObjectType();
        ArrayList<Long> entbill = new ArrayList<Long>(1000);
        int indexseq = 0;
        for (EqEassModel entryitem : item) {
            if (entbill.contains(entryitem.getFentryid())) continue;
            for (EqEassModel entryitemsub : item) {
                if (!entryitem.getFentryid().equals(entryitemsub.getFentryid())) continue;
                DynamicObject entry = new DynamicObject(sType);
                entry.set("seq", (Object)(++indexseq));
                entry.set("project", (Object)entryitemsub.getFproject());
                entry.set("cardid", (Object)entryitemsub.getFcardid());
                entry.set("material", (Object)entryitemsub.getFmaterial());
                entry.set("unit", (Object)entryitemsub.getFunit());
                entry.set("result", (Object)entryitemsub.getFresult());
                entry.set("subtool", (Object)entryitemsub.getFsubtool());
                entry.set("checkgbillid", (Object)entryitemsub.getFcheckgbill());
                entry.set("reqbillid", (Object)entryitemsub.getFreqbillid());
                entry.set("reqentryid", (Object)entryitemsub.getFreqentryid());
                if (entryitemsub.getFisreq().booleanValue()) {
                    entry.set("ptype", (Object)"D");
                    entry.set("reqstime", (Object)entryitemsub.getFreqstime());
                    entry.set("reqetime", (Object)entryitemsub.getFreqetime());
                    entry.set("reqbillno", (Object)entryitemsub.getFreqbillno());
                    entry.set("reqbilltagname", (Object)entryitemsub.getFreqbilltagname());
                    entry.set("reqbilltag", (Object)entryitemsub.getFreqbilltag());
                    entry.set("reqqty", (Object)entryitemsub.getFreqqty());
                    entry.set("requsetime", (Object)entryitemsub.getFrequsetime());
                    entry.set("reqorg", (Object)entryitemsub.getFreqorg());
                } else {
                    entry.set("ptype", (Object)"E");
                    entry.set("supstime", (Object)entryitemsub.getFsupstime());
                    entry.set("supetime", (Object)entryitemsub.getFsupetime());
                    entry.set("supbillno", (Object)entryitemsub.getFsupbillno());
                    entry.set("supbilltagname", (Object)entryitemsub.getFsupbilltagname());
                    entry.set("supbilltag", (Object)entryitemsub.getFsupbilltag());
                    entry.set("supqty", (Object)entryitemsub.getFsupqty());
                    entry.set("supusetime", (Object)entryitemsub.getFsupusetime());
                }
                if (entryitemsub.getFsubtool() > 0L && !"B".equalsIgnoreCase(entryitemsub.getFresult())) {
                    StringBuilder finishkey = new StringBuilder();
                    finishkey.append(entryitemsub.getFsubtool());
                    finishkey.append("###");
                    finishkey.append(entryitemsub.getFproject());
                    finishkey.append("###");
                    finishkey.append(entryitemsub.getFcheckgbill());
                    if (this.hastdfinish.containsKey(finishkey.toString())) {
                        entry.set("result", (Object)"E");
                    }
                }
                entrys.add((Object)entry);
            }
            entbill.add(entryitem.getFentryid());
        }
        return obj;
    }

    public Date formatDate(Date curdate) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(curdate);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        return instance.getTime();
    }

    public boolean comp(Date comp, String sYear, String sMonth) {
        Calendar cCal = Calendar.getInstance();
        int iyear = Integer.parseInt(sYear);
        int imonth = Integer.parseInt(sMonth);
        cCal.setTime(comp);
        if (cCal.get(1) > iyear) {
            return true;
        }
        if (cCal.get(1) < iyear) {
            return false;
        }
        return cCal.get(2) > imonth;
    }

    public Date dateAddDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.get(5) + days);
        return calendar.getTime();
    }

    public long daysBetween(Date smdate, Date bdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return between_days + 1L;
    }
}

