/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.integrate.entity.EqNeedPlanEntryModel;
import kd.mmc.mrp.integrate.entity.EqNeedPlanModel;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.res.RESErrorMessageUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class EqNeedPlanManager {
    ORM orm = ORM.create();
    private Map<String, List<Long>> supProjectAndworkscope = new HashMap<String, List<Long>>();
    private static final Log LOG = LogFactory.getLog(EqNeedPlanManager.class);

    public Map<Long, EqNeedPlanModel> getReqMap(AbstractResModelDataTable reqtable, IMRPExecuteLogRecorder lr) {
        GridData reqgd = reqtable.getSrcDatas();
        Map<String, Integer> reqcolIdx = reqtable.getColIdx();
        GridData.Grid datasreq = reqgd.getDatas();
        HashMap<Long, EqNeedPlanModel> eqmap = new HashMap<Long, EqNeedPlanModel>();
        for (Object[] data : datasreq) {
            Long objprj = MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.PROJECTNUMBER")], 0L);
            if (objprj <= 0L) continue;
            EqNeedPlanModel item = (EqNeedPlanModel)eqmap.get(objprj);
            if (item == null) {
                item = new EqNeedPlanModel();
                eqmap.put(objprj, item);
                item.setFproject(objprj);
                item.setFproject(objprj);
                DynamicObjectCollection proinfo = QueryServiceHelper.query((String)"pmpd_project", (String)"id,customer,workscope,fixlevel,fixdevicetype,workcenter", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)objprj)});
                if (!proinfo.isEmpty()) {
                    item.setFcustomer(((DynamicObject)proinfo.get(0)).getLong("customer"));
                    item.setFchecktype(((DynamicObject)proinfo.get(0)).getLong("fixlevel"));
                    item.setFworkscope(((DynamicObject)proinfo.get(0)).getLong("workscope"));
                    item.setFmodel(((DynamicObject)proinfo.get(0)).getLong("fixdevicetype"));
                    item.setFworkcenter(((DynamicObject)proinfo.get(0)).getLong("workcenter"));
                }
            }
            Long cobj = MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.PMPDENTID")], 0L);
            Long bobj = MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.BILLID")], 0L);
            if (item.getForgid() <= 0L) {
                Long orgid = MRPUtil.convert((Object)data[reqcolIdx.get("ENTRYENTITY.PRODUCTIONORGUNIT")].toString(), 0L);
                item.setForgid(orgid);
            }
            EqNeedPlanEntryModel entitem = new EqNeedPlanEntryModel();
            item.getfEntryModels().add(entitem);
            entitem.setFpmpdentid(cobj);
            String taskname = MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.PROJECTTASK")], "");
            entitem.setFstart(taskname);
            entitem.setFstarttaskid(bobj);
            Long standid = MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.STANDARDTASK")], 0L);
            entitem.setFstandardtask(standid);
            item.getFlststandtaskid().add(standid);
            Long SDate = MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.STARTDATE")], 0L);
            if (SDate > 0L) {
                entitem.setFstime(new Date(SDate));
            } else {
                entitem.setFstime(new Date());
            }
            Long EDate = MRPUtil.convert(data[reqcolIdx.get("ENTRYENTITY.ENDDATE")], 0L);
            if (EDate > 0L) {
                entitem.setFftime(new Date(EDate));
                continue;
            }
            entitem.setFftime(new Date());
        }
        return eqmap;
    }

    public Map<String, List<EqNeedPlanEntryModel>> getSupMap(AbstractResModelDataTable suptable, IMRPExecuteLogRecorder lr) {
        GridData supgd = suptable.getSrcDatas();
        Map<String, Integer> supcolIdx = suptable.getColIdx();
        GridData.Grid datassup = supgd.getDatas();
        HashMap<String, List<EqNeedPlanEntryModel>> supmap = new HashMap<String, List<EqNeedPlanEntryModel>>();
        HashMap<Long, Long> specprojectAndworkscope = new HashMap<Long, Long>();
        for (Object[] data : datassup) {
            DynamicObjectCollection specinfo;
            Long itemmrtype = 0L;
            Long cust = 0L;
            Long checktype = 0L;
            try {
                itemmrtype = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.MRTYPE")], 0L);
                cust = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.CUSTOMER")], 0L);
                checktype = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.CHECKTYPE")], 0L);
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
                return null;
            }
            if (itemmrtype <= 0L && cust <= 0L && checktype <= 0L) continue;
            StringBuilder combinkey = new StringBuilder();
            combinkey.append(itemmrtype);
            combinkey.append("###");
            combinkey.append(cust);
            combinkey.append("###");
            combinkey.append(checktype);
            EqNeedPlanEntryModel entitem = new EqNeedPlanEntryModel();
            ArrayList<EqNeedPlanEntryModel> listentry = (ArrayList<EqNeedPlanEntryModel>)supmap.get(combinkey.toString());
            if (listentry == null) {
                listentry = new ArrayList<EqNeedPlanEntryModel>();
                supmap.put(combinkey.toString(), listentry);
            }
            listentry.add(entitem);
            Long staskid = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.STARTID")], 0L);
            entitem.setFpmpdentid(staskid);
            Long etaskid = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.ENDID")], 0L);
            entitem.setFendpmpdentid(etaskid);
            BigDecimal qty = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.QTY")], BigDecimal.valueOf(0L));
            entitem.setFqty(qty);
            Long unitid = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.PRODUNIT")], 0L);
            entitem.setFunit(unitid);
            Long resouce = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.RESOUCE")], 0L);
            BigDecimal usetime = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.DURATION")], BigDecimal.valueOf(0L));
            BigDecimal plantime = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.PLANTIME")], BigDecimal.valueOf(0L));
            Long specproject = MRPUtil.convert(data[supcolIdx.get("ENTRYENTITY.SPECPORJECT")], 0L);
            entitem.setFplantime(plantime);
            entitem.setFspecproject(specproject);
            entitem.setFusetime(usetime);
            entitem.setFresource(resouce);
            entitem.setFcustomer(cust);
            entitem.setFchecktype(checktype);
            if (specproject <= 0L) continue;
            Long workscopeid = (Long)specprojectAndworkscope.get(specproject);
            if (workscopeid == null && !(specinfo = QueryServiceHelper.query((String)"mpdm_specproject", (String)"id,workinfo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)specproject)})).isEmpty()) {
                workscopeid = ((DynamicObject)specinfo.get(0)).getLong("workinfo");
                specprojectAndworkscope.put(specproject, workscopeid);
            }
            if (workscopeid == null) continue;
            entitem.setFworkscope(workscopeid);
            List<Long> workscopelist = this.supProjectAndworkscope.get(combinkey.toString());
            if (workscopelist != null) continue;
            workscopelist = this.getWorkScopeDetail(entitem.getFworkscope());
            this.supProjectAndworkscope.put(combinkey.toString(), workscopelist);
        }
        return supmap;
    }

    private List<Long> getWorkScopeDetail(Long WorkScopeid) {
        return (List)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"select fbasedataid from t_mpdm_wrokscp_detail where fid=?", (Object[])new Object[]{WorkScopeid}, rs -> {
            ArrayList<Long> lstid = new ArrayList<Long>(20);
            while (rs.next()) {
                lstid.add(rs.getLong(1));
            }
            return lstid;
        });
    }

    public void setMaxAndMinDate(Map<Long, EqNeedPlanModel> reqmap) {
        for (Map.Entry<Long, EqNeedPlanModel> item : reqmap.entrySet()) {
            EqNeedPlanModel value = item.getValue();
            List<EqNeedPlanEntryModel> EntryModels = value.getfEntryModels();
            Boolean findvala = false;
            Boolean findvalb = false;
            if (EntryModels.size() > 0) {
                for (EqNeedPlanEntryModel entryitem : EntryModels) {
                    if (entryitem.getFftime() != null && value.getMaxdate().compareTo(entryitem.getFftime()) < 0) {
                        value.setMaxdate(entryitem.getFftime());
                        findvala = true;
                    }
                    if (entryitem.getFstime() == null || value.getMindate().compareTo(entryitem.getFstime()) <= 0) continue;
                    value.setMindate(entryitem.getFstime());
                    findvalb = true;
                }
            }
            if (!findvala.booleanValue()) {
                value.setMaxdate(value.stringToDate("2099-12-31"));
            }
            if (findvalb.booleanValue()) continue;
            value.setMindate(value.stringToDate("1900-01-01"));
        }
    }

    public Boolean saveBill(Map<Long, EqNeedPlanModel> reqmap, Map<String, List<EqNeedPlanEntryModel>> supmap, IMRPExecuteLogRecorder lr, Long logId) {
        String[] codelst;
        DynamicObject obj2;
        Long billtype = this.getBilltype();
        if (billtype == 0L) {
            lr.updateSubStepLog(lr.getLogIdx(), "entrydetailmsg", RESErrorMessageUtil.getbilltypeError());
            return false;
        }
        for (Map.Entry<Long, EqNeedPlanModel> item : reqmap.entrySet()) {
            List<EqNeedPlanEntryModel> OtherNeedPlanentry;
            List<EqNeedPlanEntryModel> mergerOtherEntry;
            List<EqNeedPlanEntryModel> reqentrylst;
            StringBuilder mergerkey = new StringBuilder();
            mergerkey.append(item.getValue().getFmodel());
            mergerkey.append("###");
            mergerkey.append(item.getValue().getFcustomer());
            mergerkey.append("###");
            mergerkey.append(item.getValue().getFchecktype());
            List<EqNeedPlanEntryModel> supentrylst = supmap.get(mergerkey.toString());
            if (supentrylst == null) continue;
            List<Long> supworkscopedetail = this.supProjectAndworkscope.get(mergerkey.toString());
            if (supworkscopedetail != null) {
                Long workscopeid = item.getValue().getFworkscope();
                List<Long> reqworkscopedetail = this.getWorkScopeDetail(workscopeid);
                if (!reqworkscopedetail.containsAll(supworkscopedetail)) continue;
                for (EqNeedPlanEntryModel supitem : supentrylst) {
                    if (supitem.getFspecproject() <= 0L) continue;
                    supitem.setFsourcetype("1");
                }
            }
            if ((reqentrylst = item.getValue().getfEntryModels()).size() <= 0) {
                item.getValue().getfEntryModels().addAll(supentrylst);
            } else {
                List<EqNeedPlanEntryModel> mergerEntry = this.MergerEntry(reqentrylst, supentrylst, item.getValue().getMaxdate(), item.getValue().getMindate());
                item.getValue().setfEntryModels(mergerEntry);
            }
            if ((mergerOtherEntry = this.MergerEntry2(reqentrylst, OtherNeedPlanentry = this.MergerOtherNeedPlan(item), item.getValue().getMaxdate(), item.getValue().getMindate())).isEmpty()) continue;
            item.getValue().getfEntryModels().addAll(mergerOtherEntry);
        }
        ArrayList<DynamicObject> lstob = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> lstadvob = new ArrayList<DynamicObject>();
        ArrayList<Long> delprojectid = new ArrayList<Long>();
        for (Map.Entry<Long, EqNeedPlanModel> item : reqmap.entrySet()) {
            DynamicObject obj;
            if (this.getBillStatByProject(item.getKey()) > 0L) continue;
            List<Long> billidByProject = this.getBillidByProject(item.getKey());
            if (!billidByProject.isEmpty()) {
                delprojectid.addAll(billidByProject);
            } else {
                DynamicObjectCollection billIsAdv = this.getBillIsAdvType(item.getKey());
                if (billIsAdv != null && !billIsAdv.isEmpty()) {
                    DynamicObject objadv = this.modelToDobjAdv(item.getValue(), billIsAdv, logId);
                    if (objadv == null) continue;
                    lstadvob.add(objadv);
                    continue;
                }
            }
            if ((obj = this.modelToDobj(item.getValue(), billtype)) == null) continue;
            lstob.add(obj);
        }
        if (delprojectid.size() > 0) {
            DeleteServiceHelper.delete((String)"msplan_eqneedplan", (QFilter[])new QFilter[]{new QFilter("id", "in", delprojectid)});
        }
        int logindex = 0;
        if (lstob.size() > 0) {
            int i = 0;
            obj2 = this.orm.newDynamicObject("msplan_eqneedplan");
            codelst = CodeRuleServiceHelper.getBatchNumber((String)"msplan_eqneedplan", (DynamicObject)obj2, (String)((DynamicObject)lstob.get(0)).getString("org"), (int)lstob.size());
            for (DynamicObject itemobj : lstob) {
                if (codelst == null || codelst.length <= 0) {
                    itemobj.set("billno", (Object)itemobj.getPkValue().toString());
                } else {
                    itemobj.set("billno", (Object)codelst[i]);
                }
                ++i;
            }
            lr.createSubStepLog(++logindex, String.format(RESErrorMessageUtil.getbillCount(), lstob.size()), lr.getLogIdx());
            lr.updateSubStepLog(logindex - 1, "entryresult", MRPExecuteStatus.FINISHED.getAlias());
            lr.saveStepLog(false);
            this.orm.insert(lstob);
        }
        if (lstadvob.size() > 0) {
            int i = 0;
            obj2 = this.orm.newDynamicObject("msplan_eqtneedplan");
            codelst = CodeRuleServiceHelper.getBatchNumber((String)"msplan_eqtneedplan", (DynamicObject)obj2, (String)((DynamicObject)lstadvob.get(0)).getString("org"), (int)lstadvob.size());
            for (DynamicObject itemobj : lstadvob) {
                if (codelst == null || codelst.length <= 0) {
                    itemobj.set("billno", (Object)itemobj.getPkValue().toString());
                } else {
                    itemobj.set("billno", (Object)codelst[i]);
                }
                ++i;
            }
            lr.createSubStepLog(++logindex, String.format(RESErrorMessageUtil.gettzbillCount(), lstadvob.size()), lr.getLogIdx());
            lr.updateSubStepLog(logindex - 1, "entryresult", MRPExecuteStatus.FINISHED.getAlias());
            lr.saveStepLog(false);
            this.orm.insert(lstadvob);
        }
        return true;
    }

    private DynamicObject modelToDobjAdv(EqNeedPlanModel eqobj, DynamicObjectCollection billIsAdv, Long logid) {
        DynamicObject entry;
        DynamicObject obj = this.orm.newDynamicObject("msplan_eqtneedplan");
        obj.set("model", (Object)eqobj.getFmodel());
        obj.set("project", (Object)eqobj.getFproject());
        obj.set("workcenter", (Object)eqobj.getFworkcenter());
        obj.set("org", (Object)eqobj.getForgid());
        obj.set("datasource", (Object)"B");
        obj.set("billstatus", (Object)"A");
        obj.set("workstatus", (Object)"C");
        obj.set("ecnstatus", (Object)"A");
        obj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        obj.set("createtime", (Object)new Date());
        obj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        obj.set("modifytime", (Object)new Date());
        obj.set("logid", (Object)logid);
        obj.set("srcbillid", (Object)((DynamicObject)billIsAdv.get(0)).getLong("id"));
        obj.set("isdeal", (Object)false);
        DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entryentity");
        DynamicObjectType sType = entrys.getDynamicObjectType();
        boolean isfind = false;
        for (DynamicObject advobj : billIsAdv) {
            isfind = false;
            for (EqNeedPlanEntryModel newobj : eqobj.getfEntryModels()) {
                if (newobj.getFisCompare().booleanValue() || !newobj.getFstarttaskid().equals(advobj.getLong("entryentity.starttaskid")) || !newobj.getFendtaskid().equals(advobj.getLong("entryentity.endtaskid")) || !newobj.getFresource().equals(advobj.getLong("entryentity.resource"))) continue;
                newobj.setFisCompare(true);
                DynamicObject entry2 = this.MergerEqNeedPlanEntry(advobj, newobj, sType);
                if (entry2 != null) {
                    entrys.add((Object)entry2);
                }
                isfind = true;
                break;
            }
            if (isfind || (entry = this.MergerEqNeedPlanEntry(advobj, null, sType)) == null) continue;
            entrys.add((Object)entry);
        }
        for (EqNeedPlanEntryModel newobj : eqobj.getfEntryModels()) {
            if (newobj.getFisCompare().booleanValue() || (entry = this.MergerEqNeedPlanEntry(null, newobj, sType)) == null) continue;
            entrys.add((Object)entry);
        }
        if (entrys.isEmpty()) {
            return null;
        }
        return obj;
    }

    private DynamicObject MergerEqNeedPlanEntry(DynamicObject sourceobj, EqNeedPlanEntryModel item, DynamicObjectType sType) {
        DynamicObject entry = new DynamicObject(sType);
        entry.set("pgres", (Object)"A");
        if (sourceobj != null) {
            entry.set("advtype", (Object)",B");
            entry.set("uselevel", (Object)"A");
            entry.set("resource", (Object)sourceobj.getLong("entryentity.resource"));
            entry.set("start", (Object)sourceobj.getString("entryentity.start"));
            entry.set("starttaskid", (Object)sourceobj.getLong("entryentity.starttaskid"));
            entry.set("end", (Object)sourceobj.getString("entryentity.end"));
            entry.set("endtaskid", (Object)sourceobj.getLong("entryentity.endtaskid"));
            entry.set("qty", (Object)sourceobj.getBigDecimal("entryentity.qty"));
            entry.set("unit", (Object)sourceobj.getLong("entryentity.unit"));
            entry.set("stime", (Object)sourceobj.getDate("entryentity.stime"));
            entry.set("ftime", (Object)sourceobj.getDate("entryentity.ftime"));
            entry.set("srcentryid", sourceobj.get("entryentity.id"));
        }
        if (item != null) {
            entry.set("advtype", (Object)",A");
            entry.set("uselevel", (Object)"A");
            entry.set("advqty", (Object)item.getFqty());
            entry.set("advstime", (Object)item.getFstime());
            entry.set("advftime", (Object)item.getFftime());
            if (sourceobj == null) {
                entry.set("start", (Object)item.getFstart());
                entry.set("starttaskid", (Object)item.getFstarttaskid());
                entry.set("end", (Object)item.getFend());
                entry.set("endtaskid", (Object)item.getFendtaskid());
                if (item.getFresource() <= 0L) {
                    return null;
                }
                entry.set("resource", (Object)item.getFresource());
                entry.set("unit", (Object)item.getFunit());
            }
        }
        if (item != null && sourceobj != null) {
            StringBuilder sbtype = new StringBuilder();
            if (item.getFqty().compareTo(sourceobj.getBigDecimal("entryentity.qty")) != 0) {
                sbtype.append(",C");
            }
            if (!this.compareDate(item.getFftime(), sourceobj.getDate("entryentity.ftime")).booleanValue() || !this.compareDate(item.getFstime(), sourceobj.getDate("entryentity.stime")).booleanValue()) {
                sbtype.append(",D");
            }
            if (sbtype.length() <= 0) {
                return null;
            }
            entry.set("advtype", (Object)sbtype.toString());
        }
        return entry;
    }

    private Boolean compareDate(Date adate, Date bdate) {
        if (adate == null || bdate == null) {
            return false;
        }
        Calendar nCal = Calendar.getInstance();
        nCal.setTime(adate);
        Calendar cCal = Calendar.getInstance();
        cCal.setTime(bdate);
        if (cCal.get(1) == nCal.get(1) && cCal.get(2) == nCal.get(2) && cCal.get(5) == nCal.get(5) && cCal.get(11) == nCal.get(11)) {
            return true;
        }
        return false;
    }

    private DynamicObject modelToDobj(EqNeedPlanModel eqobj, Long billtype) {
        DynamicObject obj = this.orm.newDynamicObject("msplan_eqneedplan");
        obj.set("model", (Object)eqobj.getFmodel());
        obj.set("project", (Object)eqobj.getFproject());
        obj.set("workcenter", (Object)eqobj.getFworkcenter());
        obj.set("workcenter", (Object)eqobj.getFworkcenter());
        obj.set("billtype", (Object)billtype);
        obj.set("org", (Object)eqobj.getForgid());
        obj.set("datasource", (Object)"B");
        obj.set("billstatus", (Object)"A");
        obj.set("workstatus", (Object)"C");
        obj.set("ecnstatus", (Object)"A");
        obj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        obj.set("createtime", (Object)new Date());
        obj.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        obj.set("modifytime", (Object)new Date());
        DynamicObjectCollection entrys = obj.getDynamicObjectCollection("entryentity");
        DynamicObjectType sType = entrys.getDynamicObjectType();
        for (EqNeedPlanEntryModel item : eqobj.getfEntryModels()) {
            if (item.getFresource() <= 0L) continue;
            DynamicObject entry = new DynamicObject(sType);
            entry.set("start", (Object)item.getFstart());
            entry.set("starttaskid", (Object)item.getFstarttaskid());
            entry.set("end", (Object)item.getFend());
            entry.set("endtaskid", (Object)item.getFendtaskid());
            entry.set("resource", (Object)item.getFresource());
            entry.set("qty", (Object)item.getFqty());
            entry.set("unit", (Object)item.getFunit());
            entry.set("stime", (Object)item.getFstime());
            entry.set("ftime", (Object)item.getFftime());
            entry.set("sourcetype", (Object)RESErrorMessageUtil.getEqSourceType((String)item.getFsourcetype()));
            entry.set("plantime", (Object)item.getFplantime().multiply(item.getFqty()));
            entry.set("usetime", (Object)item.getFusetime());
            entry.set("key", (Object)item.getFkey());
            entry.set("choose", (Object)item.getFchoose());
            entry.set("pgres", (Object)"A");
            entrys.add((Object)entry);
        }
        if (entrys.size() <= 0) {
            return null;
        }
        return obj;
    }

    private List<EqNeedPlanEntryModel> MergerOtherNeedPlan(Map.Entry<Long, EqNeedPlanModel> item) {
        ArrayList<EqNeedPlanEntryModel> res = new ArrayList<EqNeedPlanEntryModel>(100);
        ArrayList<EqNeedPlanEntryModel> res2 = new ArrayList<EqNeedPlanEntryModel>(100);
        QFilter qFilter = new QFilter("project", "=", (Object)item.getKey());
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObjectCollection listitem = QueryServiceHelper.query((String)"msplan_otherneedplan", (String)this.getOtherBillField(), (QFilter[])new QFilter[]{qFilter});
        if (listitem != null && listitem.size() > 0) {
            for (DynamicObject entryitem : listitem) {
                EqNeedPlanEntryModel eqitem = new EqNeedPlanEntryModel();
                eqitem.setFsourcetype("3");
                eqitem.setFstart(entryitem.getString("entryentity.start"));
                eqitem.setFstarttaskid(entryitem.getLong("entryentity.starttaskid"));
                eqitem.setFend(entryitem.getString("entryentity.end"));
                eqitem.setFendtaskid(entryitem.getLong("entryentity.endtaskid"));
                eqitem.setFresource(entryitem.getLong("entryentity.resource"));
                eqitem.setFqty(entryitem.getBigDecimal("entryentity.qty"));
                eqitem.setFunit(entryitem.getLong("entryentity.unit"));
                eqitem.setFkey(entryitem.getBoolean("entryentity.key"));
                eqitem.setFchoose(entryitem.getBoolean("entryentity.choose"));
                eqitem.setFusetime(entryitem.getBigDecimal("entryentity.resource.usetime"));
                eqitem.setFplantime(entryitem.getBigDecimal("entryentity.resource.plantime"));
                res.add(eqitem);
            }
        }
        for (EqNeedPlanEntryModel item1 : res) {
            Boolean isfind = false;
            for (EqNeedPlanEntryModel item2 : res2) {
                if (!item2.getFstarttaskid().equals(item1.getFstarttaskid()) || !item2.getFendtaskid().equals(item1.getFendtaskid()) || !item2.getFresource().equals(item1.getFresource())) continue;
                item2.setFqty(item1.getFqty().add(item2.getFqty()));
                item2.setFusetime(item1.getFusetime().add(item2.getFusetime()));
                item2.setFplantime(item1.getFplantime().add(item2.getFplantime()));
                isfind = true;
                break;
            }
            if (isfind.booleanValue()) continue;
            res2.add(item1);
        }
        return res2;
    }

    private String getOtherBillField() {
        StringBuilder lst = new StringBuilder();
        lst.append("id,");
        lst.append("entryentity.id,");
        lst.append("entryentity.start,");
        lst.append("entryentity.starttaskid,");
        lst.append("entryentity.end,");
        lst.append("entryentity.endtaskid,");
        lst.append("entryentity.resource,");
        lst.append("entryentity.qty,");
        lst.append("entryentity.unit,");
        lst.append("entryentity.stime,");
        lst.append("entryentity.ftime,");
        lst.append("entryentity.key,");
        lst.append("entryentity.choose,");
        lst.append("entryentity.resource.usetime,");
        lst.append("entryentity.resource.plantime");
        return lst.toString();
    }

    private DynamicObjectCollection getBillIsAdvType(Long projectid) {
        QFilter qF = new QFilter("project", "=", (Object)projectid);
        qF.and(new QFilter("billstatus", "=", (Object)"C"));
        qF.and(new QFilter("workstatus", "=", (Object)"C"));
        return QueryServiceHelper.query((String)"msplan_eqneedplan", (String)this.getOtherBillField(), (QFilter[])new QFilter[]{qF});
    }

    private List<Long> getBillidByProject(Long projectid) {
        return (List)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"select fid from  t_msplan_eqneedplan where fbillstatus<>'C' and fproject =?", (Object[])new Object[]{projectid}, rs -> {
            ArrayList<Long> res = new ArrayList<Long>(100);
            while (rs.next()) {
                res.add(rs.getLong(1));
            }
            return res;
        });
    }

    private Long getBillStatByProject(Long projectid) {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"select fid from  t_msplan_eqneedplan where fbillstatus='C' and fworkstatus<>'C' and fproject =?", (Object[])new Object[]{projectid}, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    private Long getBilltype() {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)"select fid from T_BAS_BILLTYPE where fbillformid ='msplan_eqneedplan' and fisdefault ='1'", rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    private List<EqNeedPlanEntryModel> MergerEntry(List<EqNeedPlanEntryModel> req, List<EqNeedPlanEntryModel> sup, Date maxdate, Date mindate) {
        ArrayList<EqNeedPlanEntryModel> res = new ArrayList<EqNeedPlanEntryModel>(100);
        for (EqNeedPlanEntryModel citem : sup) {
            EqNeedPlanEntryModel resitem = citem.CopyModel();
            for (EqNeedPlanEntryModel pitem : req) {
                if (citem.getFpmpdentid().equals(pitem.getFpmpdentid()) && citem.getFpmpdentid() > 0L) {
                    resitem.setFstart(pitem.getFstart());
                    resitem.setFstarttaskid(pitem.getFstarttaskid());
                    resitem.setFstime(pitem.getFstime());
                }
                if (!citem.getFendpmpdentid().equals(pitem.getFpmpdentid()) || citem.getFendpmpdentid() <= 0L) continue;
                resitem.setFend(pitem.getFstart());
                resitem.setFendtaskid(pitem.getFstarttaskid());
                resitem.setFftime(pitem.getFftime());
            }
            if (resitem.getFftime() == null) {
                resitem.setFftime(maxdate);
            }
            if (resitem.getFstime() == null) {
                resitem.setFstime(mindate);
            }
            res.add(resitem);
        }
        return res;
    }

    private List<EqNeedPlanEntryModel> MergerEntry2(List<EqNeedPlanEntryModel> req, List<EqNeedPlanEntryModel> sup, Date maxdate, Date mindate) {
        ArrayList<EqNeedPlanEntryModel> res = new ArrayList<EqNeedPlanEntryModel>(100);
        for (EqNeedPlanEntryModel citem : sup) {
            EqNeedPlanEntryModel resitem = citem.CopyModel();
            for (EqNeedPlanEntryModel pitem : req) {
                if (citem.getFstarttaskid().equals(pitem.getFstarttaskid()) && pitem.getFstarttaskid() > 0L) {
                    resitem.setFstime(pitem.getFstime());
                }
                if (!citem.getFendtaskid().equals(pitem.getFstarttaskid()) || pitem.getFstarttaskid() <= 0L) continue;
                resitem.setFftime(pitem.getFftime());
            }
            if (resitem.getFftime() == null) {
                resitem.setFftime(maxdate);
            }
            if (resitem.getFstime() == null) {
                resitem.setFstime(mindate);
            }
            res.add(resitem);
        }
        return res;
    }
}

