/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.common.util.MRPORGUtil;
import kd.mmc.mrp.common.util.SupplypriorityComparotor;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.fomula.Expr;
import kd.mmc.mrp.framework.fomula.ParseException;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.IResDataInfo;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.model.PriorityLevelFieldSrcDefine;
import kd.mmc.mrp.model.PrioritySettingDatas;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.StockSetUpEnum;
import kd.mmc.mrp.model.enums.select.PriorityEntryFieldType;
import kd.mmc.mrp.model.enums.status.MRPPlanModelStatus;
import kd.mmc.mrp.model.enums.strategy.BillSplitStrategy;
import kd.mmc.mrp.model.enums.strategy.BillSupplyStrategy;
import kd.mmc.mrp.model.enums.strategy.OORBillResolveStrategy;
import kd.mmc.mrp.model.enums.strategy.PriorityLevelApplyType;
import kd.mmc.mrp.model.enums.strategy.PriorityLevelCalcMode;
import kd.mmc.mrp.model.struct.InvSupplyStruct;
import kd.mmc.mrp.model.struct.InvWareHouseStruct;
import kd.mmc.mrp.model.struct.MaterialStruct;
import kd.mmc.mrp.model.struct.OrgSupplyStruct;
import kd.mmc.mrp.model.struct.SupplyOrgTypeStruct;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.DynamicPriorityLevelDataTable;
import kd.mpscmm.msplan.mrp.business.helper.PlanScopeHelper;

public class PlanModel
implements IResDataInfo {
    protected DynamicObject plan;
    private HashSet<String> orgs = new HashSet();
    private HashSet<String> requirorgs = new HashSet();
    private HashSet<String> supplyorgs = new HashSet();
    private HashMap<String, SupplyStruct> priorityRelations = new HashMap();
    private HashMap<String, List<InvWareHouseStruct>> centerWarehouse = new HashMap();
    private HashMap<String, BillSplitStrategy> strategys;
    private HashMap<Integer, String> attr2BillType = new HashMap();
    private CalEnv env;
    private DynamicObjectCollection resPrioritys;
    private HashSet<String> enabledRequires;
    private HashSet<String> enabledSupplys;
    private List<Long> allPlanTags;
    private Map<String, String> wipSupply2Require = new HashMap<String, String>();
    private boolean isSpecialPlan = false;
    private boolean isEnablePlanScope = false;
    private Long invLevelId = -1L;
    private final Map<String, SupplyOrgTypeStruct> defSupplyOrgTypeStructCache = new HashMap<String, SupplyOrgTypeStruct>(4);
    private int[] prioritys;

    public PlanModel(CalEnv env) {
        this.env = env;
        env.addService(PlanModel.class, this);
    }

    public void init() {
        RunLogModel runLogModel = (RunLogModel)this.env.getService(RunLogModel.class);
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        Long planId = runLogModel.getPlanId();
        String planEntity = runLogModel.getPlanEntity();
        this.plan = cacheDatas.reloadDataById(planEntity, planId);
        this.setDefaultInvlevel();
        if (!MRPPlanModelStatus.APPROVED.getValue().equals(this.plan.getString("status"))) {
            throw new MRPBizException(Errors.getUnapprovedPlan(), this.plan.getString("number"));
        }
        this.isEnablePlanScope = PlanScopeHelper.isEnablePlanScope() && this.planGramHasPropertyContainEntryFields("entryplanscope");
        this.initOrgFilters();
        this.initAttr2BillType();
        this.getResPrioritys().sort((Comparator)new SupplypriorityComparotor());
    }

    public boolean isSpecialPlan() {
        return this.isSpecialPlan;
    }

    public boolean isEnablePlanScope() {
        return this.isEnablePlanScope;
    }

    private void setDefaultInvlevel() {
        Boolean cfgValue = (Boolean)this.env.getCfgValue(EnvCfgItem.INV_LEVEL_CALC);
        IMRPExecuteLogRecorder log = this.env.createLogRecorder();
        if (cfgValue.booleanValue()) {
            Long invLevel;
            boolean reorderPoint = this.isReorderPoint();
            boolean maxMinInventory = this.isMaxMinInventory();
            if ((reorderPoint || maxMinInventory) && (invLevel = this.getInvLevel()) != null && invLevel > 0L) {
                DynamicObject invLevelObj = BusinessDataServiceHelper.loadSingle((Object)invLevel, (String)"msplan_invlevel");
                this.plan.set("invlevel", (Object)invLevelObj);
            }
        } else {
            IMRPEnvProvider ctx = (IMRPEnvProvider)this.env;
            if (!ctx.isMRP() && !ctx.isMPS()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u542f\u7528\u5e93\u5b58\u6c34\u4f4d\u8ba1\u7b97\u53c2\u6570\uff0c\u4e0d\u80fd\u53ea\u8fd0\u884c\u518d\u8ba2\u8d27\u70b9\u6216\u6700\u5927\u6700\u5c0f\u5e93\u5b58\u8ba1\u7b97\u3002", (String)"PlanModel_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
            }
        }
    }

    public List<Long> getAllPlanTags() {
        if (this.allPlanTags != null) {
            return this.allPlanTags;
        }
        ArrayList<Long> list = new ArrayList<Long>(0);
        Object value = this.getPlanDataByParam("plantags");
        if (value instanceof DynamicObjectCollection) {
            list = new ArrayList(((DynamicObjectCollection)value).size());
            for (DynamicObject data : (DynamicObjectCollection)value) {
                Long planTagId = data.getLong("fbasedataid_id");
                list.add(planTagId);
            }
        }
        this.allPlanTags = list;
        return list;
    }

    public PriorityLevelCalcMode getPriorityLevelCalcMode() {
        String cm = this.plan.getString("computemode");
        return PriorityLevelCalcMode.parse(cm);
    }

    public PriorityLevelApplyType getPriorityLevelApplyType() {
        String appmode = (String)this.plan.get("appmode");
        return PriorityLevelApplyType.parse(appmode);
    }

    public Object getTolerOfForward() {
        return this.plan.get("earlytoler");
    }

    public Object getTolerOfDelay() {
        return this.plan.get("delaytoler");
    }

    public int getPlanOutLook() {
        return this.plan.getInt("planoutlook");
    }

    public Object advanceAdjustPeriod() {
        return this.plan.get("allowleadtime");
    }

    public Object delayAdjustPeriod() {
        return this.plan.get("allowdelaytime");
    }

    public int requireDelayPeriod() {
        if ("1".equalsIgnoreCase(this.plan.getString("outofdate"))) {
            return -1;
        }
        return this.plan.getInt("day");
    }

    public int supplyDelayPeriod() {
        if ("1".equalsIgnoreCase(this.plan.getString("scoutofdate"))) {
            return -1;
        }
        return this.plan.getInt("scday");
    }

    public Long getCompOrgId() {
        return 0L;
    }

    public String getPlanOrgId() {
        return this.plan.getDynamicObject("createorg").getString("id");
    }

    public boolean isScrapRation() {
        return this.plan.getBoolean("islossrate");
    }

    public boolean isYield() {
        return this.plan.getBoolean("isyield");
    }

    public boolean isReplace() {
        return this.plan.getBoolean("isreplace");
    }

    public String getAdjustEffectSet() {
        return this.plan.getString("adjusteffectset");
    }

    public boolean isMRP() {
        return this.plan.getBoolean("ismrp");
    }

    public boolean isMPS() {
        return this.plan.getBoolean("ismps");
    }

    public boolean isReorderPoint() {
        return this.plan.getBoolean("isreorderpoint");
    }

    public boolean isMaxMinInventory() {
        return this.plan.getBoolean("hiloinv");
    }

    public Long getInvLevel() {
        Boolean cfgValue = (Boolean)this.env.getCfgValue(EnvCfgItem.INV_LEVEL_CALC);
        if (cfgValue.booleanValue()) {
            if (this.invLevelId == null || this.invLevelId != -1L) {
                return this.invLevelId;
            }
            IDataEntityType dataEntityType = this.plan.getDataEntityType();
            boolean exist = dataEntityType.getProperties().containsKey((Object)"invlevel");
            if (!exist) {
                return null;
            }
            DynamicObject invDyn = this.plan.getDynamicObject("invlevel");
            this.invLevelId = invDyn == null ? this.getDefaultInvlevelId() : Long.valueOf(invDyn.getLong("id"));
            return this.invLevelId;
        }
        return null;
    }

    private Long getDefaultInvlevelId() {
        String ctrlView = MRPORGUtil.getCtrlViewByEntityType((String)"msplan_invlevel");
        Long planOrgId = Long.parseLong(this.getPlanOrgId());
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter typeFilter = new QFilter("type", "=", (Object)"A");
        Long resultId = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PlanModel", (String)"msplan_invlevel", (String)"id,createorg,ctrlstrategy", (QFilter[])new QFilter[]{statusFilter, enableFilter, typeFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long createorg = 0L;
                if (row.get("createorg") != null) {
                    createorg = row.getLong("createorg");
                }
                if (planOrgId.equals(createorg)) {
                    Long l = row.getLong("id");
                    return l;
                }
                if (row.get("ctrlstrategy") != null && "5".equals(row.getString("ctrlstrategy"))) {
                    resultId = row.getLong("id");
                }
                if (resultId != null || row.get("ctrlstrategy") == null || !"6".equals(row.getString("ctrlstrategy"))) continue;
                HashSet<Long> orgSet = new HashSet<Long>(16);
                List superOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlView, (long)createorg);
                ArrayList<Long> orgList = new ArrayList<Long>(2);
                orgList.add(createorg);
                List subOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)ctrlView, orgList, (boolean)true);
                this.addScopeOrgs(orgSet, superOrgs);
                this.addScopeOrgs(orgSet, subOrgs);
                if (!orgSet.contains(planOrgId)) continue;
                resultId = row.getLong("id");
            }
        }
        return resultId;
    }

    private void addScopeOrgs(Set<Long> orgSet, List<Long> superOrgs) {
        for (Long org : superOrgs) {
            orgSet.add(org);
        }
    }

    public OORBillResolveStrategy getOORDataResolveStrategy() {
        return OORBillResolveStrategy.parse(this.plan.getString("outofrange"));
    }

    public boolean isStandardPart() {
        return this.plan.getBoolean("iscommon");
    }

    public boolean isSpecialPart() {
        return this.plan.getBoolean("iscustomize");
    }

    public boolean isChoosablePart() {
        return this.plan.getBoolean("isselection");
    }

    public boolean isUnrecongnisePart() {
        return this.plan.getBoolean("isnotsetup");
    }

    public boolean isCenterWarehouse() {
        return this.planGramHasProperty("iscenterwarehouse") && this.plan.getBoolean("iscenterwarehouse");
    }

    public boolean isReserve() {
        return this.planGramHasProperty("isreserve") && this.plan.getBoolean("isreserve");
    }

    public String getReleaseMode() {
        return (String)this.getPlanDataByParam("releasemode", "");
    }

    public String getOcpWeakReserve() {
        return (String)this.getPlanDataByParam("ocpweakreserve", "");
    }

    private boolean planGramHasProperty(String prop) {
        DataEntityPropertyCollection depc = this.plan.getDataEntityType().getProperties();
        return depc.containsKey((Object)prop);
    }

    private boolean planGramHasPropertyContainEntryFields(String prop) {
        if (this.plan.getDataEntityType() instanceof MainEntityType) {
            return ((MainEntityType)this.plan.getDataEntityType()).getAllFields().containsKey(prop);
        }
        return false;
    }

    public Object getPlanDataByParam(String param) {
        return this.getPlanDataByParam(param, null);
    }

    public Object getPlanDataByParam(String param, Object defaultValue) {
        if (this.plan == null) {
            return defaultValue;
        }
        if (this.planGramHasProperty(param)) {
            return this.plan.get(param);
        }
        return defaultValue;
    }

    private void initStrategys() {
        this.strategys = new HashMap();
        DynamicObjectCollection entrys = this.plan.getDynamicObjectCollection("rearentryentity");
        for (DynamicObject e : entrys) {
            DynamicObject billType = e.getDynamicObject("entryentitytype");
            if (billType == null) {
                throw new KDBizException(Errors.getPlanAdjustStrategyIsnullError(), new Object[]{this.plan.getString("number")});
            }
            String bt = billType.getString("id");
            BillSplitStrategy bs = BillSplitStrategy.parseString(e.getString("adjuststrategy"));
            this.strategys.put(bt, bs);
        }
    }

    public HashMap<String, BillSplitStrategy> getStrategys() {
        if (this.strategys == null) {
            this.initStrategys();
        }
        return this.strategys;
    }

    private void initAttr2BillType() {
    }

    public HashMap<Integer, String> getAttr2BillType() {
        return this.attr2BillType;
    }

    public HashSet<String> getOrgs() {
        return this.orgs;
    }

    public HashSet<String> getRequirorgs() {
        return this.requirorgs;
    }

    public HashSet<String> getSupplyorgs() {
        return this.supplyorgs;
    }

    public HashMap<String, SupplyStruct> getPriorityRelations() {
        return this.priorityRelations;
    }

    public SupplyOrgTypeStruct getSupplyOrgTypeRelations(String requireOrg, String mId) {
        SupplyStruct supplyStruct = this.priorityRelations.get(requireOrg);
        String type = "";
        boolean isExist = false;
        for (Map.Entry<String, SupplyOrgTypeStruct> entry : supplyStruct.getOrgSupplys().entrySet()) {
            String typeId = entry.getKey();
            SupplyOrgTypeStruct supplyOrgTypeStruct = entry.getValue();
            if ("".equals(type) && supplyOrgTypeStruct.getIsDefault().booleanValue()) {
                type = typeId;
            }
            for (Map.Entry<String, OrgSupplyStruct> entry1 : supplyOrgTypeStruct.getMap().entrySet()) {
                OrgSupplyStruct orgSupplyStruct = entry1.getValue();
                if (!orgSupplyStruct.getMaterialIds().contains(mId)) continue;
                type = typeId;
                isExist = true;
                break;
            }
            if (!isExist) continue;
            break;
        }
        return supplyStruct.getOrgSupplys().get(type);
    }

    public HashMap<String, List<InvWareHouseStruct>> getCenterWarehouse() {
        return this.centerWarehouse;
    }

    private void initOrgFilters() {
        ORM orm = ORM.create();
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        boolean isnew = this.getIsNew();
        ArrayList<InvSupplyStruct> centerWarehouseAwareSupplyOrgs = new ArrayList<InvSupplyStruct>();
        if (isnew) {
            Object orgrangid = this.plan.get("orgrangid_tag");
            ArrayList list = new ArrayList(8);
            ArrayList<QFilter> qlist = new ArrayList<QFilter>(8);
            String mulid = this.plan.getDynamicObject("mul").getString("id");
            QFilter qFilter_enable = new QFilter("enable", "=", (Object)"1");
            QFilter qFilter_par = new QFilter("parentdnyid", "=", (Object)mulid);
            qlist.add(qFilter_enable);
            qlist.add(qFilter_par);
            if (orgrangid != null && !orgrangid.toString().isEmpty()) {
                list.addAll((Collection)SerializationUtils.deSerializeFromBase64((String)orgrangid.toString()));
            }
            qlist.add(new QFilter("demandorg", "in", list));
            Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"mrp_nodedetails", (QFilter[])qlist.toArray(new QFilter[qlist.size()]));
            for (Map.Entry mapEntry : objectDynamicObjectMap.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)mapEntry.getValue();
                SupplyStruct struct = new SupplyStruct();
                String orgId = dynamicObject.getDynamicObject("stockdemandorg").getString("id");
                this.orgs.add(String.valueOf(orgId));
                this.requirorgs.add(String.valueOf(orgId));
                this.supplyorgs.add(String.valueOf(orgId));
                this.priorityRelations.put(String.valueOf(orgId), struct);
                DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("stocksorgentrentryentity");
                struct.setBodtime(dynamicObject.getInt("bodtime"));
                String stocksetup = dynamicObject.getString("stocksetup");
                struct.setStockSetUp(stocksetup);
                MulBasedataDynamicObjectCollection stocktypes = (MulBasedataDynamicObjectCollection)dynamicObject.get("stocktype");
                MulBasedataDynamicObjectCollection stockstatus = (MulBasedataDynamicObjectCollection)dynamicObject.get("stockstatus");
                if (stocktypes != null && stocktypes.size() != 0) {
                    for (DynamicObject stocktype : stocktypes) {
                        struct.getStockTypes().add(stocktype.getString("fbasedataid_id"));
                    }
                }
                if (stockstatus != null && stockstatus.size() != 0) {
                    for (DynamicObject stockstatu : stockstatus) {
                        struct.getStockStatus().add(stockstatu.getString("fbasedataid_id"));
                    }
                }
                for (int j = 0; j < entrys.size(); ++j) {
                    DynamicObject e = (DynamicObject)entrys.get(j);
                    String supplyOrgId = e.getDynamicObject("storageorg").getString("id");
                    this.orgs.add(supplyOrgId);
                    InvSupplyStruct inv = new InvSupplyStruct();
                    inv.setPriority(e.getBigDecimal("priority"));
                    inv.setRatio(e.getBigDecimal("stockscale"));
                    struct.getInvSupplys().put(supplyOrgId, inv);
                }
                for (DynamicObject e : dynamicObject.getDynamicObjectCollection("stocksetupentryentity")) {
                    InvWareHouseStruct ware = new InvWareHouseStruct();
                    String supplyOrgId = e.getDynamicObject("stockorg").getString("id");
                    this.orgs.add(supplyOrgId);
                    String wareHouseId = e.getDynamicObject("stocknumber") == null ? null : e.getDynamicObject("stocknumber").getString("id");
                    String locationId = e.getDynamicObject("stockindex") == null ? null : e.getDynamicObject("stockindex").getString("id");
                    ware.setPriority(e.getBigDecimal("supplypriority"));
                    ware.setWarehouseId(wareHouseId);
                    ware.setLocationId(locationId);
                    ware.setWasteWH(e.getBoolean("wastewarehouse"));
                    InvSupplyStruct inv = this.setInvStruct(struct, supplyOrgId);
                    if (!inv.isContainsCenterWarehouse() && BigDecimal.ZERO.compareTo(ware.getPriority()) >= 0 && !StockSetUpEnum.IS_NOT_MRP_WAREHOUSE.getValue().equalsIgnoreCase(stocksetup)) {
                        inv.setContainsCenterWarehouse(true);
                        inv.setCenterWarehouseId(ware.getWarehouseId());
                        inv.setCenterLocationId(ware.getLocationId());
                        centerWarehouseAwareSupplyOrgs.add(inv);
                    }
                    inv.getInvWareHouses().add(ware);
                }
                entrys = dynamicObject.getDynamicObjectCollection("materialsetup");
                this.initMaterialSet(entrys, struct);
                DynamicObject netDyn = dynamicObject.getDynamicObject("demandorg");
                if (netDyn != null) {
                    String supplyOrgId;
                    DynamicObject e;
                    int j;
                    String defTypeId = this.getGlobalId();
                    entrys = dynamicObject.getDynamicObjectCollection("defaultsupply");
                    for (j = 0; j < entrys.size(); ++j) {
                        e = (DynamicObject)entrys.get(j);
                        supplyOrgId = e.getDynamicObject("defaultsupplyorg").getString("id");
                        this.orgs.add(supplyOrgId);
                        this.supplyorgs.add(supplyOrgId);
                        SupplyOrgTypeStruct defsots = struct.getOrgSupplys().get(defTypeId);
                        if (defsots == null) {
                            defsots = new SupplyOrgTypeStruct();
                        }
                        defsots.setIsDefault(Boolean.TRUE);
                        this.initSupplyOrgType_new(defsots, dynamicObject, e.getString("defaultsupplyrule"), e.getBigDecimal("supplyratio"), defTypeId, supplyOrgId, false);
                        struct.getOrgSupplys().put(defTypeId, defsots);
                    }
                    entrys = dynamicObject.getDynamicObjectCollection("supplyorgentryentity");
                    for (j = 0; j < entrys.size(); ++j) {
                        e = (DynamicObject)entrys.get(j);
                        supplyOrgId = e.getDynamicObject("supplyorg").getString("id");
                        this.orgs.add(supplyOrgId);
                        this.supplyorgs.add(supplyOrgId);
                        String typeId = e.getDynamicObject("ssupplyorggroup").getString("id");
                        SupplyOrgTypeStruct sots = struct.getOrgSupplys().get(typeId);
                        if (sots == null) {
                            sots = new SupplyOrgTypeStruct();
                            sots.setIsDefault(Boolean.FALSE);
                            this.initSupplyOrgType_new(sots, dynamicObject, e.getString("supplyrule"), e.getBigDecimal("supplyproportion"), typeId, supplyOrgId, true);
                            struct.getOrgSupplys().put(typeId, sots);
                            continue;
                        }
                        this.initSupplyOrgType_new(sots, dynamicObject, e.getString("supplyrule"), e.getBigDecimal("supplyproportion"), typeId, supplyOrgId, true);
                    }
                }
                this.initReqiurePrioritySettings(dynamicObject, struct);
            }
        } else {
            boolean isoutofrangewarehouse = (Boolean)this.getPlanDataByParam("isoutofrangewarehouse", false);
            DynamicObjectCollection orgs = this.plan.getDynamicObjectCollection("orgentryentity");
            for (DynamicObject org : orgs) {
                SupplyStruct struct = new SupplyStruct();
                DynamicObject rOrg = org.getDynamicObject("entrydemandorg");
                String orgId = rOrg.getString("id");
                this.orgs.add(orgId);
                this.requirorgs.add(orgId);
                this.supplyorgs.add(orgId);
                this.priorityRelations.put(orgId, struct);
                DynamicObject is = this.getInvSupplyStrategy(org, struct);
                DynamicObjectCollection entrys = is.getDynamicObjectCollection("entryentity");
                struct.setBodtime(is.getInt("bodtime"));
                String stocksetup = is.getString("stocksetup");
                struct.setStockSetUp(isoutofrangewarehouse ? "1" : stocksetup);
                for (DynamicObject entry : is.getDynamicObjectCollection("stockstypeentity")) {
                    DynamicObject stocktype = entry.getDynamicObject("stocktype");
                    boolean isMrp = entry.getBoolean("ismrp");
                    if (!isMrp || stocktype == null) continue;
                    struct.getStockTypes().add(stocktype.getString("id"));
                }
                for (DynamicObject entry : is.getDynamicObjectCollection("entryentity2")) {
                    DynamicObject stockstatus = entry.getDynamicObject("stocktype1");
                    boolean isMrp = entry.getBoolean("ismrp1");
                    if (!isMrp || stockstatus == null) continue;
                    struct.getStockStatus().add(stockstatus.getString("id"));
                }
                for (int j = 0; j < entrys.size(); ++j) {
                    DynamicObject e = (DynamicObject)entrys.get(j);
                    String supplyOrgId = e.getDynamicObject("storageorg").getString("id");
                    this.orgs.add(supplyOrgId);
                    InvSupplyStruct inv = new InvSupplyStruct();
                    inv.setPriority(e.getBigDecimal("priority"));
                    inv.setRatio(e.getBigDecimal("stockscale"));
                    struct.getInvSupplys().put(supplyOrgId, inv);
                }
                for (DynamicObject e : is.getDynamicObjectCollection("stocksetupentry")) {
                    InvWareHouseStruct ware = new InvWareHouseStruct();
                    String supplyOrgId = e.getDynamicObject("stockorg").getString("id");
                    this.orgs.add(supplyOrgId);
                    String wareHouseId = e.getDynamicObject("stocknumber") == null ? null : e.getDynamicObject("stocknumber").getString("id");
                    String locationId = e.getDynamicObject("stockindex") == null ? null : e.getDynamicObject("stockindex").getString("id");
                    ware.setPriority(e.getBigDecimal("supplypriority"));
                    ware.setWarehouseId(wareHouseId);
                    ware.setLocationId(locationId);
                    ware.setWasteWH(e.getBoolean("wastewarehouse"));
                    InvSupplyStruct inv = this.setInvStruct(struct, supplyOrgId);
                    if (!inv.isContainsCenterWarehouse() && BigDecimal.ZERO.compareTo(ware.getPriority()) >= 0 && !StockSetUpEnum.IS_NOT_MRP_WAREHOUSE.getValue().equalsIgnoreCase(stocksetup)) {
                        inv.setContainsCenterWarehouse(true);
                        inv.setCenterWarehouseId(ware.getWarehouseId());
                        inv.setCenterLocationId(ware.getLocationId());
                        centerWarehouseAwareSupplyOrgs.add(inv);
                    }
                    inv.getInvWareHouses().add(ware);
                }
                entrys = is.getDynamicObjectCollection("materialsetup");
                this.initMaterialSet(entrys, struct);
                DynamicObject netDyn = org.getDynamicObject("entrysupplynet");
                if (netDyn != null) {
                    long netId = netDyn.getLong("id");
                    DynamicObject sn = cacheDatas.reloadDataById("mrp_definitionsupply", netId);
                    String defTypeId = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)sn.getDynamicObject("defsupplytype"), (String)"id");
                    entrys = sn.getDynamicObjectCollection("orgentry");
                    for (DynamicObject e : entrys) {
                        String supplyOrgId = e.getDynamicObject("supplyorg").getString("id");
                        this.orgs.add(supplyOrgId);
                        this.supplyorgs.add(supplyOrgId);
                        this.setSupplyOrgTypeStruct(struct.getOrgSupplys(), defTypeId, sn, e);
                    }
                }
                this.initReqiurePrioritySettings(org, struct);
            }
        }
        SupplyStruct struct = new SupplyStruct();
        this.priorityRelations.put(this.getPlanOrgId() + "pentryentity", struct);
        this.initPlanPrioritySettings(this.plan, struct);
        this.initCenterWarehouseAwareSupplyOrgs(centerWarehouseAwareSupplyOrgs);
    }

    private void setSupplyOrgTypeStruct(Map<String, SupplyOrgTypeStruct> type2SupplyOrgTypeStruct, String defTypeId, DynamicObject sn, DynamicObject e) {
        String supplyOrgId = e.getDynamicObject("supplyorg").getString("id");
        String typeId = e.getDynamicObject("supplyorgtype").getString("id");
        SupplyOrgTypeStruct sots = type2SupplyOrgTypeStruct.get(typeId);
        if (sots == null) {
            sots = new SupplyOrgTypeStruct();
            if (defTypeId == null) {
                defTypeId = typeId;
            }
            if (typeId.equals(defTypeId)) {
                sots.setIsDefault(Boolean.TRUE);
            } else {
                sots.setIsDefault(Boolean.FALSE);
            }
            this.initSupplyOrgType(sots, sn, e.getString("supplyrule"), e.getBigDecimal("supplyproportion"), typeId, supplyOrgId);
            type2SupplyOrgTypeStruct.put(typeId, sots);
        } else {
            this.initSupplyOrgType(sots, sn, e.getString("supplyrule"), e.getBigDecimal("supplyproportion"), typeId, supplyOrgId);
        }
    }

    public Map<String, SupplyOrgTypeStruct> initSupplyNetWork(DynamicObject sn) {
        HashMap<String, SupplyOrgTypeStruct> type2SupplyOrgTypeStruct = new HashMap<String, SupplyOrgTypeStruct>(2);
        String defTypeId = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)sn.getDynamicObject("defsupplytype"), (String)"id");
        DynamicObjectCollection entrys = sn.getDynamicObjectCollection("orgentry");
        for (DynamicObject e : entrys) {
            this.setSupplyOrgTypeStruct(type2SupplyOrgTypeStruct, defTypeId, sn, e);
        }
        return type2SupplyOrgTypeStruct;
    }

    public SupplyOrgTypeStruct getDefSupplyOrgTypeStruct(Long netId) {
        if (this.defSupplyOrgTypeStructCache.containsKey(netId.toString())) {
            return this.defSupplyOrgTypeStructCache.get(netId.toString());
        }
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        DynamicObject sn = cacheDatas.reloadDataById("mrp_definitionsupply", netId);
        Map<String, SupplyOrgTypeStruct> type2SupplyOrgTypeStruct = this.initSupplyNetWork(sn);
        SupplyOrgTypeStruct sots = null;
        for (Map.Entry<String, SupplyOrgTypeStruct> entry : type2SupplyOrgTypeStruct.entrySet()) {
            sots = entry.getValue();
            if (!sots.getIsDefault().booleanValue()) continue;
            this.defSupplyOrgTypeStructCache.put(netId.toString(), sots);
            return sots;
        }
        this.defSupplyOrgTypeStructCache.put(netId.toString(), sots);
        return sots;
    }

    public SupplyOrgTypeStruct getSupplyOrgTypeStruct(Long supply_network, String orgId, String mid) {
        SupplyOrgTypeStruct defSupplyOrgTypeStruct = null;
        if (supply_network != null && supply_network > 0L) {
            defSupplyOrgTypeStruct = this.getDefSupplyOrgTypeStruct(supply_network);
        }
        if (defSupplyOrgTypeStruct == null) {
            defSupplyOrgTypeStruct = this.getSupplyOrgTypeRelations(orgId, mid);
        }
        return defSupplyOrgTypeStruct;
    }

    private DynamicObject getInvSupplyStrategy(DynamicObject orgEntry, SupplyStruct struct) {
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        RunLogModel runLogModel = (RunLogModel)this.env.getService(RunLogModel.class);
        String runType = runLogModel.getRunType();
        DynamicObject invStrategy = orgEntry.getDynamicObject("entryinvstrategy");
        DynamicObject rOrg = orgEntry.getDynamicObject("entrydemandorg");
        if (this.isEnablePlanScope() && !"F".equals(runType)) {
            DynamicObject planScope = orgEntry.getDynamicObject("entryplanscope");
            if (planScope == null) {
                throw new MRPBizException(Errors.getPlanScopeEmptyError(), rOrg.getString("name"));
            }
            QFilter qFilterOrg = new QFilter("createorg", "=", rOrg.getPkValue());
            QFilter qFilterType = new QFilter("planscope", "=", planScope.getPkValue());
            QFilter qFilter = new QFilter("effectuate_type", "=", (Object)"A");
            Long id = 0L;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"msplan_planscope_whs", (String)"inv_supply_strategy", (QFilter[])new QFilter[]{qFilter, qFilterOrg, qFilterType}, null, (int)1);){
                if (dataSet.hasNext()) {
                    id = dataSet.next().getLong(0);
                }
            }
            if (id <= 0L) {
                throw new MRPBizException(Errors.getPlanScopeNoDataError(), rOrg.getString("name"));
            }
            invStrategy = cacheDatas.reloadDataById("mrp_stocksupply_policy", id);
            struct.setPlanScope(planScope.getLong("id"));
        } else {
            if (invStrategy == null) {
                throw new MRPBizException(Errors.getInvSupplyStrategyEmptyError(), rOrg.getString("name"));
            }
            invStrategy = cacheDatas.reloadDataById("mrp_stocksupply_policy", invStrategy.getLong("id"));
        }
        return invStrategy;
    }

    private String getGlobalId() {
        return String.valueOf(DB.genGlobalLongId());
    }

    private boolean getIsNew() {
        DynamicObject mul;
        Object containMul = this.getPlanDataByParam("mul");
        return containMul != null && (mul = this.plan.getDynamicObject("mul")) != null;
    }

    private void initCenterWarehouseAwareSupplyOrgs(List<InvSupplyStruct> centerWarehouseAwareSupplyOrgs) {
        for (InvSupplyStruct iss : centerWarehouseAwareSupplyOrgs) {
            String key = String.format("%s\u0001%s", iss.getCenterWarehouseId(), iss.getCenterLocationId() == null ? "" : iss.getCenterLocationId());
            List centerWhs = this.centerWarehouse.computeIfAbsent(key, k -> new ArrayList(iss.getInvWareHouses().size() - 1));
            for (InvWareHouseStruct iwhs : iss.getInvWareHouses()) {
                if (BigDecimal.ZERO.compareTo(iwhs.getPriority()) >= 0) continue;
                centerWhs.add(iwhs);
            }
        }
    }

    private void initSupplyOrgType(SupplyOrgTypeStruct sots, DynamicObject sn, String supplyrule, BigDecimal ratio, String typeId, String supplyOrgId) {
        OrgSupplyStruct oss = new OrgSupplyStruct();
        BillSupplyStrategy bs = BillSupplyStrategy.parseString(supplyrule);
        oss.setRatio(ratio);
        oss.setStrategy(bs);
        this.setMaterialIds(sn, oss, typeId);
        sots.getMap().put(supplyOrgId, oss);
    }

    private void initSupplyOrgType_new(SupplyOrgTypeStruct sots, DynamicObject sn, String supplyrule, BigDecimal ratio, String typeId, String supplyOrgId, boolean isSetMaterial) {
        OrgSupplyStruct oss = new OrgSupplyStruct();
        BillSupplyStrategy bs = BillSupplyStrategy.parseString(supplyrule);
        oss.setRatio(ratio);
        oss.setStrategy(bs);
        if (isSetMaterial) {
            this.setMaterialIds_new(sn, oss, typeId);
        }
        sots.getMap().put(supplyOrgId, oss);
    }

    private void initMaterialSet(DynamicObjectCollection entrys, SupplyStruct struct) {
        for (DynamicObject e : entrys) {
            String supplyOrgId = e.getDynamicObject("materialorg").getString("id");
            this.orgs.add(supplyOrgId);
            String materialId = e.getDynamicObject("materiel").getString("id");
            DynamicObject warehouse = e.getDynamicObject("stock");
            String warehouseId = warehouse == null ? null : warehouse.getString("id");
            DynamicObject location = e.getDynamicObject("stockindexs");
            String locationId = location == null ? null : location.getString("id");
            InvSupplyStruct inv = this.setInvStruct(struct, supplyOrgId);
            MaterialStruct m = new MaterialStruct();
            m.setWarehouseId(warehouseId);
            m.setLocationId(locationId);
            m.setPriority(e.getBigDecimal("prioritylevel"));
            m.setRatio(e.getBigDecimal("stockratio"));
            inv.getMaterials().put(materialId, m);
        }
    }

    private InvSupplyStruct setInvStruct(SupplyStruct struct, String supplyOrgId) {
        InvSupplyStruct inv = struct.getInvSupplys().get(supplyOrgId);
        if (inv == null) {
            inv = new InvSupplyStruct();
            inv.setPriority(BigDecimal.ZERO);
            inv.setRatio(BigDecimal.ZERO);
            struct.getInvSupplys().put(supplyOrgId, inv);
        }
        return inv;
    }

    private void setMaterialIds(DynamicObject sn, OrgSupplyStruct oss, String typeId) {
        DynamicObjectCollection entrys = sn.getDynamicObjectCollection("materialentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject e = (DynamicObject)entrys.get(i);
            String materialId = e.getDynamicObject("material").getString("id");
            String type = e.getDynamicObject("supplytype").getString("id");
            if (!type.equals(typeId)) continue;
            oss.getMaterialIds().add(materialId);
        }
    }

    private void setMaterialIds_new(DynamicObject sn, OrgSupplyStruct oss, String typeId) {
        DynamicObjectCollection entrys = sn.getDynamicObjectCollection("materialentryentity");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject e = (DynamicObject)entrys.get(i);
            String materialId = e.getDynamicObject("materialnumber").getString("id");
            String type = e.getDynamicObject("msupplyorggroup").getString("id");
            if (!type.equals(typeId)) continue;
            oss.getMaterialIds().add(materialId);
        }
    }

    protected void initReqiurePrioritySettings(DynamicObject orgRow, SupplyStruct struct) {
    }

    protected void initPlanPrioritySettings(DynamicObject planOrg, SupplyStruct struct) {
        Object priority_model = this.getPlanDataByParam("prioritymodel");
        if (priority_model != null) {
            return;
        }
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        DynamicObjectCollection settings = planOrg.getDynamicObjectCollection("pentryentity");
        HashMap<String, DynamicObject> id2pt = new HashMap<String, DynamicObject>(4);
        HashMap<String, DynamicObject> type2Relation = new HashMap<String, DynamicObject>(4);
        for (DynamicObject relation : settings) {
            DynamicObject pt = relation.getDynamicObject("pentrytypename");
            if (pt == null) continue;
            String id = pt.getString("id");
            if (!id2pt.containsKey(id)) {
                pt = cacheDatas.reloadDataById("mrp_priority_type", pt.getLong("id"));
                id2pt.put(id, pt);
            }
            type2Relation.put(String.format("%s-%s", id, relation.getString("pentryelementtype")), relation);
        }
        for (Map.Entry entry : id2pt.entrySet()) {
            PrioritySettingDatas requirePriority = new PrioritySettingDatas();
            struct.getRequirePrioritys().add(requirePriority);
            DynamicObject pt = (DynamicObject)entry.getValue();
            String id = pt.getString("id");
            DynamicPriorityLevelDataTable priotityTable = new DynamicPriorityLevelDataTable(this.env, id);
            requirePriority.setRefTbl(priotityTable);
            requirePriority.setRelations(new ArrayList<PriorityLevelFieldSrcDefine>());
            DynamicObjectCollection pentrys = pt.getDynamicObjectCollection("entryentity");
            int colCount = 0;
            for (DynamicObject factor : pentrys) {
                PriorityEntryFieldType ft = PriorityEntryFieldType.parseString(factor.getString("elementtype"));
                if (ft == null) continue;
                DynamicObject relation = (DynamicObject)type2Relation.get(String.format("%s-%s", id, ft.getValue()));
                if (relation == null) continue;
                PriorityLevelFieldSrcDefine define = new PriorityLevelFieldSrcDefine();
                define.setFieldType(ft);
                define.setFullName(relation.getString("pentrydemandlogo"));
                if (!StringUtils.isEmpty((String)relation.getString("pentryfruncondition"))) {
                    try {
                        define.setCondition(new Expr(relation.getString("pentryfruncondition")));
                    }
                    catch (ParseException e) {
                        throw new MRPBizException(e, new ErrorCode("FORMULA_PARSE_FAILED", relation.getString("pentryfruncondition")));
                    }
                }
                switch (Objects.requireNonNull(ft)) {
                    case DATE: {
                        String cycle = "fcombounit" + colCount;
                        String start = "fstartdate" + colCount;
                        String end = "fenddate" + colCount;
                        priotityTable.addIndexCol(cycle);
                        priotityTable.addIndexCol(start);
                        priotityTable.addIndexCol(end);
                        define.setPlanOutlook(this.getPlanOutLook());
                        define.setPriorityStep(factor.getInt("autoprioritystep"));
                        define.setDateStep(factor.getInt("autodatestep"));
                        define.setRelatedFieldNames(cycle, start, end);
                        ++colCount;
                        break;
                    }
                    case ENTITY: {
                        String priority = "fpriority" + colCount;
                        priotityTable.addIndexCol(priority);
                        define.setRelatedFieldNames(priority);
                        define.setEntityName(factor.getDynamicObject("elementobject").getString("id"));
                        ++colCount;
                        break;
                    }
                    case NUMBER: {
                        String material = "fmaterial" + colCount;
                        String numStart = "fstartnumber" + colCount;
                        String numEnd = "fendnumber" + colCount;
                        priotityTable.addIndexCol(material);
                        priotityTable.addIndexCol(numStart);
                        priotityTable.addIndexCol(numEnd);
                        define.setRelatedFieldNames(material, numStart, numEnd);
                        ++colCount;
                        break;
                    }
                }
                requirePriority.getRelations().add(define);
            }
            requirePriority.refresh();
        }
    }

    public DynamicObjectCollection getResPrioritys() {
        if (this.resPrioritys == null) {
            this.resPrioritys = this.plan.getDynamicObjectCollection("scentryentity");
        }
        return this.resPrioritys;
    }

    public int[] getSupplyPrioritys() {
        if (this.prioritys != null) {
            return this.prioritys;
        }
        HashSet<String> enabledSupplys = this.getEnabledSupplys();
        DynamicObjectCollection resPrioritys = this.getResPrioritys();
        HashSet<Integer> unique = new HashSet<Integer>();
        for (int i = 0; i < resPrioritys.size(); ++i) {
            DynamicObject p = (DynamicObject)resPrioritys.get(i);
            if (!enabledSupplys.contains(p.getDynamicObject("resourceregisters").getString("id"))) continue;
            unique.add(p.getInt("supplypriority"));
        }
        ArrayList<Integer> all = new ArrayList<Integer>(unique);
        all.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2) * -1;
            }
        });
        this.prioritys = new int[all.size()];
        for (int i = 0; i < all.size(); ++i) {
            this.prioritys[i] = (Integer)all.get(i);
        }
        return this.prioritys;
    }

    public Integer getSupplyPrioritys(String resDataId) {
        if (StringUtils.isEmpty((String)resDataId)) {
            return 0;
        }
        DynamicObjectCollection resPrioritys = this.getResPrioritys();
        for (int i = 0; i < resPrioritys.size(); ++i) {
            DynamicObject p = (DynamicObject)resPrioritys.get(i);
            if (!resDataId.equalsIgnoreCase(p.getDynamicObject("resourceregisters").getString("id"))) continue;
            return p.getInt("supplypriority");
        }
        return null;
    }

    public boolean isOnWayTransfer(String orgId) {
        SupplyStruct ss = this.getPriorityRelations().get(orgId);
        if (ss != null && ss.getInvSupplys() != null) {
            for (Map.Entry<String, InvSupplyStruct> item : ss.getInvSupplys().entrySet()) {
                if (!item.getValue().isContainsCenterWarehouse()) continue;
                return true;
            }
        }
        return false;
    }

    public HashSet<String> getEnabledRequires() {
        if (this.enabledRequires == null) {
            this.enabledRequires = new HashSet<String>();
            this.recordDataQueryIds(this.enabledRequires, this.plan.getDynamicObjectCollection("entryentity"), "entryismrpoperat", "resourceregister");
        }
        return this.enabledRequires;
    }

    public HashSet<String> getEnabledSupplys() {
        if (this.enabledSupplys == null) {
            this.enabledSupplys = new HashSet<String>();
            this.recordDataQueryIds(this.enabledSupplys, this.plan.getDynamicObjectCollection("scentryentity"), "entryisscmrpoperat", "resourceregisters");
        }
        return this.enabledSupplys;
    }

    private void recordDataQueryIds(HashSet<String> record, DynamicObjectCollection settings, String enableTagField, String resRelateField) {
        for (DynamicObject e : settings) {
            if (!e.getBoolean(enableTagField)) continue;
            String id = e.getDynamicObject(resRelateField).getString("id");
            record.add(id);
        }
    }

    @Override
    public long getRequireResId() {
        return this.plan.getDynamicObject("demandmodel").getLong("id");
    }

    @Override
    public long getSupplyResId() {
        return this.plan.getDynamicObject("supplymodel").getLong("id");
    }

    @Override
    public long getBomResId() {
        return this.plan.getDynamicObject("demandmodel").getLong("relativeresource_id");
    }

    @Override
    public long getR2STransId() {
        return this.plan.getDynamicObject("relativetransfer").getLong("id");
    }

    public Long getPlanId() {
        return this.plan.getLong("id");
    }

    public String getPlanNumber() {
        return this.plan.getString("number");
    }

    public String getPlanType() {
        return this.plan.getDataEntityType().getName();
    }

    public DynamicObject getPlan() {
        return this.plan;
    }

    public static String getPlanType(DynamicObject plangram) {
        if (plangram == null) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(4);
        if (plangram.getBoolean("ismrp")) {
            list.add("MRP");
        }
        if (plangram.getBoolean("ismps")) {
            list.add("MPS");
        }
        if (plangram.getBoolean("isreorderpoint")) {
            list.add(ResManager.loadKDString((String)"\u518d\u8ba2\u8d27\u70b9", (String)"PlanModel_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
        }
        if (plangram.getBoolean("hiloinv")) {
            list.add(ResManager.loadKDString((String)"\u6700\u5927\u6700\u5c0f\u5e93\u5b58", (String)"PlanModel_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
        }
        String s = ((Object)list).toString();
        String replace = s.replace("[", "").replace("]", "").replace(", ", "/");
        return replace;
    }

    public Map<String, String> getWipSupply2Require() {
        DynamicObject billField = this.plan.getDynamicObject("wipbillfields");
        if (billField == null) {
            return this.wipSupply2Require;
        }
        if (this.wipSupply2Require.isEmpty()) {
            CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
            billField = cacheDatas.reloadDataById(billField.getDataEntityType().getName(), billField.getPkValue());
            DynamicObjectCollection col = billField.getDynamicObjectCollection("entryentity");
            col.forEach(entry -> this.wipSupply2Require.put(entry.getString("destfieldflag").toUpperCase(), entry.getString("sourcefieldflag").toUpperCase()));
        }
        return this.wipSupply2Require;
    }
}

