/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.consts.PlanScopeRelationConst;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.strategy.MaterialPlanMode;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class PlanScopeModel {
    private static final Log logger = LogFactory.getLog(PlanScopeModel.class);
    private final IMRPEnvProvider env;

    public PlanScopeModel(IMRPEnvProvider env) {
        this.env = env;
        this.env.addService(PlanScopeModel.class, this);
    }

    public void init() {
    }

    public Map<String, Object> loadPlanScope2RequireData(RequireRowData rowData, Map<String, Object> info) {
        Object[] mftData;
        info = new HashMap<String, Object>(info);
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        ResDataModelCollection resDataModelCollection = (ResDataModelCollection)this.env.getService(ResDataModelCollection.class);
        Long planScope = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.PLANSCOPE.getName()), 0L);
        Long productStorageOrgUnitID = DataBalanceUtil.getPlanScopeRequireOrg(rowData);
        SupplyStruct ss = planModel.getPriorityRelations().get(productStorageOrgUnitID.toString());
        if (ss == null) {
            return null;
        }
        Long supplyorgunit = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()), 0L);
        String supplyOrg = supplyorgunit > 0L ? supplyorgunit.toString() : String.valueOf(rowData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        String material = String.valueOf(rowData.getValue(DefaultField.RequireField.MATERIAL.getName()));
        Long mftId = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.MATERIALMFTINFO.getName()), 0L);
        if (mftId <= 0L) {
            mftData = cacheDatas.getMftData4OrgAndMaterial(Long.parseLong(supplyOrg), Long.parseLong(material));
            mftId = MRPUtil.convert(mftData[7], 0L);
        } else {
            mftData = cacheDatas.getMftData4Id(mftId);
        }
        rowData.update(DefaultField.RequireField.MATERIALMFTINFO.getName(), (Object)mftId);
        Long in_storage_org = Long.parseLong(supplyOrg);
        Long in_storage_warehouse = 0L;
        Long in_storage_shipping = 0L;
        if (planModel.isEnablePlanScope()) {
            Set<String> value;
            String cacheValue;
            String cacheKey = PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)productStorageOrgUnitID.toString(), (String)material);
            Long warehouse = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.WAREHOUSE.getName()), 0L);
            if (warehouse > 0L && !resDataModelCollection.isWarehouseDataHavScope(ss, warehouse, material, false)) {
                this.tagDataException(rowData, ResManager.loadKDString((String)"\u4ed3\u5e93\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4", (String)"PlanScopeModel_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), "101");
                return null;
            }
            if (planScope <= 0L) {
                planScope = DataBalanceUtil.getPlanScopeByWareHouse(this.env, ss, productStorageOrgUnitID, material, false, cacheKey, 0L, warehouse, false);
                planScope = planScope == null ? Long.valueOf(0L) : planScope;
            } else {
                if (!cacheDatas.isValidPlanScopeByOrg(productStorageOrgUnitID, planScope)) {
                    this.tagDataException(rowData, ResManager.loadKDString((String)"\u8ba1\u5212\u8303\u56f4\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4", (String)"PlanScopeModel_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), "102");
                    return null;
                }
                if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("mrprunner-loadPlanScope2RequireData: mid:%s,billno:%s,billseq:%s,planScope:%s,defplanScope:%s,warehouse:%s", material, rowData.getValue(DefaultField.RequireField.BILLNUMBER.getName()), rowData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()), planScope, ss.getPlanScope(), warehouse));
                }
                if ((cacheValue = cacheDatas.getPlanScopeCache(cacheKey, planScope.toString())) != null && !DataBalanceUtil.materialPlanScopeIsEnable(cacheValue)) {
                    this.tagDataException(rowData, ResManager.loadKDString((String)"\u8ba1\u5212\u8303\u56f4\u672a\u542f\u7528", (String)"PlanScopeModel_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]), "102");
                    return null;
                }
            }
            rowData.update(DefaultField.RequireField.PLANSCOPE.getName(), (Object)planScope);
            if (cacheDatas.isSelectMaterialPlan4PlanScope() && (value = cacheDatas.getSelectMaterialPlanScope(this.env, productStorageOrgUnitID.toString(), material)) != null) {
                boolean match = false;
                for (String v : value) {
                    String[] str = v.split("\u0001");
                    Long scope = MRPUtil.convert((Object)str[0], 0L);
                    if (!scope.equals(0L) && !planScope.equals(scope)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    this.tagDataException(rowData, ResManager.loadKDString((String)"\u8ba1\u5212\u8303\u56f4\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4", (String)"PlanScopeModel_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), "102");
                    return null;
                }
            }
            if (!planScope.equals(ss.getPlanScope())) {
                cacheValue = cacheDatas.getPlanScopeCache(cacheKey, planScope.toString());
                if (cacheValue != null) {
                    Object[] data = (Object[])JSON.parseObject((String)cacheValue, Object[].class);
                    info.put("planmode", data[0]);
                    info.put("operator", data[1]);
                    info.put("supplynetwork", data[2]);
                    info.put("isincluderequire", data[16]);
                    info.put("reorderpoint", data[3]);
                    info.put("max", data[5]);
                    info.put("min", data[6]);
                    in_storage_org = MRPUtil.convert(data[10], 0L);
                    in_storage_warehouse = MRPUtil.convert(data[11], 0L);
                    in_storage_shipping = MRPUtil.convert(data[12], 0L);
                    if (in_storage_org <= 0L) {
                        Long[] invData = cacheDatas.getInWarehouse4orgAndPlanScope(productStorageOrgUnitID, planScope);
                        in_storage_warehouse = invData[0];
                        in_storage_org = invData[1];
                        in_storage_shipping = 0L;
                    }
                }
            } else if (mftId > 0L) {
                in_storage_org = MRPUtil.convert(mftData[3], 0L);
                in_storage_warehouse = MRPUtil.convert(mftData[4], 0L);
                in_storage_shipping = MRPUtil.convert(mftData[5], 0L);
            }
            String planMode = MRPUtil.getString(info, "planmode");
            MtPlanInfoModel planInfo = (MtPlanInfoModel)this.env.getService(MtPlanInfoModel.class);
            List<String> planType = planInfo.getPlanType();
            if (!planType.contains(planMode)) {
                this.tagDataException(rowData, ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u5f0f\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4", (String)"PlanScopeModel_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]), "97");
                return null;
            }
        } else if (mftId > 0L) {
            in_storage_org = MRPUtil.convert(mftData[3], 0L);
            in_storage_warehouse = MRPUtil.convert(mftData[4], 0L);
            in_storage_shipping = MRPUtil.convert(mftData[5], 0L);
        }
        String planMode = MRPUtil.getString(info, "planmode");
        boolean isInv = MaterialPlanMode.REORDERPOINT.getValue().equalsIgnoreCase(planMode) || MaterialPlanMode.MAXANDMININV.getValue().equalsIgnoreCase(planMode);
        boolean is_includerequire = MRPUtil.convert(info.get("isincluderequire"), Boolean.FALSE);
        boolean is_inv_water_level = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName()), Boolean.FALSE);
        if (isInv && !is_includerequire && !is_inv_water_level) {
            this.tagDataException(rowData, ResManager.loadKDString((String)"\u4e0d\u8003\u8651\u5916\u90e8\u9700\u6c42", (String)"PlanScopeModel_4", (String)"mmc-mrp-mservice", (Object[])new Object[0]), "111");
            return null;
        }
        if (rowData.getValue(DefaultField.RequireField.IN_STORAGE_ORG.getName()) == null) {
            rowData.update(DefaultField.RequireField.IN_STORAGE_ORG.getName(), (Object)in_storage_org);
        }
        if (rowData.getValue(DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName()) == null) {
            rowData.update(DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName(), (Object)in_storage_warehouse);
        }
        if (rowData.getValue(DefaultField.RequireField.IN_STORAGE_SHIPPING.getName()) == null) {
            rowData.update(DefaultField.RequireField.IN_STORAGE_SHIPPING.getName(), (Object)in_storage_shipping);
        }
        return info;
    }

    private void tagDataException(RequireRowData requireRowData, String msg, String expNum) {
        String expMsgFiled = DefaultField.RequireField.EXCEPTIONMESSAGE.getName();
        String expNumFiled = DefaultField.RequireField.EXCEPTIONNUMBER.getName();
        msg = MRPUtil.appendExceptionMsg(requireRowData.getValue(expMsgFiled), msg);
        requireRowData.update(expMsgFiled, (Object)msg);
        expNum = MRPUtil.appendExceptionNumber(requireRowData.getValue(expNumFiled), expNum);
        requireRowData.update(expNumFiled, (Object)expNum);
    }

    public void addMaterByPlanScopeRelation(Set<String> materialIds, Set<String> materialPlanIds, Set<String> existMaterialPlans, QFilter outFilter) {
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        MtPlanInfoModel mtPlanInfoModel = (MtPlanInfoModel)this.env.getService(MtPlanInfoModel.class);
        if (planModel.isEnablePlanScope()) {
            boolean isIgnore = "IGNORE".equals(this.env.getCfgValue(EnvCfgItem.MATERIAL_PLAN_INFO_SETTINGS));
            QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
            qFilterStatus.and(new QFilter("enable", "=", (Object)"1"));
            HashSet<String> planTypes = new HashSet<String>(mtPlanInfoModel.getPlanType());
            String select = "createorg,material,entrymatplanscop.plantype plantype";
            QFilter qFilterOrg = new QFilter("createorg", "in", MRPUtil.setStringParseLong(planModel.getRequirorgs()));
            QFilter newoutFilter = null;
            if (outFilter != null && "masterid".equals(outFilter.getProperty())) {
                newoutFilter = new QFilter("material", outFilter.getCP(), outFilter.getValue());
            }
            HashMap<Long, Set> org2Maters = new HashMap<Long, Set>(planModel.getRequirorgs().size());
            HashSet<Long> allMaters = new HashSet<Long>(16);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"msplan_matplanscop", (String)select, (QFilter[])new QFilter[]{newoutFilter, qFilterOrg}, null);){
                for (Row row : dataSet) {
                    Long createorg = row.getLong("createorg");
                    Long material = row.getLong("material");
                    String planType = this.env.isSpecialPlan() ? MaterialPlanMode.MRP.getValue() : row.getString("plantype");
                    String key = createorg.toString() + '\u0001' + material.toString();
                    if (!planTypes.contains(planType) || existMaterialPlans.contains(key)) continue;
                    Set maters = org2Maters.computeIfAbsent(createorg, k -> new HashSet(16));
                    maters.add(material);
                    allMaters.add(material);
                }
            }
            if (!allMaters.isEmpty()) {
                int count = 0;
                int batch = (Integer)this.env.getCfgValue(EnvCfgItem.MRP_MATERIAL_PLANINFO_BATCH);
                HashSet<Long> materials = new HashSet<Long>(batch);
                Iterator iter = allMaters.iterator();
                do {
                    count = 0;
                    materials.clear();
                    while (iter.hasNext()) {
                        Long id = (Long)iter.next();
                        materials.add(id);
                        if (++count != batch) continue;
                        break;
                    }
                    QFilter qFilter = new QFilter("masterid", "in", materials);
                    if (!isIgnore) {
                        qFilter.and(qFilterStatus);
                    }
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"mpdm_materialplan", (String)"id,masterid,createorg", (QFilter[])new QFilter[]{qFilter}, null);){
                        for (Row row : dataSet) {
                            Long createorg = row.getLong("createorg");
                            Long material = row.getLong("masterid");
                            Long id = row.getLong("id");
                            Set maters = (Set)org2Maters.get(createorg);
                            if (maters == null || !maters.contains(material)) continue;
                            materialIds.add(material.toString());
                            materialPlanIds.add(id.toString());
                        }
                    }
                } while (count >= batch);
            }
        }
    }

    public void initPlanScopeRelation(MRPRedisStore dstore, Set<String> materialIds, Set<String> invPlanMaterials) {
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        if (planModel.isEnablePlanScope()) {
            MtPlanInfoModel mtPlanInfoModel = (MtPlanInfoModel)this.env.getService(MtPlanInfoModel.class);
            HashSet<String> planTypes = new HashSet<String>(mtPlanInfoModel.getPlanType());
            String select = "createorg,material,id,enable,entrymatplanscop.id entryid,entrymatplanscop.seq seq,entrymatplanscop.planscope planscope,entrymatplanscop.plantype plantype,entrymatplanscop.operator operator,entrymatplanscop.supplynetwork supplynetwork,entrymatplanscop.reorder reorder,entrymatplanscop.ecobatch ecobatch,entrymatplanscop.max max,entrymatplanscop.min min,entrymatplanscop.consexterneeds consexterneeds,entrymatplanscop.start_useing start_useing,entrymatplanscop.supplier_org supplier_org,entrymatplanscop.supplier_warehouse supplier_warehouse,entrymatplanscop.supplier_shipping supplier_shipping,entrymatplanscop.in_storage_org in_storage_org,entrymatplanscop.in_storage_warehouse in_storage_warehouse,entrymatplanscop.in_storage_shipping in_storage_shipping";
            QFilter[] qFilters = new QFilter[2];
            qFilters[0] = new QFilter("createorg", "in", MRPUtil.setStringParseLong(planModel.getRequirorgs()));
            int count = 0;
            int batch = (Integer)this.env.getCfgValue(EnvCfgItem.MRP_MATERIAL_PLANINFO_BATCH);
            HashSet<Long> materials = new HashSet<Long>(batch);
            Iterator<String> iter = materialIds.iterator();
            do {
                count = 0;
                materials.clear();
                while (iter.hasNext()) {
                    Long id = Long.parseLong(iter.next());
                    materials.add(id);
                    if (++count != batch) continue;
                    break;
                }
                HashMap<String, Map> mater2relations = new HashMap<String, Map>(batch);
                qFilters[1] = new QFilter("material", "in", materials);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"msplan_matplanscop", (String)select, (QFilter[])qFilters, null);){
                    for (Row row : dataSet) {
                        Long createorg = row.getLong("createorg");
                        Long material = row.getLong("material");
                        Long planscope = row.getLong("planscope");
                        String planType = this.env.isSpecialPlan() ? MaterialPlanMode.MRP.getValue() : row.getString("plantype");
                        String key = PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)createorg.toString(), (String)material.toString());
                        Map map = mater2relations.computeIfAbsent(key, k -> new HashMap(16));
                        Object[] data = new Object[18];
                        data[13] = row.get("id");
                        data[14] = row.get("entryid");
                        data[15] = row.get("seq");
                        data[17] = row.getBoolean("enable") != false && row.getBoolean("start_useing") != false;
                        data[16] = row.get("consexterneeds");
                        data[0] = planType;
                        data[1] = row.get("operator");
                        data[2] = row.get("supplynetwork");
                        data[3] = row.get("reorder");
                        data[4] = row.get("ecobatch");
                        data[5] = row.get("max");
                        data[6] = row.get("min");
                        data[7] = row.get("supplier_org");
                        data[8] = row.get("supplier_warehouse");
                        data[9] = row.get("supplier_shipping");
                        data[10] = row.get("in_storage_org");
                        data[11] = row.get("in_storage_warehouse");
                        data[12] = row.get("in_storage_shipping");
                        if (planscope <= 0L || !planTypes.contains(planType)) continue;
                        map.put(planscope.toString(), JSON.toJSONString((Object)data));
                        String planMode = MRPUtil.convert(data[0], "");
                        if (!MRPUtil.convert(data[17], Boolean.FALSE).booleanValue()) continue;
                        MRPUtil.addInvPlanMaterial(this.env, createorg, material, planMode, invPlanMaterials);
                    }
                }
                if (mater2relations.isEmpty()) continue;
                dstore.mapMSet("mpList_scope", mater2relations);
            } while (count >= batch);
        }
    }

    public Long[] getSupplyOrgAndWareHouse4Bom(Long[] defaultValue, Long org, String cacheKey) {
        Long warehouse = defaultValue[1];
        return this.getSupplyOrgAndWareHouse(org, warehouse, cacheKey, defaultValue);
    }

    public Long[] getSupplyOrgAndWareHouse4MaterialMftInfo(Object[] mftDatas, Long org, String cacheKey) {
        Long warehouse = MRPUtil.convert(mftDatas[1], 0L);
        Long[] defaultValue = new Long[]{MRPUtil.convert(mftDatas[0], 0L), MRPUtil.convert(mftDatas[1], 0L), MRPUtil.convert(mftDatas[2], 0L)};
        return this.getSupplyOrgAndWareHouse(org, warehouse, cacheKey, defaultValue);
    }

    public Long[] getSupplyOrgAndWareHouse4MftVersion(Object[] mftVersionDatas, Long org, String cacheKey) {
        Long warehouse = MRPUtil.convert(mftVersionDatas[1], 0L);
        Long[] defaultValue = new Long[]{MRPUtil.convert(mftVersionDatas[0], 0L), MRPUtil.convert(mftVersionDatas[1], 0L), MRPUtil.convert(mftVersionDatas[2], 0L)};
        return this.getSupplyOrgAndWareHouse(org, warehouse, cacheKey, defaultValue);
    }

    public Long[] getSupplyOrgAndWareHouse4MftVersionOrMftInfo(Object[] mftVersionDatas, Object[] mftDatas, Long org, String cacheKey) {
        Long warehouse = MRPUtil.convert(mftVersionDatas[1], 0L);
        Long[] defaultValue = new Long[]{MRPUtil.convert(mftVersionDatas[0], 0L), MRPUtil.convert(mftVersionDatas[1], 0L), MRPUtil.convert(mftVersionDatas[2], 0L)};
        Long[] value = this.getSupplyOrgAndWareHouse(org, warehouse, cacheKey, defaultValue);
        if (value == defaultValue) {
            return this.getSupplyOrgAndWareHouse4MaterialMftInfo(mftDatas, org, cacheKey);
        }
        return value;
    }

    private Long[] getSupplyOrgAndWareHouse(Long org, Long warehouse, String cacheKey, Long[] defaultValue) {
        Long[] values;
        Long scopeId;
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        String cacheValue = cacheDatas.getPlanScopeCache(cacheKey, (scopeId = cacheDatas.getPlanScope4orgAndWarehouse(org, warehouse)).toString(), true);
        if (cacheValue != null) {
            Object[] data = (Object[])JSON.parseObject((String)cacheValue, Object[].class);
            values = new Long[]{MRPUtil.convert(data[7], 0L), MRPUtil.convert(data[8], 0L), MRPUtil.convert(data[9], 0L)};
        } else {
            values = defaultValue;
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getPlanScopeByWareHouse(IMRPEnvProvider ctx, SupplyStruct ss, Long productStorageOrgUnitID, String material, boolean isCenterWarehouseCycle, String cacheKey, Long planScope, Long warehouse, boolean checkWarehouse) {
        Boolean isEnabled;
        if (planScope > 0L) {
            return planScope;
        }
        StringBuilder key = new StringBuilder();
        HashMap<Integer, Long> localCache = null;
        PlanScopeModel planScopeModel = this;
        synchronized (planScopeModel) {
            localCache = (HashMap<Integer, Long>)ctx.getLocalParams("kd.mmc.mrp.model.table.utils.DataBalanceUtil.getSupplyPlanScope");
            if (localCache == null) {
                localCache = new HashMap<Integer, Long>(8);
                ctx.putLocalParam("kd.mmc.mrp.model.table.utils.DataBalanceUtil.getSupplyPlanScope", localCache);
            }
        }
        CacheDatas cacheDatas = (CacheDatas)ctx.getService(CacheDatas.class);
        ResDataModelCollection resDataModelCollection = (ResDataModelCollection)ctx.getService(ResDataModelCollection.class);
        key.append(productStorageOrgUnitID).append(material).append(isCenterWarehouseCycle).append(cacheKey).append(warehouse);
        Integer hash = key.toString().hashCode();
        if (localCache.containsKey(hash)) {
            return (Long)localCache.get(hash);
        }
        if (checkWarehouse && warehouse > 0L && !resDataModelCollection.isWarehouseDataHavScope(ss, warehouse, material, isCenterWarehouseCycle)) {
            localCache.put(hash, null);
            return null;
        }
        Long scopeId = cacheDatas.getPlanScope4orgAndWarehouse(productStorageOrgUnitID, warehouse);
        String cacheValue = cacheDatas.getPlanScopeCache(cacheKey, scopeId.toString());
        Boolean bl = isEnabled = cacheValue == null ? null : (Boolean)ctx.getLocalParams(String.valueOf(cacheValue.hashCode()));
        if (isEnabled == null) {
            isEnabled = DataBalanceUtil.materialPlanScopeIsEnable(cacheValue);
            if (cacheValue != null) {
                ctx.putLocalParam(String.valueOf(cacheValue.hashCode()), isEnabled);
            }
        }
        planScope = isEnabled != false ? scopeId : ss.getPlanScope();
        localCache.put(hash, planScope);
        return planScope;
    }
}

