/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPDataMatchPlugin;
import kd.mmc.mrp.framework.IMRPDataSourceResolver;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.fomula.token.MethodToken;
import kd.mmc.mrp.framework.mq.event.MRPDataFetchEvent4Require;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.integrate.DataTranslator;
import kd.mmc.mrp.integrate.KDCloudMRPEnv;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanScopeModel;
import kd.mmc.mrp.integrate.entity.ResDataModel;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.strategy.ManustrategyConfirm;
import kd.mmc.mrp.model.table.ChooseCycleData;
import kd.mmc.mrp.model.table.MergeDataTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.utils.InvPlanUtil;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.utils.ExtPluginUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class RequireDataModel
extends ResDataModel {
    private static Log logger = LogFactory.getLog(RequireDataModel.class);
    private String mrpContextId;
    private long resRegId;
    private Long r2sTransId;
    private DynamicObject requireModel;
    private RequirementDataTable requireDatas;
    private List<FieldMapping> r2b;
    private List<FieldMapping> r2s;
    private List<FieldMapping> r2sNoFlex;
    private List<FieldMapping> r2sByFlex;
    private boolean isByFlex = false;
    private Set<String> materialFlexNos = new HashSet<String>();
    private List<FieldMapping> outputMapping;
    private String outputEntity;
    private String requireBillModelEntity;
    private boolean isPlanOrderExtendEntity;
    private String outputCollaborativeorder = "mrp_collaborativeorder";
    private Set<String> requireFields;
    private boolean is_single_calc = false;
    private Boolean isNullValueMatch = null;
    private static String[] manustrategyGroupFields = new String[]{"id", "strategy", "priority"};
    private DataTranslator dt = new DataTranslator();
    private static final String REDIS_STRATEGY = "strategy";
    private HashMap<String, DynamicObject> mergeRuleCache = new HashMap();
    private HashMap<String, DynamicObject> mergeDimenCache = new HashMap();
    private HashMap<String, DynamicObject> mergeCycleCache = new HashMap();
    private boolean isMatchResolverLoaded = false;
    private IMRPDataMatchPlugin matchResolver;
    private boolean isDataResolverLoaded = false;
    private IMRPDataSourceResolver dataResolver;
    private Set<Long> selectPlanDeleteOrderIds = new HashSet<Long>(16);
    private Set<Long> selectPlanDeleteCollIds = new HashSet<Long>(16);

    public RequireDataModel(long reqResRegId, Long r2sTransId, CalEnv env) {
        super(env);
        this.resRegId = reqResRegId;
        this.r2sTransId = r2sTransId;
        this.mrpContextId = env.getMRPContextId();
        this.init();
        this.initTableCols();
        env.addService(RequireDataModel.class, this);
    }

    private void init() {
        RunLogModel runLogModel;
        String runMode;
        this.requireModel = BusinessDataServiceHelper.loadSingle((Object)this.resRegId, (String)"mrp_resourceregister_cf");
        this.requireFields = this.buildFields(this.requireModel);
        this.r2b = this.checkB2RModelRelation(this.requireFields);
        this.outputMapping = this.checkOutputModelRelation(this.requireFields);
        if (this.requireModel.get("outputtype") != null) {
            this.outputEntity = this.requireModel.getDynamicObject("outputtype").getString("id");
        }
        if (kd.bos.util.StringUtils.isEmpty((String)this.outputEntity)) {
            this.outputEntity = "mrp_planorder";
        }
        this.isPlanOrderExtendEntity = MRPUtil.isPlanOrderExtendEntity(this.outputEntity);
        if (this.outputEntity.equals("mrp_simulateorder")) {
            this.outputCollaborativeorder = "mrp_simcolorder";
        }
        if ("mrp_selectmaterialplan".equalsIgnoreCase(runMode = (runLogModel = (RunLogModel)this.env.getService(RunLogModel.class)).getRunMode()) || "mrp_selectbillplan".equalsIgnoreCase(runMode)) {
            String json = MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getSelectMaterialIsSingleCalcKey(this.env.getMRPContextId()));
            this.is_single_calc = "1".equals(json);
        }
    }

    @Override
    public MRPEvent getEvent() {
        MRPDataFetchEvent4Require event = new MRPDataFetchEvent4Require();
        event.setMrpContextId(this.mrpContextId);
        return event;
    }

    @Override
    public String getCacheKey() {
        return "REQUIRE_MODELS";
    }

    @Override
    public DynamicObject getModel() {
        return this.requireModel;
    }

    @Override
    public RequirementDataTable getTable() {
        return this.requireDatas;
    }

    @Override
    public Set<String> getFields() {
        return this.requireFields;
    }

    private void initTableCols() {
        HashSet<String> indexCols = new HashSet<String>();
        if (this.r2sTransId != null) {
            DynamicObject r2sTrans = BusinessDataServiceHelper.loadSingle((Object)this.r2sTransId, (String)"mrp_billfieldtransfer");
            DynamicObjectCollection entry = r2sTrans.getDynamicObjectCollection("entryentity");
            this.r2s = RequireDataModel.buildModelRelation(entry, this.requireFields, false);
            for (FieldMapping fieldMapping : this.r2s) {
                indexCols.add(fieldMapping.getFrom());
            }
            this.r2sByFlex = new ArrayList<FieldMapping>(5);
            this.r2sNoFlex = new ArrayList<FieldMapping>(5);
            FieldMapping flexMapping = null;
            for (FieldMapping mapping : this.r2s) {
                if ("5".equals(mapping.getConverttype())) {
                    this.isByFlex = true;
                    flexMapping = mapping;
                    continue;
                }
                this.r2sNoFlex.add(mapping);
            }
            if (flexMapping != null) {
                String[] stringArray = this.getMetricFlexValues(flexMapping.getFlexMetricValue()).toArray(new String[0]);
                Set<String> srcEntitys = MethodToken.loadSourceEntityTypes(this.materialFlexNos, stringArray);
                DynamicObject sourceEntity = r2sTrans.getDynamicObject("srcbill");
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)sourceEntity.getString("number"));
                DataEntityPropertyCollection props = ((EntryProp)type.getProperty("entryentity")).getItemType().getProperties();
                HashSet<String> ignores = new HashSet<String>();
                for (int i = 0; i < props.size(); ++i) {
                    String entityNumber;
                    IDataEntityProperty prop = (IDataEntityProperty)props.get(i);
                    if (!(prop instanceof DynamicComplexProperty) || !srcEntitys.contains(entityNumber = ((DynamicComplexProperty)prop).getComplexType().getName())) continue;
                    ignores.add(("entryentity." + prop.getName()).toUpperCase());
                }
                for (FieldMapping mapping : this.r2s) {
                    if (ignores.contains(mapping.getFrom())) continue;
                    this.r2sByFlex.add(mapping);
                }
            }
        }
        if (this.r2b != null) {
            for (FieldMapping r : this.r2b) {
                indexCols.add(r.getFrom());
            }
        }
        indexCols.add(DefaultField.RequireField.DATE.getName());
        indexCols.add(DefaultField.RequireField.__PRIORITY_LEVEL__.getName());
        indexCols.add(DefaultField.RequireField.PROJECTPLANMODEL.getName());
        indexCols.add(DefaultField.RequireField.VEHICLETYPE.getName());
        this.requireDatas = new RequirementDataTable(this.env, indexCols);
        Iterator<String> its = this.requireFields.iterator();
        int index = 0;
        while (its.hasNext()) {
            this.requireDatas.getColIdx().put(its.next().toUpperCase(), index++);
        }
        int size = this.requireDatas.getColIdx().size();
        this.requireDatas.getColIdx().put(DefaultField.CommonField.ID.name(), size++);
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.MATERIALATTR.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.MATERIALATTR.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.INSPECTLEADDAYS.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.INSPECTLEADDAYS.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.LEADTYPE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.LEADTYPE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.FIXEDLEADDAYS.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.FIXEDLEADDAYS.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.DYNAMICLEADDAYS.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.DYNAMICLEADDAYS.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.PREPROCESSDAYS.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.PREPROCESSDAYS.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.POSTPROCESSDAYS.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.POSTPROCESSDAYS.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.DYNAMICBATCH.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.DYNAMICBATCH.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.DEMANDMERGERULE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.DEMANDMERGERULE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.EXCEPTIONMESSAGE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.EXCEPTIONNUMBER.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.REQUIREOPERAOTR.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.REQUIREOPERAOTR.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.__IS_MERGE_.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.__IS_MERGE_.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.__MERGE_REQBILL_NUM_.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.__MERGE_REQBILL_NUM_.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.__MERGE_REQBILL_ID_.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.__MERGE_REQBILL_ID_.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.__MERGE_REQBILL_ENTRYID_.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.__MERGE_REQBILL_ENTRYID_.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.__MERGE_REQBILL_ENTRYSEQ_.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.__MERGE_REQBILL_ENTRYSEQ_.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.__MERGE_REQQTY_.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.__MERGE_REQQTY_.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.PLAN_STRATEGY.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.PLAN_STRATEGY.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.STAND_QTY.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.STAND_QTY.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.YIELD.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.YIELD.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.ADVANCE_ADJUST_PERIOD.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.ADVANCE_ADJUST_PERIOD.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.DELAY_ADJUST_PERIOD.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.DELAY_ADJUST_PERIOD.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.TOLER_OF_FORWARD.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.TOLER_OF_FORWARD.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.TOLER_OF_DELAY.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.TOLER_OF_DELAY.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.BILL_ENTITY.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.BILL_ENTITY.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.__ISONWORK__.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.__ISONWORK__.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.REPLACEPLAN.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.REPLACEPLAN.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.ISREPLACEPLANMM.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.ISREPLACEPLANMM.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.ISREPLACE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.ISREPLACE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.REPLACEPRIORITY.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.REPLACEPRIORITY.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.REPLACESTRA.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.REPLACESTRA.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.REPLACEMETHOD.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.REPLACEMETHOD.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.FLEXMETRICID.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.FLEXMETRICID.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.FLEXMETRICVALUE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.FLEXMETRICVALUE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.ISDEPENTREQ.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.ISDEPENTREQ.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.REQUIRETYPE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.REQUIRETYPE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.MATERIALNAME.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.MATERIALNAME.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.MATERIALNUMBER.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.MATERIALNUMBER.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.PRODUCTORGNAME.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.PRODUCTORGNAME.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.PRODUCTORGNUMBER.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.PRODUCTORGNUMBER.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.PLANMODE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.PLANMODE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.INVALIDDATE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.INVALIDDATE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.SAFEINVTYPE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.SAFEINVTYPE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.SAFEINVDAYS.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.SAFEINVDAYS.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.MATERIALFLEXPROPS.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.MATERIALFLEXPROPS.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.IN_STORAGE_ORG.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.IN_STORAGE_ORG.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.IN_STORAGE_SHIPPING.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.IN_STORAGE_SHIPPING.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.SUPPLY_NETWORK.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.SUPPLY_NETWORK.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.DEMAND_SUPPLY_STRATEGY.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.DEMAND_SUPPLY_STRATEGY.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.SUPPLY_STRATEGY.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.SUPPLY_STRATEGY.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.TOP_REQUIRE_DATE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.TOP_REQUIRE_DATE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.PLANSCOPE.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.PLANSCOPE.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.SUPPLIER.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.SUPPLIER.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.__BOM_VERSION__.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.__BOM_VERSION__.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.__ISDEPENDENT__.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.__ISDEPENDENT__.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.PRODUCT.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.PRODUCT.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.ISDEPENDENT.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.ISDEPENDENT.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.ALLOWDROP.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.ALLOWDROP.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.MODULENUMERATOR.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.MODULENUMERATOR.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.MODULEDENOMINATOR.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.MODULEDENOMINATOR.getName(), size++);
        }
        if (!this.requireDatas.getColIdx().containsKey(DefaultField.RequireField.USERATIO.getName())) {
            this.requireDatas.getColIdx().put(DefaultField.RequireField.USERATIO.getName(), size++);
        }
        this.requireDatas.getColIdx().put(DefaultField.RequireField._LAST_DATE_.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__START_DATE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__END_DATE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__PRIORITY_LEVEL__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.CommonField.__MODEL_NUMBER__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.CommonField.__MODEL_ID__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__INV_PO_QTY__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__SUPPLY_QTY__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__REAL_QUATA__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDTYPE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDAMTTYPE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDNUMERATOR__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDDENOMINATOR__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDQTY__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDFIXSCRAP__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDSCRAPRATE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDSUPPLYTYPE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__PLAN_TAG__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__SRC_DATE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__REQUIRE_SOURCE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__REQUIRE_ORG_CHAIN__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__ORDER_DATE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__MATERIALPLAN__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDMATERIALPLAN__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__PLAN_USER__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__BOMID__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__PARENT_BOMID__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__SCRAPRATIO__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__DYNAMICSCRAPRATIO__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__FIXSCRAP__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__LEADTIME__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__IS_EXPANDABLE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__REAL_PARENT_MATERIAL__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__REPLACE_STRUCT__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__PARENT_MATERIAL__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__REPLACE_KEY__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__BOM_ENTRYID__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__REPLACE_MATERIAL__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__REPLACE_QTY__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.PARENT_BOMNUMBER.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__COPTYPE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__COPOPERATION__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDVALIDDATE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__CHILDINVALIDDATE__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__ENTRYAUXPROPERTY__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__REMARK__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.IS_TRACK_MATCH.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.INV_IS_TRACK_MATCH.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.SUPPLY_TRACKNUMBER.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.SUPPLY_MATERIALFLEXPROPS.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__QUOTA_SUPPLIER__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__ORIGIN_REQUIRE_ORG__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__IS_INTERNAL_GROSS_DEMAND__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.SUPPLIER_ORG.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.SUPPLIER_WAREHOUSE.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.SUPPLIER_SHIPPING.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.MATERIALPLAN_CREATEORG.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.MATERIALMFTINFO.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.MFTVERSION.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.REORDERPOINT.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.MAX.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.MIN.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.IS_INCLUDEREQUIRE.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.DEMAND_PLANMODE.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.IS_VIRTUAL_REQUIRE.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.ISSTOCKALLOT.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.ORIGIN_BILLENTITY.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.ORIGIN_BILLID.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.ORIGIN_BILLNUMBER.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.ORIGIN_BILLENTRYID.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.ORIGIN_BILLENTRYSEQ.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.BATCHPOLICY.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.BATCHINCQTY.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.BATCHINCREMENT.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.MINBATCHQTY.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.MAXBATCHQTY.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.PARTITIONQTY.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.FIXEDPERIOD.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.DYNAMICCYCLE.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.SPECIFIEDPERIOD.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.SEPARATORSYMBOL.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.INTERVALPERIOD.name(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__INVLEVEL_BILLNUMBER__.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__INVLEVEL_REQUIRE__.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__PO_ID__.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.BATCHPOLICYRICHQTY.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.BATCHPOLICYRICHDATE.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.RESERVEDTYPE.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.RESERVE_BILLNO.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.RESERVE_BILLID.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.RESERVE_BILLENTRYID.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.RESERVE_BILLENTRYSEQ.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__IS_CALC_REQUIRE__.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__EXIST_KEYPART__.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__BOM_IDX__.getName(), size++);
        this.requireDatas.getColIdx().put(DefaultField.RequireField.__SUPPLY_IDX__.getName(), size++);
        this.requireDatas.getNotNullableColMap().put(DefaultField.RequireField.MATERIAL.getName(), Long.class);
        this.requireDatas.getNotNullableColMap().put(DefaultField.RequireField.BILLID.getName(), Long.class);
        this.requireDatas.getNotNullableColMap().put(DefaultField.RequireField.QTY.getName(), BigDecimal.class);
        this.requireDatas.getNotNullableColMap().put(DefaultField.RequireField.PRODUCTIONORGUNIT.getName(), Long.class);
        this.requireDatas.getNotNullableColMap().put(DefaultField.RequireField.DATE.getName(), Long.class);
    }

    private List<FieldMapping> checkB2RModelRelation(Set<String> fromFields) {
        DynamicObject bomModel = this.requireModel.getDynamicObject("relativetransfer");
        if (bomModel == null) {
            return null;
        }
        bomModel = BusinessDataServiceHelper.loadSingle((Object)bomModel.get("id"), (String)"mrp_billfieldtransfer");
        DynamicObjectCollection relations = bomModel.getDynamicObjectCollection("entryentity");
        return RequireDataModel.buildModelRelation(relations, fromFields, false);
    }

    private List<FieldMapping> checkOutputModelRelation(Set<String> fromFields) {
        if (this.requireModel.get("outputmapping") == null) {
            this.requireBillModelEntity = "mrp_demandbill_model_inh";
            return new ArrayList<FieldMapping>();
        }
        DynamicObject outputModel = this.requireModel.getDynamicObject("outputmapping");
        outputModel = BusinessDataServiceHelper.loadSingle((Object)outputModel.get("id"), (String)"mrp_billfieldtransfer");
        this.requireBillModelEntity = outputModel.getString("srcbill.id");
        DynamicObjectCollection relations = outputModel.getDynamicObjectCollection("entryentity");
        return RequireDataModel.buildModelRelation(relations, fromFields, true);
    }

    public List<FieldMapping> getR2b() {
        return this.r2b;
    }

    public boolean r2sHavSNullValueMatch() {
        if (this.isNullValueMatch == null) {
            this.isNullValueMatch = false;
            List<FieldMapping> fieldMappings = this.getR2s();
            for (FieldMapping mapping : fieldMappings) {
                if (!mapping.isNullValueMatch()) continue;
                this.isNullValueMatch = true;
                break;
            }
        }
        return this.isNullValueMatch;
    }

    public List<FieldMapping> getR2s() {
        return this.getR2s(false);
    }

    public List<FieldMapping> getR2s(boolean isDepentReq) {
        if (isDepentReq && !this.r2sByFlex.isEmpty()) {
            return this.r2sByFlex;
        }
        return this.r2sNoFlex;
    }

    public Set<String> getMetricFlexValues(String flexMetricValue) {
        String[] nums;
        HashSet<String> billNos = new HashSet<String>(16);
        if (kd.bos.util.StringUtils.isEmpty((String)flexMetricValue)) {
            return billNos;
        }
        int startIndex = flexMetricValue.indexOf("[");
        int endIndex = flexMetricValue.indexOf("]");
        if (startIndex == -1 || endIndex == -1) {
            return billNos;
        }
        String value = flexMetricValue.substring(startIndex + 1, endIndex);
        for (String num : nums = value.split("[,]")) {
            if (!StringUtils.isNotBlank((CharSequence)num)) continue;
            String billNo = num.substring(1, num.length() - 1);
            billNos.add(billNo);
        }
        return billNos;
    }

    public boolean isByFlex() {
        return this.isByFlex;
    }

    public Set<String> getMaterialFlexNos() {
        return this.materialFlexNos;
    }

    public List<FieldMapping> getOutputMapping() {
        return this.outputMapping;
    }

    public String getRequireBillModelEntity() {
        return this.requireBillModelEntity;
    }

    public String getOutputType() {
        return this.outputEntity;
    }

    public boolean isPlanOrderExtendEntity() {
        return this.isPlanOrderExtendEntity;
    }

    public String getOutputCollaborativeorder() {
        return this.outputCollaborativeorder;
    }

    public void loadRequireMaterialExtProps() {
        final RequirementDataTable requireDatas = this.getTable();
        this.initMaterialPlanInfos();
        KDCloudMRPEnv.IMaterialPlanInfoApply applier = new KDCloudMRPEnv.IMaterialPlanInfoApply(){

            public HashMap<String, Object> toMap(Map<String, Object> info) {
                return RequireDataModel.this.infoToRequireMap(info);
            }

            @Override
            public void apply(HashMap<Integer, Map<String, Object>> colVals) {
                requireDatas.applyColValues(colVals);
            }
        };
        this.loadMaterialPlanInfo(requireDatas, DefaultField.RequireField.MATERIAL.getName(), DefaultField.RequireField.SUPPLYORGUNIT.getName(), DefaultField.RequireField.TRACKNUMBER.getName(), DefaultField.RequireField.PRODUCTIONORGUNIT.getName(), applier);
    }

    @Override
    protected void colValPut(Map<Integer, Map<String, Object>> colVals, int i, KDCloudMRPEnv.IMaterialPlanInfoApply applier, Map<String, Object> info) {
        PlanScopeModel planScopeModel = (PlanScopeModel)this.env.getService(PlanScopeModel.class);
        info = planScopeModel.loadPlanScope2RequireData(this.getTable().fetchRow(i), info);
        if (info != null) {
            super.colValPut(colVals, i, applier, info);
        }
    }

    public HashMap<String, Object> infoToRequireMap(Map<String, Object> info) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(DefaultField.RequireField.REORDERPOINT.getName(), info.get("reorderpoint"));
        ret.put(DefaultField.RequireField.MAX.getName(), info.get("max"));
        ret.put(DefaultField.RequireField.MIN.getName(), info.get("min"));
        ret.put(DefaultField.RequireField.IS_INCLUDEREQUIRE.getName(), info.get("isincluderequire"));
        ret.put(DefaultField.RequireField.MATERIALATTR.getName(), MRPUtil.getInt(info, "materialattr"));
        ret.put(DefaultField.RequireField.__MATERIALPLAN__.getName(), MRPUtil.getLong(info, "id"));
        ret.put(DefaultField.RequireField.MATERIALPLAN_CREATEORG.getName(), MRPUtil.getLong(info, "createorg"));
        ret.put(DefaultField.RequireField.SUPPLY_NETWORK.getName(), info.get("supplynetwork"));
        ret.put(DefaultField.RequireField.LEADTYPE.getName(), MRPUtil.getString(info, "leadtimetype"));
        ret.put(DefaultField.RequireField.FIXEDLEADDAYS.getName(), MRPUtil.getInt(info, "fixedleadtime"));
        ret.put(DefaultField.RequireField.DYNAMICLEADDAYS.getName(), MRPUtil.getInt(info, "changeleadtime"));
        ret.put(DefaultField.RequireField.INSPECTLEADDAYS.getName(), MRPUtil.getInt(info, "inspectionleadtime"));
        ret.put(DefaultField.RequireField.PREPROCESSDAYS.getName(), MRPUtil.getInt(info, "preprocessingtime"));
        ret.put(DefaultField.RequireField.POSTPROCESSDAYS.getName(), MRPUtil.getInt(info, "postprocessingtime"));
        ret.put(DefaultField.RequireField.DYNAMICBATCH.getName(), MRPUtil.getBigDecimal(info, "changebatch"));
        ret.put(DefaultField.RequireField.YIELD.getName(), MRPUtil.getBigDecimal(info, "yield"));
        ret.put(DefaultField.RequireField.__PLAN_TAG__.getName(), MRPUtil.getLong(info, "plantags"));
        ret.put(DefaultField.RequireField.__CHILDSCRAPRATE__.getName(), MRPUtil.getBigDecimal(info, "wastagerate"));
        ret.put(DefaultField.RequireField.REQUIREOPERAOTR.getName(), MRPUtil.getLong(info, "operator"));
        ret.put(DefaultField.RequireField.__PLAN_USER__.getName(), MRPUtil.getLong(info, "operator"));
        ret.put(DefaultField.RequireField.PLANMODE.getName(), MRPUtil.getString(info, "planmode"));
        ret.put(DefaultField.RequireField.DEMANDMERGERULE.getName(), MRPUtil.getLong(info, "demandmergerule"));
        Long manufactureGroup = MRPUtil.getLong(info, "manufacturegroup");
        String s = this.getDefaultStrategyByStrategyGroupId(manufactureGroup);
        ret.put(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName(), s);
        if (info.get("inv_not_allow_strategy") != null) {
            ret.put(DefaultField.RequireField.PLAN_STRATEGY.getName(), 0L);
        }
        ret.put(DefaultField.RequireField.ADVANCE_ADJUST_PERIOD.getName(), info.get("allowleadtime"));
        ret.put(DefaultField.RequireField.DELAY_ADJUST_PERIOD.getName(), info.get("allowdelayperiod"));
        ret.put(DefaultField.RequireField.TOLER_OF_FORWARD.getName(), info.get("leadadvance"));
        ret.put(DefaultField.RequireField.TOLER_OF_DELAY.getName(), info.get("delaytolerance"));
        ret.put(DefaultField.RequireField.BATCHPOLICY.getName(), MRPUtil.getString(info, "lotpolicy"));
        ret.put(DefaultField.RequireField.BATCHINCQTY.getName(), MRPUtil.getBigDecimal(info, "batchqty"));
        ret.put(DefaultField.RequireField.BATCHINCREMENT.getName(), MRPUtil.getBigDecimal(info, "batchincrement"));
        ret.put(DefaultField.RequireField.MINBATCHQTY.getName(), MRPUtil.getBigDecimal(info, "minlotsize"));
        ret.put(DefaultField.RequireField.MAXBATCHQTY.getName(), MRPUtil.getBigDecimal(info, "maxlotsize"));
        ret.put(DefaultField.RequireField.PARTITIONQTY.getName(), MRPUtil.getBigDecimal(info, "partitionbase"));
        ret.put(DefaultField.RequireField.FIXEDPERIOD.getName(), MRPUtil.getInt(info, "fixedperiod"));
        ret.put(DefaultField.RequireField.DYNAMICCYCLE.getName(), MRPUtil.getInt(info, "dynamiccycle"));
        ret.put(DefaultField.RequireField.SPECIFIEDPERIOD.getName(), MRPUtil.getLong(info, "specifiedperiod"));
        ret.put(DefaultField.RequireField.SEPARATORSYMBOL.getName(), MRPUtil.getString(info, "separatorsymbol"));
        ret.put(DefaultField.RequireField.INTERVALPERIOD.getName(), MRPUtil.getInt(info, "intervalperiod"));
        ret.put(DefaultField.RequireField.RESERVEDTYPE.getName(), MRPUtil.getString(info, "reservedtype"));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultStrategyByStrategyGroupId(Long manufactureGroup) {
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        Map<String, HashMap<String, Object>> id2ObjCache = cacheDatas.getId2ObjCache();
        if (manufactureGroup != null && manufactureGroup > 0L) {
            String key = "mpdm_manustrategy_group\u0001" + manufactureGroup;
            if (!id2ObjCache.containsKey(key)) {
                String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(this.env.getMRPContextId(), key);
                String cacheVal = MRPCacheManager.getInst().getSubData(this.env, REDIS_STRATEGY, cacheKey);
                HashMap<String, Object> strategy = null;
                if (cacheVal != null) {
                    strategy = this.dt.deserialize(cacheVal, HashMap.class);
                    id2ObjCache.put(key, strategy);
                } else {
                    QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)manufactureGroup)};
                    String selectFields = "id, entryentity.strategynumber strategy, entryentity.priority priority";
                    try (DataSet ds = cacheDatas.loadCacheDatas("mpdm_manustrategy_group", selectFields, filters, "entryentity.priority desc");){
                        if (ds == null) {
                            ds = ORM.create().queryDataSet(this.getClass().getName(), "mpdm_manustrategy_group", selectFields, filters, "entryentity.priority desc", 1);
                        }
                        if (ds.hasNext()) {
                            strategy = new HashMap<String, Object>();
                            Row row = ds.next();
                            for (String field : manustrategyGroupFields) {
                                strategy.put(field.trim(), row.get(field));
                            }
                            id2ObjCache.put(key, strategy);
                            MRPCacheManager.getInst().putSubData(this.env, REDIS_STRATEGY, cacheKey, this.dt.serialize(strategy));
                        }
                    }
                }
                if (strategy != null) {
                    Object s = strategy.get(REDIS_STRATEGY);
                    return s == null ? null : String.valueOf(s);
                }
                id2ObjCache.put(key, null);
            } else if (id2ObjCache.get(key) != null) {
                Object s = id2ObjCache.get(key).get(REDIS_STRATEGY);
                return s == null ? null : String.valueOf(s);
            }
        }
        return null;
    }

    public MergeDataTable createMergeTable(String ruleId) {
        DynamicObject rule = this.mergeRuleCache.get(String.valueOf(ruleId));
        if (rule == null) {
            rule = this.reloadDataById("mpdm_mergerule", ruleId);
            this.mergeRuleCache.put(String.valueOf(ruleId), rule);
        }
        DynamicObject mergeDimen = rule.getDynamicObject("mergedimen");
        Long mdId = mergeDimen.getLong("id");
        if ((mergeDimen = this.mergeDimenCache.get(String.valueOf(mdId))) == null) {
            mergeDimen = this.reloadDataById("mpdm_mergedimension", mdId);
            this.mergeDimenCache.put(String.valueOf(mdId), mergeDimen);
        }
        BigDecimal splitBatch = rule.getBigDecimal("splitbatch");
        DynamicObjectCollection entrys = mergeDimen.getDynamicObjectCollection("entryentity");
        MergeDataTable mergeDataTable = new MergeDataTable();
        List<String> mergeFields = mergeDataTable.getMergeFields();
        mergeDataTable.setSplitBatch(splitBatch);
        for (DynamicObject entry : entrys) {
            String identif = entry.getString("attridentif").toUpperCase();
            mergeFields.add(identif);
        }
        mergeDataTable.setCycleType(rule.getString("cycletype"));
        mergeDataTable.setDynamicCycle(rule.getInt("dynamiccycle"));
        mergeDataTable.setFixedCycle(rule.getInt("fixedcycle"));
        DynamicObject chooseCycle = rule.getDynamicObject("choosecycle");
        mergeDataTable.setDateOffsetDay(rule.getInt("date_offsetday"));
        mergeDataTable.setMergeType(rule.getString("mergetype"));
        mergeDataTable.setRequireSource(rule.containsProperty("is_require_source") && rule.getBoolean("is_require_source"));
        if (chooseCycle != null) {
            List<ChooseCycleData> cycleDatas = mergeDataTable.getChooseCycleDatas();
            Long cycleId = chooseCycle.getLong("id");
            if ((chooseCycle = this.mergeCycleCache.get(String.valueOf(cycleId))) == null) {
                chooseCycle = this.reloadDataById("mpdm_mergecycle", cycleId);
                this.mergeCycleCache.put(String.valueOf(cycleId), chooseCycle);
            }
            DynamicObjectCollection collection = chooseCycle.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : collection) {
                Date startDate = entry.getDate("entrystartdate");
                Date endDate = entry.getDate("entryenddate");
                Date mergeDate = entry.getDate("entrymergedate");
                ChooseCycleData cycleData = new ChooseCycleData(startDate, endDate, mergeDate);
                cycleDatas.add(cycleData);
            }
        }
        return mergeDataTable;
    }

    public HashMap<String, DynamicObject> getMergeRuleCache() {
        return this.mergeRuleCache;
    }

    public HashMap<String, DynamicObject> getMergeDimenCache() {
        return this.mergeDimenCache;
    }

    public HashMap<String, DynamicObject> getMergeCycleCache() {
        return this.mergeCycleCache;
    }

    public void loadRequireMaterialExtProps(RequireRowData rowData) {
        Map<String, Object> info;
        MtPlanInfoModel planInfo = (MtPlanInfoModel)this.env.getService(MtPlanInfoModel.class);
        this.initMaterialPlanInfos();
        String materialId = String.valueOf(rowData.getValue(DefaultField.RequireField.MATERIAL.getName()));
        String orgId = String.valueOf(rowData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        if (orgId == null || "null".equals(orgId)) {
            orgId = String.valueOf(rowData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        }
        if ((info = planInfo.getMaterialPlanInfo(materialId, orgId, new HashMap<String, Object>(InvPlanUtil.getExtendValMap(this.env, rowData, 0)))) != null) {
            PlanScopeModel planScopeModel = (PlanScopeModel)this.env.getService(PlanScopeModel.class);
            info = planScopeModel.loadPlanScope2RequireData(rowData, info);
            if (info == null) {
                return;
            }
            rowData.update(DefaultField.RequireField.MATERIALATTR.getName(), info.get("materialattr"));
            rowData.update(DefaultField.RequireField.__MATERIALPLAN__.getName(), info.get("id"));
            rowData.update(DefaultField.RequireField.MATERIALPLAN_CREATEORG.getName(), info.get("createorg"));
            rowData.update(DefaultField.RequireField.SUPPLY_NETWORK.getName(), info.get("supplynetwork"));
            rowData.update(DefaultField.RequireField.LEADTYPE.getName(), info.get("leadtimetype"));
            rowData.update(DefaultField.RequireField.FIXEDLEADDAYS.getName(), info.get("fixedleadtime"));
            rowData.update(DefaultField.RequireField.DYNAMICLEADDAYS.getName(), info.get("changeleadtime"));
            rowData.update(DefaultField.RequireField.INSPECTLEADDAYS.getName(), info.get("inspectionleadtime"));
            rowData.update(DefaultField.RequireField.PREPROCESSDAYS.getName(), info.get("preprocessingtime"));
            rowData.update(DefaultField.RequireField.POSTPROCESSDAYS.getName(), info.get("postprocessingtime"));
            rowData.update(DefaultField.RequireField.DYNAMICBATCH.getName(), info.get("changebatch"));
            rowData.update(DefaultField.RequireField.YIELD.getName(), info.get("yield"));
            rowData.update(DefaultField.RequireField.__PLAN_TAG__.getName(), info.get("plantags"));
            rowData.update(DefaultField.RequireField.__PLAN_USER__.getName(), info.get("operator"));
            rowData.update(DefaultField.RequireField.REQUIREOPERAOTR.getName(), (Object)MRPUtil.getLong(info, "operator"));
            rowData.update(DefaultField.RequireField.PLANMODE.getName(), info.get("planmode"));
            rowData.update(DefaultField.RequireField.__CHILDSCRAPRATE__.getName(), info.get("wastagerate"));
            rowData.update(DefaultField.RequireField.DEMANDMERGERULE.getName(), info.get("demandmergerule"));
            Long manufactureGroup = MRPUtil.getLong(info, "manufacturegroup");
            String s = this.getDefaultStrategyByStrategyGroupId(manufactureGroup);
            rowData.update(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName(), (Object)s);
            rowData.update(DefaultField.RequireField.ADVANCE_ADJUST_PERIOD.getName(), info.get("allowleadtime"));
            rowData.update(DefaultField.RequireField.DELAY_ADJUST_PERIOD.getName(), info.get("allowdelayperiod"));
            rowData.update(DefaultField.RequireField.TOLER_OF_FORWARD.getName(), info.get("leadadvance"));
            rowData.update(DefaultField.RequireField.TOLER_OF_DELAY.getName(), info.get("delaytolerance"));
            rowData.update(DefaultField.RequireField.BATCHPOLICY.getName(), (Object)MRPUtil.getString(info, "lotpolicy"));
            rowData.update(DefaultField.RequireField.BATCHINCQTY.getName(), (Object)MRPUtil.getBigDecimal(info, "batchqty"));
            rowData.update(DefaultField.RequireField.BATCHINCREMENT.getName(), (Object)MRPUtil.getBigDecimal(info, "batchincrement"));
            rowData.update(DefaultField.RequireField.MINBATCHQTY.getName(), (Object)MRPUtil.getBigDecimal(info, "minlotsize"));
            rowData.update(DefaultField.RequireField.MAXBATCHQTY.getName(), (Object)MRPUtil.getBigDecimal(info, "maxlotsize"));
            rowData.update(DefaultField.RequireField.PARTITIONQTY.getName(), (Object)MRPUtil.getBigDecimal(info, "partitionbase"));
            rowData.update(DefaultField.RequireField.FIXEDPERIOD.getName(), (Object)MRPUtil.getInt(info, "fixedperiod"));
            rowData.update(DefaultField.RequireField.DYNAMICCYCLE.getName(), (Object)MRPUtil.getInt(info, "dynamiccycle"));
            rowData.update(DefaultField.RequireField.SPECIFIEDPERIOD.getName(), (Object)MRPUtil.getLong(info, "specifiedperiod"));
            rowData.update(DefaultField.RequireField.SEPARATORSYMBOL.getName(), (Object)MRPUtil.getString(info, "separatorsymbol"));
            rowData.update(DefaultField.RequireField.INTERVALPERIOD.getName(), (Object)MRPUtil.getInt(info, "intervalperiod"));
            rowData.update(DefaultField.RequireField.RESERVEDTYPE.getName(), (Object)MRPUtil.getString(info, "reservedtype"));
            Long manustrategy = this.getManustrategy(this.env, info, rowData, materialId, orgId);
            boolean[] param = RequireDataModel.getManustrategyParam(this.env, manustrategy);
            boolean isTrackMatch = param[0];
            boolean allowdrop = param[2];
            rowData.update(DefaultField.RequireField.IS_TRACK_MATCH.getName(), (Object)isTrackMatch);
            rowData.update(DefaultField.RequireField.ALLOWDROP.getName(), (Object)allowdrop);
            rowData.update(DefaultField.RequireField.INV_IS_TRACK_MATCH.getName(), (Object)true);
            rowData.update(DefaultField.RequireField.PLAN_STRATEGY.getName(), (Object)(manustrategy > 0L ? manustrategy : null));
        }
    }

    private Long getManustrategy(CalEnv env, Map<String, Object> info, RequireRowData rowData, String materialId, String orgId) {
        Long manustrategy = 0L;
        String isEntryManustrategy = MRPUtil.getString(info, "isentrymanustrategy");
        if (ManustrategyConfirm.SUPERPARENT.getValue().equals(isEntryManustrategy)) {
            Long parentStrategy = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.PARENT_STRATEGY.getName()), 0L);
            return parentStrategy;
        }
        Integer isDependent = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.__ISDEPENDENT__.getName()), 0);
        if (isDependent == 0) {
            manustrategy = RequireDataModel.getManustrategyIdByTracknumber(env, MRPUtil.convert(rowData.getValue(DefaultField.RequireField.TRACKNUMBER.getName()), 0L));
        }
        if (manustrategy == 0L) {
            manustrategy = this.getManustrategyId(materialId, orgId);
        }
        return manustrategy;
    }

    public IMRPDataMatchPlugin getMatchResolver() {
        if (this.isMatchResolverLoaded) {
            return this.matchResolver;
        }
        if (this.matchResolver == null) {
            this.matchResolver = this.loadResolver(IMRPDataMatchPlugin.class, "matchresolver");
            if (this.matchResolver == null) {
                this.matchResolver = ExtPluginUtil.getProxyPlugin(null, IMRPDataMatchPlugin.class, "MRP_DATAMATCH_EXT", null);
            }
            this.isMatchResolverLoaded = true;
        }
        return this.matchResolver;
    }

    public IMRPDataSourceResolver getDataSourceResolver() {
        if (this.isDataResolverLoaded) {
            return this.dataResolver;
        }
        if (this.dataResolver == null) {
            this.dataResolver = this.loadResolver(IMRPDataSourceResolver.class, "dataresolver");
            if (this.dataResolver == null) {
                this.dataResolver = ExtPluginUtil.getProxyPlugin(null, IMRPDataSourceResolver.class, "MRP_DATASOURCERESOLVER_EXT", null);
            }
            this.isDataResolverLoaded = true;
        }
        return this.dataResolver;
    }

    private <T> T loadResolver(Class<T> clazz, String field) {
        DynamicObject resModel = this.requireModel;
        DynamicObject algoModule = resModel.getDynamicObject(field);
        if (algoModule != null) {
            algoModule = QueryServiceHelper.queryOne((String)"mrp_algoregister", (String)"algoimpletcalss", (QFilter[])new QFilter[]{new QFilter("id", "=", algoModule.get("id"))});
            String implClassName = algoModule.getString("algoimpletcalss");
            try {
                return clazz.cast(Class.forName(implClassName).newInstance());
            }
            catch (Throwable e) {
                logger.error("mrprunner-ext-class-init: failed.", e);
                throw new KDBizException(e, new ErrorCode("FAILED_TO_INIT_DATA_RESOLVER_PLUGIN", "FAILED_TO_INIT_DATA_RESOLVER_PLUGIN"), new Object[0]);
            }
        }
        return null;
    }

    public void reInitRequireTbl() {
        RequirementDataTable tmpTbl = new RequirementDataTable(this.env, new HashSet<String>());
        tmpTbl.setColIdx(this.requireDatas.getColIdx());
        tmpTbl.setFieldsMap(this.requireDatas.getFieldsMap());
        this.requireDatas = tmpTbl;
    }

    public void restoreRequireTbl(RequirementDataTable requireTbl) {
        this.requireDatas = requireTbl;
    }

    public boolean isIs_single_calc() {
        return this.is_single_calc;
    }

    public Set<Long> getSelectPlanDeleteOrderIds() {
        return this.selectPlanDeleteOrderIds;
    }

    public Set<Long> getSelectPlanDeleteCollIds() {
        return this.selectPlanDeleteCollIds;
    }
}

