/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.common.util.MRPORGUtil;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.integrate.KDCloudMRPEnv;
import kd.mmc.mrp.integrate.entity.BomDataModel;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.InventoryModel;
import kd.mmc.mrp.integrate.entity.ModelUtil;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.PlanScopeModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.integrate.entity.SupplyDataModel;
import kd.mmc.mrp.integrate.utils.SnapshotDataIntegrateUtils;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.model.enums.strategy.MaterialPlanMode;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.utils.ExtPluginUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.mpscmm.msplan.business.inventory.InvLevelEntry;
import kd.sdk.mmc.mrp.extpoint.IMRPMaterialPlanPlugin;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class ResDataModel {
    private static Log logger = LogFactory.getLog(ResDataModel.class);
    private static final ORM orm = ORM.create();
    protected CalEnv env;

    public ResDataModel(CalEnv env) {
        this.env = env;
    }

    public int fetchDatas(Set<Long> resConfigIds, IMRPExecuteLogRecorder lr, IMRPEnvProvider env) {
        DynamicObjectCollection dqs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", resConfigIds)});
        return this.fetch(lr, env, dqs);
    }

    public int fetchDatas(IMRPExecuteLogRecorder lr, IMRPEnvProvider env) {
        if (this.getModel() != null) {
            DynamicObjectCollection dataSrcs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("cgnumber.id", "=", (Object)this.getModel().getLong("id"))});
            return this.fetch(lr, env, dataSrcs);
        }
        return 0;
    }

    private int fetch(IMRPExecuteLogRecorder lr, IMRPEnvProvider env, DynamicObjectCollection dataSrcs) {
        CacheDatas cacheDatas = (CacheDatas)env.getService(CacheDatas.class);
        String cacheKey = this.getCacheKey();
        IMRPEventManager manager = (IMRPEventManager)env.getService(IMRPEventManager.class);
        HashMap<String, String> resId2EventId = new HashMap<String, String>();
        HashMap<String, String> eventId2ResId = new HashMap<String, String>();
        HashMap<String, Integer> eventId2LogIdx = new HashMap<String, Integer>();
        HashSet<String> ids = new HashSet<String>();
        int subStepIdx = 0;
        boolean isRequire = this instanceof RequireDataModel;
        boolean isSupply = this instanceof SupplyDataModel;
        String json = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getSelectBillSizeKey(env.getMRPContextId()));
        boolean isSelectBillPlan = json != null && Integer.parseInt(json) > 0;
        json = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getSelectMaterialSizeKey(env.getMRPContextId()));
        boolean isSelectMaterialPlan = json != null && Integer.parseInt(json) > 0;
        boolean isSelectBill2SelectMaterial = cacheDatas.isSelectMaterialPlan4PlanScope();
        if (isSelectBill2SelectMaterial) {
            isSelectBillPlan = false;
            isSelectMaterialPlan = true;
        }
        Set<String> dependDataSourceIds = cacheDatas.getDependDataSourceIds();
        for (DynamicObject dyn : dataSrcs) {
            HashSet<String> mIds;
            String jsonStr;
            String id = dyn.getString("id");
            ids.add(id);
            String number = dyn.getString("number");
            String name = dyn.getString("name");
            MRPEvent event = this.getEvent();
            event.setMrpContextId(env.getMRPContextId());
            event.setParam(MultiThreadCacheKey.KEY_MODEL_ID, (Serializable)((Object)id));
            event.setSubStepIdx(subStepIdx++);
            event.setRecorder(env.createLogRecorder());
            if (isRequire && isSelectBillPlan) {
                jsonStr = MRPCacheManager.getInst().getSubData(env, "selectbills", MRPRuntimeConsts.getSelectBillDataKey(env.getMRPContextId(), id));
                if (cacheDatas.isSelectBillPlan() && dependDataSourceIds.contains(id)) {
                    json = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getSelectBillMaterialKey(env.getMRPContextId()));
                    if (json != null) {
                        mIds = new HashSet(JSON.parseArray((String)json, String.class));
                        QFilter qFilter = new QFilter(DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH), "in", mIds.isEmpty() ? Collections.singletonList(0L) : MRPUtil.setStringParseLong(mIds));
                        event.setParam(MultiThreadCacheKey.KEY_RES_CUSTOM_FILTER, (Serializable)((Object)qFilter.toSerializedString()));
                        event.setParam(MultiThreadCacheKey.KEY_IS_SELECT_MATERIAL_PLAN, Boolean.valueOf(true));
                        resId2EventId.put(id, event.getEventId());
                        manager.publishCalcEvent(event);
                    }
                } else if (jsonStr != null) {
                    List list = JSON.parseArray((String)jsonStr, Object[].class);
                    ArrayList<Long> billIds = new ArrayList<Long>(list.size());
                    ArrayList<Long> billEntryIds = new ArrayList<Long>(list.size());
                    String billEntryKey = null;
                    for (Object[] obj : list) {
                        Long billId = MRPUtil.convert(obj[0], 0L);
                        Long billEntryId = MRPUtil.convert(obj[1], 0L);
                        if (StringUtils.isEmpty(billEntryKey)) {
                            billEntryKey = MRPUtil.convert(obj[2], "");
                        }
                        if (StringUtils.isNotEmpty(billEntryKey) && billEntryId > 0L) {
                            billEntryIds.add(billEntryId);
                            continue;
                        }
                        if (billId <= 0L) continue;
                        billIds.add(billId);
                    }
                    QFilter qFilter = null;
                    if (StringUtils.isNotEmpty(billEntryKey)) {
                        qFilter = new QFilter(billEntryKey + ".id", "in", billEntryIds);
                    } else if (!billIds.isEmpty()) {
                        qFilter = new QFilter("id", "in", billIds);
                    }
                    if (qFilter != null) {
                        event.setParam(MultiThreadCacheKey.KEY_RES_CUSTOM_FILTER, (Serializable)((Object)qFilter.toSerializedString()));
                        resId2EventId.put(id, event.getEventId());
                        manager.publishCalcEvent(event);
                    }
                }
            } else if ((isSupply && isSelectBillPlan || isSelectMaterialPlan && (isRequire || isSupply)) && !"mrp_cps_runner".equals(env.getRunMode())) {
                jsonStr = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getSelectBillMaterialKey(env.getMRPContextId()));
                if (jsonStr != null) {
                    mIds = new HashSet<String>(JSON.parseArray((String)jsonStr, String.class));
                    String fieldKey = isSupply ? DefaultField.SupplyField.MATERIAL.getName().toLowerCase(Locale.ENGLISH) : DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH);
                    QFilter qFilter = new QFilter(fieldKey, "in", mIds.isEmpty() ? Collections.singletonList(0L) : MRPUtil.setStringParseLong(mIds));
                    event.setParam(MultiThreadCacheKey.KEY_RES_CUSTOM_FILTER, (Serializable)((Object)qFilter.toSerializedString()));
                    event.setParam(MultiThreadCacheKey.KEY_IS_SELECT_MATERIAL_PLAN, Boolean.valueOf(isSelectMaterialPlan));
                    resId2EventId.put(id, event.getEventId());
                    manager.publishCalcEvent(event);
                }
            } else {
                resId2EventId.put(id, event.getEventId());
                manager.publishCalcEvent(event);
            }
            eventId2ResId.put(event.getEventId(), id);
            eventId2LogIdx.put(event.getEventId(), subStepIdx - 1);
            String tip = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u3010%1$s(%2$s)\u3011\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u6570\u636e", (String)"ResDataModel_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), name == null ? "" : name, number);
            lr.createSubStepLog(subStepIdx, tip, lr.getLogIdx());
            lr.saveStepLog(false);
        }
        MRPCacheManager.getInst().putData(env, cacheKey, JSON.toJSONString(ids, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        manager.wait4Response();
        for (Map.Entry entry : eventId2LogIdx.entrySet()) {
            Integer idx = (Integer)entry.getValue();
            String modelId = (String)eventId2ResId.get(entry.getKey());
            String rc = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getQueryModelRowCountKey(modelId));
            String endTs = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getQueryModelTimeCostKey(modelId));
            lr.updateSubStepLog(idx, "entrydetailmsg", String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u884c\u6570\uff1a%s", (String)"ResDataModel_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), rc == null ? Integer.valueOf(0) : rc));
            lr.updateSubStepLog(idx, "entryoperatmin", endTs);
            lr.updateSubStepLog(idx, "entryresult", MRPExecuteStatus.FINISHED.getAlias());
            lr.saveStepLog(false);
        }
        if (this instanceof BomDataModel) {
            this.mergeBOMQueryDatas(resId2EventId);
            return 0;
        }
        return this.cacheRefresh(resId2EventId, isRequire);
    }

    private int cacheRefresh(HashMap<String, String> resId2EventId, boolean isRequire) {
        long start = System.currentTimeMillis();
        int rowCount = 0;
        HashMap<String, ArrayList<String>> summarize = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, String> it : resId2EventId.entrySet()) {
            String evtId = it.getValue();
            String modelId = it.getKey();
            String val = MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getRowCountKey(evtId, modelId));
            if (val == null || "null".equals(val)) {
                DynamicObject ds = orm.queryOne("mrp_resource_dataconfig", "id,number,name", new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(modelId))});
                throw new MRPBizException(new ErrorCode("FETCH_DATASOURCE_FAILED", String.format(ResManager.loadKDString((String)"%1$s(%2$s)\u6570\u636e\u6e90\u53d6\u6570\u5931\u8d25\uff0c\u65e0\u6cd5\u8bfb\u53d6\u53d6\u6570\u8fd4\u56de\u884c\u6570\u3002", (String)"ResDataModel_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]), ds.getString("name"), ds.getString("number"))));
            }
            rowCount += Integer.parseInt(val);
            val = MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getSeparateKey(evtId, modelId));
            List keys = JSON.parseArray((String)val, String.class);
            for (String materialId : keys) {
                ArrayList<String> dataKeys = (ArrayList<String>)summarize.get(materialId);
                if (dataKeys == null) {
                    dataKeys = new ArrayList<String>(16);
                }
                dataKeys.add(MRPRuntimeConsts.getDataKey(evtId, modelId, materialId));
                summarize.put(materialId, dataKeys);
            }
        }
        String mrpContextId = this.env.getMRPContextId();
        if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-cacheRefresh-merge-datakeys-timecost: %s", mrpContextId, System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        MtPlanInfoModel planInfo = (MtPlanInfoModel)this.env.getService(MtPlanInfoModel.class);
        Set<String> enabledMaterialIds = planInfo.getEnabledMaterialIds();
        for (Map.Entry it : summarize.entrySet()) {
            String key;
            String materialId = (String)it.getKey();
            ArrayList list = (ArrayList)it.getValue();
            String string = key = isRequire ? MRPRuntimeConsts.getMaterialKey4Require(mrpContextId, materialId) : MRPRuntimeConsts.getMaterialKey4Supply(mrpContextId, materialId);
            if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mrprunner-recycle-materials, mid: %s, size: %s", materialId, list.size()));
            }
            MRPCacheManager.getInst().putData(this.env, key, JSON.toJSONString((Object)list, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            if (!isRequire && !enabledMaterialIds.contains(materialId)) continue;
            this.getTable().getSrcDataKeys().add(materialId);
        }
        logger.warn(String.format("ctxid: %s, mrprunner-cacheRefresh-refresh-datakeys-timecost: %s", mrpContextId, System.currentTimeMillis() - start));
        return rowCount;
    }

    private void mergeBOMQueryDatas(HashMap<String, String> resId2EventId) {
        for (Map.Entry<String, String> it : resId2EventId.entrySet()) {
            Object[] metas;
            String key = it.getKey();
            String value = it.getValue();
            String json = MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getSeparateKey(value, key));
            if (json == null) {
                if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.error("getDataError is null, key=" + MRPRuntimeConsts.getSeparateKey(value, key));
                }
                throw new RuntimeException("getDataError is null, key=" + MRPRuntimeConsts.getSeparateKey(value, key));
            }
            for (String string : metas = (String[])JSON.parseObject((String)json, String[].class)) {
                List datas = JSON.parseArray((String)MRPCacheManager.getInst().getSubData(this.env, "bom-" + string, MRPRuntimeConsts.getDataKey(value, key, "")), Object[].class);
                if (datas == null || datas.isEmpty()) {
                    logger.warn(String.format("ctxid: %s, mrprunner-mergeBOMQueryDatas-isEmpty,metas:%s", this.env.getMRPContextId(), Arrays.toString(metas)));
                    continue;
                }
                this.restoreTableDatas(value, key, null, datas);
            }
        }
    }

    public void restoreTableDatas(String evtId, String id, String groupKey, List<Object[]> datas) {
        DynamicObject model;
        DynamicObject dataSource;
        ResDataModelCollection resDataModel = (ResDataModelCollection)this.env.getService(ResDataModelCollection.class);
        Map<String, DynamicObject[]> dataQueryCache = resDataModel.getDataQueryCache();
        AbstractResModelDataTable table = this.getTable();
        DynamicObject resModel = this.getModel();
        DynamicObject[] cache = dataQueryCache.get(id);
        if (cache == null) {
            dataSource = this.reloadDataById("mrp_resource_dataconfig", id);
            model = dataSource.getDynamicObject("billfieldtransfer");
            model = this.reloadDataById("mrp_billfieldtransfer", model.getString("id"));
            cache = new DynamicObject[]{dataSource, model};
            dataQueryCache.put(id, cache);
        }
        dataSource = cache[0];
        model = cache[1];
        DynamicObjectCollection entrys = model.getDynamicObjectCollection("entryentity");
        table.getFieldsMap().clear();
        for (DynamicObject mapping : entrys) {
            String destField = mapping.getString("destfieldflag").toUpperCase();
            ArrayList labels = table.getFieldsMap().computeIfAbsent(destField, k -> new ArrayList());
            labels.add(destField);
        }
        List metas = JSON.parseArray((String)MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getMetaKey(evtId, id)), String.class);
        if (metas == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u6ce8\u518c\u914d\u7f6e(%1$s) - \u6570\u636e\u6e90\u914d\u7f6e(%2$s) - \u53d6\u6570\u5217\u540d\u6570\u7ec4\uff08\u7f13\u5b58\uff09\u4e3a\u7a7a\u3002", (String)"ResDataModel_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]), resModel.getString("name"), dataSource.getString("name"));
            throw new MRPBizException(Errors.getExecuteDataQueryFailed(), msg);
        }
        StringBuilder message = new StringBuilder();
        String srcName = dataSource.getString("name");
        String dataSrcId = dataSource.getString("id");
        if (StringUtils.isEmpty((String)srcName)) {
            srcName = model.getDynamicObject("srcbill").getString("name");
        }
        String srcId = model.getDynamicObject("srcbill").getString("id");
        StringBuilder fill = table.fill(metas, datas, srcId, dataSrcId, srcName, model.getString("name"));
        message.append((CharSequence)fill);
        if (message.length() > 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u6ce8\u518c\u914d\u7f6e\u201c%1$s\u201d - \u6570\u636e\u6e90\u914d\u7f6e\u201c%2$s\u201d - \u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u201c%3$s\u201d:%4$s\u503c\u4e3a\u7a7a\u3002", (String)"ResDataModel_15", (String)"mmc-mrp-mservice", (Object[])new Object[0]), resModel.getString("name"), dataSource.getString("name"), model.getString("name"), message.toString());
            logger.warn(String.format("ctxid: %s, mrprunner-restoreTableDatas-error,message:%s", this.env.getMRPContextId(), msg));
            this.writeMRPExceptionInfo(msg);
        }
    }

    public void writeMRPExceptionInfo(String msg) {
        String type = "B";
        if (this.getTable() instanceof RequirementDataTable) {
            type = "R";
        } else if (this.getTable() instanceof SupplymentDataTable) {
            type = "S";
        }
        RunLogModel runLogModel = (RunLogModel)this.env.getService(RunLogModel.class);
        DynamicObject mrpcalc_errorlog = BusinessDataServiceHelper.newDynamicObject((String)"msplan_mrpcalc_errorlog");
        mrpcalc_errorlog.set("id", (Object)ID.genLongId());
        mrpcalc_errorlog.set("runlogno", (Object)runLogModel.getRunLogNumber());
        mrpcalc_errorlog.set("errorinfo_tag", (Object)msg);
        mrpcalc_errorlog.set("type", (Object)type);
        if (msg.length() > 250) {
            mrpcalc_errorlog.set("errorinfo", (Object)msg.substring(0, 250));
        } else {
            mrpcalc_errorlog.set("errorinfo", (Object)msg);
        }
        mrpcalc_errorlog.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mrpcalc_errorlog});
    }

    protected DynamicObject reloadDataById(String entityName, Object id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
    }

    public abstract MRPEvent getEvent();

    public abstract String getCacheKey();

    public abstract DynamicObject getModel();

    public abstract AbstractResModelDataTable getTable();

    public abstract Set<String> getFields();

    protected Set<String> buildFields(DynamicObject model) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)model.getDynamicObject("businessentity").getString("id"));
        String name = mainType.getName();
        Map allEntities = mainType.getAllEntities();
        for (Map.Entry entry : allEntities.entrySet()) {
            EntityType value = (EntityType)entry.getValue();
            String entryName = value.getName();
            if (name.equals(entryName)) continue;
            for (String field : value.getFields().keySet()) {
                String entryField = entryName + '.' + field;
                fields.add(entryField.toUpperCase(Locale.ENGLISH));
            }
        }
        return fields;
    }

    public static List<FieldMapping> buildModelRelation(DynamicObjectCollection relations, Set<String> fromFields, boolean isOut) {
        String fromKey = "sourcefieldflag";
        String toKey = "destfieldflag";
        ArrayList<FieldMapping> ret = new ArrayList<FieldMapping>();
        StringBuilder message = new StringBuilder();
        for (DynamicObject relation : relations) {
            FieldMapping mapping = new FieldMapping();
            mapping.setFrom(relation.getString(fromKey).toUpperCase());
            mapping.setTo(relation.getString(toKey).toUpperCase());
            mapping.setConverttype(relation.getString("converttype"));
            String condition = relation.getString("calculateexc");
            boolean isNullMatch = relation.containsProperty("isnullmatch") && relation.getBoolean("isnullmatch");
            mapping.setNullValueMatch(isNullMatch);
            if (StringUtils.isNotEmpty((String)condition)) {
                condition = StringEscapeUtils.unescapeJava((String)condition);
                relation.set("calculateexc", (Object)condition);
            }
            if (fromFields.contains(mapping.getFrom())) {
                ret.add(mapping);
            } else if (!fromFields.contains(mapping.getFrom()) && !isOut) {
                MRPUtil.parseFormula(mapping, condition, message);
                ret.add(mapping);
            } else {
                ret.add(mapping);
            }
            String convetType = String.valueOf(relation.get("converttype"));
            if ("4".equals(convetType) || "5".equals(convetType)) {
                MRPUtil.parseFormula(mapping, condition, message);
            }
            if ("5".equals(convetType)) {
                mapping.setFlexMetricValue(condition);
            }
            if ("1".equals(convetType) || "3".equals(convetType)) {
                mapping.setFormulaValue(relation.getString("calculateexc"));
            }
            if (!"2".equals(convetType)) continue;
            mapping.setFormulaValue(relation.getString("calculateexc_tag"));
        }
        if (message.length() > 0) {
            throw new MRPBizException(Errors.getParseRelationFailed(), message);
        }
        return ret;
    }

    String getMRPContextId() {
        return this.env.getMRPContextId();
    }

    Set<String> getEnabledMaterialIds() {
        MtPlanInfoModel planInfo = (MtPlanInfoModel)this.env.getService(MtPlanInfoModel.class);
        return planInfo.getEnabledMaterialIds();
    }

    Set<String> getEnabledMaterialPlanIds() {
        MtPlanInfoModel planInfo = (MtPlanInfoModel)this.env.getService(MtPlanInfoModel.class);
        return planInfo.getEnabledMaterialPlanIds();
    }

    public synchronized void initMaterialPlanInfos() {
        this.initMaterialPlanInfos(true, this.getEnabledMaterialIds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initMaterialPlanInfos(boolean isGlobalInit, Set<String> enabledMaterialIds) {
        String value;
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        ResDataModelCollection resDataModelCollection = (ResDataModelCollection)this.env.getService(ResDataModelCollection.class);
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        long start = System.currentTimeMillis();
        QFilter dataFilter = new QFilter("status", "=", (Object)"C");
        dataFilter.and(new QFilter("enable", "=", (Object)"1"));
        if (isGlobalInit && MRPCacheManager.getInst().getData(this.env, "IS_MP_CACHED") != null) {
            return;
        }
        if (isGlobalInit) {
            MRPCacheManager.getInst().putData(this.env, "IS_MP_CACHED", "1");
        }
        MRPRedisStore dstore = MRPCacheManager.getDStore(this.getMRPContextId());
        if (enabledMaterialIds.isEmpty()) {
            StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"mrprunner-load-material-range, \u83b7\u53d6\u6709\u6548\u7269\u6599\uff08\u7f13\u5b58\uff09\u4e3a\u7a7a, ctxid: ", (String)"ResDataModel_8", (String)"mmc-mrp-mservice", (Object[])new Object[0])).append(this.getMRPContextId());
            throw new MRPBizException(Errors.getExecuteDataQueryFailed(), msg.toString());
        }
        HashSet<String> invPlanMaterials = new HashSet<String>(16);
        if (isGlobalInit && (value = MRPCacheManager.getInst().getData(this.env, MRPRuntimeConsts.getInvMaterialKey(this.env.getMRPContextId()))) != null) {
            invPlanMaterials.addAll(JSON.parseArray((String)value, String.class));
        }
        Iterator<String> iter = enabledMaterialIds.iterator();
        String ctxId = this.getMRPContextId();
        HashSet<Long> materials = new HashSet<Long>(1);
        int count = 0;
        int batch = (Integer)this.env.getCfgValue(EnvCfgItem.MRP_MATERIAL_PLANINFO_BATCH);
        MRPORGUtil orgUtil = new MRPORGUtil();
        Set<Long> requireOrgs = MRPUtil.setStringParseLong(planModel.getRequirorgs());
        String mpSelectFields = this.getMaterialPlanSelectField();
        while (true) {
            count = 0;
            materials.clear();
            while (iter.hasNext()) {
                String id = iter.next();
                materials.add(Long.valueOf(id));
                if (++count != batch) continue;
                break;
            }
            if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.info(String.format("ctxid: %s, mrprunner-fetchMP-loadMP, begin-batch, materials-size: %s, materials: %s ", ctxId, materials.size(), materials));
            }
            QFilter mFilter = new QFilter("masterid", "in", materials);
            HashMap<String, Map<String, Object>> materialBatchMap = new HashMap<String, Map<String, Object>>(materials.size());
            HashMap<String, String> sharePlanInfoCache = new HashMap<String, String>(8);
            HashMap<String, Map> controlScopeSharePlanInfoCache = new HashMap<String, Map>(8);
            long stepStart = System.currentTimeMillis();
            QFilter[] filters = "IGNORE".equals(this.env.getCfgValue(EnvCfgItem.MATERIAL_PLAN_INFO_SETTINGS)) ? new QFilter[]{mFilter} : new QFilter[]{dataFilter, mFilter};
            DataSet c = null;
            try {
                TXHandle h = TX.notSupported((String)"initMaterialPlanInfos");
                Throwable throwable = null;
                try {
                    DataSet cds = cacheDatas.loadCacheDatas("mpdm_materialplan", mpSelectFields, filters, "id asc");
                    c = cds != null ? SnapshotDataIntegrateUtils.wrap(cds) : orm.queryDataSet(KDCloudMRPEnv.class.getName(), "mpdm_materialplan", mpSelectFields, filters, "id asc");
                    if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                        logger.warn(String.format("ctxid: %s, mrprunner-fetchMP-loadMP, step-timecost: %s(ms)", ctxId, System.currentTimeMillis() - stepStart));
                    }
                    while (c.hasNext()) {
                        Row row = c.next();
                        long id = row.getLong("id");
                        long masterId = row.getLong("masterid");
                        long orgId = row.getLong("createorg");
                        String ctrlstrategy = row.getString("ctrlstrategy");
                        String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(ctxId, resDataModelCollection.getMaterialPlanKeys(String.valueOf(masterId), String.valueOf(orgId)));
                        if (!this.isEnableMaterialPlan(row)) {
                            materialBatchMap.put(cacheKey, MRPUtil.emptyMapNotModify);
                            continue;
                        }
                        HashMap<String, Object> rowToMap = this.rowToMap(c.getRowMeta(), row);
                        String planMode = row.getString("planmode");
                        if (this.env.isSpecialPlan()) {
                            planMode = MaterialPlanMode.MRP.getValue();
                            rowToMap.put("planmode", planMode);
                        }
                        if (isGlobalInit && !MaterialPlanMode.MANUPURCHASE.getValue().equalsIgnoreCase(planMode)) {
                            MRPUtil.addInvPlanMaterial(this.env, orgId, masterId, planMode, invPlanMaterials);
                        }
                        materialBatchMap.put(cacheKey, rowToMap);
                        if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                            String number = row.getString("number");
                            logger.warn(String.format("ctxid: %s, mrprunner-fetchMP-loadMP, mid: %s, mnum: %s, cacheKey: %s ,rowToMap : %s", ctxId, masterId, number, cacheKey, rowToMap));
                        }
                        if ("5".equals(ctrlstrategy)) {
                            sharePlanInfoCache.put(String.valueOf(masterId), String.valueOf(orgId));
                            continue;
                        }
                        if ("7".equals(ctrlstrategy)) continue;
                        Map setMap = controlScopeSharePlanInfoCache.computeIfAbsent(String.valueOf(masterId), k -> new HashMap());
                        Set relationOrgs = orgUtil.getRelationOrg(Long.valueOf(orgId), Long.valueOf(id), "mpdm_materialplan", ctrlstrategy, requireOrgs);
                        setMap.put(orgId, relationOrgs);
                    }
                    dstore.mapMSet("mpList", materialBatchMap);
                    dstore.mapMSet("mpList_share", sharePlanInfoCache);
                    dstore.mapMSet("mpList_ctrl_share", controlScopeSharePlanInfoCache);
                    if (count >= batch) continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                    continue;
                }
            }
            finally {
                if (c == null) continue;
                c.close();
                continue;
            }
            break;
        }
        Boolean cfgValue = (Boolean)this.env.getCfgValue(EnvCfgItem.INV_LEVEL_CALC);
        if (isGlobalInit && cfgValue.booleanValue()) {
            this.getInvMt(dstore, ctxId);
        }
        PlanScopeModel planScopeModel = (PlanScopeModel)this.env.getService(PlanScopeModel.class);
        planScopeModel.initPlanScopeRelation(dstore, enabledMaterialIds, invPlanMaterials);
        if (isGlobalInit) {
            MRPCacheManager.getInst().putData(this.env, MRPRuntimeConsts.getInvMaterialKey(this.env.getMRPContextId()), JSON.toJSONString(invPlanMaterials));
        }
        logger.warn(String.format("ctxid: %s, mrprunner-fetchMP-all, timecost: %s(ms)", this.getMRPContextId(), System.currentTimeMillis() - start));
    }

    private String getMaterialPlanSelectField() {
        String extFields;
        IMRPMaterialPlanPlugin imrpMaterialPlanPlugin = ExtPluginUtil.getProxyPlugin(null, IMRPMaterialPlanPlugin.class, "MRP_MATERIALPLAN_PLUGIN_EXT", null);
        if (imrpMaterialPlanPlugin != null && StringUtils.isNotEmpty((String)(extFields = imrpMaterialPlanPlugin.getMaterialPlanExtQueryField()))) {
            List mpExtFields = Arrays.stream(extFields.split(",")).map(String::trim).collect(Collectors.toList());
            MtPlanInfoModel.mpFieldList.addAll(mpExtFields);
            return String.format("%s, %s", "id,number,ctrlstrategy, masterid, createorg, materialattr, leadtimetype, fixedleadtime, changeleadtime, inspectionleadtime, preprocessingtime, postprocessingtime, changebatch, yield, plantag, wastagerate, operator, planmode, plantags, manufacturegroup, allowleadtime, allowdelayperiod, leadadvance, delaytolerance, wastagerateformula, demandmergerule, lotpolicy, batchqty, batchincrement, minlotsize, maxlotsize, separatorsymbol, intervalperiod, partitionbase, dynamiccycle, fixedperiod, specifiedperiod, reservedtype, supplynetwork, reorderpoint, max, min, isincluderequire, isentrymanustrategy", extFields);
        }
        return "id,number,ctrlstrategy, masterid, createorg, materialattr, leadtimetype, fixedleadtime, changeleadtime, inspectionleadtime, preprocessingtime, postprocessingtime, changebatch, yield, plantag, wastagerate, operator, planmode, plantags, manufacturegroup, allowleadtime, allowdelayperiod, leadadvance, delaytolerance, wastagerateformula, demandmergerule, lotpolicy, batchqty, batchincrement, minlotsize, maxlotsize, separatorsymbol, intervalperiod, partitionbase, dynamiccycle, fixedperiod, specifiedperiod, reservedtype, supplynetwork, reorderpoint, max, min, isincluderequire, isentrymanustrategy";
    }

    private void getInvMt(MRPRedisStore dstore, String ctxId) {
        InventoryModel invModel = (InventoryModel)this.env.getService(InventoryModel.class);
        ResDataModelCollection resDataModelCollection = (ResDataModelCollection)this.env.getService(ResDataModelCollection.class);
        InvLevel invLevel = invModel.getInvLevelAll();
        if (invLevel != null) {
            HashMap<String, Map<String, Object>> mtMap = new HashMap<String, Map<String, Object>>(32);
            HashMap<String, Boolean> invMap = new HashMap<String, Boolean>(32);
            List allBaseEntry = invLevel.getAllBaseEntry();
            for (InvLevelEntry entry : allBaseEntry) {
                Set mtIds = invLevel.getEntryMaterials(entry);
                Long orgLong = (Long)entry.getDimensionValue("bos_org");
                String orgStr = String.valueOf(orgLong);
                for (Object mt : mtIds) {
                    Long mtLong = MRPUtil.convert(mt, 0L);
                    String mtStr = String.valueOf(mtLong);
                    String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(ctxId, resDataModelCollection.getMaterialPlanKeys(mtStr, orgStr, entry));
                    if (invModel.matchType(entry)) {
                        HashMap<String, Object> info = InventoryModel.invToMap(entry, orgLong, mtLong);
                        mtMap.put(cacheKey, info);
                        String ck = invModel.getCacheKey(orgStr, mtStr, entry);
                        invMap.put(ck, true);
                        continue;
                    }
                    mtMap.put(cacheKey, MRPUtil.emptyMapNotModify);
                }
            }
            dstore.mapMSet("mpList", mtMap);
            invModel.cacheMt(dstore, invMap);
        }
    }

    HashMap<String, Object> rowToMap(RowMeta rowMeta, Row row) {
        int N = MtPlanInfoModel.mpFieldList.size();
        HashMap<String, Object> rowToMap = new HashMap<String, Object>(MtPlanInfoModel.mpFieldList.size());
        int[] mpFieldIndex = new int[N];
        int i = 0;
        for (String f : MtPlanInfoModel.mpFieldList) {
            mpFieldIndex[i++] = rowMeta.getFieldIndex(f);
        }
        i = 0;
        for (Object index : (Object)mpFieldIndex) {
            rowToMap.put(MtPlanInfoModel.mpFieldList.get(i++), row.get((int)index));
        }
        return rowToMap;
    }

    void loadMaterialPlanInfo(AbstractResModelDataTable tableDatas, String materialField, String orgField, String tracknumberField, KDCloudMRPEnv.IMaterialPlanInfoApply applier) {
        this.loadMaterialPlanInfo(tableDatas, materialField, orgField, tracknumberField, null, applier);
    }

    void loadMaterialPlanInfo(AbstractResModelDataTable tableDatas, String materialField, String orgField, String tracknumberField, String absentOrgField, KDCloudMRPEnv.IMaterialPlanInfoApply applier) {
        Object tracknumberId;
        String orgId;
        String materialId;
        int i;
        MtPlanInfoModel planInfo = (MtPlanInfoModel)this.env.getService(MtPlanInfoModel.class);
        ResDataModelCollection resDataModelCollection = (ResDataModelCollection)this.env.getService(ResDataModelCollection.class);
        Map<String, Map<String, Object>> materialPlanInfos = planInfo.getMaterialPlanInfos();
        String mrpContextId = this.env.getMRPContextId();
        int size = tableDatas.size();
        if (size == 0) {
            return;
        }
        HashMap<Integer, Map<String, Object>> colVals = new HashMap<Integer, Map<String, Object>>();
        RequirementDataTable requirementDataTable = tableDatas instanceof RequirementDataTable ? (RequirementDataTable)tableDatas : null;
        SupplymentDataTable supplymentDataTable = tableDatas instanceof SupplymentDataTable ? (SupplymentDataTable)tableDatas : null;
        HashMap<String, Set<Long>> manuStrategyMap = new HashMap<String, Set<Long>>();
        HashMap<String, Set<Long>> mftInfoMap = new HashMap<String, Set<Long>>();
        HashSet<Long> trackNumberIds = new HashSet<Long>();
        HashSet<Long> materialSet = new HashSet<Long>();
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        for (i = 0; i < size; ++i) {
            if (requirementDataTable != null && requirementDataTable.isLock(i)) continue;
            materialId = String.valueOf(tableDatas.getValue(materialField, i));
            orgId = String.valueOf(tableDatas.getValue(orgField, i));
            if (DynamicObjDataUtil.isNullStringOr0Long((String)orgId)) {
                if (absentOrgField == null) {
                    this.tagDataException(i);
                    continue;
                }
                orgId = String.valueOf(tableDatas.getValue(absentOrgField, i));
                if (DynamicObjDataUtil.isNullStringOr0Long((String)orgId)) {
                    this.tagDataException(i);
                    continue;
                }
            }
            tracknumberId = String.valueOf(tableDatas.getValue(tracknumberField, i));
            if (requirementDataTable == null && supplymentDataTable == null) continue;
            String key = String.format("%s\u0001%s", materialId, orgId);
            if (!cacheDatas.getManuStrategyCache().containsKey(key)) {
                Set manuSet = manuStrategyMap.computeIfAbsent(orgId, k -> new HashSet());
                manuSet.add(Long.valueOf(materialId));
            }
            if (!DynamicObjDataUtil.isNullStringOr0Long((String)tracknumberId) && !cacheDatas.getTrackStrategyCache().containsKey(tracknumberId)) {
                trackNumberIds.add(Long.valueOf((String)tracknumberId));
            }
            key = String.format("%s\u0001%s", orgId, materialId);
            if (!cacheDatas.getOrgAndMaterial2MftData().containsKey(key)) {
                Set mftSet = mftInfoMap.computeIfAbsent(orgId, k -> new HashSet());
                mftSet.add(Long.valueOf(materialId));
            }
            if (cacheDatas.getmConfigPropertiesCache().containsKey(materialId)) continue;
            materialSet.add(Long.valueOf(materialId));
        }
        cacheDatas.batchQueryManuStrategy(manuStrategyMap);
        cacheDatas.batchQueryMftInfo(mftInfoMap);
        if (!trackNumberIds.isEmpty()) {
            cacheDatas.batchQueryTrackStrategy(trackNumberIds);
        }
        if (!materialSet.isEmpty()) {
            String configProperties = null;
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", materialSet)};
            DataSet dataSet = orm.queryDataSet(this.getClass().getSimpleName(), "bd_material", "id,configproperties", filters, null);
            tracknumberId = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    configProperties = row.getString("configProperties");
                    cacheDatas.getmConfigPropertiesCache().put(row.getString("id"), configProperties);
                }
            }
            catch (Throwable row) {
                tracknumberId = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (tracknumberId != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)tracknumberId).addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        for (i = 0; i < size; ++i) {
            if (requirementDataTable != null && requirementDataTable.isLock(i)) continue;
            materialId = String.valueOf(tableDatas.getValue(materialField, i));
            orgId = String.valueOf(tableDatas.getValue(orgField, i));
            tracknumberId = String.valueOf(tableDatas.getValue(tracknumberField, i));
            if (DynamicObjDataUtil.isNullStringOr0Long((String)orgId)) {
                if (absentOrgField == null) {
                    this.tagDataException(i);
                    continue;
                }
                orgId = String.valueOf(tableDatas.getValue(absentOrgField, i));
                if (DynamicObjDataUtil.isNullStringOr0Long((String)orgId)) {
                    this.tagDataException(i);
                    continue;
                }
            }
            if (requirementDataTable != null || supplymentDataTable != null) {
                this.initManustrategy(materialId, orgId, (String)tracknumberId, tableDatas, i);
                this.initMaterialConfigProperties(materialId, tableDatas, i);
            }
            int type = 2;
            if (supplymentDataTable != null) {
                type = 1;
            } else if (requirementDataTable != null) {
                type = 0;
            }
            String key = resDataModelCollection.getMaterialPlanKeys(materialId, orgId, tableDatas.fetchRow(i), type);
            if (materialPlanInfos.containsKey(key)) {
                Map<String, Object> mp = materialPlanInfos.get(key);
                if (mp != null && !mp.isEmpty()) {
                    this.colValPut(colVals, i, applier, mp);
                    continue;
                }
                if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("mrprunner-materialPlanInfos-empty-material-planinfo-loadMaterialPlanInfo, ctxid: %s, mid: %s", mrpContextId, materialId));
                }
                if (mp == null) {
                    this.tagDataException(i);
                    continue;
                }
                this.tagDataException(i, ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u5f0f\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4", (String)"ResDataModel_9", (String)"mmc-mrp-mservice", (Object[])new Object[0]), "97");
                continue;
            }
            Set<String> enabledMaterialIds = this.getEnabledMaterialIds();
            Map<Object, Object> info = null;
            boolean isShare = false;
            if (!enabledMaterialIds.contains(materialId)) {
                this.tagDataException(i);
            } else {
                String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey(mrpContextId, key);
                MRPRedisStore dstore = MRPCacheManager.getDStore(mrpContextId);
                if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("mrprunner-empty-material-planinfo-loadMaterialPlanInfo, ctxid: %s, cacheKey: %s, mid: %s", mrpContextId, cacheKey, materialId));
                }
                if ((info = (HashMap)dstore.mapGet("mpList", cacheKey)) != null) {
                    if (info.isEmpty()) {
                        this.tagDataException(i, ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u5f0f\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4", (String)"ResDataModel_9", (String)"mmc-mrp-mservice", (Object[])new Object[0]), "97");
                    } else {
                        info = new HashMap(info);
                        this.colValPut(colVals, i, applier, info);
                    }
                } else {
                    isShare = true;
                    info = this.loadShareMaterialPlanInfo(materialId, orgId, dstore);
                    if (info == null) {
                        if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                            logger.warn(String.format("mrprunner-put-null-material-planinfo-loadMaterialPlanInfo, ctxid: %s, cacheKey: %s, mid: %s", mrpContextId, cacheKey, materialId));
                        }
                        this.tagDataException(i);
                    } else {
                        this.colValPut(colVals, i, applier, info);
                    }
                }
            }
            if (!isShare && info != null && !info.isEmpty()) {
                info = planInfo.zipPlanInfoMap((Map<String, Object>)info);
            }
            if ("1".equals(this.env.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mrprunner-put-data-material-planinfo-loadMaterialPlanInfo, ctxid: %s, key: %s, mid: %s , info : %s", mrpContextId, key, materialId, info));
            }
            materialPlanInfos.put(key, info);
        }
        applier.apply(colVals);
    }

    protected void colValPut(Map<Integer, Map<String, Object>> colVals, int i, KDCloudMRPEnv.IMaterialPlanInfoApply applier, Map<String, Object> info) {
        colVals.put(i, applier.toMap(info));
    }

    protected boolean[] getManustrategyParam(String materialId, String orgId) {
        return ResDataModel.getManustrategyParam(this.env, materialId, orgId);
    }

    protected Long getManustrategyId(String materialId, String orgId) {
        return ResDataModel.getManustrategyId(this.env, materialId, orgId);
    }

    public static boolean[] getManustrategyParam(CalEnv env, Long manustrategy) {
        CacheDatas cacheDatas = (CacheDatas)env.getService(CacheDatas.class);
        String selectField = "id,traceway,invisolation,allowdrop";
        DynamicObject strategyObj = cacheDatas.reloadDataById("bd_manustrategy", manustrategy, selectField);
        boolean isTrackMatch = false;
        boolean isInvIsolation = false;
        boolean allowdrop = true;
        long traceDim = 1297144009797647360L;
        if (strategyObj != null && strategyObj.getLong("id") >= 0L) {
            long id;
            DynamicObjectCollection traceway = strategyObj.getDynamicObjectCollection("traceway");
            for (DynamicObject trace : traceway) {
                id = trace.getLong("fbasedataid.id");
                if (id != traceDim) continue;
                isTrackMatch = true;
                break;
            }
            traceway = strategyObj.getDynamicObjectCollection("invisolation");
            for (DynamicObject trace : traceway) {
                id = trace.getLong("fbasedataid.id");
                if (id != traceDim) continue;
                isInvIsolation = true;
                break;
            }
            allowdrop = strategyObj.getBoolean("allowdrop");
        }
        return new boolean[]{isTrackMatch, isInvIsolation, allowdrop};
    }

    public static boolean[] getManustrategyParam(CalEnv env, String materialId, String orgId) {
        Long manustrategy = ResDataModel.getManustrategyId(env, materialId, orgId);
        return ResDataModel.getManustrategyParam(env, manustrategy);
    }

    private void initManustrategy(String materialId, String orgId, String tracknumberId, AbstractResModelDataTable tableDatas, int i) {
        boolean isRequire = tableDatas instanceof RequirementDataTable;
        Long manustrategy = 0L;
        if (!DynamicObjDataUtil.isNullStringOr0Long((String)tracknumberId)) {
            if (isRequire) {
                Integer isDependent = MRPUtil.convert(tableDatas.getValue(DefaultField.RequireField.__ISDEPENDENT__.getName(), i), 0);
                if (isDependent == 0) {
                    manustrategy = ResDataModel.getManustrategyIdByTracknumber(this.env, Long.valueOf(tracknumberId));
                }
            } else {
                manustrategy = ResDataModel.getManustrategyIdByTracknumber(this.env, Long.valueOf(tracknumberId));
            }
        }
        if (manustrategy == 0L) {
            manustrategy = this.getManustrategyId(materialId, orgId);
        }
        boolean[] param = ResDataModel.getManustrategyParam(this.env, manustrategy);
        boolean isTrackMatch = param[0];
        boolean isInvIsolation = param[1];
        boolean allowdrop = param[2];
        if (isRequire) {
            tableDatas.updateValue(DefaultField.RequireField.IS_TRACK_MATCH.getName(), i, isTrackMatch);
            tableDatas.updateValue(DefaultField.RequireField.ALLOWDROP.getName(), i, allowdrop);
            tableDatas.updateValue(DefaultField.RequireField.PLAN_STRATEGY.getName(), i, manustrategy > 0L ? manustrategy : null);
        } else {
            if (MRPUtil.convert(tableDatas.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName(), i), 0) != 0) {
                tableDatas.updateValue(DefaultField.SupplyField.INV_IS_TRACK_MATCH.getName(), i, isInvIsolation);
            }
            tableDatas.updateValue(DefaultField.SupplyField.IS_TRACK_MATCH.getName(), i, isTrackMatch);
        }
    }

    public static Long getManustrategyIdByTracknumber(CalEnv env, Long tracknumberId) {
        CacheDatas cacheDatas = (CacheDatas)env.getService(CacheDatas.class);
        Long manustrategyId = 0L;
        if (tracknumberId == 0L) {
            return manustrategyId;
        }
        if (cacheDatas.getTrackStrategyCache().containsKey(tracknumberId.toString())) {
            manustrategyId = cacheDatas.getTrackStrategyCache().get(tracknumberId.toString());
        } else {
            String selectField = "id,manustrategy";
            DynamicObject tracknumber = cacheDatas.reloadDataById("bd_tracknumber", tracknumberId, selectField);
            if (tracknumber != null && tracknumber.getLong("id") >= 0L) {
                manustrategyId = tracknumber.getLong("manustrategy.id");
                cacheDatas.getTrackStrategyCache().put(tracknumberId.toString(), manustrategyId);
            }
        }
        return manustrategyId;
    }

    public static Long getManustrategyId(CalEnv env, String materialId, String orgId) {
        CacheDatas cacheDatas = (CacheDatas)env.getService(CacheDatas.class);
        Long manustrategy = 0L;
        String key = String.format("%s\u0001%s", materialId, orgId);
        if (cacheDatas.getManuStrategyCache().containsKey(key)) {
            manustrategy = cacheDatas.getManuStrategyCache().get(key);
        } else {
            QFilter qFilterUseOrg = cacheDatas.getInvInfoOrgFilter().get(orgId);
            if (qFilterUseOrg == null) {
                qFilterUseOrg = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)Long.valueOf(orgId));
                cacheDatas.getInvInfoOrgFilter().put(orgId, qFilterUseOrg);
            }
            QFilter dataFilter = new QFilter("status", "=", (Object)"C");
            dataFilter.and(new QFilter("enable", "=", (Object)"1"));
            QFilter mFilter = new QFilter("masterid", "=", (Object)Long.valueOf(materialId));
            QFilter[] filters = new QFilter[]{dataFilter, mFilter, qFilterUseOrg};
            String select = "id,createorg,masterid,manustrategy";
            try (DataSet dataSet = orm.queryDataSet(ResDataModel.class.getSimpleName(), "bd_materialinventoryinfo", select, filters, "id desc");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    long createorg = row.getLong("createorg");
                    manustrategy = row.getLong("manustrategy");
                    if (createorg != Long.parseLong(orgId)) continue;
                    break;
                }
            }
            cacheDatas.getManuStrategyCache().put(key, manustrategy);
        }
        return manustrategy;
    }

    private void initMaterialConfigProperties(String materialId, AbstractResModelDataTable tableDatas, int i) {
        CacheDatas cacheDatas = (CacheDatas)this.env.getService(CacheDatas.class);
        String configProperties = cacheDatas.getConfigProperties(materialId);
        boolean isRequire = tableDatas instanceof RequirementDataTable;
        if (isRequire) {
            tableDatas.updateValue(DefaultField.RequireField.CONFIGPROPERTIES.getName(), i, configProperties);
        } else {
            tableDatas.updateValue(DefaultField.SupplyField.CONFIGPROPERTIES.getName(), i, configProperties);
        }
    }

    public Map<String, Object> loadShareMaterialPlanInfo(String materialId, String orgId, MRPRedisStore dstore) {
        String oriOrg;
        MtPlanInfoModel mtPlanInfoModel = (MtPlanInfoModel)this.env.getService(MtPlanInfoModel.class);
        PlanModel planModel = (PlanModel)this.env.getService(PlanModel.class);
        Map<String, Object> info = null;
        if (DynamicObjDataUtil.isNullStringOr0Long((String)orgId) || DynamicObjDataUtil.isNullStringOr0Long((String)materialId) || planModel.isEnablePlanScope()) {
            return info;
        }
        Set<String> enabledMaterialIds = this.getEnabledMaterialIds();
        if (!enabledMaterialIds.contains(materialId)) {
            return info;
        }
        if (mtPlanInfoModel.getSharePlanInfoCache().containsKey(materialId)) {
            oriOrg = mtPlanInfoModel.getSharePlanInfoCache().get(materialId);
        } else {
            oriOrg = (String)dstore.mapGet("mpList_share", materialId);
            mtPlanInfoModel.getSharePlanInfoCache().put(materialId, oriOrg);
        }
        if (oriOrg != null) {
            info = mtPlanInfoModel.getMaterialPlanInfo(materialId, oriOrg, null, true);
        } else {
            Map map;
            Long org = Long.parseLong(orgId);
            if (mtPlanInfoModel.getControlScopeSharePlanInfoCache().containsKey(materialId)) {
                map = mtPlanInfoModel.getControlScopeSharePlanInfoCache().get(materialId);
            } else {
                map = (Map)dstore.mapGet("mpList_ctrl_share", materialId);
                mtPlanInfoModel.getControlScopeSharePlanInfoCache().put(materialId, map);
            }
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!((Set)entry.getValue()).contains(org)) continue;
                    oriOrg = ((Long)entry.getKey()).toString();
                    break;
                }
            }
        }
        if (oriOrg != null) {
            info = mtPlanInfoModel.getMaterialPlanInfo(materialId, oriOrg, null, true);
        }
        return info;
    }

    private boolean isEnableMaterialPlan(Row row) {
        Set<String> enabledMaterialPlanIds = this.getEnabledMaterialPlanIds();
        long masterId = row.getLong("masterid");
        long orgId = row.getLong("createorg");
        String id = row.getString("id");
        if (masterId == 0L || orgId == 0L) {
            return false;
        }
        return enabledMaterialPlanIds.contains(id);
    }

    protected void tagDataException(int i) {
        String errorMsg = ModelUtil.getMaterialNotFoundError(this.env);
        String errorNumber = ModelUtil.getMaterialNotFoundNumber(this.env);
        this.tagDataException(i, errorMsg, errorNumber);
    }

    protected void tagDataException(int i, String msg, String expNum) {
        AbstractResModelDataTable tableDatas = this.getTable();
        if (i >= tableDatas.size()) {
            return;
        }
        if (tableDatas instanceof RequirementDataTable) {
            String expMsgFiled = DefaultField.RequireField.EXCEPTIONMESSAGE.getName();
            String expNumFiled = DefaultField.RequireField.EXCEPTIONNUMBER.getName();
            msg = MRPUtil.appendExceptionMsg(tableDatas.getValue(expMsgFiled, i), msg);
            tableDatas.updateValue(expMsgFiled, i, msg);
            expNum = MRPUtil.appendExceptionNumber(tableDatas.getValue(expNumFiled, i), expNum);
            tableDatas.updateValue(expNumFiled, i, expNum);
        }
    }
}

