/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.integrate.entity.IResDataInfo;
import kd.mmc.mrp.integrate.entity.ResourecPlanModel;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.res.RESErrorMessageUtil;

public class ResourcePlanScheme
implements IResDataInfo {
    private Long schemeId;
    private String fchkgroupplantype;
    private Boolean fisreplace;
    private Boolean fisadjust;
    private Long fplanmodel;
    private Long flistmodel;
    private Long freqmodel;
    private Long fsupplymodel;
    private Integer fplanoutlook;
    private String fchkgroupplan;
    private Integer fplanday;
    private String fchkgrouplist;
    private Integer flistday;
    private String fchkgroupreq;
    private Integer freqday;
    private String fchkgroupsupply;
    private Integer fsupplyday;
    private Set<Long> setplanconfig;
    private Set<Long> setlistconfig;
    private Set<Long> setreqconfig;
    private Set<Long> setsupplyconfig;
    private QFilter[] schemeQFilters;
    private ResourecPlanModel RequireData;
    private ResourecPlanModel SupplyData;
    private CalEnv env;
    private final ORM orm = ORM.create();
    private static final String ALGO_KEY = "RESEnv.";

    public ResourecPlanModel getRequireData() {
        return this.RequireData;
    }

    public void setRequireData(ResourecPlanModel requireData) {
        this.RequireData = requireData;
    }

    public ResourecPlanModel getSupplyData() {
        return this.SupplyData;
    }

    public void setSupplyData(ResourecPlanModel supplyData) {
        this.SupplyData = supplyData;
    }

    public ResourcePlanScheme(CalEnv env) {
        this.env = env;
        env.addService(ResourcePlanScheme.class, this);
    }

    public void init() {
        RunLogModel runLogModel = (RunLogModel)this.env.getService(RunLogModel.class);
        long schemeId = runLogModel.getPlanId();
        this.setSchemeId(schemeId);
        String selectFields = "id,status, enable,isreplace,isadjust,planmodel,chkgroupplan,planday,listmodel,chkgrouplist,listday,planoutlook,chkgroupplantype,reqmodel,chkgroupreq,reqday,supplymodel,chkgroupsupply,supplyday";
        this.schemeQFilters = new QFilter[]{new QFilter("id", "=", (Object)schemeId)};
        try (DataSet dataSet = this.orm.queryDataSet("RESEnv.getSchemeHead", "mrp_res_scheme", selectFields, this.schemeQFilters, null, 1);){
            if (dataSet.isEmpty()) {
                throw new MRPBizException(RESErrorMessageUtil.getSchemeNoExists());
            }
            Row row = dataSet.next();
            String stauts = row.getString("status");
            String enable = row.getString("enable");
            if (!"C".equals(stauts) || !"1".equals(enable)) {
                throw new MRPBizException(RESErrorMessageUtil.getSchemeNoAudit());
            }
            this.setFplanmodel(row.getLong("planmodel"));
            this.setFlistmodel(row.getLong("listmodel"));
            this.setFreqmodel(row.getLong("reqmodel"));
            this.setFsupplymodel(row.getLong("supplymodel"));
            this.setFchkgroupplantype(row.getString("chkgroupplantype"));
            this.setFplanoutlook(row.getInteger("planoutlook"));
            selectFields = "planentity.planinrun, planentity.planresource,planentity.planfieldtran";
            this.setplanconfig = this.getResourceIdSet(selectFields);
            selectFields = "listentity.listinrun, listentity.listresource,listentity.listfieldtran";
            this.setlistconfig = this.getResourceIdSet(selectFields);
            selectFields = "reqentity.reqinrun, reqentity.reqresource,reqentity.reqfieldtran";
            this.setreqconfig = this.getResourceIdSet(selectFields);
            selectFields = "supplyentity.supplyinrun, supplyentity.supplyresource,supplyentity.supplyfieldtran";
            this.setsupplyconfig = this.getResourceIdSet(selectFields);
        }
        catch (Exception e) {
            throw new MRPBizException(RESErrorMessageUtil.getSchemeNoExists());
        }
    }

    private Set<Long> getResourceIdSet(String selectFields) {
        try (DataSet dataSet = this.orm.queryDataSet("RESEnv.getSourceIds", "mrp_res_scheme", selectFields, this.schemeQFilters, null);){
            if (dataSet.isEmpty()) {
                Set<Long> set = Collections.emptySet();
                return set;
            }
            HashSet<Long> sourceIds = new HashSet<Long>();
            for (Row row : dataSet) {
                if (!row.getBoolean(0).booleanValue()) continue;
                sourceIds.add(row.getLong(1));
            }
            HashSet<Long> hashSet = sourceIds;
            return hashSet;
        }
    }

    public Set<Long> getEnabledPlan() {
        return this.setplanconfig;
    }

    public Set<Long> getEnabledList() {
        return this.setlistconfig;
    }

    public Set<Long> getEnabledSupplys() {
        return this.setsupplyconfig;
    }

    public Set<Long> getEnabledRequires() {
        return this.setreqconfig;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public String getFchkgroupplantype() {
        return this.fchkgroupplantype;
    }

    public void setFchkgroupplantype(String fchkgroupplantype) {
        this.fchkgroupplantype = fchkgroupplantype;
    }

    public Boolean getFisreplace() {
        return this.fisreplace;
    }

    public void setFisreplace(Boolean fisreplace) {
        this.fisreplace = fisreplace;
    }

    public Boolean getFisadjust() {
        return this.fisadjust;
    }

    public void setFisadjust(Boolean fisadjust) {
        this.fisadjust = fisadjust;
    }

    public Long getFplanmodel() {
        return this.fplanmodel;
    }

    public void setFplanmodel(Long fplanmodel) {
        this.fplanmodel = fplanmodel;
    }

    public Long getFlistmodel() {
        return this.flistmodel;
    }

    public void setFlistmodel(Long flistmodel) {
        this.flistmodel = flistmodel;
    }

    public Long getFreqmodel() {
        return this.freqmodel;
    }

    public void setFreqmodel(Long freqmodel) {
        this.freqmodel = freqmodel;
    }

    public Long getFsupplymodel() {
        return this.fsupplymodel;
    }

    public void setFsupplymodel(Long fsupplymodel) {
        this.fsupplymodel = fsupplymodel;
    }

    public Integer getFplanoutlook() {
        return this.fplanoutlook;
    }

    public void setFplanoutlook(Integer fplanoutlook) {
        this.fplanoutlook = fplanoutlook;
    }

    public String getFchkgroupplan() {
        return this.fchkgroupplan;
    }

    public void setFchkgroupplan(String fchkgroupplan) {
        this.fchkgroupplan = fchkgroupplan;
    }

    public Integer getFplanday() {
        return this.fplanday;
    }

    public void setFplanday(Integer fplanday) {
        this.fplanday = fplanday;
    }

    public String getFchkgrouplist() {
        return this.fchkgrouplist;
    }

    public void setFchkgrouplist(String fchkgrouplist) {
        this.fchkgrouplist = fchkgrouplist;
    }

    public Integer getFlistday() {
        return this.flistday;
    }

    public void setFlistday(Integer flistday) {
        this.flistday = flistday;
    }

    public String getFchkgroupreq() {
        return this.fchkgroupreq;
    }

    public void setFchkgroupreq(String fchkgroupreq) {
        this.fchkgroupreq = fchkgroupreq;
    }

    public Integer getFreqday() {
        return this.freqday;
    }

    public void setFreqday(Integer freqday) {
        this.freqday = freqday;
    }

    public String getFchkgroupsupply() {
        return this.fchkgroupsupply;
    }

    public void setFchkgroupsupply(String fchkgroupsupply) {
        this.fchkgroupsupply = fchkgroupsupply;
    }

    public Integer getFsupplyday() {
        return this.fsupplyday;
    }

    public void setFsupplyday(Integer fsupplyday) {
        this.fsupplyday = fsupplyday;
    }

    @Override
    public long getRequireResId() {
        return this.freqmodel;
    }

    @Override
    public long getSupplyResId() {
        return this.fsupplymodel;
    }

    @Override
    public long getBomResId() {
        return 0L;
    }

    @Override
    public long getR2STransId() {
        return 0L;
    }

    public long getplanResId() {
        return this.fplanmodel;
    }

    public long getlistResId() {
        return this.flistmodel;
    }

    public long getPlanorReqTransId() {
        return this.fsupplymodel;
    }

    public long getListorSupTransId() {
        return this.fsupplymodel;
    }
}

