/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.integrate.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.event.MRPDataFetchEvent4Require;
import kd.mmc.mrp.framework.mq.event.MRPDataFetchEvent4Supply;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.model.table.res.ResourcePlanModelTable;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.utils.MRPUtil;

public class ResourecPlanModel {
    private String mrpContextId = "";
    private long resRegId;
    private String getDataType = "";
    private Boolean issup = false;
    private Set<String> resourcePlanFields;
    private List<FieldMapping> r2s;
    private String regNumber;
    private DynamicObject ResRegeditModel;
    private ResourcePlanModelTable resTable;
    private HashMap<Long, String> tranIdtoNumber;
    protected CalEnv env;

    public ResourecPlanModel(long resRegId, Boolean isSupply, CalEnv env) {
        this.resRegId = resRegId;
        this.env = env;
        this.issup = isSupply;
        this.init();
        this.tranIdtoNumber = new HashMap(5);
        this.getDataType = "require-";
        if (isSupply.booleanValue()) {
            this.getDataType = "supply-";
        }
        this.resTable = new ResourcePlanModelTable();
    }

    public int fetchDatas(Set<Long> resConfigIds, IMRPExecuteLogRecorder lr, IMRPEnvProvider env) {
        DynamicObjectCollection dqs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", resConfigIds)});
        return this.fetch(lr, env, dqs);
    }

    public int fetchDatas(IMRPExecuteLogRecorder lr, IMRPEnvProvider env) {
        if (this.getModel() != null) {
            DynamicObjectCollection dataSrcs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("cgnumber.id", "=", (Object)this.getModel().getLong("id"))});
            return this.fetch(lr, env, dataSrcs);
        }
        return 0;
    }

    private int fetch(IMRPExecuteLogRecorder lr, IMRPEnvProvider env, DynamicObjectCollection dataSrcs) {
        String id;
        String cacheKey = this.getCacheKey();
        IMRPEventManager manager = (IMRPEventManager)env.getService(IMRPEventManager.class);
        HashMap<String, String> resId2EventId = new HashMap<String, String>();
        HashMap<String, String> eventId2ResId = new HashMap<String, String>();
        HashMap<String, Integer> eventId2LogIdx = new HashMap<String, Integer>();
        HashMap<String, String> sourIdtoNumber = new HashMap<String, String>();
        HashSet<String> ids = new HashSet<String>();
        int subStepIdx = 0;
        for (DynamicObject dyn : dataSrcs) {
            id = dyn.getString("id");
            ids.add(id);
            String number = dyn.getString("number");
            String name = dyn.getString("name");
            MRPEvent event = this.getEvent();
            event.setMrpContextId(env.getMRPContextId());
            event.setParam(MultiThreadCacheKey.KEY_MODEL_ID, (Serializable)((Object)id));
            event.setSubStepIdx(subStepIdx++);
            event.setRecorder(env.createLogRecorder());
            sourIdtoNumber.put(event.getEventId(), number);
            resId2EventId.put(id, event.getEventId());
            eventId2ResId.put(event.getEventId(), id);
            eventId2LogIdx.put(event.getEventId(), subStepIdx - 1);
            manager.publishCalcEvent(event);
            String tip = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u3010%1$s(%2$s)\u3011\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u6570\u636e", (String)"ResourecPlanModel_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), name == null ? "" : name, number);
            lr.createSubStepLog(subStepIdx, tip, lr.getLogIdx());
            lr.saveStepLog(false);
        }
        MRPCacheManager.getInst().putData(env, cacheKey, JSON.toJSONString(ids, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        manager.wait4Response();
        for (Map.Entry entry : eventId2LogIdx.entrySet()) {
            Integer idx = (Integer)entry.getValue();
            String modelId = (String)eventId2ResId.get(entry.getKey());
            String rc = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getQueryModelRowCountKey(modelId));
            String endTs = MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getQueryModelTimeCostKey(modelId));
            lr.updateSubStepLog(idx, "entrydetailmsg", String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u884c\u6570\uff1a%s", (String)"ResourecPlanModel_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), rc));
            lr.updateSubStepLog(idx, "entryoperatmin", endTs);
            lr.updateSubStepLog(idx, "entryresult", MRPExecuteStatus.FINISHED.getAlias());
            lr.saveStepLog(false);
        }
        for (Map.Entry it : resId2EventId.entrySet()) {
            id = (String)it.getKey();
            String evtId = (String)it.getValue();
            List datas = JSON.parseArray((String)MRPCacheManager.getInst().getSubData(env, this.getDataType, MRPRuntimeConsts.getDataKey(evtId, id, "")), Object[].class);
            List metas = JSON.parseArray((String)MRPCacheManager.getInst().getData(env, MRPRuntimeConsts.getMetaKey(evtId, id)), String.class);
            StringBuilder message = new StringBuilder();
            Long resid = Long.valueOf((String)eventId2ResId.get(evtId));
            this.initTableCols(resid);
            StringBuilder fill = this.resTable.fill(metas, datas, "", "", "", "");
            message.append((CharSequence)fill);
            if (message.length() <= 0) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u6ce8\u518c\u914d\u7f6e\u201c%1$s\u201d - \u6570\u636e\u6e90\u914d\u7f6e\u201c%2$s\u201d - \u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u201c%3$s\u201d:%4$s\u503c\u4e3a\u7a7a\u3002", (String)"ResourecPlanModel_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]), this.regNumber, sourIdtoNumber.get(evtId), this.tranIdtoNumber.get(resid));
            throw new MRPBizException(Errors.getExecuteDataQueryFailed(), msg);
        }
        return 0;
    }

    public List<FieldMapping> getR2s() {
        return this.r2s;
    }

    private void initTableCols(Long r2sTransId) {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"mrp_resource_dataconfig", (String)"id,name,number,billfieldtransfer", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)r2sTransId)});
        if (queryOne != null) {
            if (r2sTransId != null) {
                DynamicObject r2sTrans = BusinessDataServiceHelper.loadSingle((Object)queryOne.get("billfieldtransfer"), (String)"mrp_billfieldtransfer");
                this.tranIdtoNumber.put(r2sTransId, r2sTrans.getString("number"));
                DynamicObjectCollection entrys = r2sTrans.getDynamicObjectCollection("entryentity");
                this.resTable.getFieldsMap().clear();
                for (DynamicObject mapping : entrys) {
                    String destField = mapping.getString("destfieldflag").toUpperCase();
                    ArrayList labels = this.resTable.getFieldsMap().computeIfAbsent(destField, k -> new ArrayList());
                    labels.add(destField);
                }
                this.r2s = this.buildModelRelation(entrys, this.resourcePlanFields, false);
            }
            Iterator<String> its = this.resourcePlanFields.iterator();
            int index = 0;
            while (its.hasNext()) {
                this.resTable.getColIdx().put(its.next().toUpperCase(), index++);
            }
        }
    }

    protected List<FieldMapping> buildModelRelation(DynamicObjectCollection relations, Set<String> fromFields, boolean isOut) {
        String fromKey = "sourcefieldflag";
        String toKey = "destfieldflag";
        ArrayList<FieldMapping> ret = new ArrayList<FieldMapping>();
        StringBuilder message = new StringBuilder();
        for (DynamicObject relation : relations) {
            FieldMapping mapping = new FieldMapping();
            mapping.setFrom(relation.getString(fromKey).toUpperCase());
            mapping.setTo(relation.getString(toKey).toUpperCase());
            mapping.setConverttype(relation.getString("converttype"));
            String condition = relation.getString("calculateexc");
            if (fromFields.contains(mapping.getFrom())) {
                ret.add(mapping);
            } else if (!fromFields.contains(mapping.getFrom()) && !isOut) {
                MRPUtil.parseFormula(mapping, condition, message);
                ret.add(mapping);
            } else {
                ret.add(mapping);
            }
            if ("4".equals(String.valueOf(relation.get("converttype")))) {
                MRPUtil.parseFormula(mapping, condition, message);
            }
            if ("1".equals(String.valueOf(relation.get("converttype"))) || "3".equals(String.valueOf(relation.get("converttype")))) {
                mapping.setFormulaValue(relation.getString("calculateexc"));
            }
            if (!"2".equals(String.valueOf(relation.get("converttype")))) continue;
            mapping.setFormulaValue(relation.getString("calculateexc_tag"));
        }
        if (message.length() > 0) {
            throw new MRPBizException(Errors.getParseRelationFailed(), message);
        }
        return ret;
    }

    protected Set<String> buildFields(DynamicObject model) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)model.getDynamicObject("businessentity").getString("id"));
        String name = mainType.getName();
        Map allEntities = mainType.getAllEntities();
        for (Map.Entry entry : allEntities.entrySet()) {
            EntityType value = (EntityType)entry.getValue();
            String entryName = value.getName();
            if (name.equals(entryName)) {
                for (String field : value.getFields().keySet()) {
                    fields.add(field.toUpperCase(Locale.ENGLISH));
                }
                continue;
            }
            for (String field : value.getFields().keySet()) {
                String entryField = entryName + '.' + field;
                fields.add(entryField.toUpperCase(Locale.ENGLISH));
            }
        }
        return fields;
    }

    private void init() {
        this.ResRegeditModel = BusinessDataServiceHelper.loadSingle((Object)this.resRegId, (String)"mrp_resourceregister_cf");
        this.regNumber = this.ResRegeditModel.getString("number");
        this.resourcePlanFields = this.buildFields(this.ResRegeditModel);
    }

    public MRPEvent getEvent() {
        MRPEvent event = new MRPDataFetchEvent4Require();
        if (this.issup.booleanValue()) {
            event = new MRPDataFetchEvent4Supply();
        }
        event.setMrpContextId(this.mrpContextId);
        return event;
    }

    public String getCacheKey() {
        return "RESOURCE_MODELS";
    }

    public DynamicObject getModel() {
        return this.ResRegeditModel;
    }

    public AbstractResModelDataTable getTable() {
        return this.resTable;
    }

    public Set<String> getFields() {
        return this.resourcePlanFields;
    }
}

