/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.mmc.mrp.framework.fomula.Expr;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.model.PriorityLevelFieldSrcDefine;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.select.PriorityEntryFieldType;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.DynamicPriorityLevelDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.utils.MRPUtil;

public class PrioritySettingDatas {
    private DynamicPriorityLevelDataTable refTbl;
    private ArrayList<PriorityLevelFieldSrcDefine> relations;

    public ArrayList<PriorityLevelFieldSrcDefine> getRelations() {
        return this.relations;
    }

    public void setRelations(ArrayList<PriorityLevelFieldSrcDefine> relations) {
        this.relations = relations;
    }

    public DynamicPriorityLevelDataTable getRefTbl() {
        return this.refTbl;
    }

    public void setRefTbl(DynamicPriorityLevelDataTable refTbl) {
        this.refTbl = refTbl;
    }

    public int apply(RequirementDataTable table, int rowIdx) {
        List<Integer> results = null;
        int priorityIncrease = 0;
        Map<String, Object> requireData = table.fetchRow(rowIdx).toMap();
        for (PriorityLevelFieldSrcDefine relation : this.relations) {
            int index;
            ColumnDatas columnDatas;
            Object result;
            if (results != null && results.isEmpty()) break;
            ExprContext exprCtx = new ExprContext();
            exprCtx.addPreDefinedParam("requireData", requireData);
            Expr expr = relation.getCondition();
            if (expr != null && !MRPUtil.isTrue(result = expr.execute(exprCtx))) continue;
            String[] fields = relation.getRelatedFieldNames();
            if (PriorityEntryFieldType.DATE == relation.getFieldType()) {
                String type;
                Object val = table.getValue(relation.getFullName().toUpperCase(), rowIdx);
                if (!(val instanceof Number)) continue;
                Long value = MRPUtil.convert(val, System.currentTimeMillis());
                int zero = 0;
                int one = 1;
                int two = 2;
                String string = type = this.refTbl.getSrcDatas().getDatas().isEmpty() ? "" : MRPUtil.convert(this.refTbl.getValue(fields[zero].toUpperCase(Locale.ENGLISH), 0), "");
                if (relation.getPriorityStep() > 0 && relation.getDateStep() > 0) {
                    Calendar cal = Calendar.getInstance();
                    OrgBasedCalendarModel.nomalize(cal);
                    long current = cal.getTimeInMillis();
                    int distance = value > current ? relation.getPlanOutlook() - (int)((value - current) / 86400000L) : relation.getPlanOutlook() + (int)((current - value) / 86400000L);
                    priorityIncrease += distance / relation.getDateStep() * relation.getPriorityStep();
                    continue;
                }
                int compare = (int)((value - System.currentTimeMillis()) / 86400000L);
                if (!"day".equals(type)) {
                    if ("month".equals(type)) {
                        compare /= 30;
                    } else if ("year".equals(type)) {
                        compare /= 365;
                    }
                }
                String startCol = fields[one];
                String endCol = fields[two];
                List<Integer> selections = MRPUtil.and(this.refTbl.getCol(startCol).over(new BigDecimal(compare), true), this.refTbl.getCol(endCol).less(new BigDecimal(compare), true));
                if (results == null && selections != null) {
                    results = selections;
                    continue;
                }
                results = MRPUtil.and(results, selections);
                continue;
            }
            if (PriorityEntryFieldType.NUMBER == relation.getFieldType()) {
                Object value = table.getValue(relation.getFullName().toUpperCase(), rowIdx);
                int index2 = 0;
                String materialCol = fields[index2];
                int next = 1;
                String startCol = fields[next];
                int last = 2;
                String endCol = fields[last];
                this.refTbl.getCol(materialCol);
                List<Integer> i1 = this.refTbl.getCol(endCol).less(value, true);
                List<Integer> i2 = this.refTbl.getCol(materialCol).get(table.getValue(DefaultField.RequireField.MATERIAL.getName(), rowIdx));
                List<Integer> i3 = this.refTbl.getCol(startCol).over(value, true);
                List<Integer> i4 = MRPUtil.and(i2, i3);
                List<Integer> selections = MRPUtil.and(i1, i4);
                if (results == null && selections != null) {
                    results = selections;
                    continue;
                }
                results = MRPUtil.and(results, selections);
                continue;
            }
            if (PriorityEntryFieldType.ENTITY != relation.getFieldType() || (columnDatas = this.refTbl.getCol(fields[index = 0])) == null) continue;
            List<Integer> selections = columnDatas.get(table.getValue(relation.getFullName().toUpperCase(), rowIdx));
            if (results == null && selections != null) {
                results = selections;
                continue;
            }
            results = MRPUtil.and(results, selections);
        }
        if (results != null && !results.isEmpty()) {
            int weight = ((BigDecimal)this.refTbl.getValue("FWEIGHT", (Integer)results.get(0))).intValue();
            return weight + priorityIncrease;
        }
        return priorityIncrease;
    }

    public void refresh() {
        this.refTbl.refresh();
    }
}

