/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.date;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.BizLog;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.model.date.MRPDate;
import kd.mmc.mrp.model.enums.select.WorkCalendarDayType;
import kd.mmc.mrp.utils.MRPUtil;

public class OrgBasedCalendarModel {
    private MRPDate maxDate = null;
    private MRPDate minDate = null;
    private String orgId = null;
    private List<MRPDate> dates;
    private HashMap<Date, Integer> periods;
    private boolean isSatRest;
    private boolean isSunRest;
    private boolean isMonRest;
    private boolean isTueRest;
    private boolean isWenRest;
    private boolean isThuRest;
    private boolean isFriRest;
    private Date requireStartDate;
    private Date supplyStartDate;
    private Date endDate;

    public OrgBasedCalendarModel(String orgId) {
        this.orgId = orgId;
        this.initData();
    }

    public Date getRequireStartDate() {
        return this.requireStartDate;
    }

    public void setRequireStartDate(Date planDate, int delayPeriod) {
        this.requireStartDate = this.getStartDate(planDate, delayPeriod);
    }

    public Date getSupplyStartDate() {
        return this.supplyStartDate;
    }

    public void setSupplyStartDate(Date planDate, int delayPeriod) {
        this.supplyStartDate = this.getStartDate(planDate, delayPeriod);
    }

    private Date getStartDate(Date planDate, int delayPeriod) {
        if (delayPeriod < 0) {
            return this.minDate.getDate().getTime();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(planDate);
        calendar.add(5, -delayPeriod);
        return calendar.getTime().before(this.minDate.getDate().getTime()) ? this.minDate.getDate().getTime() : calendar.getTime();
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date planDate, int planOutLook) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(planDate);
        calendar.add(5, planOutLook);
        this.endDate = calendar.getTime().after(this.maxDate.getDate().getTime()) ? this.maxDate.getDate().getTime() : calendar.getTime();
    }

    private void initData() {
        this.dates = new ArrayList<MRPDate>(16);
        this.periods = new HashMap(16);
        JSONObject jsonObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"ICalendarService", (String)"getCalendarData", (Object[])new Object[]{Long.valueOf(this.orgId), "A", "B", null, null, null});
        if (jsonObject == null || !jsonObject.getBoolean("issuccessful").booleanValue()) {
            if (jsonObject != null) {
                BizLog.log((String)("plancalendar empty: " + jsonObject.get((Object)"msg")));
            }
            return;
        }
        JSONObject defCal = jsonObject.getJSONArray("data").getJSONObject(0);
        Map entryMap = defCal.getJSONObject("workdateentry").getInnerMap();
        ArrayList<Map<Object, Object>> entrys = new ArrayList<Map<Object, Object>>(entryMap.size());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (Map.Entry entry : entryMap.entrySet()) {
            HashMap<String, Comparable<Date>> value = new HashMap<String, Comparable<Date>>(2);
            value.put("workdate", MRPUtil.normalize(sdf, (String)entry.getKey()));
            value.put("datetype", Integer.valueOf(Integer.parseInt(entry.getValue().toString())));
            entrys.add(value);
        }
        this.isSatRest = defCal.containsKey((Object)"issatrest") && defCal.getBoolean("issatrest") != false;
        this.isSunRest = defCal.containsKey((Object)"issunrest") && defCal.getBoolean("issunrest") != false;
        this.isMonRest = defCal.containsKey((Object)"ismonrest") && defCal.getBoolean("ismonrest") != false;
        this.isTueRest = defCal.containsKey((Object)"istuerest") && defCal.getBoolean("istuerest") != false;
        this.isWenRest = defCal.containsKey((Object)"iswedrest") && defCal.getBoolean("iswedrest") != false;
        this.isThuRest = defCal.containsKey((Object)"isthurest") && defCal.getBoolean("isthurest") != false;
        boolean bl = this.isFriRest = defCal.containsKey((Object)"isfrirest") && defCal.getBoolean("isfrirest") != false;
        if (this.isSatRest && this.isSunRest && this.isMonRest && this.isTueRest && this.isWenRest && this.isThuRest && this.isFriRest) {
            throw new MRPBizException(Errors.getNoWorkDayInCalendar());
        }
        entrys.sort(new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                return ((Date)o1.get("workdate")).compareTo((Date)o2.get("workdate"));
            }
        });
        MRPDate previousWork = null;
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            Map entry = (Map)entrys.get(i);
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)entry.get("workdate"));
            OrgBasedCalendarModel.nomalize(cal);
            WorkCalendarDayType dt = WorkCalendarDayType.valueOf((Integer)entry.get("datetype"));
            MRPDate date = new MRPDate(cal, dt, i);
            this.dates.add(date);
            this.periods.put(cal.getTime(), i);
            date.setPreviousWorkDay(previousWork);
            if (!this.isWorkday(dt.getValue())) continue;
            previousWork = date;
            this.setNextWork(this.dates, previousWork, i);
            if (this.minDate == null) {
                this.minDate = date;
            }
            this.maxDate = date;
        }
    }

    private void setNextWork(List<MRPDate> dates, MRPDate nextDate, int len) {
        MRPDate date;
        for (int i = len - 1; i >= 0 && (date = dates.get(i)).getNextWorkDay() == null; --i) {
            date.setNextWorkDay(nextDate);
        }
    }

    public MRPDate getMinDate() {
        return this.minDate;
    }

    public MRPDate getMaxDate() {
        return this.maxDate;
    }

    public boolean isEmpty() {
        return this.dates.isEmpty();
    }

    public int getWorkDaySeq(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        OrgBasedCalendarModel.nomalize(cal);
        date = cal.getTime();
        Integer period = this.periods.get(date);
        if (period == null) {
            if (date.compareTo(this.dates.get(0).getDate().getTime()) < 0) {
                period = (int)((this.dates.get(0).getDate().getTimeInMillis() - cal.getTimeInMillis()) / 86400000L + 1L);
                period = -period.intValue();
            } else {
                period = (int)((cal.getTimeInMillis() - this.dates.get(this.dates.size() - 1).getDate().getTimeInMillis()) / 86400000L + 1L);
                period = period + (this.dates.size() - 1);
            }
            this.periods.put(date, period);
            return period;
        }
        return period;
    }

    public Calendar getDate(Date date, boolean isBack) {
        MRPDate mrpDate;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        OrgBasedCalendarModel.nomalize(cal);
        date = cal.getTime();
        if (date.compareTo(this.dates.get(0).getDate().getTime()) < 0 || date.compareTo(this.dates.get(this.dates.size() - 1).getDate().getTime()) > 0) {
            this.search(isBack, cal, 1);
            return cal;
        }
        if (isBack) {
            for (mrpDate = this.dates.get(this.periods.get(date)); mrpDate != null && !this.isWorkday(mrpDate.getDayType().getValue()); mrpDate = mrpDate.getPreviousWorkDay()) {
            }
        } else {
            while (mrpDate != null && !this.isWorkday(mrpDate.getDayType().getValue())) {
                mrpDate = mrpDate.getNextWorkDay();
            }
        }
        return this.getWorkDate(cal, mrpDate, isBack, 1);
    }

    private Calendar getWorkDate(Calendar cal, MRPDate mrpDate, boolean isBack, int n) {
        if (mrpDate != null) {
            return mrpDate.getDate();
        }
        if (isBack) {
            MRPDate date = this.dates.get(0);
            cal = (Calendar)date.getDate().clone();
        } else {
            MRPDate date = this.dates.get(this.dates.size() - 1);
            cal = (Calendar)date.getDate().clone();
        }
        this.search(isBack, cal, n);
        return cal;
    }

    public Calendar getDate(Date date, boolean isBack, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        OrgBasedCalendarModel.nomalize(cal);
        date = cal.getTime();
        Date calStart = this.dates.get(0).getDate().getTime();
        Date calEnd = this.dates.get(this.dates.size() - 1).getDate().getTime();
        if (date.compareTo(calStart) < 0 || date.compareTo(calEnd) > 0) {
            this.search(isBack, cal, n);
            return cal;
        }
        MRPDate mrpDate = this.dates.get(this.periods.get(date));
        if (mrpDate != null) {
            if (isBack) {
                while (n > 0 && mrpDate != null) {
                    mrpDate = mrpDate.getPreviousWorkDay();
                    --n;
                }
            } else {
                while (n > 0 && mrpDate != null) {
                    mrpDate = mrpDate.getNextWorkDay();
                    --n;
                }
            }
        }
        if (mrpDate == null) {
            ++n;
        }
        return this.getWorkDate(cal, mrpDate, isBack, n);
    }

    public int calcRestDays(Long start, Long end) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(start);
        OrgBasedCalendarModel.nomalize(cal);
        start = cal.getTimeInMillis();
        cal.setTimeInMillis(end);
        OrgBasedCalendarModel.nomalize(cal);
        end = cal.getTimeInMillis();
        int restCount = 0;
        while (start < end) {
            cal.setTimeInMillis(start);
            Integer idx = this.periods.get(cal.getTime());
            if (idx == null) {
                int dayInWeek = cal.get(7);
                switch (dayInWeek) {
                    case 2: {
                        if (!this.isMonRest) break;
                        ++restCount;
                        break;
                    }
                    case 3: {
                        if (!this.isTueRest) break;
                        ++restCount;
                        break;
                    }
                    case 4: {
                        if (!this.isWenRest) break;
                        ++restCount;
                        break;
                    }
                    case 5: {
                        if (!this.isThuRest) break;
                        ++restCount;
                        break;
                    }
                    case 6: {
                        if (!this.isFriRest) break;
                        ++restCount;
                        break;
                    }
                    case 7: {
                        if (!this.isSatRest) break;
                        ++restCount;
                        break;
                    }
                    case 1: {
                        if (!this.isSunRest) break;
                        ++restCount;
                    }
                }
            } else {
                MRPDate mrpDate = this.dates.get(idx);
                if (!this.isWorkday(mrpDate.getDayType().getValue())) {
                    ++restCount;
                }
            }
            start = start + 86400000L;
        }
        return restCount;
    }

    private void search(boolean isBack, Calendar cal, int days) {
        if (this.isMonRest && this.isTueRest && this.isWenRest && this.isThuRest && this.isFriRest && this.isSatRest && this.isSunRest) {
            throw new KDBizException(new ErrorCode("NO_WORK_DAYS", ResManager.loadKDString((String)"\u65e5\u5386\u672a\u8bbe\u7f6e\u5de5\u4f5c\u65e5\uff0c\u8ba1\u7b97\u8d85\u51fa\u8ba1\u5212\u65f6\u95f4\u5931\u8d25\u3002", (String)"OrgBasedCalendarModel_1", (String)"mmc-mrp-mservice", (Object[])new Object[0])), new Object[0]);
        }
        block9: while (days > 0) {
            if (isBack) {
                cal.add(5, -1);
            } else {
                cal.add(5, 1);
            }
            int dayInWeek = cal.get(7);
            switch (dayInWeek) {
                case 2: {
                    if (!this.isMonRest) break;
                    continue block9;
                }
                case 3: {
                    if (!this.isTueRest) break;
                    continue block9;
                }
                case 4: {
                    if (!this.isWenRest) break;
                    continue block9;
                }
                case 5: {
                    if (!this.isThuRest) break;
                    continue block9;
                }
                case 6: {
                    if (!this.isFriRest) break;
                    continue block9;
                }
                case 7: {
                    if (!this.isSatRest) break;
                    continue block9;
                }
                case 1: {
                    if (!this.isSunRest) break;
                    continue block9;
                }
            }
            --days;
        }
    }

    private boolean isWorkday(int dateType) {
        return dateType == WorkCalendarDayType.WORKDAY.getValue() || dateType == WorkCalendarDayType.HALFWORKDAY.getValue();
    }

    public static void nomalize(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }
}

