/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.fomula.Expr;
import kd.mmc.mrp.framework.fomula.ExprContext;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.bitset.BitSetFactory;
import kd.mmc.mrp.utils.bitset.IntBitSet;

public class ColumnDatas
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private TreeMap<Comparable<?>, IntBitSet> sortedDatas = new TreeMap();
    private Class<?> valueClazz;
    private IntBitSet nullValueReferences = this.createIntBitSet();
    private int rowCount = 0;
    private IntBitSet filter;
    private IntBitSet removedRows;
    private Integer fastBatch = -1;
    private IntBitSet EMPTYBITSET = this.createIntBitSet();

    public void put(Comparable<?> value, Integer id) {
        IntBitSet ids;
        ++this.rowCount;
        if (value == null) {
            this.nullValueReferences.set(id);
            return;
        }
        value = this.makeKey(value);
        if (this.valueClazz == null) {
            this.valueClazz = value.getClass();
        }
        if ((ids = this.sortedDatas.get(value)) == null) {
            ids = this.createIntBitSet();
            this.sortedDatas.put(value, ids);
        }
        ids.set(id);
    }

    public void remove(Object val, Integer rowIdx) {
        IntBitSet ids;
        if (val == null && this.nullValueReferences.get(rowIdx)) {
            this.nullValueReferences.remove(rowIdx);
            return;
        }
        if (val != null && (ids = this.sortedDatas.get(this.makeKey(val))) != null && ids.get(rowIdx)) {
            ids.remove(rowIdx);
        }
    }

    private Comparable<?> makeKey(Object val) {
        if (this.valueClazz != null && this.valueClazz != val.getClass()) {
            if (this.valueClazz == String.class) {
                return String.valueOf(this.getVal(val, false));
            }
            if (this.valueClazz == Long.class) {
                return this.getVal(val, false);
            }
            throw new MRPBizException(Errors.getUnknownDataType(), val, val.getClass());
        }
        return this.getVal(val, true);
    }

    private Comparable<?> getVal(Object val, boolean isComparable) {
        if (val instanceof String) {
            if (isComparable) {
                return (Comparable)val;
            }
            return Long.valueOf((String)val);
        }
        if (val instanceof Integer) {
            return (long)((Integer)val).intValue();
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).longValue();
        }
        if (val instanceof Date) {
            return ((Date)val).getTime();
        }
        throw new MRPBizException(Errors.getUnknownDataType(), val, val.getClass());
    }

    public List<Integer> get(Object value) {
        if (value == null) {
            return this.isNull();
        }
        value = this.makeKey(value);
        return this.doListFilter(ColumnDatas.toList(this.sortedDatas.get(value)));
    }

    public Integer getFirstNoCheck(Object value) {
        if (value == null) {
            return ColumnDatas.toFirstOne(this.nullValueReferences);
        }
        value = this.makeKey(value);
        return ColumnDatas.toFirstOne(this.sortedDatas.get(value));
    }

    private IntBitSet getAsBitSet(Object value) {
        IntBitSet src;
        IntBitSet ret = this.createIntBitSet();
        if (value == null) {
            src = this.nullValueReferences;
        } else {
            value = this.makeKey(value);
            src = this.sortedDatas.get(value);
        }
        if (src != null) {
            ret.or(src);
        }
        return ret;
    }

    public IntBitSet getAsBitSet(Map<String, Object> requireData, AbstractResModelDataTable supplyTbl, IntBitSet supplys, Object value, Expr formula) {
        return this.getAsBitSet(requireData, supplyTbl, supplys, value, formula, false);
    }

    public IntBitSet getAsBitSet(Map<String, Object> requireData, AbstractResModelDataTable supplyTbl, IntBitSet supplys, Object value, Expr formula, boolean isNullValueMatch) {
        return this.getAsBitSet(requireData, supplys, value, formula, isNullValueMatch, idx -> {
            RowData supply = supplyTbl.fetchRow(idx);
            return supply.toMap();
        });
    }

    public IntBitSet getAsBitSet(Map<String, Object> requireData, IntBitSet supplys, Object value, Expr formula, boolean isNullValueMatch, IDataFetcher fetcher) {
        return this.getAsBitSetImpl(requireData, supplys, value, formula, isNullValueMatch, fetcher);
    }

    public void setFastBatch(int fastBatch) {
        this.fastBatch = fastBatch;
    }

    private IntBitSet getAsBitSetImpl(Map<String, Object> requireData, IntBitSet supplys, Object value, Expr formula, boolean isNullValueMatch, IDataFetcher fetcher) {
        HashSet all;
        IntBitSet currentSet;
        if (supplys == null) {
            supplys = this.wrapToBitSet(this.getAsBitSet(value));
            return supplys;
        }
        if (supplys.cardinate() == 0) {
            return supplys;
        }
        if (formula == null && !isNullValueMatch) {
            IntBitSet ret = this.getAsBitSet(value);
            ret.and(supplys);
            return ret;
        }
        if (value == null) {
            currentSet = this.nullValueReferences;
        } else {
            value = this.makeKey(value);
            currentSet = this.sortedDatas.get(value);
        }
        IntBitSet longNullValueSet = null;
        if (isNullValueMatch) {
            longNullValueSet = this.sortedDatas.get(this.valueClazz == String.class ? "" : Long.valueOf(0L));
        }
        IntBitSet bitSet = this.createIntBitSet();
        try (TraceSpan ts = Tracer.create((String)"ColumnDatas.getAsBitSet-excludeCalc", (String)"getAsBitSet-excludeCalc");){
            int size = -1;
            if (this.fastBatch > 0) {
                size = supplys.cardinate() / this.fastBatch + 1;
            }
            if (size > 1 && DataMatchUtils.fast_match_pool != null) {
                all = new HashSet(supplys.cardinate());
                ArrayList<Integer> candiates = new ArrayList<Integer>(supplys.cardinate());
                Iterator<Integer> bomIter = supplys.iterator();
                while (bomIter.hasNext()) {
                    candiates.add(bomIter.next());
                }
                ArrayList list = new ArrayList(size);
                int from = 0;
                for (int i = 0; i < size; ++i) {
                    int to = from + this.fastBatch;
                    if (to > candiates.size()) {
                        to = candiates.size();
                    }
                    if (from >= to) continue;
                    list.add(new ArrayList(candiates.subList(from, to)).iterator());
                    from += this.fastBatch.intValue();
                }
                ArrayList<Future> tasks = new ArrayList<Future>(list.size());
                for (Iterator iterator : list) {
                    Future task = DataMatchUtils.fast_match_pool.submit((Callable)new TaskWorker(iterator, currentSet, this.nullValueReferences, longNullValueSet, isNullValueMatch, requireData, fetcher, formula), RequestContext.get());
                    tasks.add(task);
                }
                for (Future future : tasks) {
                    try {
                        all.addAll((Collection)future.get());
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("mrprunner-fast-match-failed.", e);
                    }
                }
            } else {
                Object removes = new TaskWorker(supplys.iterator(), currentSet, this.nullValueReferences, longNullValueSet, isNullValueMatch, requireData, fetcher, formula).call();
                all = new HashSet(removes);
            }
        }
        ts = Tracer.create((String)"ColumnDatas.getAsBitSet-remove", (String)"getAsBitSet-remove");
        var12_12 = null;
        try {
            Iterator<Integer> iter = supplys.iterator();
            while (iter.hasNext()) {
                Integer next = iter.next();
                if (all.contains(next)) continue;
                bitSet.set(next);
            }
        }
        catch (Throwable throwable) {
            var12_12 = throwable;
            throw throwable;
        }
        finally {
            if (ts != null) {
                if (var12_12 != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable) {
                        var12_12.addSuppressed(throwable);
                    }
                } else {
                    ts.close();
                }
            }
        }
        return bitSet;
    }

    private IntBitSet wrapToBitSet(IntBitSet rows) {
        if (rows == null) {
            return this.EMPTYBITSET;
        }
        if (this.filter == null) {
            if (this.removedRows == null || this.removedRows.cardinate() == 0) {
                return rows;
            }
        } else if (this.filter.cardinate() == 0) {
            return this.EMPTYBITSET;
        }
        IntBitSet bitSet = this.createIntBitSet();
        try (TraceSpan ts = Tracer.create((String)"ColumnDatas.wrapToBitSet-remove", (String)"wrapToBitSet-remove");){
            Iterator<Integer> iter = rows.iterator();
            while (iter.hasNext()) {
                int i = iter.next();
                if (this.filter != null && !this.filter.get(i) || this.removedRows != null && this.removedRows.get(i)) continue;
                bitSet.set(i);
            }
        }
        return bitSet;
    }

    public void lockRows(Set<Integer> idxes) {
        for (Map.Entry<Comparable<?>, IntBitSet> entry : this.sortedDatas.entrySet()) {
            IntBitSet index = entry.getValue();
            for (Integer idx : idxes) {
                if (index.get(idx)) {
                    index.remove(idx);
                }
                if (!this.nullValueReferences.get(idx)) continue;
                this.nullValueReferences.remove(idx);
            }
        }
    }

    public void unLockRows(Set<Integer> idxes) {
    }

    public List<Integer> isNull() {
        return ColumnDatas.toList(this.nullValueReferences);
    }

    private IntBitSet createIntBitSet() {
        return BitSetFactory.createIntBitSet();
    }

    private List<Integer> doListFilter(Collection<Integer> rows) {
        if (rows == null) {
            return new ArrayList<Integer>();
        }
        if (this.filter == null) {
            if (this.removedRows == null || this.removedRows.cardinate() == 0) {
                return new ArrayList<Integer>(rows);
            }
        } else if (this.filter.cardinate() == 0) {
            return new ArrayList<Integer>(0);
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(1);
        for (Integer idx : rows) {
            boolean isRemovedRow;
            boolean isEnabeldRow = this.filter == null || this.filter.get(idx);
            boolean bl = isRemovedRow = this.removedRows != null && this.removedRows.get(idx);
            if (!isEnabeldRow || isRemovedRow) continue;
            ret.add(idx);
        }
        return ret;
    }

    public void setRemovedRows(Set<Integer> removedRows) {
        if (removedRows == null) {
            this.removedRows = null;
            return;
        }
        this.removedRows = this.createIntBitSet();
        for (Integer i : removedRows) {
            this.removedRows.set(i);
        }
    }

    public void setRemovedRows(IntBitSet removedRows) {
        this.removedRows = removedRows;
    }

    public void setFilter(Set<Integer> filter) {
        if (filter == null) {
            return;
        }
        this.filter = this.createIntBitSet();
        for (Integer i : filter) {
            this.filter.set(i);
        }
    }

    public Iterator<Comparable<?>> iterator() {
        return this.sortedDatas.keySet().iterator();
    }

    public Iterator<Comparable<?>> descendingIterator() {
        return this.sortedDatas.descendingKeySet().iterator();
    }

    public Iterator<Comparable<?>> ascendingIterator() {
        return this.sortedDatas.descendingKeySet().descendingIterator();
    }

    public void mergeFilter(Set<Integer> newFilter) {
        if (this.filter == null) {
            this.setFilter(newFilter);
        } else {
            for (Integer i : newFilter) {
                this.filter.set(i);
            }
        }
    }

    public int size() {
        return this.sortedDatas.size();
    }

    public static List<Integer> toList(IntBitSet bitSet) {
        if (bitSet == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(bitSet.cardinate());
        Iterator<Integer> iter = bitSet.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static Integer toFirstOne(IntBitSet bitSet) {
        if (bitSet == null) {
            return -1;
        }
        Iterator<Integer> iter = bitSet.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return -1;
    }

    public List<Integer> over(Object value, boolean isIncludeEquals) {
        IntBitSet all = this.createIntBitSet();
        for (Map.Entry<Comparable<?>, IntBitSet> it : this.sortedDatas.entrySet()) {
            Comparable<?> key = it.getKey();
            IntBitSet svalue = it.getValue();
            int result = key.compareTo(this.makeKey(value));
            if (isIncludeEquals) {
                if (result > 0) continue;
                all.or(svalue);
                continue;
            }
            if (result >= 0) continue;
            all.or(svalue);
        }
        return ColumnDatas.toList(all);
    }

    public List<Integer> less(Object value, boolean isIncludeEquals) {
        IntBitSet selections = this.createIntBitSet();
        for (Map.Entry<Comparable<?>, IntBitSet> sortedDataEntrySet : this.sortedDatas.entrySet()) {
            int result = sortedDataEntrySet.getKey().compareTo(this.makeKey(value));
            if (isIncludeEquals) {
                if (result < 0) continue;
                selections.or(sortedDataEntrySet.getValue());
                continue;
            }
            if (result <= 0) continue;
            selections.or(sortedDataEntrySet.getValue());
        }
        selections.or(this.nullValueReferences);
        return ColumnDatas.toList(selections);
    }

    public ColumnDatas clone() {
        ColumnDatas ret = new ColumnDatas();
        ret.valueClazz = this.valueClazz;
        ret.sortedDatas = this.sortedDatas;
        ret.rowCount = this.rowCount;
        ret.nullValueReferences = this.nullValueReferences;
        ret.filter = this.filter;
        return ret;
    }

    private static class TaskWorker
    implements Callable<Set<Integer>> {
        private Iterator<Integer> iter;
        private IntBitSet currentSet;
        private IntBitSet nullValueReferences;
        private IntBitSet longNullValueSet;
        private boolean isNullValueMatch;
        private Map<String, Object> requireData;
        private IDataFetcher fetcher;
        private Expr formula;

        public TaskWorker(Iterator<Integer> iter, IntBitSet currentSet, IntBitSet nullValueReferences, IntBitSet longNullValueSet, boolean isNullValueMatch, Map<String, Object> requireData, IDataFetcher fetcher, Expr formula) {
            this.iter = iter;
            this.currentSet = currentSet;
            this.nullValueReferences = nullValueReferences;
            this.longNullValueSet = longNullValueSet;
            this.isNullValueMatch = isNullValueMatch;
            this.requireData = requireData;
            this.fetcher = fetcher;
            this.formula = formula;
        }

        @Override
        public Set<Integer> call() {
            HashSet<Integer> removes = new HashSet<Integer>(7);
            while (this.iter.hasNext()) {
                int idx = this.iter.next();
                if (this.currentSet != null && this.currentSet.get(idx) || this.isNullValueMatch && (this.nullValueReferences != null && this.nullValueReferences.get(idx) || this.longNullValueSet != null && this.longNullValueSet.get(idx))) continue;
                Object result = true;
                if (this.formula != null) {
                    ExprContext exprCtx = new ExprContext();
                    Map<String, Object> supplyData = this.fetcher.fetch(idx);
                    exprCtx.addPreDefinedParam("requireData", this.requireData);
                    exprCtx.addPreDefinedParam("supplyData", supplyData);
                    result = this.formula.execute(exprCtx);
                }
                if (!MRPUtil.isTrue(result)) continue;
                removes.add(idx);
            }
            return removes;
        }
    }

    public static interface IDataFetcher {
        public Map<String, Object> fetch(int var1);
    }
}

