/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.MemoryGrid;

public class DiffZipMemoryGrid
implements GridData.Grid {
    private static final long[] fastPointers = new long[64];
    private float compressFactor = 0.5f;
    private final MemoryGrid grid;

    public DiffZipMemoryGrid(int bufferSize, int compressRatio) {
        this.grid = new MemoryGrid(bufferSize);
        this.compressFactor = (float)compressRatio / 100.0f;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return new InnerIterator();
    }

    @Override
    public int size() {
        return this.grid.size();
    }

    @Override
    public void add(Object[] row) {
        this.grid.add(this.compress(row));
    }

    @Override
    public Object[] get(int idx) {
        return this.expand(this.grid.get(idx));
    }

    @Override
    public void addAll(List<Object[]> rows) {
        for (Object[] row : rows) {
            this.grid.add(this.compress(row));
        }
    }

    @Override
    public void clear() {
        this.grid.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.grid.isEmpty();
    }

    @Override
    public void update(int rowIdx, Object[] row) {
        Object[] next = this.grid.get(rowIdx);
        if (next[0] instanceof RowDesc) {
            RowDesc rd = (RowDesc)next[0];
            int prevIndex = rd.srcIdx;
            Object[] prevRow = this.grid.get(prevIndex);
            this.grid.update(rowIdx, this.compressRowByPreRow(prevRow, prevIndex, row, true));
        } else {
            Object[] n;
            for (int idx = rowIdx + 1; idx < this.size() && (n = this.grid.get(idx))[0] instanceof RowDesc && ((RowDesc)n[0]).srcIdx == rowIdx; ++idx) {
                this.grid.update(idx, this.compressRowByPreRow(row, rowIdx, this.get(idx), true));
            }
            this.grid.update(rowIdx, row);
        }
    }

    @Override
    public void updateValue(int rowIdx, int colIdx, Object colValue) {
        Object[] next = this.grid.get(rowIdx);
        if (next[0] instanceof RowDesc) {
            RowDesc rd = (RowDesc)next[0];
            this.updateCompressRowValue(rd, colIdx, colValue);
        } else if (!this.equals(next[colIdx], colValue)) {
            Object[] n;
            Object oldColValue = next[colIdx];
            this.grid.updateValue(rowIdx, colIdx, colValue);
            for (int idx = rowIdx + 1; idx < this.size() && (n = this.grid.get(idx))[0] instanceof RowDesc && ((RowDesc)n[0]).srcIdx == rowIdx; ++idx) {
                RowDesc rd = (RowDesc)n[0];
                if ((rd.pointers[colIdx / 64] & fastPointers[colIdx % 64]) == 0L) continue;
                this.updateCompressRowValue(rd, colIdx, oldColValue);
            }
        }
    }

    private void updateCompressRowValue(RowDesc rd, int colIdx, Object colValue) {
        Object[] srcRow = this.grid.get(rd.srcIdx);
        if ((rd.pointers[colIdx / 64] & fastPointers[colIdx % 64]) != 0L) {
            if (!this.equals(srcRow[colIdx], colValue)) {
                int bitPosition = colIdx % 64;
                long mask = 1L << bitPosition ^ 0xFFFFFFFFFFFFFFFFL;
                ((RowDesc)rd).pointers[colIdx / 64] = rd.pointers[colIdx / 64] & mask;
                ArrayList<Object> buffer = new ArrayList<Object>(rd.diffObjs.length + 1);
                int pos = 0;
                int diff = 0;
                for (int i = 0; i < rd.pointers.length && pos < srcRow.length; ++i) {
                    for (int j = 0; j < 64 && pos < srcRow.length; ++pos, ++j) {
                        if (pos == colIdx) {
                            buffer.add(colValue);
                            continue;
                        }
                        if ((rd.pointers[i] & fastPointers[j]) != 0L) continue;
                        buffer.add(rd.diffObjs[diff++]);
                    }
                }
                RowDesc.access$202(rd, buffer.toArray(new Object[0]));
            }
        } else {
            int pos = 0;
            int diff = 0;
            for (int i = 0; i < rd.pointers.length && pos < srcRow.length && colIdx != pos; ++i) {
                for (int j = 0; j < 64 && pos < srcRow.length && colIdx != pos; ++pos, ++j) {
                    if ((rd.pointers[i] & fastPointers[j]) != 0L) continue;
                    ++diff;
                }
            }
            if (colIdx == pos) {
                ((RowDesc)rd).diffObjs[diff] = colValue;
            }
        }
    }

    private Object[] expand(Object[] next) {
        if (next[0] instanceof RowDesc) {
            RowDesc rd = (RowDesc)next[0];
            Object[] srcRow = this.grid.get(rd.srcIdx);
            Object[] expand = new Object[srcRow.length];
            int pos = 0;
            int diff = 0;
            for (int i = 0; i < rd.pointers.length && pos < srcRow.length; ++i) {
                for (int j = 0; j < 64 && pos < srcRow.length; ++pos, ++j) {
                    expand[pos] = (rd.pointers[i] & fastPointers[j]) != 0L ? srcRow[pos] : rd.diffObjs[diff++];
                }
            }
            next = expand;
        }
        return next;
    }

    private Object[] compress(Object[] row) {
        if (this.grid.size() == 0) {
            return row;
        }
        int prevIndex = this.grid.size() - 1;
        Object[] prevRow = this.grid.get(prevIndex);
        if (prevRow[0] instanceof RowDesc) {
            prevIndex = ((RowDesc)prevRow[0]).srcIdx;
            prevRow = this.grid.get(prevIndex);
        }
        if (prevRow.length != row.length || this.grid.get(0).length != row.length) {
            return row;
        }
        return this.compressRowByPreRow(prevRow, prevIndex, row, false);
    }

    private Object[] compressRowByPreRow(Object[] prevRow, int prevIndex, Object[] row, boolean ignoreCompressFactor) {
        int n = row.length / 64 + 1;
        long[] pointers = new long[n];
        for (int i = 0; i < n; ++i) {
            pointers[i] = 0L;
        }
        int compressCnt = 0;
        ArrayList<Object> buffer = new ArrayList<Object>(80);
        for (int i = 0; i < row.length; ++i) {
            if (this.equals(prevRow[i], row[i])) {
                ++compressCnt;
                pointers[i / 64] = pointers[i / 64] | fastPointers[i % 64];
                continue;
            }
            buffer.add(row[i]);
        }
        if (ignoreCompressFactor || (float)compressCnt / (float)row.length >= this.compressFactor) {
            return new Object[]{new RowDesc(prevIndex, pointers, buffer.toArray())};
        }
        return row;
    }

    private boolean equals(Object prevObj, Object obj) {
        if (prevObj == null && obj == null) {
            return true;
        }
        if (prevObj != null && obj != null) {
            return prevObj.equals(obj);
        }
        return false;
    }

    public String toString() {
        int compressCnt = 0;
        for (Object[] row : this.grid) {
            if (!(row[0] instanceof RowDesc)) continue;
            ++compressCnt;
        }
        String msg = ResManager.loadKDString((String)"\u6570\u636e\u538b\u7f29\u5185\u5b58\u8868\u683c\uff0c\u603b\u6570\u636e\u884c\uff1a%1$s\uff0c\u538b\u7f29\u6570\u636e\u884c\uff1a%2$s\uff0c\u538b\u7f29\u7cfb\u6570\uff1a%3$s\u3002", (String)"DiffZipMemoryGrid_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
        return String.format(msg, this.grid.size(), compressCnt, Float.valueOf(this.compressFactor));
    }

    static {
        DiffZipMemoryGrid.fastPointers[0] = 1L;
        for (int i = 1; i < 64; ++i) {
            DiffZipMemoryGrid.fastPointers[i] = fastPointers[i - 1] << 1;
        }
    }

    private static class RowDesc {
        private int srcIdx;
        private long[] pointers;
        private Object[] diffObjs;

        public RowDesc(int srcIdx, long[] pointers, Object[] diffObjs) {
            this.srcIdx = srcIdx;
            this.pointers = pointers;
            this.diffObjs = diffObjs;
        }

        static /* synthetic */ Object[] access$202(RowDesc x0, Object[] x1) {
            x0.diffObjs = x1;
            return x1;
        }
    }

    private class InnerIterator
    implements Iterator<Object[]> {
        private Iterator<Object[]> storeIter;

        public InnerIterator() {
            this.storeIter = DiffZipMemoryGrid.this.grid.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.storeIter.hasNext();
        }

        @Override
        public Object[] next() {
            Object[] next = this.storeIter.next();
            return DiffZipMemoryGrid.this.expand(next);
        }
    }
}

