/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.GridData;

public class DynamicPriorityLevelDataTable {
    protected String refTablName;
    protected HashMap<String, ColumnDatas> index = new HashMap();
    protected GridData srcDatas;
    protected HashMap<String, Integer> colIdx = new HashMap();
    protected CalEnv runParam;

    public DynamicPriorityLevelDataTable(CalEnv runParam, String priorityId) {
        this.runParam = runParam;
        this.srcDatas = new GridData((IMRPEnvProvider)runParam);
        this.refTablName = "t_mrp_" + priorityId;
    }

    private void fill(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        if (this.colIdx.isEmpty()) {
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                this.colIdx.put(meta.getColumnLabel(i).toUpperCase(), i - 1);
            }
        }
        ArrayList<Object[]> datas = new ArrayList<Object[]>(0);
        int rowIdx = this.srcDatas.getDatas().size();
        while (rs.next()) {
            Object[] row = new Object[this.colIdx.size()];
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                Object cll;
                row[i - 1] = cll = rs.getObject(i);
            }
            for (Map.Entry<String, ColumnDatas> entry : this.index.entrySet()) {
                Integer idx = this.colIdx.get(entry.getKey().toUpperCase());
                this.index.get(entry.getKey()).put((Comparable)row[idx], rowIdx);
            }
            ++rowIdx;
            datas.add(row);
        }
        this.srcDatas.getDatas().addAll(datas);
    }

    public void addIndexCol(String colLabel) {
        if (!this.index.containsKey(colLabel)) {
            this.index.put(colLabel, new ColumnDatas());
        }
    }

    public void refresh() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FWEIGHT");
        for (String colName : this.index.keySet()) {
            sql.append(", ").append(colName);
        }
        sql.append(" FROM ").append(this.refTablName);
        DB.query((DBRoute)new DBRoute("scm"), (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                DynamicPriorityLevelDataTable.this.fill(rs);
                return null;
            }
        });
    }

    public ColumnDatas getCol(String colLabel) {
        return this.index.get(colLabel);
    }

    public Object getValue(String colLabel, int rowIdx) {
        Integer idx = this.colIdx.get(colLabel);
        return this.srcDatas.getDatas().get(rowIdx)[idx];
    }

    public GridData getSrcDatas() {
        return this.srcDatas;
    }
}

