/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table;

import java.io.Serializable;
import java.util.List;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.table.DiffZipMemoryGrid;
import kd.mmc.mrp.model.table.MemoryGrid;
import kd.mmc.mrp.model.table.RandomAccessGrid;
import kd.mmc.mrp.utils.MRPUtil;

public class GridData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Grid grid;

    public GridData(String gridDataType) {
        this.init(gridDataType, 6000, 50);
    }

    public GridData(IMRPEnvProvider ctx) {
        String gridDataType = (String)ctx.getCfgValue(EnvCfgItem.MRP_DATA_STORAGE_TYPE);
        Integer cnt = (Integer)ctx.getCfgValue(EnvCfgItem.MEM_DATA_STORE_CNT);
        int compressRatio = MRPUtil.convert(ctx.getCfgValue(EnvCfgItem.DATATABLE_COMPRESS_RATIO), 0);
        this.init(gridDataType, cnt, compressRatio);
    }

    public GridData(String gridDataType, IMRPEnvProvider ctx) {
        Integer cnt = (Integer)ctx.getCfgValue(EnvCfgItem.MEM_DATA_STORE_CNT);
        int compressRatio = MRPUtil.convert(ctx.getCfgValue(EnvCfgItem.DATATABLE_COMPRESS_RATIO), 0);
        this.init(gridDataType, cnt, compressRatio);
    }

    private void init(String gridDataType, Integer cnt, int compressRatio) {
        if ("MEM-ONLY".equals(gridDataType)) {
            this.grid = new MemoryGrid(cnt);
        } else if ("MEM-DISK".equals(gridDataType)) {
            this.grid = new RandomAccessGrid();
        } else if (!"MEM-REDIS".equals(gridDataType)) {
            if ("MEM-COMPRESS".equals(gridDataType)) {
                this.grid = new DiffZipMemoryGrid(cnt, compressRatio);
            } else {
                throw new IllegalArgumentException("unknown storage type.");
            }
        }
    }

    public Grid getDatas() {
        return this.grid;
    }

    public static interface Grid
    extends Iterable<Object[]> {
        public int size();

        public void add(Object[] var1);

        public Object[] get(int var1);

        public void addAll(List<Object[]> var1);

        public void clear();

        public boolean isEmpty();

        public void update(int var1, Object[] var2);

        default public void updateValue(int rowIdx, int colIdx, Object colValue) {
            Object[] rowData = this.get(rowIdx);
            rowData[colIdx] = colValue;
            this.update(rowIdx, rowData);
        }
    }
}

