/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.model.table.GridData;

public class ZipMemGrid
implements GridData.Grid {
    private int bufferSize = 6000;
    private List<List<byte[]>> store;
    private List<byte[]> currentBuffer;
    private int size = 0;

    public ZipMemGrid(int bufferSize) {
        this.bufferSize = bufferSize;
        this.store = new ArrayList<List<byte[]>>(10000);
        this.currentBuffer = new ArrayList<byte[]>(bufferSize);
        this.store.add(this.currentBuffer);
    }

    @Override
    public Iterator<Object[]> iterator() {
        return new InnerIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(Object[] row) {
        ++this.size;
        if (this.currentBuffer.size() == this.bufferSize) {
            this.currentBuffer = new ArrayList<byte[]>(this.bufferSize);
            this.store.add(this.currentBuffer);
        }
        this.currentBuffer.add(MRPRedisStore.encode(row));
    }

    @Override
    public Object[] get(int idx) {
        int pos = idx / this.bufferSize;
        byte[] bytes = this.store.get(pos).get(idx % this.bufferSize);
        return (Object[])MRPRedisStore.decode(bytes);
    }

    @Override
    public void addAll(List<Object[]> rows) {
        Iterator<Object[]> iter = rows.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    @Override
    public void clear() {
        this.size = 0;
        this.store.clear();
        this.currentBuffer.clear();
        this.currentBuffer = new ArrayList<byte[]>(this.bufferSize);
        this.store.add(this.currentBuffer);
    }

    @Override
    public boolean isEmpty() {
        return this.currentBuffer.isEmpty() && this.store.size() == 1;
    }

    @Override
    public void update(int rowIdx, Object[] row) {
        int pos = rowIdx / this.bufferSize;
        this.store.get(pos).set(rowIdx % this.bufferSize, MRPRedisStore.encode(row));
    }

    private class InnerIterator
    implements Iterator<Object[]> {
        private Iterator<List<byte[]>> storeIter;
        private Iterator<byte[]> currentIter;

        public InnerIterator() {
            this.storeIter = ZipMemGrid.this.store.iterator();
            this.currentIter = this.storeIter.next().iterator();
        }

        @Override
        public boolean hasNext() {
            boolean ret = this.currentIter.hasNext();
            if (ret) {
                return true;
            }
            if (this.storeIter.hasNext()) {
                this.currentIter = this.storeIter.next().iterator();
                ret = this.currentIter.hasNext();
            }
            return ret;
        }

        @Override
        public Object[] next() {
            byte[] bytes = this.currentIter.next();
            return (Object[])MRPRedisStore.decode(bytes);
        }
    }
}

