/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.res;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPDataSourceResolver;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MultiThreadCacheManager;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.utils.MRPUtil;
import kd.sdk.mmc.mrp.framework.res.IResModelDataTable;

public abstract class AbstractResModelDataTable
implements Serializable,
IResModelDataTable {
    private static final Log logger = LogFactory.getLog(AbstractResModelDataTable.class);
    private static final long serialVersionUID = 1L;
    private final WeakHashMap<Object, Object> ValueBuffer = new WeakHashMap(5000);
    protected HashMap<String, ColumnDatas> index = new HashMap();
    protected GridData srcDatas;
    protected Map<String, Integer> colIdx = new HashMap<String, Integer>();
    private HashMap<String, ArrayList<String>> fieldsMap = new HashMap();
    private Map<String, Class<?>> notNullableColMap = new HashMap();
    private HashSet<String> srcDataKeys = new HashSet();
    protected transient CalEnv runParam;
    protected MultiThreadCacheKey filterKeyName = MultiThreadCacheKey.KEY_COMMON_FILTER;

    protected AbstractResModelDataTable() {
        this.srcDatas = new GridData("MEM-ONLY");
    }

    protected AbstractResModelDataTable(CalEnv runParam, Set<String> indexCols) {
        this.srcDatas = new GridData((IMRPEnvProvider)runParam);
        for (String colLabel : indexCols) {
            this.index.put(colLabel.toUpperCase(), new ColumnDatas());
        }
        this.runParam = runParam;
    }

    public GridData getSrcDatas() {
        return this.srcDatas;
    }

    public void setSrcDatas(GridData srcDatas) {
        this.srcDatas = srcDatas;
    }

    public Map<String, Integer> getColIdx() {
        return this.colIdx;
    }

    public void setColIdx(Map<String, Integer> colIdx) {
        this.colIdx = colIdx;
    }

    public HashMap<String, ArrayList<String>> getFieldsMap() {
        return this.fieldsMap;
    }

    public void setFieldsMap(HashMap<String, ArrayList<String>> fieldsMap) {
        this.fieldsMap = fieldsMap;
    }

    public Map<String, Class<?>> getNotNullableColMap() {
        return this.notNullableColMap;
    }

    public void setNotNullableColMap(Map<String, Class<?>> notNullableColMap) {
        this.notNullableColMap = notNullableColMap;
    }

    public HashSet<String> getSrcDataKeys() {
        return this.srcDataKeys;
    }

    public void setSrcDataKeys(HashSet<String> srcDataKeys) {
        this.srcDataKeys = srcDataKeys;
    }

    public <T> T useBufferData(T data) {
        if (data == null) {
            return null;
        }
        Object old = this.ValueBuffer.computeIfAbsent(data, k -> data);
        return (T)old;
    }

    /*
     * Could not resolve type clashes
     */
    public StringBuilder fill(List<String> cols, List<Object[]> rows, String modelId, String resDataId, String resDataName, String modelName) {
        int rowIdx = this.srcDatas.getDatas().size();
        StringBuilder message = new StringBuilder();
        if (rows == null || rows.isEmpty()) {
            return message;
        }
        for (Object[] next : rows) {
            IMRPDataSourceResolver imrpDataSourceResolver;
            Integer idx;
            Object[] row = new Object[this.colIdx.size()];
            for (int i = 0; i < cols.size(); ++i) {
                String colName = cols.get(i).toUpperCase();
                ArrayList<String> colLabels = this.fieldsMap.get(colName);
                Object cll = next[i];
                if (colLabels == null) {
                    if (this.colIdx.get(colName) == null) continue;
                    colLabels = new ArrayList();
                    colLabels.add(colName);
                }
                for (String colLabel : colLabels) {
                    if (this.colIdx.get(colLabel) == null) {
                        String name = this.getAlias4Name(colLabel);
                        String msg = String.format(ResManager.loadKDString((String)"\u7531\u4e8e\u5b9e\u4f53\u5b57\u6bb5%1$s\u88ab\u8c03\u6574\u6216\u8005\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u201c%2$s\u201d\u6570\u636e\u4e2d\u5b57\u6bb5\u6620\u5c04\u4fe1\u606f\u914d\u7f6e\u7684\u5b57\u6bb5\u6807\u8bc6\u4e3a%3$s\u7684\u6570\u636e\u3002", (String)"AbstractResModelDataTable_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), name, modelName, colLabel);
                        logger.warn(String.format("ctxid: %s, mrprunner-AbstractResModelDataTable-fill-error,message:%s", this.runParam.getMRPContextId(), msg));
                        continue;
                    }
                    row[this.colIdx.get((Object)colLabel).intValue()] = this.useBufferData(cll);
                }
            }
            boolean isValidDate = this.setDefaultData(row);
            if (!isValidDate) {
                if (!"1".equals(this.runParam.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) continue;
                logger.warn(String.format("ctxid: %s, mrprunner-AbstractResModelDataTable-fill-data-error,message:%s", this.runParam.getMRPContextId(), row));
                continue;
            }
            for (Map.Entry entry : this.notNullableColMap.entrySet()) {
                String notNullCol = (String)entry.getKey();
                Class colClass = (Class)entry.getValue();
                idx = this.colIdx.get(notNullCol);
                if (idx != null && (!this.isNull(row[idx], colClass) || this.isIgnoreNullValue(notNullCol, row))) continue;
                if (message.length() < 20000) {
                    String logo = this.getLogo(row);
                    if (isValidDate && logo != null) {
                        message.append(logo);
                    }
                    String name = this.getAlias4Name(notNullCol);
                    message.append('[').append(name).append(']').append("\r\n");
                }
                isValidDate = false;
            }
            if (!isValidDate || !this.isValidDate(this.runParam, row, modelId, resDataId)) continue;
            if (this.runParam instanceof IMRPEnvProvider && (imrpDataSourceResolver = ((IMRPEnvProvider)this.runParam).getDataSourceResolver()) != null) {
                int type = -1;
                if (this instanceof RequirementDataTable) {
                    type = 0;
                } else if (this instanceof SupplymentDataTable) {
                    type = 1;
                } else if (this instanceof BOMStructDataTable) {
                    type = 2;
                }
                if (!imrpDataSourceResolver.isValidDate((IMRPEnvProvider)this.runParam, this.getColIdx(), row, modelId, resDataId, type)) continue;
            }
            this.afterFillRow(row, modelId, resDataName, resDataId);
            Object[][] splits = this.splitRow(row);
            for (int j = 0; j < splits.length; ++j) {
                row = splits[j];
                this.afterFillRow(row, modelId, resDataName, resDataId);
                for (Map.Entry<String, ColumnDatas> entry : this.index.entrySet()) {
                    idx = this.colIdx.get(entry.getKey());
                    if (idx == null) continue;
                    Object v = row[idx];
                    if (v != null && !(v instanceof Comparable)) {
                        v = v.toString();
                    }
                    this.index.get(entry.getKey()).put((Comparable)v, rowIdx);
                }
                ++rowIdx;
                this.srcDatas.getDatas().add(row);
            }
        }
        if (message.length() >= 20000) {
            message.append("...");
        }
        return message;
    }

    protected boolean isIgnoreNullValue(String notNullCol, Object[] row) {
        return false;
    }

    protected boolean setDefaultData(Object[] rowData) {
        return true;
    }

    public abstract String getLogo(Object[] var1);

    public abstract String getAlias4Name(String var1);

    private boolean isNull(Object cll, Class<?> colClass) {
        if (cll == null) {
            return true;
        }
        if (colClass == Long.class && MRPUtil.convert(cll, 0L) <= 0L) {
            return true;
        }
        return colClass == String.class && MRPUtil.convert(cll, "").trim().isEmpty();
    }

    public void applyColValues(Map<Integer, Map<String, Object>> colVals) {
        for (int i = 0; i < this.size(); ++i) {
            Map<String, Object> ext = colVals.get(i);
            if (ext == null) continue;
            for (Map.Entry<String, Object> entry : ext.entrySet()) {
                Object oldVal;
                Integer col = this.colIdx.get(entry.getKey());
                if (col == null) continue;
                ColumnDatas cd = this.index.get(String.valueOf(col));
                Object attr = ext.get(entry.getKey());
                if (col == null || (oldVal = this.srcDatas.getDatas().get(i)[col]) != null && (!(oldVal instanceof Number) || ((Number)oldVal).intValue() != 0)) continue;
                if (attr != null) {
                    this.srcDatas.getDatas().get((int)i)[col.intValue()] = attr;
                }
                if (cd == null) continue;
                cd.put((Comparable)attr, i);
            }
        }
    }

    public int fill(RowData data) {
        Object[] row = data.getValues();
        return this.fill(row);
    }

    public int fill(Object[] row) {
        int rowIdx = this.srcDatas.getDatas().size();
        for (Map.Entry<String, Integer> entry : this.colIdx.entrySet()) {
            if (!this.index.containsKey(entry.getKey())) continue;
            Object v = row[this.colIdx.get(entry.getKey())];
            if (v != null && !(v instanceof Comparable)) {
                v = v.toString();
            }
            this.index.get(entry.getKey()).put((Comparable)v, rowIdx);
        }
        this.srcDatas.getDatas().add(row);
        return this.srcDatas.getDatas().size() - 1;
    }

    public int fillNoIndex(RowData data) {
        Object[] row = data.getValues();
        this.srcDatas.getDatas().add(row);
        return this.srcDatas.getDatas().size() - 1;
    }

    public int[] fill(RowData[] datas) {
        if (datas == null) {
            return new int[0];
        }
        int[] ret = new int[datas.length];
        for (int i = 0; i < datas.length; ++i) {
            ret[i] = this.fill(datas[i]);
        }
        return ret;
    }

    public void clearIndex(String colLabel) {
        this.index.put(colLabel, new ColumnDatas());
    }

    public void updateValue(String colLabel, Integer rowIdx, Object newVal) {
        Integer col = this.colIdx.get(colLabel);
        Object old = this.srcDatas.getDatas().get(rowIdx)[col];
        if (Objects.equals(old, newVal)) {
            return;
        }
        this.srcDatas.getDatas().updateValue(rowIdx, col, newVal);
        this.updateIndexValue(colLabel, rowIdx, old);
    }

    public void updateIndexValue(String colLabel, Integer rowIdx, Object old) {
        Integer col = this.colIdx.get(colLabel);
        ColumnDatas column = this.index.get(colLabel);
        if (column != null) {
            column.remove(old, rowIdx);
            column.put((Comparable)this.srcDatas.getDatas().get(rowIdx)[col], rowIdx);
        }
    }

    protected abstract void afterFillRow(Object[] var1, String var2, String var3, String var4);

    protected Object[][] splitRow(Object[] row) {
        return new Object[][]{row};
    }

    protected boolean isValidDate(CalEnv runParam, Object[] rowData) {
        return this.isValidDate(runParam, rowData, "", "");
    }

    protected boolean isValidDate(CalEnv runParam, Object[] rowData, String modelId, String resDataId) {
        return true;
    }

    public abstract RowData fetchRow(int var1);

    public abstract List<? extends RowData> fetchRow(Collection<Integer> var1);

    public Object getValue(String colLabel, int rowIdx) {
        Integer idx = this.colIdx.get(colLabel);
        if (idx == null) {
            return null;
        }
        return this.srcDatas.getDatas().get(rowIdx)[idx];
    }

    public Integer size() {
        return this.srcDatas.getDatas().size();
    }

    public synchronized void setFilter(Set<Integer> filter) {
        MultiThreadCacheManager.setCacheData(this.filterKeyName, filter);
    }

    public ColumnDatas getCol(String colLabel) {
        ColumnDatas col = this.index.get(colLabel.toUpperCase());
        ColumnDatas ret = col.clone();
        Set filter = (Set)MultiThreadCacheManager.getCacheData(this.filterKeyName);
        ret.setFilter(filter);
        return ret;
    }

    public void clear() {
        this.srcDatas.getDatas().clear();
        for (String key : this.index.keySet()) {
            this.index.put(key, new ColumnDatas());
        }
    }

    public void addIndexCol(String colLabel) {
        this.index.put(colLabel.toUpperCase(), new ColumnDatas());
    }
}

