/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.res;

import com.alibaba.fastjson.JSON;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.integrate.entity.BomDataModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.integrate.entity.SupplyDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.utils.MRPUtil;
import org.apache.commons.collections.map.LRUMap;

public class FlexFieldDataTable {
    private IMRPEnvProvider ctx;
    private Map<String, Set<String>> materialExtPropMap = new LRUMap(500, 100.0f);
    private Map<Long, Map<?, ?>> flexValues = new LRUMap(500, 100.0f);
    private boolean isEnabled = false;
    private boolean isStrictMatch = true;

    public FlexFieldDataTable(IMRPEnvProvider ctx, boolean isEnabled) {
        this.ctx = ctx;
        this.isEnabled = isEnabled;
        AppParam appParam = new AppParam("0MBBBZ1L5IAW", Long.valueOf(ctx.getPlanOrgId()));
        Map mrpParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (mrpParam.get("materialflexmatchtype") != null && "1".equals(mrpParam.get("materialflexmatchtype"))) {
            this.isStrictMatch = false;
        }
    }

    public void loadFlexValues() {
        Long mFlexId;
        int i;
        if (!this.isEnabled) {
            return;
        }
        ResDataModelCollection rdmc = (ResDataModelCollection)this.ctx.getService(ResDataModelCollection.class);
        RequireDataModel rm = rdmc.getRequire();
        RequirementDataTable rt = rm.getTable();
        SupplyDataModel sm = rdmc.getSupply();
        SupplymentDataTable st = sm.getTable();
        HashSet<Long> flexFieldIds = new HashSet<Long>(rt.size() + st.size());
        for (i = 0; i < rt.size(); ++i) {
            mFlexId = MRPUtil.convert(rt.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName(), i), 0L);
            if (0L == mFlexId) continue;
            flexFieldIds.add(mFlexId);
        }
        for (i = 0; i < st.size(); ++i) {
            mFlexId = MRPUtil.convert(st.getValue(DefaultField.SupplyField.MATERIALFLEXPROPS.getName(), i), 0L);
            if (0L == mFlexId) continue;
            flexFieldIds.add(mFlexId);
        }
        this.loadFlexValues(flexFieldIds);
    }

    private void loadFlexValues(Set<Long> flexFieldIds) {
        if (flexFieldIds.isEmpty()) {
            return;
        }
        MRPRedisStore store = MRPCacheManager.getDStore(this.ctx.getMRPContextId());
        HashSet<String> notInMemoryIds = new HashSet<String>();
        for (Long flexFieldId : flexFieldIds) {
            if (this.flexValues.containsKey(flexFieldId)) continue;
            notInMemoryIds.add(flexFieldId.toString());
        }
        if (notInMemoryIds.isEmpty()) {
            return;
        }
        HashSet<Long> notInCacheIds = new HashSet<Long>();
        final Map redisContents = store.mapMGet("flexvalues", notInMemoryIds.toArray(new String[0]));
        for (String flexFieldId : notInMemoryIds) {
            String json = (String)redisContents.get(flexFieldId);
            if (StringUtils.isEmpty((String)json)) {
                notInCacheIds.add(Long.valueOf(flexFieldId));
                continue;
            }
            Map values = (Map)JSON.parseObject((String)json, Map.class);
            this.flexValues.put(Long.valueOf(flexFieldId), values);
        }
        StringBuilder sql = new StringBuilder("select fid, fvalue from t_bd_flexauxpropdata where fid in (?");
        for (int i = 1; i < notInCacheIds.size(); ++i) {
            sql.append(", ?");
        }
        sql.append(")");
        if (!notInCacheIds.isEmpty()) {
            DB.query((DBRoute)new DBRoute("sys"), (String)sql.toString(), (Object[])notInCacheIds.toArray(), (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        long id = rs.getLong("fid");
                        String key = String.valueOf(id);
                        String json = rs.getString("fvalue");
                        redisContents.put(key, json);
                        Map values = (Map)JSON.parseObject((String)json, Map.class);
                        FlexFieldDataTable.this.flexValues.put(id, values);
                    }
                    return redisContents;
                }
            });
        }
        store.mapMSet("flexvalues", redisContents);
    }

    public List<Integer> findSupplys(RowData require, List<Integer> supplys) {
        MRPRedisStore store = MRPCacheManager.getDStore(this.ctx.getMRPContextId());
        if (!this.isEnabled || !this.loadMaterialExtendPropSettings(require, store)) {
            return supplys;
        }
        Long mId = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L);
        Long mFlexId = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
        Map<?, ?> requireExtendProps = this.doMapGet(mFlexId);
        ArrayList<Integer> ret = new ArrayList<Integer>(supplys.size());
        block0: for (int idx : supplys) {
            Long mSupplyFlexId = MRPUtil.convert(this.ctx.supplyDatas().getValue(DefaultField.SupplyField.MATERIALFLEXPROPS.getName(), idx), 0L);
            if (mFlexId.equals(mSupplyFlexId)) {
                ret.add(idx);
                continue;
            }
            Map<?, ?> supplyExtendProps = this.doMapGet(mSupplyFlexId);
            if (requireExtendProps == null && supplyExtendProps == null) {
                ret.add(idx);
                continue;
            }
            if (requireExtendProps == null || supplyExtendProps == null) continue;
            for (String field : this.reloadMterialExtendPropSettings(store, String.valueOf(mId))) {
                if (this.equals(requireExtendProps.get(field), supplyExtendProps.get(field))) continue;
                continue block0;
            }
            ret.add(idx);
        }
        return ret;
    }

    public void appendBOMCacheKey(RowData require, StringBuilder keyBuffer) {
        MRPRedisStore store = MRPCacheManager.getDStore(this.ctx.getMRPContextId());
        if (!this.isEnabled || !this.loadMaterialExtendPropSettings(require, store)) {
            return;
        }
        Long mId = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L);
        for (String field : this.reloadMterialExtendPropSettings(store, String.valueOf(mId))) {
            keyBuffer.append(field);
        }
    }

    public List<Integer> findBOM(RowData require, List<Integer> boms) {
        MRPRedisStore store = MRPCacheManager.getDStore(this.ctx.getMRPContextId());
        if (!this.isEnabled || !this.loadMaterialExtendPropSettings(require, store)) {
            return boms;
        }
        Long mId = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L);
        Long mFlexId = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
        Map<?, ?> requireExtendProps = this.doMapGet(mFlexId);
        ArrayList<Integer> ret = new ArrayList<Integer>(boms.size());
        block0: for (int idx : boms) {
            Long mBomFlexId = MRPUtil.convert(this.ctx.bomDatas().getValue(DefaultField.BOMField.MATERIALFLEXPROPS.getName(), idx), 0L);
            if (mFlexId.equals(mBomFlexId)) {
                ret.add(idx);
                continue;
            }
            Map<?, ?> bomExtendProps = this.doMapGet(mBomFlexId);
            if (requireExtendProps == null && bomExtendProps == null) {
                ret.add(idx);
                continue;
            }
            if (requireExtendProps == null || bomExtendProps == null) continue;
            for (String field : this.reloadMterialExtendPropSettings(store, String.valueOf(mId))) {
                if (this.equals(requireExtendProps.get(field), bomExtendProps.get(field))) continue;
                continue block0;
            }
            ret.add(idx);
        }
        if (!this.isStrictMatch && ret.isEmpty() && !boms.isEmpty()) {
            return boms;
        }
        return ret;
    }

    public Map<?, ?> doMapGet(Long mFlexId) {
        if (0L == mFlexId) {
            return new HashMap();
        }
        HashMap extendProps = this.flexValues.get(mFlexId);
        if (extendProps == null) {
            MRPRedisStore store = MRPCacheManager.getDStore(this.ctx.getMRPContextId());
            String id = mFlexId.toString();
            Map redisContents = store.mapMGet("flexvalues", id);
            String json = (String)redisContents.get(id);
            if (!StringUtils.isEmpty((String)json)) {
                extendProps = (HashMap)JSON.parseObject((String)json, Map.class);
                this.flexValues.put(mFlexId, extendProps);
            } else {
                extendProps = new HashMap();
                this.flexValues.put(mFlexId, extendProps);
            }
        }
        return extendProps;
    }

    public Set<String> reloadMterialExtendPropSettings(MRPRedisStore store, String mId) {
        if (this.materialExtPropMap.get(mId) != null) {
            return this.materialExtPropMap.get(mId);
        }
        Map fields = (Map)store.mapGet("materialExtPropSettings", mId);
        HashSet<String> effectPlanFields = new HashSet<String>();
        if (fields != null) {
            fields.forEach((k, v) -> {
                if (v.booleanValue()) {
                    effectPlanFields.add((String)k);
                }
            });
        }
        this.materialExtPropMap.put(mId, effectPlanFields);
        return effectPlanFields;
    }

    private boolean loadMaterialExtendPropSettings(RowData require, MRPRedisStore store) {
        Long mId = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L);
        Set<String> materialExtPropSettings = this.reloadMterialExtendPropSettings(store, String.valueOf(mId));
        return materialExtPropSettings != null && !materialExtPropSettings.isEmpty();
    }

    private boolean equals(Object one, Object other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null || other == null) {
            return false;
        }
        return one.equals(other);
    }

    public void loadFlexDatasByBOM() {
        if (!this.isEnabled) {
            return;
        }
        ResDataModelCollection rdmc = (ResDataModelCollection)this.ctx.getService(ResDataModelCollection.class);
        BomDataModel bdm = rdmc.getBom();
        BOMStructDataTable bt = bdm.getTable();
        HashSet<Long> flexFieldIds = new HashSet<Long>(bt.size());
        for (int i = 0; i < bt.size(); ++i) {
            Long mFlexId = MRPUtil.convert(bt.getValue(DefaultField.BOMField.MATERIALFLEXPROPS.getName(), i), 0L);
            if (0L != mFlexId) {
                flexFieldIds.add(mFlexId);
            }
            if (0L == (mFlexId = MRPUtil.convert(bt.getValue(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName(), i), 0L))) continue;
            flexFieldIds.add(mFlexId);
        }
        this.loadFlexValues(flexFieldIds);
        ORM orm = ORM.create();
        MRPRedisStore store = MRPCacheManager.getDStore(this.ctx.getMRPContextId());
        HashMap<String, Map> materailExtendProps = new HashMap<String, Map>(16);
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), "bd_material", "id, number, isuseauxpty, auxptyentry.auxpty, auxptyentry.isaffectplan, auxptyentry.auxpty.number, auxptyentry.auxpty.flexfield, auxptyentry.auxpty.name", new QFilter[]{new QFilter("isuseauxpty", "=", (Object)"1")});){
            while (ds.hasNext()) {
                Row row = ds.next();
                Boolean isuseauxpty = row.getBoolean("isuseauxpty");
                if (isuseauxpty == null || !isuseauxpty.booleanValue()) continue;
                String id = String.valueOf(row.getLong("id"));
                Map settings = materailExtendProps.computeIfAbsent(id, k -> new HashMap());
                String key = row.getString("auxptyentry.auxpty.flexfield");
                Boolean isaffectplan = row.getBoolean("auxptyentry.isaffectplan");
                settings.put(key, isaffectplan);
            }
        }
        store.mapMSet("materialExtPropSettings", materailExtendProps);
    }
}

