/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.res;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.common.consts.PlanScopeRelationConst;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MRPWorkCalendarManager;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.enums.ResType;
import kd.mmc.mrp.model.enums.strategy.OORBillResolveStrategy;
import kd.mmc.mrp.model.struct.ReserveData;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.ReserveUtil;
import kd.mmc.mrp.utils.bitset.BitSetFactory;
import kd.mmc.mrp.utils.bitset.IntBitSet;

public class SupplymentDataTable
extends AbstractResModelDataTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int llc = 0;
    private IntBitSet removedRows = BitSetFactory.createIntBitSet();
    private static final Log logger = LogFactory.getLog(SupplymentDataTable.class);
    private Map<String, Integer> r2Row = new HashMap<String, Integer>(16);
    private Map<String, Integer> s2Col = new HashMap<String, Integer>(16);
    private Map<String, ReserveData> s2Reserve = new HashMap<String, ReserveData>(16);
    private Map<String, ReserveData> r2Reserve = new HashMap<String, ReserveData>(16);
    private Map<String, ReserveData> reserveDatas;
    private Map<String, BigDecimal> singleSpSumQty = new HashMap<String, BigDecimal>(16);
    private Set<String> requireIsCheckReserve = new HashSet<String>(2);

    public SupplymentDataTable() {
    }

    public SupplymentDataTable(CalEnv runParam, Set<String> indexCols) {
        super(runParam, indexCols);
        this.filterKeyName = MultiThreadCacheKey.KEY_SUPPLY_FILTER;
    }

    public void setLLC(int llc) {
        this.llc = llc;
    }

    @Override
    protected boolean setDefaultData(Object[] rowData) {
        int idx = this.getColIdx().get(DefaultField.SupplyField.ISSTORAGEDATA.getName());
        if (1 == MRPUtil.convert(rowData[idx], 0)) {
            RunLogModel runLogModel = (RunLogModel)this.runParam.getService(RunLogModel.class);
            rowData[this.getColIdx().get((Object)DefaultField.SupplyField.DATE.getName()).intValue()] = runLogModel.getPlanDate().getTime();
        }
        return super.setDefaultData(rowData);
    }

    @Override
    public String getLogo(Object[] row) {
        String name;
        Object value = row[this.getColIdx().get(DefaultField.SupplyField.BILLNUMBER.getName())];
        Object seq = row[this.getColIdx().get(DefaultField.SupplyField.BILLENTRYSEQ.getName())];
        Object material = row[this.getColIdx().get(DefaultField.SupplyField.MATERIAL.getName())];
        String string = value == null ? null : (name = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801(%1$s)-\u5206\u5f55\u884c\u53f7(%2$s)-", (String)"SupplymentDataTable_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]), value.toString(), seq == null ? Integer.valueOf(0) : seq));
        if (name == null) {
            value = row[this.getColIdx().get(DefaultField.SupplyField.BILLID.getName())];
            String string2 = name = value == null ? null : String.format(ResManager.loadKDString((String)"\u5355\u636eID(%s)-", (String)"SupplymentDataTable_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), value.toString());
        }
        if (material != null) {
            MtPlanInfoModel planInfoModel = (MtPlanInfoModel)this.runParam.getService(MtPlanInfoModel.class);
            String[] mData = planInfoModel.getMaterialDataById(String.valueOf(material));
            String number = mData[0];
            name = name + String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801(%s)-", (String)"SupplymentDataTable_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]), number);
        }
        return name;
    }

    @Override
    public String getAlias4Name(String name) {
        String alias = DefaultField.SupplyField.getAlias4Name(name);
        if (alias == null) {
            alias = name;
        }
        return alias;
    }

    @Override
    protected void afterFillRow(Object[] row, String modelId, String resDataName, String resDataId) {
        this.afterFillRowImpl(row, modelId, resDataName, resDataId);
    }

    public void afterFillRowImpl(Object[] row, String modelId, String resDataName, String resDataId) {
        PlanModel planModel = (PlanModel)this.runParam.getService(PlanModel.class);
        row[this.getColIdx().get((Object)DefaultField.CommonField.__MODEL_ID__.name()).intValue()] = resDataId;
        row[this.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name()).intValue()] = resDataName;
        if (StringUtils.isNotBlank((CharSequence)modelId)) {
            row[this.getColIdx().get((Object)DefaultField.SupplyField.BILL_ENTITY.getName()).intValue()] = modelId;
        }
        Integer pidx = planModel.getSupplyPrioritys(resDataId);
        row[this.getColIdx().get((Object)DefaultField.SupplyField.__PRIORITY_LEVEL__.getName()).intValue()] = pidx;
        row[this.getColIdx().get((Object)DefaultField.SupplyField.__IS_OCCUPIED__.getName()).intValue()] = false;
        Integer idx = this.getColIdx().get(DefaultField.SupplyField.SUPPLYORGUNIT.getName());
        String supplyOrgId = String.valueOf(row[idx]);
        row[this.getColIdx().get((Object)DefaultField.SupplyField.__ISCENTERTRANS__.getName()).intValue()] = planModel.isOnWayTransfer(supplyOrgId);
        row[this.getColIdx().get((Object)DefaultField.SupplyField.QTY.getName()).intValue()] = MRPUtil.toBigDecimal(row[this.getColIdx().get(DefaultField.SupplyField.QTY.getName())]);
        if (row[this.getColIdx().get(DefaultField.SupplyField.TRACKNUMBER.getName())] == null) {
            row[this.getColIdx().get((Object)DefaultField.SupplyField.TRACKNUMBER.getName()).intValue()] = 0L;
        }
        row[this.getColIdx().get((Object)DefaultField.SupplyField.INV_IS_TRACK_MATCH.getName()).intValue()] = true;
    }

    public List<RowData> fetchRow(Collection<Integer> rows) {
        return this.fetchRow(rows, false);
    }

    public List<RowData> fetchRow(Collection<Integer> rows, boolean isIgnoreOccupation) {
        if (rows == null) {
            return null;
        }
        ArrayList<RowData> datas = new ArrayList<RowData>(rows.size());
        for (Integer next : rows) {
            RowData data = new RowData(this.srcDatas, this.getColIdx(), this.getSrcDatas().getDatas().get(next), next, ResType.SUPPLY);
            Object[] values = data.getValues();
            if (!isIgnoreOccupation && ((Boolean)values[this.getColIdx().get(DefaultField.SupplyField.__IS_OCCUPIED__.getName())]).booleanValue()) continue;
            datas.add(data);
        }
        return datas;
    }

    public List<Integer> sortByPriority(String productOrgUnitID, List<Integer> rows, String strategyId) {
        ResDataModelCollection res = (ResDataModelCollection)this.runParam.getService(ResDataModelCollection.class);
        return res.sortByPriority(this, productOrgUnitID, rows, strategyId);
    }

    public void lock(Collection<Integer> rows, Integer requireIdx) {
        for (Integer idx : rows) {
            Object[] row = this.getSrcDatas().getDatas().get(idx);
            row[this.getColIdx().get((Object)DefaultField.SupplyField.__IS_OCCUPIED__.name()).intValue()] = true;
            row[this.getColIdx().get((Object)DefaultField.SupplyField.__REQUIRE_IDX__.name()).intValue()] = requireIdx;
            this.removedRows.set(idx);
        }
        ColumnDatas col = (ColumnDatas)this.index.get(DefaultField.SupplyField.MATERIAL.getName());
        col.lockRows(new HashSet<Integer>(rows));
    }

    public void unlock(Collection<Integer> rows) {
        for (Integer idx : rows) {
            Object[] row = this.getSrcDatas().getDatas().get(idx);
            row[this.getColIdx().get((Object)DefaultField.SupplyField.__IS_OCCUPIED__.name()).intValue()] = false;
            this.removedRows.remove(idx);
        }
        ColumnDatas col = (ColumnDatas)this.index.get(DefaultField.SupplyField.MATERIAL.getName());
        col.unLockRows(new HashSet<Integer>(rows));
    }

    public void setValue(String colLabel, Object value, Integer idx) {
        Object[] row = this.getSrcDatas().getDatas().get(idx);
        row[this.getColIdx().get((Object)colLabel).intValue()] = value;
    }

    @Override
    public ColumnDatas getCol(String colLabel) {
        ColumnDatas col = super.getCol(colLabel);
        return col;
    }

    public RowData split(RowData src, BigDecimal newQty) {
        return this.split(src, newQty, (IMRPEnvProvider)this.runParam);
    }

    public RowData split(RowData src, BigDecimal newQty, IMRPEnvProvider ctx) {
        RowData splitCopy = src.clone();
        splitCopy.update(DefaultField.CommonField.ID.name(), (Object)UUID.randomUUID().toString());
        splitCopy.update(DefaultField.SupplyField.QTY.getName(), (Object)newQty);
        splitCopy.update(DefaultField.SupplyField.__IS_SPLITED__.name(), (Object)Boolean.TRUE);
        Object srcID = src.getValue(DefaultField.SupplyField.__SPLIT_SRC_ID__.name());
        if (srcID == null) {
            srcID = src.getValue(DefaultField.CommonField.ID.name());
        }
        splitCopy.update(DefaultField.SupplyField.__SPLIT_SRC_ID__.name(), srcID);
        BigDecimal qty = MRPUtil.toBigDecimal(src.getValue(DefaultField.SupplyField.QTY.getName())).subtract(newQty);
        BigDecimal yieldCal = BigDecimal.ONE;
        if (src.getValue(DefaultField.SupplyField.YIELD.getName()) != null && ctx.isYield()) {
            yieldCal = MRPUtil.toBigDecimal(src.getValue(DefaultField.SupplyField.YIELD.getName()));
        }
        if (yieldCal.compareTo(BigDecimal.ONE) >= 0 || yieldCal.compareTo(BigDecimal.ZERO) <= 0) {
            src.update(DefaultField.SupplyField.QTY.getName(), (Object)qty);
            src.update(DefaultField.SupplyField.ORIGINQTY.getName(), (Object)qty);
            splitCopy.update(DefaultField.SupplyField.ORIGINQTY.getName(), (Object)newQty);
        } else {
            Object unitId = src.getValue(DefaultField.SupplyField.BASEUNIT.getName());
            BigDecimal originQty = MRPUtil.calcYield(yieldCal, unitId, qty, ctx, false);
            BigDecimal splitCopyOriginQty = MRPUtil.calcYield(yieldCal, unitId, newQty, ctx, false);
            src.update(DefaultField.SupplyField.QTY.getName(), (Object)qty);
            src.update(DefaultField.SupplyField.ORIGINQTY.getName(), (Object)originQty);
            splitCopy.update(DefaultField.SupplyField.ORIGINQTY.getName(), (Object)splitCopyOriginQty);
        }
        return splitCopy;
    }

    public RowData[] splitStorage(RowData src, BigDecimal newQty) {
        RowData[] splitCopys = new RowData[]{src.clone()};
        BigDecimal qty = MRPUtil.toBigDecimal(src.getValue(DefaultField.SupplyField.QTY.getName()));
        Object srcID = src.getValue(DefaultField.SupplyField.__SPLIT_SRC_ID__.name());
        if (srcID == null) {
            srcID = src.getValue(DefaultField.SupplyField.BILLID.getName());
        }
        src.update(DefaultField.SupplyField.QTY.getName(), (Object)newQty);
        src.update(DefaultField.SupplyField.__SPLIT_SRC_ID__.name(), srcID);
        src.update(DefaultField.SupplyField.__IS_SPLITED__.name(), (Object)Boolean.TRUE);
        if (qty.equals(newQty)) {
            return null;
        }
        int index = 0;
        splitCopys[index].update(DefaultField.CommonField.ID.name(), (Object)UUID.randomUUID().toString());
        splitCopys[index].update(DefaultField.SupplyField.QTY.getName(), (Object)qty.subtract(newQty));
        return splitCopys;
    }

    @Override
    protected boolean isValidDate(CalEnv runParam, Object[] rowData, String modelId, String resDataId) {
        boolean ret;
        PlanModel planModel = (PlanModel)runParam.getService(PlanModel.class);
        CacheDatas cacheDatas = (CacheDatas)runParam.getService(CacheDatas.class);
        RequireDataModel requireDataModel = (RequireDataModel)runParam.getService(RequireDataModel.class);
        if (MRPUtil.isRemoveHisBill(runParam, MRPUtil.convert(rowData[this.getColIdx().get(DefaultField.SupplyField.BILLID.getName())], 0L), modelId, this.llc)) {
            return false;
        }
        Integer idx = this.getColIdx().get(DefaultField.SupplyField.SUPPLYORGUNIT.getName());
        String supplyOrgId = String.valueOf(rowData[idx]);
        idx = this.getColIdx().get(DefaultField.SupplyField.QTY.getName());
        String materialId = String.valueOf(rowData[this.getColIdx().get(DefaultField.SupplyField.MATERIAL.getName())]);
        if (BigDecimal.ZERO.compareTo(MRPUtil.convert(rowData[idx], BigDecimal.ZERO)) >= 0) {
            idx = this.getColIdx().get(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName());
            rowData[idx.intValue()] = "86";
            idx = this.getColIdx().get(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName());
            rowData[idx.intValue()] = String.format(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u4f9b\u5e94\u6570\u91cf%s\u3002", (String)"SupplymentDataTable_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]), rowData[idx]);
            return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
        }
        idx = this.getColIdx().get(DefaultField.SupplyField.ISSTORAGEDATA.getName());
        if (1 == MRPUtil.convert(rowData[idx], 0)) {
            RunLogModel runLogModel = (RunLogModel)runParam.getService(RunLogModel.class);
            rowData[this.getColIdx().get((Object)DefaultField.SupplyField.DATE.getName()).intValue()] = runLogModel.getPlanDate().getTime();
            if (!planModel.getOrgs().contains(supplyOrgId)) {
                idx = this.getColIdx().get(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName());
                rowData[idx.intValue()] = "85";
                idx = this.getColIdx().get(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName());
                rowData[idx.intValue()] = ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u7ec4\u7ec7\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"SupplymentDataTable_4", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
                logger.warn(String.format("ctxid: %s, mrprunner-remove-inv-supply-data, supplyOrg: %s, mid: %s, msg: %s", runParam.getMRPContextId(), supplyOrgId, materialId, rowData[idx]));
                return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
            }
            return true;
        }
        if (!planModel.getRequirorgs().contains(supplyOrgId)) {
            idx = this.getColIdx().get(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName());
            rowData[idx.intValue()] = "85";
            idx = this.getColIdx().get(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName());
            rowData[idx.intValue()] = ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u7ec4\u7ec7\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"SupplymentDataTable_4", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            logger.warn(String.format("ctxid: %s, mrprunner-remove-not-inv-supply-data, supplyOrg: %s, mid: %s, msg: %s", runParam.getMRPContextId(), supplyOrgId, materialId, rowData[idx]));
            return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
        }
        MRPWorkCalendarManager manager = runParam.dateManager();
        idx = this.getColIdx().get(DefaultField.SupplyField.DATE.getName());
        Date supplyDate = MRPUtil.normalize(new Date((Long)rowData[idx]));
        rowData[idx.intValue()] = supplyDate.getTime();
        Date startDate = manager.getBeginDateSupply(supplyOrgId, null);
        Date endDate = manager.getEndDateOutLook(supplyOrgId, null);
        OrgBasedCalendarModel sOcm = manager.get(supplyOrgId, null);
        int startseq = sOcm.getWorkDaySeq(startDate);
        int endseq = sOcm.getWorkDaySeq(endDate);
        int dayseq = sOcm.getWorkDaySeq(supplyDate);
        boolean bl = ret = startseq <= dayseq && endseq >= dayseq;
        if (!ret) {
            idx = this.getColIdx().get(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName());
            rowData[idx.intValue()] = "86";
            idx = this.getColIdx().get(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName());
            rowData[idx.intValue()] = ResManager.loadKDString((String)"\u4f9b\u5e94\u65f6\u95f4\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\u3002", (String)"SupplymentDataTable_5", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            logger.warn(String.format("ctxid: %s, mrprunner-remove-not-inv-supply-data, supplyOrg: %s, mid: %s, msg: %s", runParam.getMRPContextId(), supplyOrgId, materialId, rowData[idx]));
            return planModel.getOORDataResolveStrategy() == OORBillResolveStrategy.RECORDEXCEPTIONTAG;
        }
        return true;
    }

    @Override
    public RowData fetchRow(int rowIdx) {
        return new RowData(this.srcDatas, this.getColIdx(), this.getSrcDatas().getDatas().get(rowIdx), rowIdx, ResType.SUPPLY);
    }

    @Override
    public void clear() {
        super.clear();
        this.removedRows = BitSetFactory.createIntBitSet();
    }

    public void initReserveMapping(RequirementDataTable requireTbl, List<Object[]> datas) {
        String key;
        Long billentry_id;
        Long bill_id;
        int i;
        if (datas.isEmpty()) {
            return;
        }
        int row = 0;
        int col = 0;
        for (i = 0; i < requireTbl.size(); ++i) {
            bill_id = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.BILLID.getName(), i), 0L);
            billentry_id = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.BILLENTRYID.getName(), i), 0L);
            if (billentry_id == 0L) {
                billentry_id = bill_id;
            }
            if (this.r2Row.containsKey(key = bill_id.toString() + '-' + billentry_id)) continue;
            this.r2Row.put(key, row++);
        }
        for (i = 0; i < this.size(); ++i) {
            bill_id = MRPUtil.convert(this.getValue(DefaultField.SupplyField.BILLID.getName(), i), 0L);
            billentry_id = MRPUtil.convert(this.getValue(DefaultField.SupplyField.BILLENTRYID.getName(), i), 0L);
            if (billentry_id == 0L) {
                billentry_id = bill_id;
            }
            if (!this.s2Col.containsKey(key = bill_id.toString() + '-' + billentry_id)) {
                this.s2Col.put(key, col++);
            }
            BigDecimal qty = MRPUtil.convert(this.getValue(DefaultField.SupplyField.QTY.getName(), i), BigDecimal.ZERO);
            qty = this.singleSpSumQty.getOrDefault(key, BigDecimal.ZERO).add(qty);
            this.singleSpSumQty.put(key, qty);
        }
        this.reserveDatas = new HashMap<String, ReserveData>(row);
        Map<String, Integer> reserveColIndex = ReserveUtil.getReserveColIndex();
        HashMap<String, LinkedHashMap> reqResSupQtyNotCalc = new HashMap<String, LinkedHashMap>(16);
        HashSet<Integer> useRequireRow = new HashSet<Integer>(16);
        HashSet<Integer> useSupplyCol = new HashSet<Integer>(16);
        HashMap<String, Map<String, ReserveData>> sup2reqQtyMap = new HashMap<String, Map<String, ReserveData>>(datas.size());
        for (Object[] value : datas) {
            Integer c;
            RowData rowData = new RowData(this.srcDatas, reserveColIndex, value, -1, ResType.RESERVE);
            String bal_obj = rowData.getString("bal_obj");
            String bill_obj = rowData.getString("bill_obj");
            Long bill_id2 = 0L;
            if (rowData.getLong("bill_id") != null) {
                bill_id2 = rowData.getLong("bill_id");
            }
            Long billentry_id2 = 0L;
            if (rowData.getLong("billentry_id") != null) {
                billentry_id2 = rowData.getLong("billentry_id");
            }
            if (billentry_id2 <= 0L) {
                billentry_id2 = bill_id2;
            }
            Long bal_id = 0L;
            if (rowData.getLong("bal_id") != null) {
                bal_id = rowData.getLong("bal_id");
            }
            Long bal_entryid = 0L;
            if (rowData.getLong("bal_entryid") != null) {
                bal_entryid = rowData.getLong("bal_entryid");
            }
            if (bal_entryid <= 0L) {
                bal_entryid = bal_id;
            }
            BigDecimal base_qty = rowData.getBigDecimal("base_qty");
            if (MRPUtil.isRemoveHisBill(this.runParam, bill_id2, bill_obj, this.llc) || MRPUtil.isRemoveHisBill(this.runParam, bal_id, bal_obj, this.llc) || base_qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            boolean isweak = rowData.getBoolean("isweak");
            String key2 = bill_id2.toString() + '-' + billentry_id2;
            Integer r = this.r2Row.get(key2);
            if (r != null) {
                ReserveData requireR = this.r2Reserve.computeIfAbsent(key2, k -> new ReserveData());
                requireR.addReserveQty(base_qty, isweak);
            }
            if ((c = this.s2Col.get(key2 = bal_id.toString() + '-' + bal_entryid)) != null) {
                ReserveData supplyR = this.s2Reserve.computeIfAbsent(key2, k -> new ReserveData());
                supplyR.addReserveQty(base_qty, isweak);
            }
            if (r != null && c == null) {
                Map map = reqResSupQtyNotCalc.computeIfAbsent(bill_id2.toString() + '-' + billentry_id2, k -> new LinkedHashMap(4));
                String balKey = String.format("%s\u0001%s\u0001%s", rowData.get("bal_obj"), bal_id, bal_entryid);
                BigDecimal notCalcQty = map.getOrDefault(balKey, BigDecimal.ZERO);
                notCalcQty = notCalcQty.add(base_qty);
                map.put(balKey, notCalcQty);
            }
            Map reqQtyMap = sup2reqQtyMap.computeIfAbsent(bal_id.toString() + '-' + bal_entryid, k -> new HashMap(2));
            ReserveData reqQtyReserveData = reqQtyMap.computeIfAbsent(bill_id2.toString() + '-' + billentry_id2, k -> new ReserveData());
            reqQtyReserveData.addReserveQty(base_qty, isweak);
            if (r == null || c == null) continue;
            useRequireRow.add(r);
            useSupplyCol.add(c);
            ReserveData reserveData = this.reserveDatas.computeIfAbsent(String.valueOf(r) + '-' + String.valueOf(c), k -> new ReserveData());
            reserveData.addReserveQty(base_qty, isweak);
        }
        if (useRequireRow.isEmpty()) {
            this.r2Row = new HashMap<String, Integer>(0);
        } else {
            this.r2Row.entrySet().removeIf(entry -> !useRequireRow.contains(entry.getValue()));
        }
        if (useSupplyCol.isEmpty()) {
            this.s2Col = new HashMap<String, Integer>(0);
        } else {
            this.s2Col.entrySet().removeIf(entry -> !useSupplyCol.contains(entry.getValue()));
        }
        if (!reqResSupQtyNotCalc.isEmpty()) {
            for (int i2 = 0; i2 < requireTbl.size(); ++i2) {
                String key3;
                Map map;
                Long bill_id3 = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.BILLID.getName(), i2), 0L);
                Long billentry_id3 = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.BILLENTRYID.getName(), i2), 0L);
                if (billentry_id3 == 0L) {
                    billentry_id3 = bill_id3;
                }
                if ((map = (Map)reqResSupQtyNotCalc.get(key3 = bill_id3.toString() + '-' + billentry_id3)) == null) continue;
                Long material = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.MATERIAL.getName(), i2), 0L);
                String billEntity = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.BILL_ENTITY.getName(), i2), "");
                String billNo = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.BILLNUMBER.getName(), i2), "");
                Integer billEntrySeq = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName(), i2), 0);
                String reserve_billno = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.RESERVE_BILLNO.getName(), i2), "");
                Long reserve_billid = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.RESERVE_BILLID.getName(), i2), 0L);
                Long reserve_billentryid = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.RESERVE_BILLENTRYID.getName(), i2), 0L);
                Integer reserve_billentryseq = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.RESERVE_BILLENTRYSEQ.getName(), i2), 0);
                boolean isGetReserveData = reserve_billno != null && reserve_billid != null && reserve_billid > 0L;
                IMRPEnvProvider ctx = (IMRPEnvProvider)this.runParam;
                RequireDataModel requireDataModel = (RequireDataModel)ctx.getService(RequireDataModel.class);
                String outPutType = requireDataModel.getOutputType();
                BigDecimal notCalcQty = BigDecimal.ZERO;
                BigDecimal qty = MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.QTY.getName(), i2), BigDecimal.ZERO);
                for (Map.Entry entry2 : map.entrySet()) {
                    BigDecimal noQty = (BigDecimal)entry2.getValue();
                    if (notCalcQty.compareTo(qty) >= 0) break;
                    if (noQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if ((notCalcQty = notCalcQty.add(noQty)).compareTo(qty) >= 0) {
                        noQty = qty.subtract(notCalcQty.subtract(noQty));
                        notCalcQty = qty;
                    }
                    entry2.setValue(((BigDecimal)entry2.getValue()).subtract(noQty));
                    if (!isGetReserveData || noQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    List list = ctx.getReserveCacheData().computeIfAbsent(material.toString(), k -> new ArrayList(16));
                    String[] str = ((String)entry2.getKey()).split("\u0001");
                    HashMap<String, Object> resMap = new HashMap<String, Object>(32);
                    resMap.put("ori_bill_obj", billEntity);
                    resMap.put("ori_bill_no", billNo);
                    resMap.put("ori_bill_id", bill_id3);
                    resMap.put("ori_billentry_id", billentry_id3);
                    resMap.put("ori_billentry_seq", billEntrySeq);
                    resMap.put("bill_obj", outPutType);
                    resMap.put("r_sale_org", MRPUtil.convert(requireTbl.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName(), i2), 0L));
                    resMap.put("bill_no", reserve_billno);
                    resMap.put("bill_id", reserve_billid);
                    resMap.put("billentry_id", reserve_billentryid);
                    resMap.put("billentry_seq", reserve_billentryseq);
                    resMap.put("s_materiel", material);
                    resMap.put("bal_obj", str[0]);
                    resMap.put("bal_id", MRPUtil.convert((Object)str[1], 0L));
                    resMap.put("bal_entryid", MRPUtil.convert((Object)str[2], 0L));
                    resMap.put("qty", noQty);
                    resMap.put("base_qty", noQty);
                    resMap.put("ori_qty", noQty);
                    resMap.put("isDependReqReserve", "1");
                    list.add(resMap);
                }
                if (notCalcQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                requireTbl.updateValue(DefaultField.RequireField.__MERGE_REQQTY_.getName(), i2, qty);
                requireTbl.updateValue(DefaultField.RequireField.QTY.getName(), i2, qty.subtract(notCalcQty));
                String msg = MRPUtil.appendExceptionMsg(requireTbl.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), i2), String.format(ResManager.loadKDString((String)"\u9700\u6c42\u88ab\u8ba1\u7b97\u8303\u56f4\u5916\u4f9b\u5e94\u5360\u7528:%s", (String)"SupplymentDataTable_7", (String)"mmc-mrp-mservice", (Object[])new Object[0]), notCalcQty.stripTrailingZeros().toPlainString()));
                String string = MRPUtil.appendExceptionNumber(requireTbl.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), i2), "100");
                requireTbl.updateValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), i2, string);
                requireTbl.updateValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), i2, msg);
            }
        }
        this.splitSupplyByReserveMapping(sup2reqQtyMap);
    }

    private void splitSupplyByReserveMapping(Map<String, Map<String, ReserveData>> sup2reqQtyMap) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Long bill_id = MRPUtil.convert(this.getValue(DefaultField.SupplyField.BILLID.getName(), i), 0L);
            Long billentry_id = MRPUtil.convert(this.getValue(DefaultField.SupplyField.BILLENTRYID.getName(), i), 0L);
            if (billentry_id == 0L) {
                billentry_id = bill_id;
            }
            BigDecimal sQty = MRPUtil.convert(this.getValue(DefaultField.SupplyField.QTY.getName(), i), BigDecimal.ZERO);
            String key = bill_id.toString() + '-' + billentry_id;
            Map<String, ReserveData> reqQtyMap = sup2reqQtyMap.get(key);
            if (reqQtyMap == null || sQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            for (Map.Entry<String, ReserveData> entry : reqQtyMap.entrySet()) {
                String requireKey = entry.getKey();
                ReserveData reserveData = entry.getValue();
                BigDecimal reserveQty = reserveData.getReserveQty();
                BigDecimal weakQty = reserveData.getWeakReserveQty();
                sQty = this.splitSupplyByReserveQty(reserveQty, reserveData, sQty, i, requireKey, false);
                sQty = this.splitSupplyByReserveQty(weakQty, reserveData, sQty, i, requireKey, true);
            }
        }
    }

    private BigDecimal splitSupplyByReserveQty(BigDecimal reserveQty, ReserveData reserveData, BigDecimal sQty, int i, String requireKey, boolean isWeak) {
        if (reserveQty.compareTo(BigDecimal.ZERO) > 0 && sQty.compareTo(BigDecimal.ZERO) > 0) {
            if (sQty.compareTo(reserveQty) > 0) {
                RowData split = this.split(this.fetchRow(i), reserveQty);
                i = this.fill(split);
                reserveData.addReserveQty(reserveQty.negate(), isWeak);
                sQty = sQty.subtract(reserveQty);
            } else {
                reserveData.addReserveQty(sQty.negate(), isWeak);
                sQty = BigDecimal.ZERO;
            }
            this.updateValue(DefaultField.SupplyField.__RESERVE_REQUIRE_KEY_.getName(), i, requireKey);
            this.updateValue(DefaultField.SupplyField._IS_RESERVE_SUPPLY_.getName(), i, true);
            if (isWeak) {
                this.updateValue(DefaultField.SupplyField._IS_WEAK_RESERVE_SUPPLY_.getName(), i, true);
            }
        }
        return sQty;
    }

    public void refreshReserveMapping(RequirementDataTable requireTbl, List<Object[]> datas) {
        this.r2Row.clear();
        this.s2Col.clear();
        this.singleSpSumQty.clear();
        this.requireIsCheckReserve.clear();
        this.reserveDatas = null;
        this.initReserveMapping(requireTbl, datas);
    }

    public List<Integer> sortSupplyByReserve(IMRPEnvProvider env, List<Integer> supplys, RequireRowData requireData) {
        PlanModel planModel = (PlanModel)env.getService(PlanModel.class);
        boolean isReserve = planModel.isReserve();
        String ocpWeakReserve = planModel.getOcpWeakReserve();
        if (!isReserve) {
            return supplys;
        }
        Long reqBillId = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.BILLID.getName()), 0L);
        Long reqBillEntryId = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.BILLENTRYID.getName()), 0L);
        if (reqBillEntryId == 0L) {
            reqBillEntryId = reqBillId;
        }
        String rKey = reqBillId.toString() + '-' + reqBillEntryId;
        Integer row = this.r2Row.get(rKey);
        HashSet<Integer> supplySet = new HashSet<Integer>(supplys);
        if (row != null && this.requireIsCheckReserve.add(rKey)) {
            Long productStorageOrgUnitID = DataBalanceUtil.getPlanScopeRequireOrg(requireData);
            String material = String.valueOf(requireData.getValue(DefaultField.RequireField.MATERIAL.getName()));
            String cacheKey = PlanScopeRelationConst.getRedisPlanScopeRelationKey((String)productStorageOrgUnitID.toString(), (String)material);
            SupplyStruct ss = planModel.getPriorityRelations().getOrDefault(productStorageOrgUnitID.toString(), new SupplyStruct());
            ColumnDatas columnDatas = this.getCol(DefaultField.SupplyField.__RESERVE_REQUIRE_KEY_.getName());
            List<Integer> list = columnDatas.get(rKey);
            for (Integer i : list) {
                String key;
                Integer col;
                if (supplySet.contains(i)) continue;
                RowData supply = this.fetchRow(i);
                Object isLocked = supply.getValue(DefaultField.SupplyField.__IS_OCCUPIED__.name());
                Object isReplace = supply.getValue(DefaultField.SupplyField.__IS_REPLACE__.getName());
                if (isLocked != null && ((Boolean)isLocked).booleanValue() || isReplace != null && ((Boolean)isReplace).booleanValue()) continue;
                Long bill_id = MRPUtil.convert(supply.getValue(DefaultField.SupplyField.BILLID.getName()), 0L);
                Long billentry_id = MRPUtil.convert(supply.getValue(DefaultField.SupplyField.BILLENTRYID.getName()), 0L);
                if (billentry_id == 0L) {
                    billentry_id = bill_id;
                }
                if ((col = this.s2Col.get(key = bill_id.toString() + '-' + billentry_id)) == null || this.reserveDatas.get(String.valueOf(row) + '-' + String.valueOf(col)) == null) continue;
                if (supply.getValue(DefaultField.SupplyField.DYNAMIC_PLANSCOPE.getName()) == null) {
                    Long planScope = DataBalanceUtil.getSupplyPlanScope(env, ss, productStorageOrgUnitID, material, false, cacheKey, supply);
                    supply.update(DefaultField.SupplyField.DYNAMIC_PLANSCOPE.getName(), (Object)planScope);
                }
                supplys.add(i);
            }
        }
        ArrayList<Integer> sp = new ArrayList<Integer>();
        ListIterator<Integer> its = supplys.listIterator();
        while (its.hasNext()) {
            Integer next = its.next();
            RowData supply = this.fetchRow(next);
            String requireKey = supply.getString(DefaultField.SupplyField.__RESERVE_REQUIRE_KEY_.getName());
            boolean isReserveRequire = MRPUtil.convert(supply.getValue(DefaultField.SupplyField._IS_RESERVE_SUPPLY_.getName()), Boolean.FALSE);
            boolean isWeakReserve = MRPUtil.convert(supply.getValue(DefaultField.SupplyField._IS_WEAK_RESERVE_SUPPLY_.getName()), Boolean.FALSE);
            if (!isReserveRequire || !StringUtils.isNotBlank((CharSequence)requireKey)) continue;
            if (requireKey.equals(rKey)) {
                sp.add(next);
                its.remove();
                continue;
            }
            if (isWeakReserve && StringUtils.equalsIgnoreCase((CharSequence)ocpWeakReserve, (CharSequence)"1")) continue;
            its.remove();
        }
        sp.addAll(supplys);
        return sp;
    }

    public Map<String, ReserveData> getS2Reserve() {
        return this.s2Reserve;
    }

    public Map<String, ReserveData> getR2Reserve() {
        return this.r2Reserve;
    }

    public Map<String, Integer> getR2Row() {
        return this.r2Row;
    }

    public Map<String, Integer> getS2Col() {
        return this.s2Col;
    }

    public Map<String, ReserveData> getReserveDatas() {
        return this.reserveDatas;
    }

    public Map<String, BigDecimal> getSingleSpSumQty() {
        return this.singleSpSumQty;
    }

    public void clearReserveDataCache() {
        this.r2Row = new HashMap<String, Integer>(16);
        this.s2Col = new HashMap<String, Integer>(16);
        this.s2Reserve = new HashMap<String, ReserveData>(16);
        this.r2Reserve = new HashMap<String, ReserveData>(16);
        this.singleSpSumQty = new HashMap<String, BigDecimal>(16);
        this.requireIsCheckReserve = new HashSet<String>(2);
        this.reserveDatas = null;
    }
}

