/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.res;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.mmc.mrp.exception.MRPBizException;

public class TNode {
    private Set<TNode> parents = new HashSet<TNode>();
    private Set<TNode> children = new HashSet<TNode>();
    private String mId;
    private int level = 0;

    public TNode(String mId) {
        this.mId = mId;
    }

    private void addParent(TNode parent) {
        if (parent.level >= this.level) {
            TNode.sink(parent.level - this.level + 1, this);
        }
        this.parents.add(parent);
    }

    public void addChild(TNode child) {
        if (this.children.contains(child)) {
            return;
        }
        if (child.level <= this.level) {
            TNode.sink(this.level - child.level + 1, child);
        }
        this.children.add(child);
        if (!child.parents.contains(this)) {
            child.addParent(this);
        }
    }

    private static void sink(int delta, TNode node) {
        node.level += delta;
        if (node.level > 99) {
            throw new MRPBizException(new ErrorCode("OVERFLOW_MAX_LLC", ResManager.loadKDString((String)"\u4f4e\u4f4d\u7801\u8ba1\u7b97\u8d85\u8fc799\u5c42\u3002\u7269\u6599ID\uff1a%1$s\uff0c\u5c42\u7ea7\uff1a%2$s", (String)"TNode_0", (String)"mmc-mrp-mservice", (Object[])new Object[0])), node.mId, node.level);
        }
        for (TNode child : node.children) {
            if (child.level > node.level) continue;
            TNode.sink(node.level - child.level + 1, child);
        }
    }

    public Set<TNode> getParents() {
        return this.parents;
    }

    public Set<TNode> getChildren() {
        return this.children;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return this.mId;
    }

    public static boolean isAncestor(TNode parent, TNode child, List<TNode> cycleChecker) {
        if (parent.parents.contains(child)) {
            cycleChecker.add(parent);
            return true;
        }
        for (TNode p : parent.parents) {
            if (!TNode.isAncestor(p, child, cycleChecker)) continue;
            cycleChecker.add(parent);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.mId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TNode) {
            return Objects.equals(this.mId, ((TNode)obj).mId);
        }
        return false;
    }
}

