/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.store;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;

public class MRPHeapLimitPolicy {
    private static int RC = 500000;
    private AtomicInteger count = new AtomicInteger(0);
    private AtomicInteger limit = new AtomicInteger(RC);

    public synchronized boolean canAddRow() {
        if (this.count.get() < this.limit.get()) {
            this.count.incrementAndGet();
            return true;
        }
        return false;
    }

    public synchronized void releaseRowCount(final int rowCount) {
        this.count.updateAndGet(new IntUnaryOperator(){

            @Override
            public int applyAsInt(int operand) {
                return operand - (MRPHeapLimitPolicy.this.count.get() < rowCount ? MRPHeapLimitPolicy.this.count.get() : rowCount);
            }
        });
    }

    static {
        Runtime rt = Runtime.getRuntime();
        long maxMem = rt.maxMemory();
        double sizeByGB = (double)maxMem / 1024.0 / 1024.0 / 1024.0;
        int all = Math.max((int)sizeByGB, 1);
        RC *= all;
    }
}

