/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.store;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.mmc.mrp.model.table.store.MRPHeapLimitPolicy;
import kd.mmc.mrp.model.table.store.spill.DataSpillDiskResolver;
import kd.mmc.mrp.model.table.store.spill.IMRPDataSpillResolver;

public class RandomAccessStore<T>
implements Iterable<T>,
AutoCloseable {
    private static final MRPHeapLimitPolicy JVM_MAX_ROWS_POLICY = new MRPHeapLimitPolicy();
    private MRPHeapLimitPolicy limitPolicy;
    private int rowCount = 0;
    private ArrayList<T> heapRows = new ArrayList(1000);
    private IMRPDataSpillResolver<T> writer;

    private RandomAccessStore(MRPHeapLimitPolicy limitPolicy) {
        this.limitPolicy = limitPolicy;
    }

    public synchronized void write(T rowDatas) {
        if (this.writer == null && this.limitPolicy.canAddRow()) {
            this.heapRows.add(rowDatas);
        } else {
            this.createSpill();
            try {
                this.writer.write(this.rowCount, rowDatas);
            }
            catch (IOException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("MRP_SPILL_WRITE_ERROR", "MRP_SPILL_WRITE_ERROR"), new Object[0]);
            }
        }
        ++this.rowCount;
    }

    public synchronized T readLine(int rowIdx) {
        if (rowIdx < this.heapRows.size()) {
            return this.heapRows.get(rowIdx);
        }
        this.checkWrite(rowIdx);
        try {
            return this.writer.read(rowIdx);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("MRP_SPILL_READ_ERROR", "MRP_SPILL_READ_ERROR"), new Object[0]);
        }
    }

    public synchronized void update(int rowIdx, T row) {
        if (rowIdx < this.heapRows.size()) {
            this.heapRows.set(rowIdx, row);
            return;
        }
        this.checkWrite(rowIdx);
        try {
            this.writer.update(rowIdx, row);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("MRP_SPILL_UPDATE_ERROR", "MRP_SPILL_UPDATE_ERROR"), new Object[0]);
        }
    }

    private void checkWrite(int rowIdx) {
        if (this.writer == null) {
            throw new KDBizException(new ErrorCode("MRP_HEAP_ROWS_OUT_OF_RANGE", "rowIdx out of range " + rowIdx), new Object[0]);
        }
    }

    @Override
    public synchronized void close() throws Exception {
        this.limitPolicy.releaseRowCount(this.heapRows.size());
        this.heapRows.clear();
        this.rowCount = 0;
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    private void createSpill() {
        if (this.writer == null) {
            this.writer = new DataSpillDiskResolver();
            this.heapRows.trimToSize();
        }
    }

    public static <T> RandomAccessStore<T> createInst() {
        return new RandomAccessStore<T>(JVM_MAX_ROWS_POLICY);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.writer == null) {
            return this.heapRows.iterator();
        }
        return Iterators.concat(this.heapRows.iterator(), this.writer.iterator());
    }
}

