/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.model.table.utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.entity.BomDataModel;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.InventoryModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.SupplyDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.strategy.BillSupplyStrategy;
import kd.mmc.mrp.model.enums.strategy.MaterialPlanMode;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.mpscmm.msplan.business.inventory.InvLevelEntry;

public class InvPlanUtil {
    public static void updateInvRequireFields(IMRPEnvProvider ctx, RequireRowData invRequire, Object org, Object material) {
        InvPlanUtil.updateInvRequireFields(ctx, invRequire, org, material, null);
    }

    public static void updateInvRequireFields(IMRPEnvProvider ctx, RequireRowData invRequire, Object org, Object material, InvLevelEntry invLevelEntry) {
        InventoryModel invModel = (InventoryModel)ctx.getService(InventoryModel.class);
        InvLevel invLevel = invModel.getInvLevel();
        if (invLevel == null) {
            return;
        }
        org = MRPUtil.convert(org, 0L);
        material = MRPUtil.convert(material, 0L);
        if (invLevelEntry == null) {
            invLevelEntry = invLevel.getEntry(org, material, new HashMap<String, Long>(InvPlanUtil.getExtendValMap(ctx, invRequire, 0)));
        }
        if (invLevelEntry == null) {
            return;
        }
        invRequire.update(DefaultField.RequireField.BILLID.getName(), invLevelEntry.getId());
        invRequire.update(DefaultField.RequireField.BILLENTRYID.getName(), (Object)invLevelEntry.getEntryId());
        invRequire.update(DefaultField.RequireField.BILLENTRYSEQ.getName(), (Object)invLevelEntry.getSeq());
        invRequire.update(DefaultField.RequireField.BILLNUMBER.getName(), (Object)InvPlanUtil.getInvLevelBillNo(ctx, invLevelEntry));
        invRequire.update(DefaultField.RequireField.BILL_ENTITY.getName(), (Object)"msplan_invlevel");
        invRequire.update(DefaultField.CommonField.__MODEL_NUMBER__.name(), (Object)ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d", (String)"InvPlanUtil_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
        invRequire.update(DefaultField.RequireField.__REQUIRE_SOURCE__.getName(), null);
    }

    public static void updateInvRequireFieldsByMPlan(IMRPEnvProvider ctx, RequireRowData invRequire) {
        PlanModel pm;
        boolean isEnablePlanScope;
        String invKey;
        Map<String, RequireRowData> invPlanKey2Require = ctx.getInvPlanKey2Require();
        RequireRowData emptyRequire = invPlanKey2Require.get(invKey = InvPlanUtil.getEmptyRequireKey(invRequire, isEnablePlanScope = (pm = (PlanModel)ctx.getService(PlanModel.class)).isEnablePlanScope()));
        if (emptyRequire != null) {
            invRequire.update(DefaultField.RequireField.BILLID.getName(), emptyRequire.getValue(DefaultField.RequireField.BILLID.getName()));
            invRequire.update(DefaultField.RequireField.BILLENTRYID.getName(), emptyRequire.getValue(DefaultField.RequireField.BILLENTRYID.getName()));
            invRequire.update(DefaultField.RequireField.BILLENTRYSEQ.getName(), emptyRequire.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()));
            invRequire.update(DefaultField.RequireField.BILLNUMBER.getName(), emptyRequire.getValue(DefaultField.RequireField.BILLNUMBER.getName()));
            invRequire.update(DefaultField.RequireField.BILL_ENTITY.getName(), emptyRequire.getValue(DefaultField.RequireField.BILL_ENTITY.getName()));
            invRequire.update(DefaultField.CommonField.__MODEL_NUMBER__.name(), emptyRequire.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name()));
            invRequire.update(DefaultField.RequireField.__REQUIRE_SOURCE__.getName(), emptyRequire.getValue(DefaultField.RequireField.__REQUIRE_SOURCE__.getName()));
        }
    }

    public static Map<String, Long> getExtendValMap(CalEnv ctx, RowData rowData, int type) {
        Map<String, String> extendDimToColumn = InvPlanUtil.getExtendDimToColumn(ctx, type);
        HashMap<String, Long> extendValMap = new HashMap<String, Long>(extendDimToColumn.size());
        for (Map.Entry<String, String> entry : extendDimToColumn.entrySet()) {
            extendValMap.put(entry.getKey(), rowData.getLong(entry.getValue()));
        }
        return extendValMap;
    }

    public static Map<String, String> getExtendDimToColumn(CalEnv ctx, int type) {
        DynamicObject module;
        InventoryModel invModel = (InventoryModel)ctx.getService(InventoryModel.class);
        List<String> extendDimensions = invModel.getExtendDimensions();
        HashMap<String, String> extendKeys = new HashMap<String, String>(extendDimensions.size());
        if (extendDimensions.isEmpty()) {
            return extendKeys;
        }
        switch (type) {
            case 1: {
                SupplyDataModel supplyDataModel = (SupplyDataModel)ctx.getService(SupplyDataModel.class);
                module = supplyDataModel.getModel();
                break;
            }
            case 2: {
                BomDataModel bomDataModel = (BomDataModel)ctx.getService(BomDataModel.class);
                module = bomDataModel.getModel();
                break;
            }
            default: {
                RequireDataModel requireDataModel = (RequireDataModel)ctx.getService(RequireDataModel.class);
                module = requireDataModel.getModel();
            }
        }
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)module.getDynamicObject("businessentity").getString("id"));
        String name = mainType.getName();
        Map allEntities = mainType.getAllEntities();
        block4: for (Map.Entry entry : allEntities.entrySet()) {
            EntityType value = (EntityType)entry.getValue();
            String entryName = value.getName();
            if (name.equals(entryName)) continue;
            for (Map.Entry entityPropertyEntry : value.getFields().entrySet()) {
                IDataEntityProperty property = (IDataEntityProperty)entityPropertyEntry.getValue();
                if (property instanceof BasedataProp && extendDimensions.remove(((BasedataProp)property).getBaseEntityId())) {
                    String entryField = entryName + '.' + (String)entityPropertyEntry.getKey();
                    extendKeys.put(((BasedataProp)property).getBaseEntityId(), entryField.toUpperCase(Locale.ENGLISH));
                }
                if (!extendDimensions.isEmpty()) continue;
                continue block4;
            }
        }
        return extendKeys;
    }

    private static String getInvLevelBillNo(IMRPEnvProvider ctx, InvLevelEntry invLevelEntry) {
        CacheDatas cacheDatas = (CacheDatas)ctx.getService(CacheDatas.class);
        DynamicObject inv = cacheDatas.reloadDataById("msplan_invlevel", invLevelEntry.getId(), "number,createorg");
        DynamicObject org = inv == null ? null : inv.getDynamicObject("createorg");
        String orgNumber = org == null ? "" : org.getString("number");
        String invNumber = inv == null ? "" : inv.getString("number");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return String.format("%s_%s_%s_%s", orgNumber, invNumber, invLevelEntry.getSeq(), format.format(new Date()));
    }

    public static RequireRowData createEmptyRequire(IMRPEnvProvider ctx, BigDecimal rQty, Long planScope, Long org, Long material, Long date, Long id, Long entryId, int seq, String entity) {
        CacheDatas cacheDatas = (CacheDatas)ctx.getService(CacheDatas.class);
        RequirementDataTable requirementDataTable = ctx.requireDatas();
        Map<String, Integer> colIdx = requirementDataTable.getColIdx();
        Object[] obj = new Object[colIdx.size()];
        DynamicObject materialData = cacheDatas.reloadDataById("bd_material", material, "id,number,baseunit");
        RequireRowData require = new RequireRowData(requirementDataTable.getSrcDatas(), -1, colIdx, obj);
        require.update(DefaultField.RequireField.MATERIAL.getName(), (Object)material);
        require.update(DefaultField.RequireField.PRODUCTIONORGUNIT.getName(), (Object)org);
        require.update(DefaultField.RequireField.QTY.getName(), (Object)rQty);
        require.update(DefaultField.RequireField.DATE.getName(), (Object)date);
        require.update(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName(), (Object)true);
        DynamicObject unit = materialData == null ? null : materialData.getDynamicObject("baseunit");
        require.update(DefaultField.RequireField.BASEUNIT.getName(), (Object)(unit != null ? unit.getLong("id") : 0L));
        require.update(DefaultField.RequireField.PLANSCOPE.getName(), (Object)planScope);
        require.update(DefaultField.RequireField.BILLID.getName(), (Object)id);
        require.update(DefaultField.RequireField.BILLENTRYID.getName(), (Object)entryId);
        require.update(DefaultField.RequireField.BILLENTRYSEQ.getName(), (Object)seq);
        DynamicObject orgData = cacheDatas.reloadDataById("bos_org", org, "id,number");
        String orgNumber = orgData == null ? "" : orgData.getString("number");
        String invNumber = materialData == null ? "" : materialData.getString("number");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        require.update(DefaultField.RequireField.BILLNUMBER.getName(), (Object)String.format("%s_%s_%s_%s", orgNumber, invNumber, seq, format.format(new Date(date))));
        require.update(DefaultField.RequireField.BILL_ENTITY.getName(), (Object)entity);
        require.update(DefaultField.CommonField.__MODEL_NUMBER__.name(), (Object)ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d", (String)"InvPlanUtil_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
        require.update(DefaultField.RequireField.INV_IS_TRACK_MATCH.getName(), (Object)true);
        return require;
    }

    public static String getEmptyRequireKey(RequireRowData requireData, boolean isEnablePlanScope) {
        Long org = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()), 0L);
        if (org <= 0L || BillSupplyStrategy.INVENTORY.getValue().equals(requireData.getString(DefaultField.RequireField.SUPPLY_STRATEGY.getName()))) {
            org = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), 0L);
        }
        Long material = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L);
        Long planScope = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.PLANSCOPE.getName()), 0L);
        return isEnablePlanScope ? String.format("%s\u0001%s\u0001%s", org, material, planScope) : String.format("%s\u0001%s", org, material);
    }

    public static boolean isInvRequire(IMRPEnvProvider ctx, RequireRowData requireData) {
        return InvPlanUtil.isOldInvRequire(ctx, requireData) || InvPlanUtil.isInvRequire(requireData);
    }

    public static boolean isInvRequire(RequireRowData requireData) {
        String planmode = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.DEMAND_PLANMODE.getName()), "");
        if (StringUtils.isEmpty((String)planmode)) {
            planmode = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.PLANMODE.getName()), "");
        }
        return MaterialPlanMode.MAXANDMININV.getValue().equalsIgnoreCase(planmode) || MaterialPlanMode.REORDERPOINT.getValue().equalsIgnoreCase(planmode);
    }

    public static boolean isNewInvRequire(IMRPEnvProvider ctx, RequireRowData requireData) {
        return !InvPlanUtil.isOldInvRequire(ctx, requireData) && InvPlanUtil.isInvRequire(requireData);
    }

    public static boolean isOldInvRequire(IMRPEnvProvider ctx, RequireRowData requireData) {
        InvLevel invLevel;
        InventoryModel invModel = (InventoryModel)ctx.getService(InventoryModel.class);
        if (invModel != null && (invLevel = invModel.getInvLevel()) != null) {
            Long material;
            Long org = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), 0L);
            return invLevel.getEntry((Object)org, (Object)(material = MRPUtil.convert(requireData.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L)), new HashMap<String, Long>(InvPlanUtil.getExtendValMap(ctx, requireData, 0))) != null;
        }
        return false;
    }

    public static boolean isNewCreateSupplyBill(IMRPEnvProvider ctx, RowData supply) {
        String billEntity = supply.getString(DefaultField.SupplyField.BILL_ENTITY.getName());
        String billNumber = supply.getString(DefaultField.SupplyField.BILLNUMBER.getName());
        String key = String.format("%s\u0001%s", billEntity, billNumber);
        return ctx.getPoNum2InvRequireQty().get(key) != null;
    }
}

