/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.adjustsuggest;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.BOTPHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mservice.mrp.algoregister.api.IDropDataCtrlService;

public class AdjustSuggestServiceImpl {
    private static final Log log = LogFactory.getLog(AdjustSuggestServiceImpl.class);

    public Map<String, Object> releaseData(List<Long> adjustSuggestIds) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"mrp_adjustsuggest");
        DynamicObject[] edcs = BusinessDataServiceHelper.load((Object[])adjustSuggestIds.toArray(new Long[0]), (DynamicObjectType)entityType);
        Map<Long, DynamicObject> edcMap = this.genEdcMap(edcs);
        HashMap<Long, String> errorMap = new HashMap<Long, String>();
        ArrayList<Long> releaseIds = new ArrayList<Long>(edcs.length);
        ArrayList<Long> successIds = new ArrayList<Long>(edcs.length);
        result.put("error", errorMap);
        result.put("success", successIds);
        Map<Long, DynamicObject> checkData = this.verifyReleaseDatas(edcMap, releaseIds, errorMap);
        this.dealPomMtfOrderData(checkData, errorMap, successIds, releaseIds);
        DynamicObject adjustSuggestRel = this.getAdjustSuggestRel();
        if (adjustSuggestRel == null) {
            String error = ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u53ef\u7528\u8c03\u6574\u5efa\u8bae\u91ca\u653e\u914d\u7f6e\u3002", (String)"AdjustSuggestServiceImpl_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            this.setError(error, releaseIds, errorMap, checkData);
            return result;
        }
        try {
            this.pushDatas(checkData, adjustSuggestRel, errorMap, successIds, releaseIds);
        }
        catch (Exception ex) {
            log.error("\u91ca\u653e\u8c03\u6574\u5efa\u8bae\u62a5\u9519\uff1a", (Throwable)ex);
            String error = String.format(ResManager.loadKDString((String)"\u91ca\u653e\u8c03\u6574\u5efa\u8bae\u62a5\u9519\uff1a%s", (String)"AdjustSuggestServiceImpl_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), ex.getMessage());
            this.setError(error, releaseIds, errorMap, checkData);
        }
        return result;
    }

    private void dealPomMtfOrderData(Map<Long, DynamicObject> checkData, Map<Long, String> errorMap, List<Long> successIds, List<Long> releaseIds) {
        String message;
        String result;
        Map value;
        Set adjustIds;
        Object key;
        Object billtype;
        HashMap<Long, List> pendMftOrderMap = new HashMap<Long, List>(checkData.size());
        for (Map.Entry<Long, DynamicObject> entry : checkData.entrySet()) {
            String lineid;
            DynamicObject adjustSuggest = entry.getValue();
            DynamicObject billtypeObj = adjustSuggest.getDynamicObject("billtype");
            if (billtypeObj == null || !"pom_mftorder".equals(billtype = billtypeObj.getString("number")) || StringUtils.isBlank((CharSequence)(lineid = adjustSuggest.getString("lineid")))) continue;
            Long entryId = Long.valueOf(lineid);
            List list = pendMftOrderMap.computeIfAbsent(entryId, k -> new ArrayList(16));
            list.add(adjustSuggest);
        }
        if (pendMftOrderMap == null || pendMftOrderMap.isEmpty()) {
            return;
        }
        QFilter qFilterIds = new QFilter("treeentryentity.id", "in", pendMftOrderMap.keySet());
        QFilter[] filters = new QFilter[]{qFilterIds};
        HashMap<Long, Object> entryIdBillstatusInfo = new HashMap<Long, Object>();
        DataSet dataset = QueryServiceHelper.queryDataSet((String)AdjustSuggestServiceImpl.class.getName(), (String)"pom_mftorder", (String)"id,billstatus,treeentryentity.id,treeentryentity.baseqty", (QFilter[])filters, null);
        billtype = null;
        try {
            while (dataset.hasNext()) {
                Row row = dataset.next();
                HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
                String string = row.getString(1);
                Long l = row.getLong(2);
                BigDecimal baseqty = row.getBigDecimal(3);
                map.put("baseqty", baseqty);
                map.put("billstatus", (BigDecimal)((Object)string));
                entryIdBillstatusInfo.put(l, map);
            }
            dataset.close();
        }
        catch (Throwable row) {
            billtype = row;
            throw row;
        }
        finally {
            if (dataset != null) {
                if (billtype != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)billtype).addSuppressed(row);
                    }
                } else {
                    dataset.close();
                }
            }
        }
        HashMap<Long, Set> entryIdAdjustIdorderMap = new HashMap<Long, Set>(16);
        HashSet<Long> closeOrInvalidOrders = new HashSet<Long>(16);
        HashMap<Long, Map> orderEntryIdAndChangeInfo = new HashMap<Long, Map>(16);
        for (Map.Entry entry : pendMftOrderMap.entrySet()) {
            List list = (List)entry.getValue();
            for (DynamicObject adjustSuggest : list) {
                ArrayList<Long> arrayList;
                String lineid = adjustSuggest.getString("lineid");
                Long entryId = Long.valueOf(lineid);
                Map map = (Map)entryIdBillstatusInfo.get(entryId);
                if (map == null || map.isEmpty()) continue;
                Set adjustSuggestIds = entryIdAdjustIdorderMap.computeIfAbsent(entryId, k -> new HashSet(16));
                adjustSuggestIds.add(adjustSuggest.getLong("id"));
                String billstatus = (String)map.get("billstatus");
                BigDecimal baseqty = (BigDecimal)map.get("baseqty");
                BigDecimal qty = adjustSuggest.getBigDecimal("qty");
                if (baseqty.compareTo(qty) == 0 && "C".equals(billstatus)) {
                    adjustSuggestIds.remove(adjustSuggest.getLong("id"));
                }
                if (baseqty.compareTo(qty) != 0) {
                    String error2 = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u4e0d\u652f\u6301\u90e8\u5206\u8c03\u6574\u3002", (String)"AdjustSuggestServiceImpl_12", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
                    arrayList = new ArrayList<Long>();
                    arrayList.add(adjustSuggest.getLong("id"));
                    this.setError(error2, arrayList, errorMap, checkData);
                    continue;
                }
                if ("D".equals(billstatus)) {
                    String error = ResManager.loadKDString((String)"\u4f5c\u5e9f\u5355\u636e\u4e0d\u652f\u6301\u8c03\u6574\u3002", (String)"AdjustSuggestServiceImpl_13", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
                    arrayList = new ArrayList();
                    arrayList.add(adjustSuggest.getLong("id"));
                    this.setError(error, arrayList, errorMap, checkData);
                    continue;
                }
                String adjustsuggest = adjustSuggest.getString("adjustsuggest");
                if (!"A".equals(billstatus) && !"B".equals(billstatus)) continue;
                if ("0".equals(adjustsuggest)) {
                    closeOrInvalidOrders.add(entryId);
                    continue;
                }
                Date adjustdate = adjustSuggest.getDate("adjustdate");
                Map changeInfoMap = orderEntryIdAndChangeInfo.computeIfAbsent(entryId, k -> new HashMap());
                changeInfoMap.put("planendtime", adjustdate);
            }
        }
        try {
            Map closeResult = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMftOrderService", (String)"closeOrInvalidOrderByOrderEntryId", (Object[])new Object[]{closeOrInvalidOrders, "pom_mftorder"});
            if (closeResult != null) {
                for (Map.Entry entry : closeResult.entrySet()) {
                    key = (Long)entry.getKey();
                    adjustIds = (Set)entryIdAdjustIdorderMap.get(key);
                    value = (Map)entry.getValue();
                    result = (String)value.get("success");
                    if ("false".equals(result)) {
                        message = (String)value.get("message");
                        ArrayList<Long> ids2 = new ArrayList<Long>(1);
                        ids2.addAll(adjustIds);
                        this.setError(message, ids2, errorMap, checkData);
                        continue;
                    }
                    if (!"true".equals(result)) continue;
                    successIds.addAll(adjustIds);
                }
            }
        }
        catch (Exception ex) {
            log.error("\u91ca\u653e\u751f\u4ea7\u5de5\u5355\u5173\u95ed\u62a5\u9519\uff1a", (Throwable)ex);
            String string = ex.getMessage();
            ArrayList<Long> arrayList = new ArrayList<Long>(closeOrInvalidOrders.size());
            for (Long closeOrInvalidOrder : closeOrInvalidOrders) {
                arrayList.addAll((Collection)entryIdAdjustIdorderMap.get(closeOrInvalidOrder));
            }
            this.setError(string, arrayList, errorMap, checkData);
        }
        try {
            Map xOrderResult = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMftOrderService", (String)"xOrderByOrderEntryIdNew", (Object[])new Object[]{orderEntryIdAndChangeInfo, "pom_mftorder"});
            if (xOrderResult != null) {
                for (Map.Entry entry : xOrderResult.entrySet()) {
                    key = (Long)entry.getKey();
                    adjustIds = (Set)entryIdAdjustIdorderMap.get(key);
                    value = (Map)entry.getValue();
                    result = (String)value.get("success");
                    if ("false".equals(result)) {
                        message = (String)value.get("message");
                        ArrayList<Long> ids = new ArrayList<Long>(1);
                        ids.addAll(adjustIds);
                        this.setError(message, ids, errorMap, checkData);
                        continue;
                    }
                    if (!"true".equals(result)) continue;
                    successIds.addAll(adjustIds);
                }
            }
        }
        catch (Exception ex) {
            log.error("\u91ca\u653e\u751f\u4ea7\u5de5\u5355\u53d8\u66f4\u62a5\u9519\uff1a", (Throwable)ex);
            String string = ex.getMessage();
            ArrayList<Long> arrayList = new ArrayList<Long>(orderEntryIdAndChangeInfo.size());
            arrayList.addAll(orderEntryIdAndChangeInfo.keySet());
            this.setError(string, arrayList, errorMap, checkData);
        }
        ArrayList<DynamicObject> adjustSuggests = new ArrayList<DynamicObject>(successIds.size());
        for (Long l : successIds) {
            adjustSuggests.add(checkData.get(l));
        }
        SaveServiceHelper.save((DynamicObject[])adjustSuggests.toArray(new DynamicObject[adjustSuggests.size()]));
        for (Set set : entryIdAdjustIdorderMap.values()) {
            for (Long adjustId : set) {
                checkData.remove(adjustId);
                releaseIds.add(adjustId);
            }
        }
    }

    private Map<Long, DynamicObject> verifyReleaseDatas(Map<Long, DynamicObject> edcMap, List<Long> releaseIds, Map<Long, String> errorMap) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)edcMap.size());
        for (Map.Entry<Long, DynamicObject> edcEntry : edcMap.entrySet()) {
            Long key = edcEntry.getKey();
            DynamicObject edc = edcEntry.getValue();
            if (edc.getBoolean("releasestatus")) {
                errorMap.put(key, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u91ca\u653e\uff0c\u4e0d\u53ef\u518d\u91cd\u590d\u91ca\u653e\u64cd\u4f5c\u3002", (String)"AdjustSuggestServiceImpl_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
                continue;
            }
            Date currentTime = new Date();
            edc.set("releasestatus", (Object)Boolean.TRUE);
            edc.set("dealer", (Object)RequestContext.get().getCurrUserId());
            edc.set("dealdate", (Object)currentTime);
            result.put(edc.getLong("id"), edc);
            releaseIds.add(edc.getLong("id"));
        }
        return result;
    }

    private void pushDatas(Map<Long, DynamicObject> checkData, DynamicObject adjustSuggestRel, Map<Long, String> errorMap, List<Long> successIds, List<Long> releaseIds) {
        HashMap asSrcRelMap = Maps.newHashMapWithExpectedSize((int)checkData.size());
        HashMap srcRelAsMap = Maps.newHashMapWithExpectedSize((int)checkData.size());
        HashMap srcOrderIdMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap asOrderIdMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap srcPushTarMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap asTochangeMap = Maps.newHashMapWithExpectedSize((int)10);
        this.dealAdjustSuggestRel(adjustSuggestRel, srcPushTarMap, asTochangeMap);
        this.dealAdjustSuggest(checkData, srcOrderIdMap, asSrcRelMap, srcRelAsMap, asOrderIdMap);
        IDropDataCtrlService dropDataCtrlService = this.getDropDataCtrlPlugin(adjustSuggestRel.getDynamicObject("releaseplugin"));
        if (dropDataCtrlService == null) {
            String error = ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8c03\u6574\u5efa\u8bae\u91ca\u653e\u914d\u7f6e\u91ca\u653e\u63d2\u4ef6\u3002", (String)"AdjustSuggestServiceImpl_9", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            this.setError(error, releaseIds, errorMap, checkData);
            return;
        }
        for (Map.Entry<String, List<Long>> entry : srcOrderIdMap.entrySet()) {
            String key = (String)entry.getKey();
            List asOrderIds = (List)asOrderIdMap.get(key);
            this.dealData(entry, srcPushTarMap, errorMap, srcRelAsMap, checkData, asTochangeMap, successIds, asOrderIds, dropDataCtrlService);
        }
    }

    private void dealData(Map.Entry<String, List<Long>> srcOrderIdEntry, Map<String, String> srcPushTarMap, Map<Long, String> errorMap, Map<Long, List<Long>> srcRelAsMap, Map<Long, DynamicObject> checkData, Map<String, Map<String, String>> asTochangeMap, List<Long> successIds, List<Long> asOrderIds, IDropDataCtrlService dropDataCtrlService) {
        Long asId;
        ConvertRuleElement loadRule = null;
        String ruleId = null;
        List<Long> orderIds = srcOrderIdEntry.getValue();
        String billtype = srcOrderIdEntry.getKey();
        String changebill = srcPushTarMap.get(billtype);
        if (StringUtils.isBlank((CharSequence)changebill)) {
            String error = ResManager.loadKDString((String)"\u8c03\u6574\u5efa\u8bae\u91ca\u653e\u914d\u7f6e\u672a\u914d\u7f6e\u4f9b\u5e94\u5355\u636e\u5b9e\u4f53\u5bf9\u5e94\u53d8\u66f4\u5355\u5b9e\u4f53\u3002", (String)"AdjustSuggestServiceImpl_14", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            this.setError(error, asOrderIds, errorMap, checkData);
            return;
        }
        List rules = BOTPHelper.getRules((String)billtype, (String)changebill);
        if (rules == null || rules.size() == 0) {
            String error = ResManager.loadKDString((String)"\u6570\u636e\u7684\u4f9b\u5e94\u5355\u636e\u5b9e\u4f53\u5230\u5bf9\u5e94\u53d8\u66f4\u5355\u672a\u627e\u5230\u8f6c\u6362\u89c4\u5219\u3002", (String)"AdjustSuggestServiceImpl_4", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            this.setError(error, asOrderIds, errorMap, checkData);
            return;
        }
        loadRule = (ConvertRuleElement)rules.get(0);
        ruleId = loadRule.getId();
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(orderIds.size());
        for (Long pk : orderIds) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)pk);
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(billtype);
        args.setTargetEntityNumber(changebill);
        args.setRuleId(ruleId);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        if (result.getBillReports().size() > 0) {
            for (SourceBillReport billReport : result.getBillReports()) {
                if (billReport.isFullSuccess()) continue;
                StringBuilder error = new StringBuilder();
                error.append(ResManager.loadKDString((String)"\u6570\u636e\u7684\u4e0b\u63a8\u5355\u636e\u5931\u8d25\uff1a", (String)"AdjustSuggestServiceImpl_5", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
                if (StringUtils.isNotBlank((CharSequence)result.getMessage())) {
                    error.append(result.getMessage()).append('\u3002').append("\r\n");
                }
                error.append(billReport.getRowInfo());
                error.append(':');
                error.append(billReport.buildSummary()).append('\u3002').append("\r\n");
                Object billId = billReport.getBillId();
                Long orderId = Long.valueOf(billId.toString());
                ArrayList<Long> errorOrderIds = new ArrayList<Long>();
                errorOrderIds.addAll((Collection)srcRelAsMap.get(orderId));
                asOrderIds.removeAll(errorOrderIds);
                this.setError(error.toString(), errorOrderIds, errorMap, checkData);
            }
        } else if (result.getBillReports().size() == 0) {
            String errorMessage;
            StringBuilder error = new StringBuilder();
            error.append(ResManager.loadKDString((String)"\u6570\u636e\u7684\u4e0b\u63a8\u5355\u636e\u5931\u8d25\uff1a", (String)"AdjustSuggestServiceImpl_5", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
            if (StringUtils.isNotBlank((CharSequence)result.getMessage())) {
                error.append(result.getMessage());
            }
            if ((errorMessage = error.toString()).length() > 450) {
                errorMessage = errorMessage.substring(0, 450);
            }
            this.setError(errorMessage, asOrderIds, errorMap, checkData);
            return;
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)changebill);
        List targetBills = result.loadTargetDataObjects(refDataProvider, mainType);
        String sourceLoadField = PlanOrderHelper.getSourceLoadField((ConvertRuleElement)loadRule);
        if (StringUtils.isBlank((CharSequence)sourceLoadField)) {
            String error = ResManager.loadKDString((String)"\u6570\u636e\u7684\u8ba2\u5355\u7c7b\u578b\u5230\u5bf9\u5e94\u53d8\u66f4\u5355\u672a\u627e\u5230\u5bf9\u5e94\u539f\u5355id\u5b57\u6bb5\u3002", (String)"AdjustSuggestServiceImpl_15", (String)"mmc-mrp-mservice", (Object[])new Object[0]);
            this.setError(error, asOrderIds, errorMap, checkData);
            return;
        }
        HashMap targetOrderMap = Maps.newHashMapWithExpectedSize((int)targetBills.size());
        HashMap<Long, Long> xorderIdToAsIdMap = new HashMap<Long, Long>(targetBills.size());
        ArrayList<DynamicObject> targetOrders = new ArrayList<DynamicObject>(targetBills.size());
        if (targetBills != null && targetBills.size() >= 1) {
            int i = 0;
            for (DynamicObject targetBill : targetBills) {
                List sourceBillIds = PlanOrderHelper.getSourceBillId((DynamicObject)targetBill, (String)changebill, (String)sourceLoadField);
                Long sourceBillId = (Long)sourceBillIds.get(0);
                List<Long> asIds = srcRelAsMap.get(sourceBillId);
                i += asIds.size();
            }
            long[] newTargetBillIds = DB.genLongIds((String)mainType.getAlias(), (int)i);
            int j = 0;
            for (DynamicObject targetBill : targetBills) {
                DynamicObject[] sourceBillIds = PlanOrderHelper.getSourceBillId((DynamicObject)targetBill, (String)changebill, (String)sourceLoadField);
                Long sourceBillId = (Long)sourceBillIds.get(0);
                List<Long> asIds = srcRelAsMap.get(sourceBillId);
                for (Long asId2 : asIds) {
                    DynamicObject newTargetBill = (DynamicObject)OrmUtils.clone((Object)targetBill, (IDataEntityType)mainType, (boolean)true, (boolean)true);
                    Long newTargetBillId = newTargetBillIds[j];
                    ++j;
                    newTargetBill.set("id", (Object)newTargetBillId);
                    DynamicObject adjustsuggest = checkData.get(asId2);
                    xorderIdToAsIdMap.put(newTargetBill.getLong("id"), asId2);
                    String changetype = adjustsuggest.getString("adjustsuggest");
                    Map changeType = dropDataCtrlService.getChangeType(changetype, changebill);
                    String lineId = adjustsuggest.getString("lineid");
                    for (Map.Entry entry : changeType.entrySet()) {
                        String[] tagValueStr = ((String)entry.getKey()).split("\\.");
                        if (tagValueStr.length >= 2) {
                            int n = 0;
                            this.setEntryValue(tagValueStr, n, newTargetBill, lineId, entry.getValue(), loadRule);
                            continue;
                        }
                        newTargetBill.set((String)entry.getKey(), entry.getValue());
                    }
                    int lineno = adjustsuggest.getInt("lineno");
                    Map<String, String> map = asTochangeMap.get(changebill);
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        Object value = adjustsuggest.get(entry.getKey());
                        String tagValue = entry.getValue();
                        if (StringUtils.isBlank((Object)value) || StringUtils.isBlank((CharSequence)tagValue)) {
                            if (!"adjustcause".equals(entry.getKey())) continue;
                            newTargetBill.set(entry.getValue(), (Object)ResManager.loadKDString((String)"\u8c03\u6574\u5efa\u8bae\u91ca\u653e\u4ea7\u751f\u3002", (String)"AdjustSuggestServiceImpl_7", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
                            continue;
                        }
                        String[] tagValueStr = tagValue.split("\\.");
                        if (tagValueStr.length >= 2) {
                            int n = 0;
                            this.setEntryValue(tagValueStr, n, newTargetBill, lineId, value, loadRule);
                            continue;
                        }
                        newTargetBill.set(entry.getValue(), value);
                    }
                    if ("mrp_xplanorder".equals(changebill)) {
                        newTargetBill.set("issysgen", (Object)true);
                    }
                    this.dealBillNo(changebill, newTargetBill);
                    targetOrderMap.put(newTargetBill.getPkValue(), newTargetBill);
                    targetOrders.add(newTargetBill);
                }
            }
        }
        OperateOption option = OperateOption.create();
        OperationResult operationResult = null;
        operationResult = OperationServiceHelper.executeOperate((String)"save", (String)changebill, (DynamicObject[])targetOrders.toArray(new DynamicObject[0]), (OperateOption)option);
        DynamicObject[] targetorders = BusinessDataServiceHelper.load((String)changebill, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", targetOrderMap.keySet())});
        ArrayList<Long> successPkIds = new ArrayList<Long>(targetorders.length);
        ArrayList<DynamicObject> adjustSuggests = new ArrayList<DynamicObject>(targetorders.length);
        for (DynamicObject targetorder : targetorders) {
            Long successPkId = targetorder.getLong("id");
            successPkIds.add(successPkId);
            asId = (Long)xorderIdToAsIdMap.get(successPkId);
            successIds.add(asId);
            adjustSuggests.add(checkData.get(asId));
        }
        SaveServiceHelper.save((DynamicObject[])adjustSuggests.toArray(new DynamicObject[adjustSuggests.size()]));
        if (!operationResult.isSuccess()) {
            List allErrors;
            StringBuilder error = new StringBuilder();
            error.append(ResManager.loadKDString((String)"\u91ca\u653e\u4e0b\u6e38\u53d8\u66f4\u5355\u636e\u65f6\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"AdjustSuggestServiceImpl_8", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
            if (StringUtils.isNotBlank((CharSequence)result.getMessage())) {
                error.append(result.getMessage());
            }
            if ((allErrors = operationResult.getAllErrorOrValidateInfo()) == null || allErrors.size() == 0) {
                String errorStr = operationResult.getMessage();
                this.setError(errorStr, asOrderIds, errorMap, checkData);
            } else {
                for (IOperateInfo info : allErrors) {
                    Object pkValue = info.getPkValue();
                    if (successPkIds.contains(pkValue)) continue;
                    asId = (Long)xorderIdToAsIdMap.get(pkValue);
                    StringBuilder infoerror = new StringBuilder();
                    String errorMessage = errorMap.get(asId);
                    if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        errorMap.put(asId, infoerror.append(errorMessage).append(info.getMessage()).append("\n\r").toString());
                        continue;
                    }
                    errorMap.put(asId, infoerror.append((CharSequence)error).append(info.getMessage()).append("\n\r").toString());
                }
            }
        }
    }

    private void setEntryValue(String[] tagValueStr, int n, DynamicObject newTargetBill, String lineId, Object value, ConvertRuleElement loadRule) {
        if (n > tagValueStr.length - 1 || tagValueStr[n] == null) {
            return;
        }
        String key = tagValueStr[n];
        if (newTargetBill.get(key) instanceof DynamicObjectCollection) {
            DynamicObjectCollection newTargetBillEntrys = newTargetBill.getDynamicObjectCollection(key);
            String sourceLoadField = PlanOrderHelper.getSourceLoadField((ConvertRuleElement)loadRule, (String)key);
            int index = sourceLoadField.indexOf("key");
            if (-1 == index) {
                index = 0;
            }
            String result = sourceLoadField.substring(index);
            result = result.replace(key + ".", "");
            Iterator iterator = newTargetBillEntrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject data = (DynamicObject)iterator.next();
                String entryId = data.getString(result);
                if (!lineId.equals(entryId)) {
                    iterator.remove();
                    continue;
                }
                this.setEntryValue(tagValueStr, ++n, data, lineId, value, loadRule);
            }
        } else {
            newTargetBill.set(key, value);
        }
    }

    private void dealBillNo(String changebill, DynamicObject targetBill) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)changebill);
        String mainOrg = dataEntityType.getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg)) {
            targetBill.set("billno", (Object)UUID.randomUUID().toString().substring(0, 30));
            return;
        }
        String mainOrgId = AdjustSuggestServiceImpl.getDataId(targetBill.get(mainOrg), 0L).toString();
        boolean exist = CodeRuleServiceHelper.isExist((String)changebill, (DynamicObject)targetBill, (String)mainOrgId);
        if (!exist && StringUtils.isBlank((CharSequence)targetBill.getString("billno"))) {
            targetBill.set("billno", (Object)UUID.randomUUID().toString().substring(0, 30));
        }
    }

    public static Long getDataId(Object src, Long defaultValue) {
        if (src == null) {
            return defaultValue;
        }
        if (src instanceof Long) {
            return (Long)src;
        }
        if (src instanceof DynamicObject) {
            DynamicObject result = (DynamicObject)src;
            Object pkValue = result.getPkValue();
            if (pkValue instanceof Long) {
                return (Long)pkValue;
            }
            return defaultValue;
        }
        if (src instanceof String) {
            return Long.valueOf(src.toString());
        }
        return defaultValue;
    }

    private void setError(String error, List<Long> orderIds, Map<Long, String> errorMap, Map<Long, DynamicObject> checkData) {
        for (Long orderId : orderIds) {
            if (error.length() > 450) {
                error = error.substring(0, 450);
            }
            DynamicObject data = checkData.get(orderId);
            String name = data.getDynamicObject("billtype").getLocaleString("name").getLocaleValue();
            String billno = data.getString("billno");
            String builder = String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u5b9e\u4f53\u201c%1$s\u201d\u5355\u636e\u7f16\u53f7\u201c%2$s\u201d%3$s\u3002", (String)"AdjustSuggestServiceImpl_11", (String)"mmc-mrp-mservice", (Object[])new Object[0]), name, billno, error);
            errorMap.put(orderId, builder);
        }
    }

    private void dealAdjustSuggestRel(DynamicObject adjustSuggestRel, Map<String, String> srcPushTarMap, Map<String, Map<String, String>> asTochangeMap) {
        DynamicObjectCollection entryentity = adjustSuggestRel.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            String billtype = entry.getDynamicObject("billtype").getString("id");
            String changebill = entry.getDynamicObject("changebill").getString("id");
            srcPushTarMap.put(billtype, changebill);
            DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subentry : subentryentity) {
                HashMap map = asTochangeMap.get(changebill);
                if (map == null) {
                    map = Maps.newHashMapWithExpectedSize((int)2);
                }
                map.put(subentry.getString("adjustsugfieldsign"), subentry.getString("changebillfieldsign"));
                asTochangeMap.put(changebill, map);
            }
        }
    }

    private void dealAdjustSuggest(Map<Long, DynamicObject> checkData, Map<String, List<Long>> srcOrderIdMap, Map<Long, Long> asSrcRelMap, Map<Long, List<Long>> srcRelAsMap, Map<String, List<Long>> asOrderIdMap) {
        for (DynamicObject data : checkData.values()) {
            String billtype = data.getDynamicObject("billtype").getString("id");
            Long id = data.getLong("id");
            Long billId = data.getLong("billid");
            List srcOrderIds = srcOrderIdMap.computeIfAbsent(billtype, k -> new ArrayList());
            List ids = srcRelAsMap.computeIfAbsent(billId, k -> new ArrayList());
            ids.add(id);
            List asIds = asOrderIdMap.computeIfAbsent(billtype, k -> new ArrayList());
            asIds.add(id);
            srcOrderIds.add(billId);
            asSrcRelMap.put(id, billId);
        }
    }

    private DynamicObject getAdjustSuggestRel() {
        DynamicObject adjustSuggestRel = null;
        DynamicObject[] adjustSuggestRels = BusinessDataServiceHelper.load((String)"msplan_adjustsuggest_rel", (String)this.getSelectAdjustsuggestRelFields(), (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        if (adjustSuggestRels != null && adjustSuggestRels.length > 0) {
            adjustSuggestRel = adjustSuggestRels[0];
        }
        return adjustSuggestRel;
    }

    private String getSelectAdjustsuggestRelFields() {
        StringBuilder fields = new StringBuilder();
        fields.append("id").append(',');
        fields.append("enable").append(',');
        fields.append("releaseplugin").append(',');
        fields.append("entryentity").append(',');
        fields.append("subentryentity").append(',');
        fields.append("entryentity").append('.').append("billtype").append(',');
        fields.append("entryentity").append('.').append("changebill").append(',');
        fields.append("subentryentity").append('.').append("adjustsugfieldsign").append(',');
        fields.append("subentryentity").append('.').append("changebillfieldsign");
        return fields.toString();
    }

    private IDropDataCtrlService getDropDataCtrlPlugin(DynamicObject dynamicObject) {
        IDropDataCtrlService dropDataCtrlService = null;
        try {
            if (dynamicObject != null) {
                String algoimpletcalss = dynamicObject.getString("algoimpletcalss");
                dropDataCtrlService = (IDropDataCtrlService)Class.forName(algoimpletcalss).newInstance();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException exp) {
            log.error(exp.getMessage(), (Throwable)exp);
        }
        return dropDataCtrlService;
    }

    private Map<Long, DynamicObject> genEdcMap(DynamicObject[] edcs) {
        HashMap<Long, DynamicObject> edcMap = new HashMap<Long, DynamicObject>(edcs.length);
        for (DynamicObject dyn : edcs) {
            edcMap.put(dyn.getLong("id"), dyn);
        }
        return edcMap;
    }
}

