/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.batchpolicy;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.mservice.batchpolicy.AbstractBatchProcessor;
import kd.mmc.mrp.utils.MRPUtil;

public class DirectBatchProcessor
extends AbstractBatchProcessor {
    public DirectBatchProcessor(IMRPEnvProvider provider) {
        super(provider);
    }

    public void splitOrdersByDirectLotPolicy(DataBalanceTable.RSMapping mapping, Map<Integer, Boolean> cache) {
        Date cycleDate;
        BigDecimal rQty;
        RequireRowData require = mapping.getRequire();
        BigDecimal batchincrement = require.getBigDecimal(DefaultField.RequireField.BATCHINCREMENT.getName()) == null ? BigDecimal.ZERO : require.getBigDecimal(DefaultField.RequireField.BATCHINCREMENT.getName());
        BigDecimal batchQty = require.getBigDecimal(DefaultField.RequireField.BATCHINCQTY.getName()) == null ? BigDecimal.ZERO : require.getBigDecimal(DefaultField.RequireField.BATCHINCQTY.getName());
        try (TraceSpan ts = Tracer.create((String)"DirectBatchProcessor.richMappingSupply", (String)"richMappingSupply");){
            rQty = this.richMappingSupply(mapping, cache);
        }
        if (rQty == null || rQty.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (mapping.getBeforeMergedQty() == null) {
            mapping.setBeforeMergedQty(rQty);
        }
        BigDecimal mQty = batchQty.compareTo(BigDecimal.ZERO) <= 0 ? rQty : rQty.add(batchincrement).divide(batchQty, 0, RoundingMode.CEILING).multiply(batchQty);
        BigDecimal minBatchQty = require.getBigDecimal(DefaultField.RequireField.MINBATCHQTY.getName());
        BigDecimal maxBatchQty = require.getBigDecimal(DefaultField.RequireField.MAXBATCHQTY.getName());
        BigDecimal partitionbase = require.getBigDecimal(DefaultField.RequireField.PARTITIONQTY.getName());
        int intervalperiod = MRPUtil.getIntervalperiod(require);
        Date date = cycleDate = new Date((Long)mapping.getRequire().getValue(DefaultField.RequireField.DATE.getName()));
        cycleDate = MRPUtil.getDateByCalendar(cycleDate, mapping, this.provider);
        Stack<DataBalanceTable.RSMapping> rsMappingStack = new Stack<DataBalanceTable.RSMapping>();
        if (minBatchQty.compareTo(BigDecimal.ZERO) > 0 && mQty.compareTo(minBatchQty) <= 0) {
            mQty = minBatchQty;
            this.setCurrentMappingToBatchQty(mapping, date, intervalperiod, minBatchQty, rsMappingStack);
        } else if (mQty.compareTo(minBatchQty) > 0 && partitionbase.compareTo(BigDecimal.ZERO) > 0) {
            this.splitMappingByBatchQty(mapping, mQty, partitionbase, cycleDate, intervalperiod, rsMappingStack);
        } else if (maxBatchQty.compareTo(BigDecimal.ZERO) <= 0 && partitionbase.compareTo(BigDecimal.ZERO) <= 0) {
            this.setCurrentMappingToBatchQty(mapping, date, intervalperiod, mQty, rsMappingStack);
        } else if (maxBatchQty.compareTo(BigDecimal.ZERO) > 0 && partitionbase.compareTo(BigDecimal.ZERO) <= 0) {
            this.splitMappingByBatchQty(mapping, mQty, maxBatchQty, cycleDate, intervalperiod, rsMappingStack);
        } else {
            this.setCurrentMappingToBatchQty(mapping, date, intervalperiod, mQty, rsMappingStack);
        }
        BigDecimal richQty = mQty.subtract(rQty);
        if (richQty.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal qty = richQty;
            while (qty.compareTo(BigDecimal.ZERO) > 0 && !rsMappingStack.isEmpty()) {
                TraceSpan ts = Tracer.create((String)"DirectBatchProcessor.productRichMapping", (String)"productRichMapping");
                Throwable throwable = null;
                try {
                    qty = this.productRichMapping(rsMappingStack, mapping, qty);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ts == null) continue;
                    if (throwable != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ts.close();
                }
            }
        }
    }

    @Override
    public void splitOrderByMergedMapping(IMRPEnvProvider provider, BigDecimal batchQty, DataBalanceTable.RSMapping mapping, DataBalanceTable.RSMapping rsmapping, String poNum, Long poId, List<DataBalanceTable.RSMapping> richMappings) {
        rsmapping.setVirtualQty(batchQty);
        boolean isRichAdjust = false;
        if (mapping.getChildMappings() != null && !mapping.getChildMappings().isEmpty()) {
            if (mapping.getBeforeMergedQty() != null && mapping.getBeforeMergedQty().compareTo(BigDecimal.ZERO) > 0 && mapping.getBeforeMergedQty().compareTo(rsmapping.getVirtualQty()) <= 0) {
                DataBalanceTable.RSMapping newnxMapping = mapping.clone();
                newnxMapping.setrQty(mapping.getBeforeMergedQty());
                newnxMapping.setGenPlanOrder(false);
                MRPUtil.batchRichUpdateFields(newnxMapping, rsmapping, poNum, poId);
                this.setIsClearSupplys(newnxMapping);
                newnxMapping.setCreateDepentRequire(false);
                provider.calcBalanceDetails().getUnVisitedMappings().add(newnxMapping);
                rsmapping.setVirtualQty(rsmapping.getVirtualQty().subtract(rsmapping.getBeforeMergedQty()));
                mapping.setBeforeMergedQty(BigDecimal.ZERO);
                mapping.setCalDetail(false);
                if (rsmapping.getVirtualQty().compareTo(BigDecimal.ZERO) == 0) {
                    rsmapping.setCalDetail(false);
                }
            } else if (mapping.getBeforeMergedQty() != null && mapping.getBeforeMergedQty().compareTo(BigDecimal.ZERO) > 0) {
                mapping.setBeforeMergedQty(mapping.getBeforeMergedQty().subtract(rsmapping.getVirtualQty()));
                DataBalanceTable.RSMapping newnxMapping = mapping.clone();
                newnxMapping.setrQty(rsmapping.getVirtualQty());
                newnxMapping.setGenPlanOrder(false);
                MRPUtil.batchRichUpdateFields(newnxMapping, rsmapping, poNum, poId);
                this.setIsClearSupplys(newnxMapping);
                newnxMapping.setCreateDepentRequire(false);
                provider.calcBalanceDetails().getUnVisitedMappings().add(newnxMapping);
                rsmapping.setVirtualQty(BigDecimal.ZERO);
                rsmapping.setCalDetail(false);
                provider.calcBalanceDetails().getUnVisitedMappings().add(rsmapping);
                return;
            }
            Iterator<DataBalanceTable.RSMapping> mappingIterator = mapping.getChildMappings().iterator();
            boolean currentRsMappingOver = false;
            while (mappingIterator.hasNext()) {
                boolean hasVirtualRichSupply = false;
                DataBalanceTable.RSMapping childMapping = mappingIterator.next();
                if (!richMappings.isEmpty()) {
                    Iterator<DataBalanceTable.RSMapping> richIterator = richMappings.iterator();
                    boolean isNext = true;
                    while (richIterator.hasNext() && isNext) {
                        DataBalanceTable.RSMapping richMapping = richIterator.next();
                        if (richMapping.getVirtualQty().compareTo(childMapping.getrQty()) >= 0) {
                            richMapping.setVirtualQty(richMapping.getVirtualQty().subtract(childMapping.getrQty()));
                            mappingIterator.remove();
                            hasVirtualRichSupply = true;
                            MRPUtil.batchRichUpdateFields(childMapping, richMapping, richMapping.getRequire().getString(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName()), richMapping.getRequire().getLong(DefaultField.RequireField.__PO_ID__.getName()));
                            if (richMapping.getVirtualQty().compareTo(BigDecimal.ZERO) <= 0) {
                                richIterator.remove();
                            }
                            isNext = false;
                            continue;
                        }
                        DataBalanceTable.RSMapping newRichMapping = childMapping.clone();
                        newRichMapping.setGenPlanOrder(false);
                        newRichMapping.setVirtualQty(richMapping.getVirtualQty());
                        this.setIsClearSupplys(newRichMapping);
                        newRichMapping.setCreateDepentRequire(false);
                        MRPUtil.batchRichUpdateFields(newRichMapping, richMapping, richMapping.getRequire().getString(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName()), richMapping.getRequire().getLong(DefaultField.RequireField.__PO_ID__.getName()));
                        provider.calcBalanceDetails().getUnVisitedMappings().add(newRichMapping);
                        childMapping.setrQty(childMapping.getrQty().subtract(richMapping.getVirtualQty()));
                        richMapping.setVirtualQty(BigDecimal.ZERO);
                        richIterator.remove();
                    }
                }
                if (hasVirtualRichSupply) continue;
                if (rsmapping.getVirtualQty().compareTo(BigDecimal.ZERO) != 0 && !currentRsMappingOver) {
                    if (rsmapping.getVirtualQty().compareTo(childMapping.getrQty()) >= 0) {
                        rsmapping.setVirtualQty(rsmapping.getVirtualQty().subtract(childMapping.getrQty()));
                        mappingIterator.remove();
                        MRPUtil.batchRichUpdateFields(childMapping, rsmapping, poNum, poId);
                        isRichAdjust = true;
                        if (rsmapping.getVirtualQty().compareTo(BigDecimal.ZERO) <= 0) continue;
                        richMappings.add(rsmapping);
                        continue;
                    }
                    childMapping.setrQty(childMapping.getrQty().subtract(rsmapping.getVirtualQty()));
                    rsmapping = this.partCloneMapping(rsmapping, childMapping, poNum, poId);
                    currentRsMappingOver = true;
                    continue;
                }
                break;
            }
        } else if (mapping.getBeforeMergedQty() != null && mapping.getBeforeMergedQty().compareTo(BigDecimal.ZERO) > 0 && mapping.getBeforeMergedQty().compareTo(rsmapping.getrQty()) < 0) {
            rsmapping.setVirtualQty(mapping.getBeforeMergedQty());
            mapping.setBeforeMergedQty(BigDecimal.ZERO);
        } else if (mapping.getBeforeMergedQty() != null && mapping.getBeforeMergedQty().compareTo(BigDecimal.ZERO) > 0) {
            mapping.setBeforeMergedQty(mapping.getBeforeMergedQty().subtract(rsmapping.getVirtualQty()));
        } else {
            rsmapping.setCalDetail(false);
        }
        if (isRichAdjust) {
            rsmapping.setCalDetail(false);
        } else {
            this.setIsClearSupplys(rsmapping);
        }
        provider.calcBalanceDetails().getUnVisitedMappings().add(rsmapping);
    }

    public DataBalanceTable.RSMapping partCloneMapping(DataBalanceTable.RSMapping rsmapping, DataBalanceTable.RSMapping targetMapping, String poNum, Long poId) {
        BigDecimal rQty = rsmapping.getrQty();
        BigDecimal virtualQty = rsmapping.getVirtualQty();
        Long dateTime = (Long)rsmapping.getRequire().getValue(DefaultField.RequireField.DATE.getName());
        Long startTime = (Long)rsmapping.getRequire().getValue(DefaultField.RequireField.__START_DATE__.getName());
        Long endTime = (Long)rsmapping.getRequire().getValue(DefaultField.RequireField.__END_DATE__.getName());
        rsmapping = targetMapping.clone();
        rsmapping.getRequire().update(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName(), (Object)poNum);
        rsmapping.getRequire().update(DefaultField.RequireField.__PO_ID__.getName(), (Object)poId);
        rsmapping.getRequire().update(DefaultField.RequireField.DATE.getName(), (Object)dateTime);
        rsmapping.getRequire().update(DefaultField.RequireField.__START_DATE__.getName(), (Object)startTime);
        rsmapping.getRequire().update(DefaultField.RequireField.__END_DATE__.getName(), (Object)endTime);
        rsmapping.setrQty(rQty);
        rsmapping.setVirtualQty(virtualQty);
        rsmapping.setGenPlanOrder(true);
        return rsmapping;
    }
}

