/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.batchpolicy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.mservice.batchpolicy.BatchCalcService;
import kd.mmc.mrp.utils.MRPUtil;

public class DirectLotBatchService
extends BatchCalcService {
    public DirectLotBatchService(IMRPEnvProvider ctx) {
        super(ctx);
    }

    @Override
    protected List<BigDecimal> calcBatch(BigDecimal rQty, RequireRowData require, boolean isSplit) {
        ArrayList<BigDecimal> resultQtys = new ArrayList<BigDecimal>(2);
        BigDecimal mQty = this.getMQty(rQty, require);
        BigDecimal minBatchQty = MRPUtil.convert(require.getValue(DefaultField.RequireField.MINBATCHQTY.getName()), BigDecimal.ZERO);
        BigDecimal maxBatchQty = MRPUtil.convert(require.getValue(DefaultField.RequireField.MAXBATCHQTY.getName()), BigDecimal.ZERO);
        BigDecimal partitionbase = MRPUtil.convert(require.getValue(DefaultField.RequireField.PARTITIONQTY.getName()), BigDecimal.ZERO);
        if (minBatchQty.compareTo(BigDecimal.ZERO) > 0 && mQty.compareTo(minBatchQty) <= 0) {
            mQty = minBatchQty;
            resultQtys.add(mQty);
        } else if (mQty.compareTo(minBatchQty) > 0 && partitionbase.compareTo(BigDecimal.ZERO) > 0 && isSplit) {
            this.splitMappingByBatchQty(mQty, partitionbase, resultQtys);
        } else if (maxBatchQty.compareTo(BigDecimal.ZERO) <= 0 && partitionbase.compareTo(BigDecimal.ZERO) <= 0) {
            resultQtys.add(mQty);
        } else if (maxBatchQty.compareTo(BigDecimal.ZERO) > 0 && partitionbase.compareTo(BigDecimal.ZERO) <= 0 && isSplit) {
            this.splitMappingByBatchQty(mQty, maxBatchQty, resultQtys);
        } else {
            resultQtys.add(mQty);
        }
        return resultQtys;
    }

    @Override
    public List<BigDecimal> splitBatchQty(BigDecimal rQty, RequireRowData require) {
        ArrayList<BigDecimal> resultQtys = new ArrayList<BigDecimal>(2);
        BigDecimal maxBatchQty = MRPUtil.convert(require.getValue(DefaultField.RequireField.MAXBATCHQTY.getName()), BigDecimal.ZERO);
        BigDecimal partitionbase = MRPUtil.convert(require.getValue(DefaultField.RequireField.PARTITIONQTY.getName()), BigDecimal.ZERO);
        if (partitionbase.compareTo(BigDecimal.ZERO) > 0) {
            this.splitMappingByBatchQty(rQty, partitionbase, resultQtys);
        } else if (maxBatchQty.compareTo(BigDecimal.ZERO) > 0) {
            this.splitMappingByBatchQty(rQty, maxBatchQty, resultQtys);
        } else {
            resultQtys.add(rQty);
        }
        return resultQtys;
    }
}

