/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.batchpolicy;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.mservice.batchpolicy.AbstractBatchProcessor;
import kd.mmc.mrp.utils.MRPUtil;

public class FixedBatchProcessor
extends AbstractBatchProcessor {
    public FixedBatchProcessor(IMRPEnvProvider provider) {
        super(provider);
    }

    public void splitOrdersByFixedLotPolicy(DataBalanceTable.RSMapping mapping, Map<Integer, Boolean> cache) {
        BigDecimal batchQty;
        RequireRowData require = mapping.getRequire();
        BigDecimal batchincrement = require.getBigDecimal(DefaultField.RequireField.BATCHINCREMENT.getName()) == null ? BigDecimal.ZERO : require.getBigDecimal(DefaultField.RequireField.BATCHINCREMENT.getName());
        BigDecimal bigDecimal = batchQty = require.getBigDecimal(DefaultField.RequireField.BATCHINCQTY.getName()) == null ? BigDecimal.ZERO : require.getBigDecimal(DefaultField.RequireField.BATCHINCQTY.getName());
        if (batchQty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal rQty = this.richMappingSupply(mapping, cache);
        if (rQty == null || rQty.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        BigDecimal mQty = rQty.add(batchincrement).divide(batchQty, 0, RoundingMode.CEILING).multiply(batchQty);
        BigDecimal partitionbase = require.getBigDecimal(DefaultField.RequireField.PARTITIONQTY.getName());
        int intervalperiod = MRPUtil.getIntervalperiod(require);
        Date cycleDate = new Date((Long)mapping.getRequire().getValue(DefaultField.RequireField.DATE.getName()));
        Stack<DataBalanceTable.RSMapping> rsMappingStack = new Stack<DataBalanceTable.RSMapping>();
        if (mQty.compareTo(batchQty) <= 0) {
            mQty = batchQty;
            this.setCurrentMappingToBatchQty(mapping, batchQty, rsMappingStack);
        } else if (partitionbase.compareTo(BigDecimal.ZERO) > 0) {
            this.splitMappingByBatchQty(mapping, mQty, partitionbase, cycleDate, intervalperiod, rsMappingStack);
        } else {
            return;
        }
        BigDecimal richQty = mQty.subtract(rQty);
        if (richQty.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal qty = richQty;
            while (qty.compareTo(BigDecimal.ZERO) > 0 && !rsMappingStack.isEmpty()) {
                qty = this.productRichMapping(rsMappingStack, mapping, qty);
            }
        }
    }

    @Override
    public void splitOrderByMergedMapping(IMRPEnvProvider provider, BigDecimal batchQty, DataBalanceTable.RSMapping mapping, DataBalanceTable.RSMapping rsmapping, String poNum, Long poId, List<DataBalanceTable.RSMapping> richMappings) {
        this.setIsClearSupplys(rsmapping);
        provider.calcBalanceDetails().getUnVisitedMappings().add(rsmapping);
    }
}

