/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.fcast;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.enums.DateType;
import kd.mmc.mrp.common.util.ForecastUtils;
import kd.mmc.mrp.mservice.api.fcast.PurForecastReleaseService;
import kd.mmc.mrp.utils.MRPUtil;

public class PurForecastReleaseServiceImpl
implements PurForecastReleaseService {
    private final String algoKey = this.getClass().getSimpleName();

    public void releaseForecast2pm(List<Object> entryIds) {
        Object list;
        String selectField = this.getSelectField();
        QFilter qFilter = new QFilter("entryentity.id", "in", entryIds);
        qFilter.and(new QFilter("entryentity.datatype", "=", (Object)"B"));
        boolean first = true;
        Long dataset = 0L;
        List dateCols = Collections.emptyList();
        Date planstartdate = null;
        String caculatelog = "";
        String srcbillid = "";
        ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
        HashMap<Long, List> purOrg2Data = new HashMap<Long, List>(2);
        HashMap<Long, Set> purOrg2Materials = new HashMap<Long, Set>(2);
        Long plangram = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"mrp_pur_fctdata", (String)selectField, (QFilter[])new QFilter[]{qFilter}, null);){
            RowMeta rowMeta = dataSet.getRowMeta();
            while (dataSet.hasNext()) {
                Map date2Qty;
                Long purorg;
                Row row = dataSet.next();
                if (first) {
                    dataset = row.getLong("dataset");
                    planstartdate = row.getDate("planstartdate");
                    dateCols = (List)SerializationUtils.fromJsonString((String)row.getString("dateinfo_tag"), List.class);
                    caculatelog = row.getString("caculatelog");
                    srcbillid = row.getString("id");
                    plangram = row.getLong("plangram");
                    first = false;
                }
                if ((purorg = row.getLong("purorg")) <= 0L) continue;
                list = purOrg2Data.computeIfAbsent(purorg, k -> new ArrayList(16));
                Map map = rowMeta.toMap(row);
                list.add(map);
                String date_qty_tag = row.getString("date_qty_tag");
                try {
                    date2Qty = (Map)objectMapper.readValue(date_qty_tag, HashMap.class);
                }
                catch (JsonProcessingException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u8d2d\u9884\u6d4b\u65f6\u95f4\u5217\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u9884\u6d4b\u6570\u636e\u3002", (String)"PurForecastReleaseServiceImpl_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
                }
                map.put("date_qty_tag", date2Qty);
                Set mids = purOrg2Materials.computeIfAbsent(purorg, k -> new HashSet(16));
                mids.add(row.getLong("material"));
            }
        }
        int day = 0;
        int week = 0;
        int month = 0;
        Object setId = ForecastUtils.getDateSetId((Long)dataset);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"mrp_dateset", (String)"entryentity.type type, entryentity.num num", (QFilter[])new QFilter[]{new QFilter("id", "=", setId)}, null);
        list = null;
        try {
            boolean isNull = true;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String type = row.getString("type");
                int num = row.getInteger("num");
                if (StringUtils.equals((CharSequence)type, (CharSequence)DateType.DAY.getValue())) {
                    day = num;
                    isNull = false;
                    continue;
                }
                if (StringUtils.equals((CharSequence)type, (CharSequence)DateType.MONTH.getValue())) {
                    month = num;
                    isNull = false;
                    continue;
                }
                if (!StringUtils.equals((CharSequence)type, (CharSequence)DateType.WEEK.getValue())) continue;
                week = num;
                isNull = false;
            }
            if (isNull) {
                day = 28;
                week = 75;
            }
        }
        catch (Throwable isNull) {
            list = isNull;
            throw isNull;
        }
        finally {
            if (dataSet != null) {
                if (list != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable isNull) {
                        ((Throwable)list).addSuppressed(isNull);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        ArrayList<Map<String, Object>> entryentity = new ArrayList<Map<String, Object>>(4);
        params.put("entryentity", entryentity);
        if (day > 0) {
            this.addUnitEntry(entryentity, day, "D");
        }
        if (week > 0) {
            this.addUnitEntry(entryentity, week, "W");
        }
        if (month > 0) {
            this.addUnitEntry(entryentity, month, "M");
        }
        Long planSchemeId = this.getPlanSchemeId(params, plangram);
        ArrayList<HashMap<String, Object>> list2 = new ArrayList<HashMap<String, Object>>(2);
        long[] indexkeys = IDService.get().genLongIds(purOrg2Data.size());
        int seq = 0;
        for (Map.Entry entry : purOrg2Data.entrySet()) {
            Set mids = (Set)purOrg2Materials.get(entry.getKey());
            Map mId2Operator = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurApplyService", (String)"getMaterialFitOperatorNew", (Object[])new Object[]{entry.getKey(), mids});
            HashMap<String, Object> head = new HashMap<String, Object>(8);
            list2.add(head);
            head.put("indexkey", indexkeys[seq++]);
            head.put("forecastplanscheme", planSchemeId);
            head.put("org", entry.getKey());
            head.put("planstartdate", planstartdate);
            ArrayList<HashMap<String, Object>> entryList = new ArrayList<HashMap<String, Object>>(((List)entry.getValue()).size());
            head.put("entryentity", entryList);
            this.putHeadData(head, caculatelog);
            for (Map data : (List)entry.getValue()) {
                HashMap<String, Object> detail = new HashMap<String, Object>(8);
                entryList.add(detail);
                detail.put("material", data.get("material"));
                detail.put("supplier", data.get("supplier"));
                detail.put("unit", data.get("unit"));
                Map map = (Map)mId2Operator.get(MRPUtil.convert(data.get("material"), 0L));
                if (map != null) {
                    detail.put("operatorgroup", map.get("operatorgroup"));
                    detail.put("operator", map.get("operator"));
                }
                HashMap<String, BigDecimal> dateQtyMap = new HashMap<String, BigDecimal>(dateCols.size());
                Map date2Qty = (Map)data.get("date_qty_tag");
                for (String col : dateCols) {
                    Object qtyObj = date2Qty.get(col);
                    BigDecimal qty = BigDecimal.ZERO;
                    if (qtyObj != null) {
                        qty = new BigDecimal(qtyObj.toString());
                    }
                    dateQtyMap.put(col, qty);
                }
                detail.put("entry_date_qty", dateQtyMap);
                detail.put("srcbillentity", "mrp_pur_fctdata");
                detail.put("srcbillno", caculatelog);
                detail.put("publishstatus", "A");
                detail.put("srcbillid", srcbillid);
                detail.put("srcbillentryseq", String.valueOf(data.get("seq")));
                detail.put("srcbillentryid", String.valueOf(data.get("entryid")));
                this.putEntryDetailData(detail, data);
            }
        }
        if (!list2.isEmpty()) {
            List r = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"ForecastPlan", (String)"saveForecastPlanBill", (Object[])new Object[]{list2});
            StringBuilder error = new StringBuilder();
            for (Map result : r) {
                if (((Boolean)result.get("issuccess")).booleanValue()) continue;
                String message = String.valueOf(result.get("message"));
                error.append(message).append("\r\n");
            }
            if (error.length() > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7aef\u670d\u52a1\u5f02\u5e38\uff1a%s\u3002", (String)"PurForecastReleaseServiceImpl_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]), error.toString()));
            }
        }
    }

    private void addUnitEntry(List<Map<String, Object>> entryentity, int n, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeunit", type);
        map.put("step", 1);
        map.put("periods", n);
        entryentity.add(map);
    }

    protected String getSelectField() {
        return "id, plangram, caculatelog, dataset, planstartdate, dateinfo_tag, entryentity.seq seq, entryentity.id entryid, entryentity.material material, entryentity.unit unit, entryentity.date_qty_tag date_qty_tag, entryentity.supplier supplier, entryentity.purorg purorg";
    }

    protected void putEntryDetailData(Map<String, Object> detail, Map<String, Object> data) {
    }

    protected void putHeadData(Map<String, Object> head, String caculatelog) {
    }

    protected Long getPlanSchemeId(Map<String, Object> params, Long plangram) {
        return (Long)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"ForecastPlan", (String)"getForecastPlanSchemeId", (Object[])new Object[]{params});
    }
}

