/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.fcast;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.util.ForecastUtils;
import kd.mmc.mrp.mservice.api.fcast.PurForecastReverseService;

public class PurForecastReverseServiceImpl
implements PurForecastReverseService {
    private static final String MRP_PUR_FCTDATA = "mrp_pur_fctdata";
    private final String algoKey = this.getClass().getSimpleName();

    /*
     * WARNING - void declaration
     */
    public Map<Long, Boolean> splitStatusReverse(Map<Long, String> params) {
        void var11_21;
        Object[] p;
        HashMap result = Maps.newHashMapWithExpectedSize((int)params.size());
        if (params.isEmpty()) {
            return result;
        }
        QFilter qFilter = new QFilter("entryentity.id", "in", params.keySet());
        HashMap id2Material = Maps.newHashMapWithExpectedSize((int)1);
        HashMap idAndMaterial2Status = Maps.newHashMapWithExpectedSize((int)params.size());
        HashMap isLatestData = Maps.newHashMapWithExpectedSize((int)1);
        Throwable throwable = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)MRP_PUR_FCTDATA, (String)"id, caculatelog, entryentity.id entryid, entryentity.material material", (QFilter[])new QFilter[]{qFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long entryId = row.getLong("entryid");
                String string = row.getString("caculatelog");
                Long material = row.getLong("material");
                Long id = row.getLong("id");
                Boolean is_latest_data = (Boolean)isLatestData.get(id);
                if (is_latest_data == null) {
                    is_latest_data = ForecastUtils.isLastRunLog((String)string);
                    isLatestData.put(id, is_latest_data);
                }
                if (!is_latest_data.booleanValue()) {
                    result.put(entryId, Boolean.FALSE);
                    params.remove(entryId);
                    continue;
                }
                Set mids = id2Material.computeIfAbsent(id, k -> new HashSet(16));
                mids.add(material);
                String splitStatus = params.get(entryId);
                idAndMaterial2Status.put(String.format("%s\u0001%s", id, material), splitStatus);
            }
        }
        catch (Throwable row) {
            Throwable throwable2 = row;
            throw row;
        }
        for (Map.Entry entry : id2Material.entrySet()) {
            Long id = (Long)entry.getKey();
            Set mids = (Set)entry.getValue();
            this.putEntryParam(idAndMaterial2Status, params, id, mids);
        }
        Timestamp taday = new Timestamp(System.currentTimeMillis());
        String string = "update t_mrp_pur_fctentry set fsplited = ?, fsplittime = ? where fentryid = ? and fpublished = '1'";
        ArrayList ps = Lists.newArrayListWithCapacity((int)params.size());
        for (Map.Entry entry : params.entrySet()) {
            p = new Object[]{entry.getValue(), taday, entry.getKey()};
            ps.add(p);
        }
        if (ps.isEmpty()) {
            return result;
        }
        int[] res = DB.executeBatch((DBRoute)new DBRoute("scm"), (String)string, (List)ps);
        boolean bl = false;
        while (var11_21 < res.length) {
            p = (Object[])ps.get((int)var11_21);
            Boolean flag = Boolean.TRUE;
            if (res[var11_21] == 0) {
                flag = Boolean.FALSE;
            }
            result.put((Long)p[2], flag);
            ++var11_21;
        }
        return result;
    }

    private void putEntryParam(Map<String, String> idAndMaterial2Status, Map<Long, String> params, Long id, Set<Long> mids) {
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)id), new QFilter("entryentity.material", "in", mids)};
        String selectField = "entryentity.id entryid, entryentity.material";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)MRP_PUR_FCTDATA, (String)selectField, (QFilter[])qFilters, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long entryId = row.getLong(0);
                Long material = row.getLong(1);
                String key = String.format("%s\u0001%s", id, material);
                String splitStatus = idAndMaterial2Status.get(key);
                if (splitStatus == null || params.containsKey(entryId)) continue;
                params.put(entryId, splitStatus);
            }
        }
    }
}

