/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.fetch;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.KDCloudDataFetcher;
import kd.mmc.mrp.integrate.MRPIntegrateFactory;
import kd.mmc.mrp.model.wrapper.DynamicRowSet;
import kd.mmc.mrp.mservice.api.fetch.FetchDataService;

public class FetchDataServiceImpl
implements FetchDataService {
    public HashMap<String, ArrayList<Object[]>> fetchDatas(String modelId, Set<String> metaCols) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"mrp_caculate_log");
        Long id = ORM.create().genLongId((IDataEntityType)mainEntityType);
        IMRPEnvProvider ctx = this.createNewLog(id);
        DynamicRowSet rowSet = new KDCloudDataFetcher(ctx).fetchDatas(modelId, metaCols);
        HashMap<String, ArrayList<Object[]>> dataMap = rowSet.getRows();
        if (dataMap.isEmpty()) {
            try (DataSet ds = rowSet.getData();){
                String[] metas = rowSet.getMetas();
                StringBuilder metaKey = new StringBuilder();
                for (Row data : ds) {
                    Object[] row = new Object[metas.length];
                    metaKey.setLength(0);
                    for (int i = 0; i < row.length; ++i) {
                        Object val;
                        String label = metas[i];
                        row[i] = val = data.get(label);
                        if (!metaCols.contains(label)) continue;
                        if (metaKey.length() != 0) {
                            metaKey.append('\u0001');
                        }
                        metaKey.append(row[i]);
                    }
                    ArrayList datas = dataMap.computeIfAbsent(metaKey.toString(), k -> new ArrayList());
                    datas.add(row);
                }
            }
        }
        String[] fieldFlags = rowSet.getMetas();
        ArrayList<String[]> fieldLists = new ArrayList<String[]>(2);
        fieldLists.add(fieldFlags);
        dataMap.put("MetaCols", fieldLists);
        DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])new Object[]{id});
        return dataMap;
    }

    private IMRPEnvProvider createNewLog(Long id) {
        DynamicObject caculateLog = ORM.create().newDynamicObject("mrp_caculate_log");
        caculateLog.set("id", (Object)id);
        caculateLog.set("number", (Object)"jstest1234");
        caculateLog.set("createorg", (Object)OrgUnitServiceHelper.getRootOrgId());
        caculateLog.set("useorg", (Object)OrgUnitServiceHelper.getRootOrgId());
        caculateLog.set("runtype", (Object)"A");
        caculateLog.set("plandate", (Object)new Date());
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set("dataversion", (Object)0L);
        IMRPEnvProvider env = MRPIntegrateFactory.createMRPEnv(caculateLog);
        return env;
    }
}

