/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.fetch;

import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;

public class NetChangeReleaseComparator
implements Comparator<DynamicObject> {
    private final List<BFRow> bfRows;
    private final String billKey;
    private final String billEntryKey;

    public NetChangeReleaseComparator(List<BFRow> bfRows, String billKey, String billEntryKey) {
        this.bfRows = bfRows;
        this.billKey = billKey;
        this.billEntryKey = billEntryKey;
    }

    @Override
    public int compare(DynamicObject o1, DynamicObject o2) {
        Long bal_id1 = o1.getLong(this.billKey);
        Long bal_entryid1 = o1.getLong(this.billEntryKey);
        if (bal_entryid1 <= 0L) {
            bal_entryid1 = bal_id1;
        }
        Long bal_id2 = o2.getLong(this.billKey);
        Long bal_entryid2 = o2.getLong(this.billEntryKey);
        if (bal_entryid2 <= 0L) {
            bal_entryid2 = bal_id2;
        }
        for (BFRow rfRow : this.bfRows) {
            BFRowId sid = rfRow.getSId();
            Long billId = sid.getBillId();
            Long entryId = sid.getEntryId();
            if (entryId == null || entryId <= 0L) {
                entryId = billId;
            }
            if (bal_id1.equals(billId) && bal_entryid1.equals(entryId)) {
                return -1;
            }
            if (!bal_id2.equals(billId) || !bal_entryid2.equals(entryId)) continue;
            return 1;
        }
        return 0;
    }
}

