/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CalcLogUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Object log;
        UpgradeResult result = new UpgradeResult();
        QFilter qFilter = new QFilter("runtype", "=", (Object)"A");
        qFilter.and(new QFilter("programnumber", "=", (Object)""));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mrp_caculate_log", (String)"id,plangram,programnumber,programname", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, List> map = new HashMap<Long, List>(16);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            log = dynamicObjects[i];
            long planId = log.getLong("plangram");
            if (planId <= 0L) continue;
            List list = map.getOrDefault(planId, new ArrayList(16));
            list.add(log);
            map.put(planId, list);
        }
        qFilter = new QFilter("id", "in", map.keySet());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"mrp_planprogram", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, null);
        log = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong(0);
                String number = row.getString(1);
                String name = row.getString(2);
                List list = (List)map.get(id);
                if (list == null) continue;
                this.updateNumberAndName(number, name, list);
            }
        }
        catch (Throwable throwable) {
            log = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (log != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)log).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            SaveServiceHelper.update((DynamicObject[])((List)entry.getValue()).toArray(new DynamicObject[0]));
        }
        result.setSuccess(true);
        result.setLog("CalcLog update success");
        return result;
    }

    private void updateNumberAndName(String number, String name, List<DynamicObject> list) {
        for (DynamicObject data : list) {
            data.set("programnumber", (Object)number);
            data.set("programname", (Object)name);
        }
    }
}

