/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.integrate.KDCloudCPSEnv;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.struct.ReplaceMaterialStruct;
import kd.mmc.mrp.model.struct.ReplaceStruct;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.utils.MRPUtil;

public class CPSUtil {
    public static BigDecimal min(BigDecimal alreadyQty, BigDecimal currentQty) {
        int cmp = alreadyQty.compareTo(currentQty);
        if (cmp > 0) {
            return currentQty;
        }
        return alreadyQty;
    }

    public static void tagBOMNotFound(RequireRowData reqData) {
        CPSUtil.tagException(reqData, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5236\u9020BOM", (String)"CPSRequireStatNode_1", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]), "30");
    }

    public static void tagBOMEntrysNotFound(RequireRowData reqData) {
        CPSUtil.tagException(reqData, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728BOM\u7ec4\u4ef6", (String)"CPSRequireStatNode_2", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]), "30");
    }

    public static void tagException(RequireRowData reqData, String msg, String code) {
        msg = MRPUtil.appendExceptionMsg(reqData.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), msg);
        reqData.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)msg);
        String number = MRPUtil.appendExceptionMsg(reqData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), code);
        reqData.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)number);
    }

    public static void refreshReserveMapping(KDCloudCPSEnv ctx, RequirementDataTable requireTbl, SupplymentDataTable supplyTbl) {
        PlanModel pm = (PlanModel)ctx.getService(PlanModel.class);
        if (!pm.isReserve()) {
            return;
        }
        Set<String> enableMaterialIds = ctx.getEnableMaterialIds();
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        for (String materialId : enableMaterialIds) {
            String cacheKey = MRPRuntimeConsts.getReserveRecordSplitKey(ctx.getMRPContextId(), materialId);
            String jsonStr = MRPCacheManager.getInst().getSubData(ctx, "reserve_record", cacheKey);
            if (!StringUtils.isNotBlank((CharSequence)jsonStr)) continue;
            datas.addAll(JSON.parseArray((String)jsonStr, Object[].class));
        }
        if (!datas.isEmpty()) {
            supplyTbl.refreshReserveMapping(requireTbl, datas);
        }
    }

    public static int batchExecuteSql(List<Map<String, Object>> details, Long headId, String entity, boolean isDetail) {
        IDataEntityType dt = ORM.create().newDynamicObject(entity).getDataEntityType();
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ");
        sql.append(dt.getAlias());
        sql.append(" (");
        sql.append("fid,fentryid,fmaterial,fsuppriority,fsupmaterial,");
        sql.append("fmaterialattr,fsupplyqty,fdemandqty,fsrcdemandqty,frequireorgid,");
        sql.append("fdemandbilltype,fdemandbillf7,fbillno,fdemanddate,fbillid,");
        sql.append("fbillentryid,fbillentryseq,fexception,fexceptionnumber,fsupplyorgid,");
        sql.append("fsupplybilltype,fsupplybillf7,fsupplybillno,fsupplydate,fsupplybillid,");
        sql.append("fsupplybillentryid,fsupplybillentryseq,fishandle,fbomversion,freqpriority,");
        sql.append("fsexpmsg,fsexpnumber,fwarehouseid,flocationid,finvpriority,");
        sql.append("fllc,fparentbomid,fbomid,feditdate,feditreason,");
        sql.append("fyieldratio,fscrapratio,fdynamicscrapratio,ffixscrap,fdynamicscrapformula,");
        sql.append("fconfiguredcode,ftracknumber,fsuptracknumber,fdemandauxpty,fsupplyauxpty,");
        sql.append("fsupplydetail,fdemandproject,fsupplyproject,fadjustqty,fdemandwarehouse,");
        sql.append("fdemandplanscope,fsupplyplanscope,fmergebillno,fmergebillentryseq,forigindemanddate,");
        sql.append("fworkcenter,foperationno,foperationdesc,foperationid,fiskeypart,");
        sql.append("fexistkeypart,fisreseve,fsupplierid,freplaceplanid,fisreplace,");
        sql.append("freplacepriority,fismainreplace,fisvirtual");
        if (isDetail) {
            sql.append(",ftopmaterial,ffullsetstatus,fsupmaterialattr,fsupconfigcode");
        }
        sql.append(") values (");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?");
        if (isDetail) {
            sql.append(",?,?,?,?");
        }
        sql.append(")");
        int count = details.size();
        ArrayList<Object[]> valueList = new ArrayList<Object[]>(count);
        long[] genLongIds = ORM.create().genLongIds(dt, details.size());
        for (int i = 0; i < count; ++i) {
            Map<String, Object> map = details.get(i);
            Object[] values = new Object[isDetail ? 77 : 73];
            values[0] = headId;
            values[1] = genLongIds[i];
            values[2] = MRPUtil.convert(map.get("material"), 0L);
            values[3] = MRPUtil.convert(map.get("suppriority"), "");
            values[4] = MRPUtil.convert(map.get("supmaterial"), 0L);
            values[5] = MRPUtil.convert(map.get("materialattr"), "");
            values[6] = MRPUtil.convert(map.get("supplyqty"), BigDecimal.ZERO);
            values[7] = MRPUtil.convert(map.get("demandqty"), BigDecimal.ZERO);
            values[8] = MRPUtil.convert(map.get("srcdemandqty"), BigDecimal.ZERO);
            values[9] = MRPUtil.convert(map.get("requireorg"), 0L);
            values[10] = MRPUtil.convert(map.get("demandbilltype"), "");
            values[11] = MRPUtil.convert(map.get("demandbillf7"), "");
            values[12] = MRPUtil.convert(map.get("billno"), "");
            values[13] = map.get("demanddate") == null ? null : new Date((Long)map.get("demanddate"));
            values[14] = MRPUtil.convert(map.get("billid"), "");
            values[15] = MRPUtil.convert(map.get("billentryid"), "");
            values[16] = MRPUtil.convert(map.get("billentryseq"), 0);
            values[17] = MRPUtil.convert(map.get("exception"), "");
            values[18] = MRPUtil.convert(map.get("exceptionnumber"), "");
            values[19] = MRPUtil.convert(map.get("supplyorg"), 0L);
            values[20] = MRPUtil.convert(map.get("supplybilltype"), "");
            values[21] = MRPUtil.convert(map.get("supplybillf7"), "");
            values[22] = MRPUtil.convert(map.get("supplybillno"), "");
            values[23] = map.get("supplydate") == null ? null : new Date((Long)map.get("supplydate"));
            values[24] = MRPUtil.convert(map.get("supplybillid"), "");
            values[25] = MRPUtil.convert(map.get("supplybillentryid"), "");
            values[26] = MRPUtil.convert(map.get("supplybillentryseq"), 0);
            values[27] = MRPUtil.convert(map.get("ishandle"), false);
            values[28] = MRPUtil.convert(map.get("bomversion"), 0L);
            values[29] = MRPUtil.convert(map.get("reqpriority"), "");
            values[30] = MRPUtil.convert(map.get("sexpmsg"), "");
            values[31] = MRPUtil.convert(map.get("sexpnumber"), "");
            values[32] = MRPUtil.convert(map.get("warehouse"), 0L);
            values[33] = MRPUtil.convert(map.get("location"), 0L);
            values[34] = MRPUtil.convert(map.get("invpriority"), "");
            values[35] = MRPUtil.convert(map.get("llc"), "");
            values[36] = MRPUtil.convert(map.get("parentbomid"), "");
            values[37] = MRPUtil.convert(map.get("bomid"), "");
            values[38] = map.get("editdate") == null ? null : new Date((Long)map.get("editdate"));
            values[39] = MRPUtil.convert(map.get("editreason"), "");
            values[40] = MRPUtil.convert(map.get("yieldratio"), BigDecimal.ZERO);
            values[41] = MRPUtil.convert(map.get("scrapratio"), BigDecimal.ZERO);
            values[42] = MRPUtil.convert(map.get("dynamicscrapratio"), BigDecimal.ZERO);
            values[43] = MRPUtil.convert(map.get("fixscrap"), BigDecimal.ZERO);
            values[44] = MRPUtil.convert(map.get("dynamicscrapformula"), "");
            values[45] = MRPUtil.convert(map.get("configuredcode"), 0L);
            values[46] = MRPUtil.convert(map.get("tracknumber"), 0L);
            values[47] = MRPUtil.convert(map.get("suptracknumber"), 0L);
            values[48] = MRPUtil.convert(map.get("demandauxpty"), 0L);
            values[49] = MRPUtil.convert(map.get("supplyauxpty"), 0L);
            values[50] = MRPUtil.convert(map.get("supplydetail"), "");
            values[51] = MRPUtil.convert(map.get("demandproject"), 0L);
            values[52] = MRPUtil.convert(map.get("supplyproject"), 0L);
            values[53] = MRPUtil.convert(map.get("adjustqty"), BigDecimal.ZERO);
            values[54] = MRPUtil.convert(map.get("demandwarehouse"), 0L);
            values[55] = MRPUtil.convert(map.get("demandplanscope"), 0L);
            values[56] = MRPUtil.convert(map.get("supplyplanscope"), 0L);
            values[57] = MRPUtil.convert(map.get("mergebillno"), "");
            values[58] = MRPUtil.convert(map.get("mergebillentryseq"), 0);
            values[59] = map.get("origindemanddate") == null ? null : new Date((Long)map.get("origindemanddate"));
            values[60] = MRPUtil.convert(map.get("workcenter"), 0L);
            values[61] = MRPUtil.convert(map.get("operationno"), "");
            values[62] = MRPUtil.convert(map.get("operationdesc"), "");
            values[63] = MRPUtil.convert(map.get("operation"), 0L);
            Boolean isKeyPart = MRPUtil.convert(map.get("iskeypart"), false);
            values[64] = isKeyPart;
            values[65] = MRPUtil.convert(map.get("existkeypart"), false);
            values[66] = MRPUtil.convert(map.get("isreseve"), false);
            values[67] = MRPUtil.convert(map.get("supplysupplier"), 0L);
            values[68] = MRPUtil.convert(map.get("replaceplan"), 0L);
            values[69] = MRPUtil.convert(map.get("isreplace"), false);
            values[70] = MRPUtil.convert(map.get("replacepriority"), 0);
            values[71] = MRPUtil.convert(map.get("ismianreplace"), false);
            values[72] = MRPUtil.convert(map.get("isvirtual"), false);
            if (isDetail) {
                values[73] = MRPUtil.convert(map.get("topmaterial"), 0L);
                values[74] = MRPUtil.convert(map.get("fullsetstatus"), "");
                values[75] = MRPUtil.convert(map.get("supmaterialattr"), "");
                values[76] = MRPUtil.convert(map.get("supconfigcode"), 0L);
            }
            valueList.add(values);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), valueList);
        details.clear();
        return count;
    }

    public static int getDetailSaveBatch(IMRPEnvProvider ctx) {
        int batch = (Integer)ctx.getCfgValue(EnvCfgItem.DETAIL_SAVING_BATCH);
        if (batch <= 0) {
            batch = 5000;
        }
        return batch;
    }

    public static Map<String, ReplaceStruct> getReplaceMap(IMRPEnvProvider ctx, List<RequireRowData> tmpBomChildren) {
        Long auxpty;
        String material;
        HashMap<String, ReplaceStruct> replaceMap = new HashMap<String, ReplaceStruct>();
        if (!ctx.isReplace()) {
            return replaceMap;
        }
        HashMap<String, List> groupMap = new HashMap<String, List>();
        ArrayList<RequireRowData> copyList = new ArrayList<RequireRowData>(tmpBomChildren);
        Iterator<RequireRowData> it = tmpBomChildren.iterator();
        while (it.hasNext()) {
            RequireRowData rowData = it.next();
            String string = String.valueOf(rowData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
            if (DynamicObjDataUtil.isNullStringOr0Long((String)string)) continue;
            String replacestra = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.REPLACESTRA.getName()), "");
            String replacemethod = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.REPLACEMETHOD.getName()), "");
            ReplaceStruct replaceStruct = (ReplaceStruct)replaceMap.get(string);
            if (replaceStruct == null) {
                replaceStruct = new ReplaceStruct();
                replaceStruct.setReplaceMethod(replacemethod);
                replaceStruct.setReplaceStra(replacestra);
                replaceStruct.setReplaceMs(new ArrayList<ReplaceMaterialStruct>());
                replaceMap.put(string, replaceStruct);
            }
            Boolean isMain = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()), false);
            Boolean isReplace = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.ISREPLACE.getName()), false);
            Integer replacepriority = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()), 0);
            if (isReplace.booleanValue()) {
                String key = string + "\u0001" + replacepriority;
                groupMap.computeIfAbsent(key, k -> new ArrayList()).add(rowData);
                it.remove();
                continue;
            }
            ReplaceMaterialStruct struct = replaceStruct.getMainReplaceM();
            if (struct == null) {
                struct = new ReplaceMaterialStruct();
                struct.setPriority(replacepriority);
                struct.setRepMaterials(new HashMap<String, RequireRowData>());
                replaceStruct.setMainReplaceM(struct);
            }
            material = rowData.getString(DefaultField.RequireField.MATERIAL.getName());
            if (isMain.booleanValue()) {
                auxpty = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
                struct.setMaterial(material);
                struct.setMaterialAuxproperty(auxpty);
                struct.setRequireRowData(rowData);
                continue;
            }
            struct.getRepMaterials().put(material, rowData);
            it.remove();
        }
        for (Map.Entry entry : groupMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] split = key.split("\u0001");
            List value = (List)entry.getValue();
            ReplaceStruct replaceStruct = (ReplaceStruct)replaceMap.get(split[0]);
            ReplaceMaterialStruct struct = new ReplaceMaterialStruct();
            struct.setPriority(Integer.valueOf(split[1]));
            struct.setRepMaterials(new HashMap<String, RequireRowData>());
            for (RequireRowData rowData : value) {
                material = rowData.getString(DefaultField.RequireField.MATERIAL.getName());
                auxpty = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
                Boolean isMain = MRPUtil.convert(rowData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()), false);
                if (isMain.booleanValue()) {
                    struct.setMaterial(material);
                    struct.setMaterialAuxproperty(auxpty);
                    struct.setRequireRowData(rowData);
                    continue;
                }
                struct.getRepMaterials().put(material, rowData);
            }
            replaceStruct.getReplaceMs().add(struct);
        }
        Iterator iterator = replaceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ReplaceStruct struct = (ReplaceStruct)entry.getValue();
            if ("1004".equals(struct.getReplaceStra())) {
                iterator.remove();
                continue;
            }
            if (struct.getMainReplaceM() == null) {
                iterator.remove();
                continue;
            }
            if (struct.getReplaceMs().isEmpty()) {
                iterator.remove();
                continue;
            }
            struct.getReplaceMs().sort((o1, o2) -> o1.getPriority() - o2.getPriority());
            if (struct.getMainReplaceM().getRequireRowData().getValue(DefaultField.RequireField.USERATIO.getName()) != null) continue;
            struct.getMainReplaceM().getRequireRowData().update(DefaultField.RequireField.USERATIO.getName(), (Object)new BigDecimal(100));
        }
        tmpBomChildren.sort(new Comparator<RequireRowData>(){

            @Override
            public int compare(RequireRowData o1, RequireRowData o2) {
                Long replacePlanId1 = MRPUtil.convert(o1.getValue(DefaultField.RequireField.REPLACEPLAN.getName()), 0L);
                Long replacePlanId2 = MRPUtil.convert(o2.getValue(DefaultField.RequireField.REPLACEPLAN.getName()), 0L);
                Long material1 = MRPUtil.convert(o1.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L);
                Long material2 = MRPUtil.convert(o2.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L);
                Boolean isReplace1 = MRPUtil.convert(o1.getValue(DefaultField.RequireField.ISREPLACE.getName()), false);
                Boolean isReplace2 = MRPUtil.convert(o2.getValue(DefaultField.RequireField.ISREPLACE.getName()), false);
                if (replacePlanId1.equals(0L) && replacePlanId2.equals(0L)) {
                    return material1.compareTo(material2);
                }
                if (replacePlanId1.equals(0L) && !replacePlanId2.equals(0L)) {
                    return -1;
                }
                if (!replacePlanId1.equals(0L) && replacePlanId2.equals(0L)) {
                    return 1;
                }
                if (isReplace1.booleanValue() && !isReplace2.booleanValue()) {
                    return 1;
                }
                if (!isReplace1.booleanValue() && isReplace2.booleanValue()) {
                    return -1;
                }
                return material1.compareTo(material2);
            }
        });
        if (replaceMap.isEmpty()) {
            tmpBomChildren.clear();
            tmpBomChildren.addAll(copyList);
        }
        return replaceMap;
    }
}

