/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.OperationContextCreator;
import kd.bos.eye.api.memobj.Meminfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;

public class MRPCalcStateManager {
    private final String mrpContextId;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private final String stateKey;
    private final String exceptionKey;
    private final String keepAliveKey;
    private static final String STATE_TERMINATED = "terminated";
    private static final String STATE_MASTER_TERMINATED = "master_terminated";
    private static final String STATE_MANUTERMINATED = "manu_terminated";
    private CallBack callback;
    private int masterCheckPeriod = 10000;
    private int workerCheckPeriod = 10000;
    private int masterKeepAlivePeriod = 30000;
    private long masterKeepAliveTimeout = 78000L;
    private Timer timer = null;
    private Timer keepAliveTimer = null;
    private TimerTask workerTimeTask = new TimerTask(){

        @Override
        public void run() {
            if (MRPCalcStateManager.this.isMasterTerminated()) {
                MRPCalcStateManager.this.callback.masterTerminated();
                MRPCalcStateManager.this.stopWorkerThread();
            } else if (MRPCalcStateManager.this.isMasterLost()) {
                MRPCalcStateManager.this.callback.masterLost();
                MRPCalcStateManager.this.stopWorkerThread();
            }
        }
    };
    private TimerTask masterTimeTask = new TimerTask(){

        @Override
        public void run() {
            if (MRPCalcStateManager.this.isWorkerTerminated()) {
                MRPCalcStateManager.this.callback.workerTerminated();
                runners.remove(MRPCalcStateManager.this.mrpContextId);
                MRPCalcStateManager.this.timer.cancel();
            }
            if (MRPCalcStateManager.this.isManuTerminated()) {
                MRPCalcStateManager.this.callback.manuTerminated();
                runners.remove(MRPCalcStateManager.this.mrpContextId);
                MRPCalcStateManager.this.timer.cancel();
            }
        }
    };
    private TimerTask keepAliveTimeTask = new TimerTask(){

        @Override
        public void run() {
            MRPCalcStateManager.this.setKeepAlive();
        }
    };
    private static Set<String> runners = new HashSet<String>();
    private static final Log logger = LogFactory.getLog(MRPCalcStateManager.class);
    private static final Pattern pattern = Pattern.compile("[\\S]+");
    private static final String MAGIC = "/";
    private static int PID = -1;

    public MRPCalcStateManager(String mrpContextId, CallBack callback) {
        this.mrpContextId = mrpContextId;
        this.stateKey = this.makeStateKey();
        this.exceptionKey = this.makeExceptionKey();
        this.keepAliveKey = this.makeKeepAliveKey();
        this.callback = callback;
    }

    private static String makeStateKey(String ctxId) {
        return "mrpcalc-state-" + ctxId;
    }

    private String makeStateKey() {
        return "mrpcalc-state-" + this.mrpContextId;
    }

    private String makeExceptionKey() {
        return "mrpcalc-exception-" + this.mrpContextId;
    }

    private String makeKeepAliveKey() {
        return "mrpcalc-keepalive-" + this.mrpContextId;
    }

    public void startWorkerCheckThread() {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(this.workerTimeTask, this.workerCheckPeriod, (long)this.workerCheckPeriod);
    }

    public void startMasterCheckThread() {
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(this.masterTimeTask, this.masterCheckPeriod, (long)this.masterCheckPeriod);
        this.keepAliveTimer = new Timer();
        this.keepAliveTimer.scheduleAtFixedRate(this.keepAliveTimeTask, 10L, (long)this.masterKeepAlivePeriod);
        this.setKeepAlive();
    }

    public void stopWorkerThread() {
        if (this.timer != null) {
            runners.remove(this.mrpContextId);
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void stopMasterWorker() {
        if (this.timer != null) {
            runners.remove(this.mrpContextId);
            this.timer.cancel();
            this.timer = null;
            this.keepAliveTimer.cancel();
            this.keepAliveTimer = null;
        }
    }

    private void setKeepAlive() {
        cache.put(this.keepAliveKey, (Object)("" + System.currentTimeMillis()));
    }

    public boolean isMasterLost() {
        String value = (String)cache.get(this.keepAliveKey);
        if (value == null) {
            return true;
        }
        long timestamp = Long.parseLong(value);
        return System.currentTimeMillis() - timestamp > this.masterKeepAliveTimeout;
    }

    public boolean isMasterTerminated() {
        String value = (String)cache.get(this.stateKey);
        return STATE_MASTER_TERMINATED.equals(value);
    }

    public boolean isWorkerTerminated() {
        String value = (String)cache.get(this.stateKey);
        return value != null && STATE_TERMINATED.equals(value);
    }

    public String getTerminatedException() {
        return (String)cache.get(this.exceptionKey);
    }

    public void setTerminated(String exception) {
        if (cache.get(this.stateKey) == null) {
            cache.put(this.stateKey, (Object)STATE_TERMINATED);
            if (exception == null) {
                cache.put(this.exceptionKey, (Object)exception);
            }
        }
    }

    public void setMasterTerminated() {
        cache.put(this.stateKey, (Object)STATE_MASTER_TERMINATED);
    }

    public boolean isManuTerminated() {
        String value = (String)cache.get(this.stateKey);
        return value != null && STATE_MANUTERMINATED.equals(value);
    }

    public static void setManuTerminated(String ctxId) {
        cache.put(MRPCalcStateManager.makeStateKey(ctxId), (Object)STATE_MANUTERMINATED);
    }

    public void startMemoryCheckThread(final long sleepTime) {
        if (!runners.isEmpty()) {
            runners.add(this.mrpContextId);
            return;
        }
        runners.add(this.mrpContextId);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!runners.isEmpty()) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        logger.error("mrprunner-gc-thread-failed", (Throwable)e);
                    }
                    MRPCalcStateManager.doFullGC();
                }
            }
        }).start();
    }

    public static void doFullGC() {
        OperationContextCreator.getOrCreateForBos();
        if (PID < 0) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String name = runtime.getName();
                PID = Integer.parseInt(name.substring(0, name.indexOf(64)));
            }
            catch (Exception e) {
                logger.error("mrprunner-get-pid-error:", (Throwable)e);
                PID = 0;
                return;
            }
        }
        String params = " -histo:live ";
        try {
            String cmdPath = ConfigurationUtil.getString((String)"JAVA_HOME");
            String cmd = cmdPath.endsWith(MAGIC) ? cmdPath + "bin/jmap" + params + PID : cmdPath + "/bin/jmap" + params + PID;
            Process ps = Runtime.getRuntime().exec(cmd);
            try (InputStream inputStream = ps.getInputStream();
                 InputStreamReader isr = new InputStreamReader(inputStream);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                boolean startinfo = false;
                while ((line = br.readLine()) != null) {
                    if (line.contains("--------------")) {
                        startinfo = true;
                        continue;
                    }
                    if (!startinfo || line.contains("Total") && !line.contains(":")) continue;
                    Matcher matcher = pattern.matcher(line);
                    int index = 1;
                    Meminfo info = new Meminfo();
                    while (matcher.find()) {
                        if (index == 2) {
                            info.setInstances(Integer.parseInt(matcher.group()));
                        }
                        if (index == 3) {
                            info.setBytes(Long.parseLong(matcher.group()));
                        }
                        if (index == 4) {
                            info.setClsName(matcher.group());
                        }
                        ++index;
                    }
                }
            }
        }
        catch (Throwable iex) {
            logger.error("mrprunner-fullgc-error:", iex);
        }
    }

    public static interface CallBack {
        public void workerTerminated();

        public void masterTerminated();

        public void masterLost();

        public void manuTerminated();
    }
}

