/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.mq.IMRPEventManager;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.enums.status.PlanOrderStatus;
import kd.mmc.mrp.utils.ReserveUtil;

public class MRPClearDataUtil {
    public static List<QFilter> getMRPClearHistoryDataFilter(IMRPEnvProvider ctx, QFilter filterRequireOrg, QFilter filterSupplyOrg) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        QFilter dataSourceFilter = new QFilter("datasource", "=", (Object)"B");
        MtPlanInfoModel planInfo = (MtPlanInfoModel)ctx.getService(MtPlanInfoModel.class);
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        List<String> planmode = planInfo.getPlanType();
        QFilter plantagsfilter = null;
        List<Long> list = planModel.getAllPlanTags();
        plantagsfilter = !list.isEmpty() ? new QFilter("materialplanid.plantags", "in", list) : new QFilter("materialplanid.plantags", "=", (Object)0L);
        QFilter filterPlanMode = new QFilter("materialplanid.planmode", "in", planmode);
        qFilters.add(dataSourceFilter);
        qFilters.add(filterRequireOrg);
        qFilters.add(filterSupplyOrg);
        qFilters.add(filterPlanMode);
        qFilters.add(plantagsfilter);
        ArrayList<String> billStatus = new ArrayList<String>(2);
        billStatus.add(PlanOrderStatus.SAVED.getValue());
        billStatus.add(PlanOrderStatus.SUBMITED.getValue());
        QFilter status = new QFilter("billstatus", "in", billStatus);
        qFilters.add(status);
        return qFilters;
    }

    public static List<QFilter> getDeleteAuditBillFilters(List<QFilter> qFilters, List<QFilter> qFilterList, List<String> orderTypes) {
        int index = qFilters.size() - 1;
        QFilter qFilterDropStatus = new QFilter("billstatus", "=", (Object)PlanOrderStatus.AUDITED.getValue());
        qFilterDropStatus.and("dropstatus", "in", (Object)new String[]{" ", "A", "B", "E"});
        qFilterDropStatus.and("ordertype", "in", orderTypes);
        ArrayList<QFilter> newqFilterList = new ArrayList<QFilter>(qFilterList);
        newqFilterList.set(index, qFilterDropStatus);
        return newqFilterList;
    }

    public static void addCollaborativeorderBillStatusFilter(List<QFilter> qFilterList) {
        QFilter qFilter = null;
        for (QFilter q : qFilterList) {
            if (!"billstatus".equals(q.getProperty())) continue;
            qFilter = q;
            break;
        }
        if (qFilter != null && qFilter.getValue() instanceof List) {
            List billStatus = (List)qFilter.getValue();
            billStatus.add("F");
        }
    }

    public static int[] clearHisData(DataSet dataset, IMRPEnvProvider ctx, String outputType, String modelId, Class<?> c) {
        int clearCount = 0;
        int clearEntryCount = 0;
        int clearBatch = (Integer)ctx.getCfgValue(EnvCfgItem.PLAN_ORDER_CLEAR_BATCH);
        IMRPEventManager mqManager = (IMRPEventManager)ctx.getService(IMRPEventManager.class);
        IMRPExecuteLogRecorder logRecorder = ctx.createLogRecorder();
        HashSet<Long> ids = new HashSet<Long>(clearBatch);
        boolean isClearPlanOrder = "po-clear".equals(modelId);
        while (dataset.hasNext()) {
            Long id = dataset.next().getLong("id");
            ids.add(id);
            ++clearCount;
            if (ids.size() < clearBatch) continue;
            if (isClearPlanOrder) {
                clearEntryCount += MRPClearDataUtil.publicPlanOrderClearEvent(ctx, mqManager, logRecorder, outputType, ids, modelId, c, clearBatch);
                continue;
            }
            MRPClearDataUtil.publicClearEvent(ctx, mqManager, logRecorder, ids, modelId, c);
        }
        if (ids.size() > 0) {
            if (isClearPlanOrder) {
                clearEntryCount += MRPClearDataUtil.publicPlanOrderClearEvent(ctx, mqManager, logRecorder, outputType, ids, modelId, c, clearBatch);
            } else {
                MRPClearDataUtil.publicClearEvent(ctx, mqManager, logRecorder, ids, modelId, c);
            }
        }
        return new int[]{clearCount, clearEntryCount};
    }

    public static int[] clearHisData(Set<Long> deleteIds, IMRPEnvProvider ctx, String outputType, String modelId, Class<?> c, boolean noUpdateRunLog) {
        int clearCount = 0;
        int clearEntryCount = 0;
        int clearBatch = (Integer)ctx.getCfgValue(EnvCfgItem.PLAN_ORDER_CLEAR_BATCH);
        IMRPEventManager mqManager = (IMRPEventManager)ctx.getService(IMRPEventManager.class);
        IMRPExecuteLogRecorder logRecorder = ctx.createLogRecorder();
        HashSet<Long> ids = new HashSet<Long>();
        boolean isClearPlanOrder = "po-clear".equals(modelId);
        for (Long id : deleteIds) {
            ids.add(id);
            ++clearCount;
            if (ids.size() < clearBatch) continue;
            if (isClearPlanOrder) {
                clearEntryCount += MRPClearDataUtil.publicPlanOrderClearEvent(ctx, mqManager, logRecorder, outputType, ids, modelId, c, clearBatch, noUpdateRunLog);
                continue;
            }
            MRPClearDataUtil.publicClearEvent(ctx, mqManager, logRecorder, ids, modelId, c, noUpdateRunLog);
        }
        if (ids.size() > 0) {
            if (isClearPlanOrder) {
                clearEntryCount += MRPClearDataUtil.publicPlanOrderClearEvent(ctx, mqManager, logRecorder, outputType, ids, modelId, c, clearBatch, noUpdateRunLog);
            } else {
                MRPClearDataUtil.publicClearEvent(ctx, mqManager, logRecorder, ids, modelId, c, noUpdateRunLog);
            }
        }
        return new int[]{clearCount, clearEntryCount};
    }

    private static int publicPlanOrderClearEvent(IMRPEnvProvider ctx, IMRPEventManager mqManager, IMRPExecuteLogRecorder logRecorder, String outputType, Set<Long> ids, String modelId, Class<?> c, int clearBatch) {
        return MRPClearDataUtil.publicPlanOrderClearEvent(ctx, mqManager, logRecorder, outputType, ids, modelId, c, clearBatch, false);
    }

    private static int publicPlanOrderClearEvent(IMRPEnvProvider ctx, IMRPEventManager mqManager, IMRPExecuteLogRecorder logRecorder, String outputType, Set<Long> ids, String modelId, Class<?> c, int clearBatch, boolean noUpdateRunLog) {
        HashMap<Long, Integer> po2EntrySize = new HashMap<Long, Integer>(ids.size());
        int clearEntryCount = 0;
        try (DataSet dataSetEntry = QueryServiceHelper.queryDataSet((String)"MRP-PLANORDER-CLEANER", (String)outputType, (String)"id, entryentity.id entryid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null).filter("entryid > 0L");){
            for (Row row : dataSetEntry) {
                Long l = row.getLong(0);
                ids.remove(l);
                int clearEntry = po2EntrySize.getOrDefault(l, 0);
                po2EntrySize.put(l, ++clearEntry);
                ++clearEntryCount;
            }
        }
        int clearEntry = 0;
        HashSet<Long> newIds = new HashSet<Long>(clearBatch);
        ArrayList list = new ArrayList(po2EntrySize.entrySet());
        list.sort((o1, o2) -> (Integer)o2.getValue() - (Integer)o1.getValue());
        for (Map.Entry entry : list) {
            if ((Integer)entry.getValue() >= clearBatch) {
                HashSet<Long> singleton = new HashSet<Long>(1);
                singleton.add((Long)entry.getKey());
                MRPClearDataUtil.publicClearEvent(ctx, mqManager, logRecorder, singleton, modelId, c, noUpdateRunLog);
                continue;
            }
            newIds.add((Long)entry.getKey());
            if (newIds.size() + (clearEntry += ((Integer)entry.getValue()).intValue()) < clearBatch) continue;
            MRPClearDataUtil.publicClearEvent(ctx, mqManager, logRecorder, newIds, modelId, c, noUpdateRunLog);
            clearEntry = 0;
        }
        if (newIds.size() > 0) {
            MRPClearDataUtil.publicClearEvent(ctx, mqManager, logRecorder, newIds, modelId, c, noUpdateRunLog);
        }
        if (ids.size() > 0) {
            MRPClearDataUtil.publicClearEvent(ctx, mqManager, logRecorder, ids, modelId, c, noUpdateRunLog);
        }
        return clearEntryCount;
    }

    private static void publicClearEvent(IMRPEnvProvider ctx, IMRPEventManager mqManager, IMRPExecuteLogRecorder logRecorder, Set<Long> ids, String modelId, Class<?> c) {
        MRPClearDataUtil.publicClearEvent(ctx, mqManager, logRecorder, ids, modelId, c, false);
    }

    private static void publicClearEvent(IMRPEnvProvider ctx, IMRPEventManager mqManager, IMRPExecuteLogRecorder logRecorder, Set<Long> ids, String modelId, Class<?> c, boolean noUpdateRunLog) {
        MRPEvent evt = null;
        try {
            evt = (MRPEvent)c.newInstance();
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("MRP-PLANORDER-CLEANER", e.getMessage()), new Object[0]);
        }
        evt.setParam(MultiThreadCacheKey.KEY_MATERIAL_ROWS, (Serializable)((Object)JSON.toJSONString(ids, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})));
        evt.setParam(MultiThreadCacheKey.KEY_MODEL_ID, (Serializable)((Object)modelId));
        if (noUpdateRunLog) {
            evt.setParam(MultiThreadCacheKey.KEY_IS_NOT_UPDATE_RUNLOG, Boolean.valueOf(true));
        }
        evt.setMrpContextId(ctx.getMRPContextId());
        evt.setRecorder(logRecorder);
        ReserveUtil.reserveRemoveByBillId(ids, ctx.getRunLogNumber());
        mqManager.publishCalcEvent(evt);
        ids.clear();
    }
}

