/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.mmc.mrp.common.util.DateUtils;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.MRPWorkCalendarManager;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.fomula.Expr;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.ResType;
import kd.mmc.mrp.model.enums.select.LeadType;
import kd.mmc.mrp.model.enums.strategy.BillSupplyStrategy;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.enums.strategy.MaterialPlanMode;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.model.table.utils.InvPlanUtil;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.mservice.batchpolicy.DirectBatchProcessor;
import kd.mmc.mrp.mservice.batchpolicy.FixedBatchProcessor;
import kd.mmc.mrp.vo.DynamicCycleVo;
import kd.mmc.mrp.vo.MergeCycleVo;

public class MRPUtil {
    private static final Log logger = LogFactory.getLog(MRPUtil.class);
    private static AtomicInteger eventCounter = new AtomicInteger();
    private static AtomicInteger eventIncCounter = new AtomicInteger();
    private static AtomicInteger eventDecCounter = new AtomicInteger();
    public static final Map<String, Object> emptyMapNotModify = Collections.emptyMap();
    private static final Map<String, DynamicObject> poTemplateMap = new ConcurrentHashMap<String, DynamicObject>(2);
    private static final Map<String, DynamicObject> collaborateTemplateMap = new ConcurrentHashMap<String, DynamicObject>(2);
    private static int cacheSplitSize = 50;
    private static int threadPoolSize = 1;
    private static boolean zipEnable = true;
    private static boolean singleHostUseJson = true;
    private static final BigDecimal MAX_QTY = new BigDecimal("10000000000000");

    public static void resetOnCount() {
        eventCounter.set(0);
        eventIncCounter.set(0);
        eventDecCounter.set(0);
    }

    public static void onPublished() {
        int c = eventIncCounter.incrementAndGet();
        int cur = eventCounter.incrementAndGet();
        logger.info("###onPublished, \u5171\u53d1\u5e03=" + c + ", \u73b0\u5b58=" + cur);
    }

    public static void onReponsed() {
        int c = eventDecCounter.incrementAndGet();
        int cur = eventCounter.decrementAndGet();
        logger.info("###onReponsed, \u5171\u8fd4\u56de=" + c + ", \u73b0\u5b58=" + cur);
    }

    public static IMRPEnvProvider clone(IMRPEnvProvider ctx) {
        if (MRPUtil.isByMQ()) {
            return ctx;
        }
        return ctx.copy();
    }

    public static Calendar createCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static SimpleDateFormat createSimpleDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static Date normalize(Date date) {
        SimpleDateFormat SDF_YYYY_MM_DD = MRPUtil.createSimpleDateFormat();
        String dateStr = SDF_YYYY_MM_DD.format(date);
        return MRPUtil.normalize(SDF_YYYY_MM_DD, dateStr);
    }

    public static Date normalize(SimpleDateFormat SDF_YYYY_MM_DD, String dateStr) {
        Date date;
        try {
            date = SDF_YYYY_MM_DD.parse(dateStr);
        }
        catch (ParseException e) {
            throw new MRPBizException(e, Errors.getDateFormatFailed());
        }
        return date;
    }

    public static boolean dateEquals(Calendar d1, Calendar d2) {
        if (d1 == null && d2 != null || d1 != null && d2 == null) {
            return false;
        }
        if (d1 == null && d2 == null) {
            return true;
        }
        return d1.get(1) == d2.get(1) && d1.get(2) == d2.get(2) && d1.get(5) == d2.get(5);
    }

    public static BigDecimal multiply(BigDecimal b1, BigDecimal b2) {
        BigDecimal bd = b1.multiply(b2);
        if (bd.scale() > 10) {
            return bd.setScale(10, 1);
        }
        return bd;
    }

    public static Boolean convert(Object src, Boolean defaultValue) {
        if (src == null) {
            return defaultValue;
        }
        if (src instanceof Boolean) {
            return (Boolean)src;
        }
        if (src instanceof Number) {
            Integer result = MRPUtil.convert(src, 0);
            if (result == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (src instanceof String) {
            return "1".equals(src.toString()) || "true".equalsIgnoreCase(src.toString());
        }
        return defaultValue;
    }

    public static boolean isTrue(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        String literal = String.valueOf(val);
        return !"false".equalsIgnoreCase(literal) && !"0".equals(literal);
    }

    public static boolean isEmpty(List<?> collection) {
        return collection == null || collection.isEmpty();
    }

    @SafeVarargs
    public static <T> HashSet<T> array2Set(T ... values) {
        HashSet<T> set = new HashSet<T>();
        for (T value : values) {
            set.add(value);
        }
        return set;
    }

    public static <T> HashSet<T> array2Set(List<T> values) {
        HashSet<T> set = new HashSet<T>(values);
        return set;
    }

    public static List<Integer> and(List<Integer> src0, List<Integer> src1) {
        if (src0 == null) {
            return src1;
        }
        if (src1 == null) {
            return src0;
        }
        List<Integer> max = src0.size() > src1.size() ? src0 : src1;
        List<Integer> min = src0.size() > src1.size() ? src1 : src0;
        HashSet<Integer> set = new HashSet<Integer>(max);
        min.removeIf(item -> !set.contains(item));
        return min;
    }

    public static List<Integer> or(List<Integer> src0, List<Integer> src1) {
        List<Integer> max = src0.size() > src1.size() ? src0 : src1;
        List<Integer> min = src0.size() > src1.size() ? src1 : src0;
        HashSet<Integer> set = new HashSet<Integer>(max);
        for (Integer item : min) {
            if (set.contains(item)) continue;
            max.add(item);
        }
        return max;
    }

    public static <T> T convert(Object src, T defaultValue) {
        if (src == null || "null".equals(src.toString())) {
            return defaultValue;
        }
        if (src instanceof BigDecimal) {
            if (defaultValue instanceof BigDecimal) {
                return (T)src;
            }
            if (defaultValue instanceof Integer) {
                return (T)Integer.valueOf(((BigDecimal)src).setScale(0, RoundingMode.HALF_UP).intValue());
            }
            if (defaultValue instanceof Long) {
                return (T)Long.valueOf(((BigDecimal)src).setScale(0, RoundingMode.HALF_UP).longValue());
            }
            if (defaultValue instanceof String) {
                return (T)src.toString();
            }
        } else if (src instanceof Integer) {
            if (defaultValue instanceof BigDecimal) {
                return (T)new BigDecimal((Integer)src);
            }
            if (defaultValue instanceof Integer) {
                return (T)src;
            }
            if (defaultValue instanceof Long) {
                return (T)Long.valueOf(src.toString());
            }
            if (defaultValue instanceof String) {
                return (T)src.toString();
            }
        } else if (src instanceof Long) {
            if (defaultValue instanceof BigDecimal) {
                return (T)new BigDecimal((Long)src);
            }
            if (defaultValue instanceof Integer) {
                return (T)Integer.valueOf(src.toString());
            }
            if (defaultValue instanceof Long) {
                return (T)src;
            }
            if (defaultValue instanceof String) {
                return (T)src.toString();
            }
        } else if (src instanceof String) {
            if (kd.bos.util.StringUtils.isEmpty((String)src.toString())) {
                return defaultValue;
            }
            if (defaultValue instanceof String) {
                return (T)src;
            }
            if (defaultValue instanceof BigDecimal) {
                return (T)new BigDecimal((String)src);
            }
            if (defaultValue instanceof Integer) {
                return (T)Integer.valueOf((String)src);
            }
            if (defaultValue instanceof Long) {
                return (T)Long.valueOf((String)src);
            }
        }
        logger.warn(String.format("mrprunner-value-convert-error, src: %s(class: %s), default: %s(class: %s)", src, src.getClass(), defaultValue, defaultValue == null ? "null" : defaultValue.getClass()));
        return defaultValue;
    }

    public static LocalDate date2LocalDate(Date date) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date localDate2Date(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zdt = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public static String getStackTrace(Throwable t) {
        StringBuilder error = new StringBuilder(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        if (t == null || t.getStackTrace() == null || t.getStackTrace().length == 0) {
            return error.toString();
        }
        StackTraceElement[] details = t.getStackTrace();
        error.append(t).append("\r\n");
        for (StackTraceElement stackTraceElement : details) {
            error.append(stackTraceElement).append("\r\n");
            if (error.length() > 3000) break;
        }
        return error.toString();
    }

    public static String appendExceptionMsg(Object oldMsg, String newMsg) {
        if (MRPUtil.isNullString(newMsg)) {
            return oldMsg == null ? "" : oldMsg.toString();
        }
        StringBuilder exception = new StringBuilder();
        if (!MRPUtil.isNullString(oldMsg)) {
            exception.append(oldMsg);
            if (!exception.toString().contains(newMsg)) {
                exception.append("\r\n").append(" - ").append(newMsg);
            }
        } else {
            exception.append(" - ").append(newMsg);
        }
        return exception.toString();
    }

    public static String appendExceptionNumber(Object oldMsg, String newMsg) {
        if (MRPUtil.isNullString(newMsg)) {
            return oldMsg == null ? "" : oldMsg.toString();
        }
        StringBuilder exception = new StringBuilder();
        if (!MRPUtil.isNullString(oldMsg)) {
            exception.append(oldMsg);
            if (!exception.toString().contains(newMsg)) {
                exception.append(',').append(newMsg);
            }
        } else {
            exception.append(newMsg);
        }
        return exception.toString();
    }

    public static String mergeException(String oldExc, String newExc, String splitSign) {
        if (MRPUtil.isNullString(oldExc)) {
            return newExc;
        }
        if (MRPUtil.isNullString(newExc)) {
            return oldExc;
        }
        if (oldExc.equals(newExc)) {
            return oldExc;
        }
        String[] s1 = oldExc.split(splitSign);
        String[] s2 = newExc.split(splitSign);
        LinkedHashSet set = new LinkedHashSet();
        Collections.addAll(set, s1);
        Collections.addAll(set, s2);
        StringBuilder sb = new StringBuilder();
        for (String str : set) {
            if (sb.length() > 0) {
                sb.append(splitSign);
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static boolean isNullString(Object str) {
        return str == null || StringUtils.isBlank((CharSequence)str.toString()) || StringUtils.equalsIgnoreCase((CharSequence)str.toString(), (CharSequence)"null");
    }

    public static void calcDate(RequireRowData require, BigDecimal qty, IMRPEnvProvider ctx) {
        int bodtime;
        String inv_plan_date_calc_set;
        if (qty == null || qty.compareTo(BigDecimal.ZERO) <= 0) {
            qty = require.getNewQrequireQty() == null ? BigDecimal.ZERO : require.getNewQrequireQty();
        }
        boolean isForwardSort = "FORWARD_SORT".equals(inv_plan_date_calc_set = (String)ctx.getCfgValue(EnvCfgItem.INV_PLAN_DATE_CALC_SET)) && !ctx.isAllowPast() && InvPlanUtil.isNewInvRequire(ctx, require);
        MRPWorkCalendarManager wcm = ctx.dateManager();
        String supplyOrgId = String.valueOf(require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        SupplyStruct ss = ctx.getPriorityRelations().get(supplyOrgId);
        Long date = (Long)require.getValue(DefaultField.RequireField.DATE.getName());
        Long end = (Long)require.getValue(DefaultField.RequireField.__END_DATE__.getName());
        Long start = (Long)require.getValue(DefaultField.RequireField.__START_DATE__.getName());
        int mt = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIALATTR.getAlias()), MaterialAttribute.OTHER.getValue());
        Integer inspectLeadDays = MRPUtil.convert(require.getValue(DefaultField.RequireField.INSPECTLEADDAYS.getName()), 0);
        Integer postProcessDays = MRPUtil.convert(require.getValue(DefaultField.RequireField.POSTPROCESSDAYS.getName()), 0);
        Integer leadTime = 0;
        String leadType = (String)require.getValue(DefaultField.RequireField.LEADTYPE.getName());
        if (leadType == null) {
            leadType = LeadType.FIXED.getValue();
        }
        if (LeadType.FIXED.getValue().equals(leadType)) {
            leadTime = MRPUtil.convert(require.getValue(DefaultField.RequireField.FIXEDLEADDAYS.getName()), 0);
        } else if (LeadType.DYNAMIC.getValue().equals(leadType)) {
            leadTime = MRPUtil.convert(require.getValue(DefaultField.RequireField.DYNAMICLEADDAYS.getName()), 0);
            BigDecimal dynamicBatch = MRPUtil.convert(require.getValue(DefaultField.RequireField.DYNAMICBATCH.getName()), BigDecimal.ZERO);
            if (dynamicBatch != null && dynamicBatch.compareTo(BigDecimal.ZERO) > 0) {
                leadTime = qty.divide(dynamicBatch, 0, RoundingMode.CEILING).intValue() * leadTime;
            }
        }
        String requireProductOrgUnitID = String.valueOf(require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        OrgBasedCalendarModel sOcm = wcm.get(supplyOrgId, requireProductOrgUnitID);
        if (MaterialAttribute.PURCHASEDPART.getValue() != mt) {
            date = sOcm.getDate(new Date(date), true).getTimeInMillis();
        }
        if (end == null) {
            end = MaterialAttribute.PURCHASEDPART.getValue() == mt ? Long.valueOf(date - (long)(inspectLeadDays + postProcessDays) * 86400000L) : Long.valueOf(sOcm.getDate(new Date(date), true, inspectLeadDays + postProcessDays).getTimeInMillis());
            require.update(DefaultField.RequireField.__END_DATE__.getName(), (Object)end);
            if (start == null) {
                start = MaterialAttribute.PURCHASEDPART.getValue() == mt ? Long.valueOf(end - (long)leadTime.intValue() * 86400000L) : Long.valueOf(sOcm.getDate(new Date(end), true, leadTime).getTimeInMillis());
                require.update(DefaultField.RequireField.__START_DATE__.getName(), (Object)start);
            }
        }
        Integer preProcessDays = MRPUtil.convert(require.getValue(DefaultField.RequireField.PREPROCESSDAYS.getName()), 0);
        Long orderDate = MRPUtil.convert(require.getValue(DefaultField.RequireField.__START_DATE__.getName()), System.currentTimeMillis());
        int n = bodtime = ss == null ? 0 : ss.getBodtime();
        if (MaterialAttribute.PURCHASEDPART.getValue() == mt) {
            bodtime = 0;
            orderDate = orderDate - (long)preProcessDays.intValue() * 86400000L;
        } else {
            orderDate = sOcm.getDate(new Date(orderDate), true, bodtime + preProcessDays).getTimeInMillis();
        }
        require.update(DefaultField.RequireField.__ORDER_DATE__.getName(), (Object)orderDate);
        require.update(DefaultField.RequireField._LAST_DATE_.getName(), (Object)orderDate);
        if (orderDate < ctx.getPlanDate().getTime() && isForwardSort) {
            if (MaterialAttribute.PURCHASEDPART.getValue() != mt) {
                orderDate = sOcm.getDate(new Date(ctx.getPlanDate().getTime()), false).getTimeInMillis();
                start = sOcm.getDate(new Date(orderDate), false, bodtime + preProcessDays).getTimeInMillis();
                end = sOcm.getDate(new Date(start), false, leadTime).getTimeInMillis();
                date = sOcm.getDate(new Date(end), false, inspectLeadDays + postProcessDays).getTimeInMillis();
            } else {
                orderDate = ctx.getPlanDate().getTime();
                start = orderDate + (long)preProcessDays.intValue() * 86400000L;
                end = start + (long)leadTime.intValue() * 86400000L;
                date = end + (long)(inspectLeadDays + postProcessDays) * 86400000L;
            }
            require.update(DefaultField.RequireField.__ORDER_DATE__.getName(), (Object)orderDate);
            require.update(DefaultField.RequireField._LAST_DATE_.getName(), (Object)orderDate);
            require.update(DefaultField.RequireField.__END_DATE__.getName(), (Object)end);
            require.update(DefaultField.RequireField.__START_DATE__.getName(), (Object)start);
            require.update(DefaultField.RequireField.DATE.getName(), (Object)date);
        }
    }

    public static Object convert(Object value, IDataEntityProperty prop) {
        Class cls = prop.getPropertyType();
        if (prop instanceof IComplexProperty) {
            cls = ((IComplexProperty)prop).getComplexType().getPrimaryKey().getPropertyType();
        }
        if (value == null && cls == String.class) {
            return " ";
        }
        if (cls == Date.class && value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        return ObjectConverter.convert((Object)value, (Class)cls);
    }

    public static String genPONum(IMRPEnvProvider ctx, String orgId) {
        String num;
        int genBatch = ctx.getGenBatch();
        RequireDataModel require = (RequireDataModel)ctx.getService(RequireDataModel.class);
        String outputType = require.getOutputType();
        DynamicObject poTemplate = poTemplateMap.computeIfAbsent(outputType, k -> BusinessDataServiceHelper.newDynamicObject((String)outputType));
        String cacheKey = "codeRule-not-find-" + orgId;
        String cacheVal = ctx.getCustomParams(cacheKey);
        if (kd.bos.util.StringUtils.isNotEmpty((String)cacheVal) && "false".equals(cacheVal)) {
            return UUID.randomUUID().toString().substring(0, 30);
        }
        if (genBatch > 0) {
            ArrayBlockingQueue<String> poNumQueue = ctx.getPoNumQueue(orgId);
            num = poNumQueue.poll();
            if (kd.bos.util.StringUtils.isEmpty((String)num)) {
                String[] nums = MRPUtil.genBatchPONum(ctx, orgId, genBatch, true);
                cacheVal = ctx.getCustomParams(cacheKey);
                if (kd.bos.util.StringUtils.isNotEmpty((String)cacheVal) && "false".equals(cacheVal)) {
                    num = nums[0];
                } else {
                    poNumQueue.addAll(Arrays.asList(nums));
                    num = poNumQueue.poll();
                }
            }
        } else {
            num = CodeRuleServiceHelper.getNumber((String)outputType, (DynamicObject)poTemplate, (String)orgId);
            if (kd.bos.util.StringUtils.isEmpty((String)num)) {
                num = UUID.randomUUID().toString().substring(0, 30);
                ctx.putCustomParams(cacheKey, "false");
            }
        }
        return num;
    }

    public static String[] genBatchPONum(IMRPEnvProvider ctx, String orgId, int count) {
        return MRPUtil.genBatchPONum(ctx, orgId, count, false);
    }

    private static String[] genBatchPONum(IMRPEnvProvider ctx, String orgId, int count, boolean noCodeRuleGetOne) {
        RequireDataModel require = (RequireDataModel)ctx.getService(RequireDataModel.class);
        String outputType = require.getOutputType();
        DynamicObject poTemplate = poTemplateMap.computeIfAbsent(outputType, k -> BusinessDataServiceHelper.newDynamicObject((String)outputType));
        String cacheKey = "codeRule-not-find-" + orgId;
        String cacheVal = ctx.getCustomParams(cacheKey);
        if (kd.bos.util.StringUtils.isNotEmpty((String)cacheVal) && "false".equals(cacheVal)) {
            String[] num = new String[count];
            for (int i = 0; i < num.length; ++i) {
                num[i] = UUID.randomUUID().toString().substring(0, 30);
            }
            return num;
        }
        String[] num = CodeRuleServiceHelper.getBatchNumber((String)outputType, (DynamicObject)poTemplate, (String)orgId, (int)count);
        if (num.length <= 0) {
            num = new String[noCodeRuleGetOne ? 1 : count];
            for (int i = 0; i < num.length; ++i) {
                num[i] = UUID.randomUUID().toString().substring(0, 30);
            }
            ctx.putCustomParams(cacheKey, "false");
        }
        return num;
    }

    public static Long genLongId() {
        return ID.genLongId();
    }

    public static String genCollaborateTemplateNum(IMRPEnvProvider ctx, String orgId) {
        RequireDataModel requireDataModel = (RequireDataModel)ctx.getService(RequireDataModel.class);
        String outputCollaborativeorder = requireDataModel.getOutputCollaborativeorder();
        DynamicObject collaborateTemplate = collaborateTemplateMap.computeIfAbsent(outputCollaborativeorder, k -> BusinessDataServiceHelper.newDynamicObject((String)outputCollaborativeorder));
        String cacheKey = "collaborate-codeRule-not-find-" + orgId;
        String cacheVal = ctx.getCustomParams(cacheKey);
        if (!kd.bos.util.StringUtils.isEmpty((String)cacheVal) && "false".equals(cacheVal)) {
            return UUID.randomUUID().toString().substring(0, 30);
        }
        String num = CodeRuleServiceHelper.getNumber((String)outputCollaborativeorder, (DynamicObject)collaborateTemplate, (String)orgId);
        if (kd.bos.util.StringUtils.isEmpty((String)num)) {
            num = UUID.randomUUID().toString().substring(0, 30);
            ctx.putCustomParams(cacheKey, "false");
        }
        return num;
    }

    public static String genOutPutNum(IMRPEnvProvider ctx, String orgId, String outPutType) {
        String cacheKey = "codeRule-not-find-" + orgId;
        String cacheVal = ctx.getCustomParams(cacheKey);
        if (!kd.bos.util.StringUtils.isEmpty((String)cacheVal) && "false".equals(cacheVal)) {
            return UUID.randomUUID().toString().substring(0, 30);
        }
        DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)outPutType);
        String num = CodeRuleServiceHelper.getNumber((String)outPutType, (DynamicObject)result, (String)orgId);
        if (kd.bos.util.StringUtils.isEmpty((String)num)) {
            num = UUID.randomUUID().toString().substring(0, 30);
            ctx.putCustomParams(cacheKey, "false");
        }
        return num;
    }

    public static String getString(Map<String, Object> info, String field) {
        Object val = info.get(field);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    public static BigDecimal toBigDecimal(Object val) {
        BigDecimal bd;
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).setScale(10, 1);
        }
        try {
            bd = new BigDecimal(val.toString());
        }
        catch (Throwable e) {
            return BigDecimal.ZERO;
        }
        if (bd.scale() > 10) {
            return bd.setScale(10, 1);
        }
        return bd;
    }

    public static BigDecimal getBigDecimal(Map<String, Object> info, String field) {
        Object val = info.get(field);
        return MRPUtil.toBigDecimal(val);
    }

    public static Integer getInt(Map<String, Object> info, String field) {
        Object val = info.get(field);
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).intValue();
        }
        try {
            return new BigDecimal(val.toString()).intValue();
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public static Long getLong(Map<String, Object> info, String field) {
        Object val = info.get(field);
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).longValue();
        }
        try {
            return new BigDecimal(val.toString()).longValue();
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    public static boolean isByMQ() {
        return true;
    }

    public static int getThreadPoolSize() {
        return threadPoolSize;
    }

    public static boolean isZipEnabled() {
        return zipEnable;
    }

    public static int getCacheSplitSize() {
        return cacheSplitSize;
    }

    public static boolean isSingleHostUseJson() {
        return singleHostUseJson;
    }

    public static String row2String(Map<String, Integer> cols, Object[] row) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry : cols.entrySet()) {
            sb.append('[').append(entry.getKey()).append(" : ");
            sb.append(row[entry.getValue()]).append(']');
        }
        return sb.toString();
    }

    public static Date addDays(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        return cal.getTime();
    }

    public static List<MergeCycleVo> getMergeCycleVos(IMRPEnvProvider provider, long specialperiod) {
        ArrayList<MergeCycleVo> cycleList = new ArrayList(3);
        QFilter idFilter = new QFilter("id", "=", (Object)specialperiod);
        if (provider.getSpecialCycleCache().get(specialperiod) != null) {
            cycleList = provider.getSpecialCycleCache().get(specialperiod);
        } else {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MRPUtil", (String)"mpdm_mergecycle", (String)"entryentity.entrystartdate entrystartdate,entryentity.entryenddate entryenddate,entryentity.entrymergedate entrymergedate", (QFilter[])new QFilter[]{idFilter}, (String)"entryentity.entrymergedate asc");){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    MergeCycleVo mergeDateVo = new MergeCycleVo(MRPUtil.normalize(row.getDate("entrystartdate")), MRPUtil.normalize(row.getDate("entryenddate")), MRPUtil.normalize(row.getDate("entrymergedate")));
                    cycleList.add(mergeDateVo);
                }
            }
            provider.getSpecialCycleCache().put(specialperiod, cycleList);
        }
        return cycleList;
    }

    public static void dealSpecialCycles(IMRPEnvProvider provider, List<DataBalanceTable.RSMapping> mappings, long specialperiod) {
        if (specialperiod <= 0L) {
            return;
        }
        HashMap<Integer, Boolean> cache = new HashMap<Integer, Boolean>(mappings.size());
        MRPUtil.sortRsMappingsByRequireDate(mappings);
        List<MergeCycleVo> cycleList = MRPUtil.getMergeCycleVos(provider, specialperiod);
        Iterator<MergeCycleVo> cycleIts = cycleList.iterator();
        if (!cycleList.isEmpty()) {
            MergeCycleVo cycleVo = cycleIts.next();
            Iterator<DataBalanceTable.RSMapping> rsIts = mappings.iterator();
            TreeMap rsMappingMap = new TreeMap();
            DataBalanceTable.RSMapping nxmapping = null;
            boolean isMatch = false;
            block0: while (rsIts.hasNext()) {
                nxmapping = rsIts.next();
                if (nxmapping.getBeforeMergedQty() == null) {
                    nxmapping.setBeforeMergedQty(nxmapping.getrQty());
                }
                Date nxDate = new Date((Long)nxmapping.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
                while (nxDate.compareTo(cycleVo.getEndDate()) > 0) {
                    if (!cycleIts.hasNext()) break block0;
                    cycleVo = cycleIts.next();
                }
                long cycleTime = cycleVo.getStartDate().getTime();
                if (nxDate.compareTo(cycleVo.getStartDate()) >= 0 && nxDate.compareTo(cycleVo.getEndDate()) <= 0) {
                    nxDate = cycleVo.getMergeDate();
                    nxmapping.getRequire().update(DefaultField.RequireField.DATE.getName(), (Object)nxDate.getTime());
                    List<DataBalanceTable.RSMapping> rsMappingList = null;
                    if (rsMappingMap.get(cycleTime) != null) {
                        rsMappingList = (List)rsMappingMap.get(cycleVo.getStartDate().getTime());
                        for (DataBalanceTable.RSMapping rsMapping : rsMappingList) {
                            if (rsMapping.getBeforeMergedQty() == null) {
                                rsMapping.setBeforeMergedQty(rsMapping.getrQty());
                            }
                            if (!MRPUtil.convert(rsMapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getAlias()), MaterialAttribute.OTHER.getValue()).equals(MRPUtil.convert(nxmapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getAlias()), MaterialAttribute.OTHER.getValue())) || !DataBalanceUtil.isMatch(provider, rsMapping.getRequire(), nxmapping.getRequire(), true, cache) || !DataBalanceUtil.isMatch(provider, nxmapping.getRequire(), rsMapping.getRequire(), true, cache)) continue;
                            rsIts.remove();
                            MRPUtil.doMergeWork(provider, nxmapping, rsMapping);
                            isMatch = true;
                            break;
                        }
                    } else {
                        rsMappingList = new ArrayList(cycleList.size());
                    }
                    if (!isMatch) {
                        rsMappingList.add(nxmapping);
                        rsMappingMap.put(cycleTime, rsMappingList);
                        continue;
                    }
                    isMatch = false;
                    continue;
                }
                if (nxDate.compareTo(cycleVo.getStartDate()) >= 0) continue;
            }
            for (Map.Entry rsMappingListEntry : rsMappingMap.entrySet()) {
                for (DataBalanceTable.RSMapping rsMapping : (List)rsMappingListEntry.getValue()) {
                    MRPUtil.splitOrdersByDirectLotPolicy(provider, rsMapping, cache);
                }
            }
        }
    }

    public static void sortRsMappingsByRequireDate(List<DataBalanceTable.RSMapping> mappings) {
        Collections.sort(mappings, new Comparator<DataBalanceTable.RSMapping>(){

            @Override
            public int compare(DataBalanceTable.RSMapping var1, DataBalanceTable.RSMapping var2) {
                long var1date = (Long)var1.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName());
                long var2date = (Long)var2.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName());
                Date v1Date = new Date(var1date);
                Date v2Date = new Date(var2date);
                return v1Date.compareTo(v2Date);
            }
        });
    }

    public static void dealDynamicCycles(IMRPEnvProvider provider, List<DataBalanceTable.RSMapping> mappings, Integer dynamicperiod) {
        if (dynamicperiod <= 0) {
            return;
        }
        HashMap<Integer, Boolean> cache = new HashMap<Integer, Boolean>(mappings.size());
        MRPUtil.sortRsMappingsByRequireDate(mappings);
        Iterator<DataBalanceTable.RSMapping> rsIts = mappings.iterator();
        boolean isMatch = false;
        ArrayList<DynamicCycleVo> dynamicCycleVos = new ArrayList<DynamicCycleVo>(dynamicperiod);
        while (rsIts.hasNext()) {
            DataBalanceTable.RSMapping nxMapping = rsIts.next();
            if (nxMapping.getBeforeMergedQty() == null) {
                nxMapping.setBeforeMergedQty(nxMapping.getrQty());
            }
            if (dynamicCycleVos.isEmpty()) {
                DynamicCycleVo dynamicCycleVo = new DynamicCycleVo(nxMapping, 1);
                dynamicCycleVos.add(dynamicCycleVo);
                continue;
            }
            for (DynamicCycleVo dynamicCycleVo : dynamicCycleVos) {
                Date nxDate;
                Date dynamicCycleDate;
                boolean isDynamicMatch;
                DataBalanceTable.RSMapping dsMapping = dynamicCycleVo.getRsMapping();
                if (dsMapping.getBeforeMergedQty() == null) {
                    dsMapping.setBeforeMergedQty(dsMapping.getrQty());
                }
                if (!MRPUtil.convert(dsMapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getAlias()), MaterialAttribute.OTHER.getValue()).equals(MRPUtil.convert(nxMapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getAlias()), MaterialAttribute.OTHER.getValue()))) continue;
                long dynamicCycleTime = 0L;
                long nxTime = 0L;
                if (dynamicCycleVo.getRsMapping().getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()) != null) {
                    dynamicCycleTime = (Long)dynamicCycleVo.getRsMapping().getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName());
                }
                if (nxMapping.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()) != null) {
                    nxTime = (Long)nxMapping.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName());
                }
                if (!(isDynamicMatch = (dynamicCycleDate = DateUtils.convertDate((Date)new Date(dynamicCycleTime))).compareTo(nxDate = DateUtils.convertDate((Date)new Date(nxTime))) == 0 || dynamicCycleVo.getCount() < dynamicperiod) || !DataBalanceUtil.isMatch(provider, dsMapping.getRequire(), nxMapping.getRequire(), true, cache) || !DataBalanceUtil.isMatch(provider, nxMapping.getRequire(), dsMapping.getRequire(), true, cache)) continue;
                if (dynamicCycleDate.compareTo(nxDate) != 0) {
                    dynamicCycleVo.setCount(dynamicCycleVo.getCount() + 1);
                }
                MRPUtil.doMergeWork(provider, nxMapping, dsMapping);
                isMatch = true;
            }
            if (!isMatch) {
                DynamicCycleVo dynamicCycleVo;
                dynamicCycleVo = new DynamicCycleVo(nxMapping, 1);
                dynamicCycleVos.add(dynamicCycleVo);
                continue;
            }
            isMatch = false;
        }
        for (DynamicCycleVo dynamicCycleVo : dynamicCycleVos) {
            MRPUtil.splitOrdersByDirectLotPolicy(provider, dynamicCycleVo.getRsMapping(), cache);
        }
    }

    public static void addChildMapping(DataBalanceTable.RSMapping parentMapping, DataBalanceTable.RSMapping childMapping, int size) {
        MRPUtil.addChildMapping(parentMapping, childMapping);
    }

    public static void addChildMapping(DataBalanceTable.RSMapping parentMapping, DataBalanceTable.RSMapping childMapping) {
        if (parentMapping.getChildMappings() == null) {
            parentMapping.setChildMappings(new LinkedList<DataBalanceTable.RSMapping>());
        }
        childMapping.getRequire().update(DefaultField.RequireField.DATE.getName(), parentMapping.getRequire().getValue(DefaultField.RequireField.DATE.getName()));
        childMapping.getRequire().update(DefaultField.RequireField.SUPPLY_TRACKNUMBER.getName(), parentMapping.getRequire().getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
        childMapping.getRequire().update(DefaultField.RequireField.SUPPLY_MATERIALFLEXPROPS.getName(), parentMapping.getRequire().getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()));
        parentMapping.getChildMappings().add(childMapping);
    }

    public static void batchRichUpdateFields(DataBalanceTable.RSMapping newnxMapping, DataBalanceTable.RSMapping rsmapping, String poNum, Long poId) {
        newnxMapping.getRequire().update(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName(), (Object)poNum);
        newnxMapping.getRequire().update(DefaultField.RequireField.__PO_ID__.getName(), (Object)poId);
        newnxMapping.getRequire().update(DefaultField.RequireField.BATCHPOLICYRICHDATE.getName(), rsmapping.getRequire().getValue(DefaultField.RequireField.DATE.getName()));
        newnxMapping.getRequire().update(DefaultField.RequireField.SUPPLY_TRACKNUMBER.getName(), rsmapping.getRequire().getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
        newnxMapping.getRequire().update(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName(), rsmapping.getRequire().getValue(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName()));
        newnxMapping.getRequire().update(DefaultField.RequireField.SUPPLY_MATERIALFLEXPROPS.getName(), rsmapping.getRequire().getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dealFixedCycles(IMRPEnvProvider provider, List<DataBalanceTable.RSMapping> mappings, Integer fixedperiod) {
        if (fixedperiod <= 0) {
            return;
        }
        boolean isFlexPropMatch = (Boolean)provider.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
        HashMap<Integer, Boolean> cache = new HashMap<Integer, Boolean>(mappings.size());
        HashMap<Long, MergeCache> mergeCaches = new HashMap<Long, MergeCache>(7);
        MRPUtil.sortRsMappingsByRequireDate(mappings);
        Iterator<DataBalanceTable.RSMapping> rsits = mappings.iterator();
        Date startdate = null;
        Date nxdate = null;
        Date endDate = null;
        boolean isMatch = false;
        TreeMap rsMappingMap = new TreeMap();
        while (rsits.hasNext()) {
            Throwable throwable;
            TraceSpan span;
            DataBalanceTable.RSMapping dsMapping;
            Iterator rsMappingIterator;
            List rsMappingList;
            MergeCache current;
            long startTime;
            Integer nxmappingKey;
            DataBalanceTable.RSMapping nxmapping;
            Throwable throwable2;
            TraceSpan ts;
            block118: {
                ts = Tracer.create((String)"MRPUtil.dealFixedCycles-mappingCycles", (String)"dealFixedCycles-mappingCycles");
                throwable2 = null;
                try {
                    nxmapping = rsits.next();
                    long requireFlexedProp = MRPUtil.convert(nxmapping.getRequire().getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), 0L);
                    Integer n = nxmappingKey = isFlexPropMatch ? DataBalanceUtil.createDataCacheKey(nxmapping.getRequire(), provider.r2s(), requireFlexedProp) : DataBalanceUtil.createCacheKey(nxmapping.getRequire(), provider.r2s());
                    if (nxmapping.getBeforeMergedQty() == null) {
                        nxmapping.setBeforeMergedQty(nxmapping.getrQty());
                    }
                    if (startdate == null) {
                        startdate = new Date((Long)nxmapping.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
                    }
                    nxdate = new Date((Long)nxmapping.getRequire().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
                    endDate = MRPUtil.addDays(startdate, fixedperiod);
                    while (nxdate.compareTo(endDate) >= 0) {
                        startdate = MRPUtil.addDays(startdate, fixedperiod);
                        endDate = MRPUtil.addDays(startdate, fixedperiod);
                    }
                    startTime = startdate.getTime();
                    if (nxdate.compareTo(startdate) < 0 || nxdate.compareTo(endDate) > 0) continue;
                    if (rsMappingMap.get(startTime) != null) {
                        current = (MergeCache)mergeCaches.get(startTime);
                        rsMappingList = (List)rsMappingMap.get(startTime);
                        rsMappingIterator = rsMappingList.iterator();
                        dsMapping = current.getUnMerges().get(nxmappingKey);
                        if (dsMapping != null) {
                            span = Tracer.create((String)"MRPUtil.dealFixedCycles-fast-unMerged", (String)"dealFixedCycles-fast-unMerged");
                            throwable = null;
                            try {
                                if (!MRPUtil.convert(dsMapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue()).equals(MRPUtil.convert(nxmapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue()))) continue;
                                MRPUtil.doMergeWork(provider, nxmapping, dsMapping);
                                continue;
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (span == null) continue;
                                if (throwable != null) {
                                    try {
                                        span.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                span.close();
                                continue;
                            }
                        }
                        span = Tracer.create((String)"MRPUtil.dealFixedCycles-fast-merged", (String)"dealFixedCycles-fast-merged");
                        throwable = null;
                        break block118;
                    }
                    TraceSpan span2 = Tracer.create((String)"MRPUtil.dealFixedCycles-unMerged", (String)"dealFixedCycles-unMerged");
                    Throwable throwable5 = null;
                    try {
                        nxmapping.getRequire().update(DefaultField.RequireField.DATE.getName(), (Object)startTime);
                        LinkedList<DataBalanceTable.RSMapping> rsMappingList2 = new LinkedList<DataBalanceTable.RSMapping>();
                        rsMappingList2.add(nxmapping);
                        rsMappingMap.put(startTime, rsMappingList2);
                        MergeCache current2 = new MergeCache(7);
                        mergeCaches.put(startTime, current2);
                        current2.getUnMerges().put(nxmappingKey, nxmapping);
                        continue;
                    }
                    catch (Throwable throwable6) {
                        throwable5 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (span2 == null) continue;
                        if (throwable5 != null) {
                            try {
                                span2.close();
                            }
                            catch (Throwable throwable7) {
                                throwable5.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        span2.close();
                        continue;
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
            }
            try {
                dsMapping = current.getMerges().get(nxmappingKey);
                if (dsMapping != null) {
                    if (!MRPUtil.convert(dsMapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue()).equals(MRPUtil.convert(nxmapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue()))) continue;
                    MRPUtil.doMergeWork(provider, nxmapping, dsMapping);
                    continue;
                }
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                    continue;
                }
                span.close();
                continue;
            }
            while (rsMappingIterator.hasNext()) {
                span = Tracer.create((String)"MRPUtil.dealFixedCycles-mergeCycles", (String)"dealFixedCycles-mergeCycles");
                throwable = null;
                try {
                    dsMapping = (DataBalanceTable.RSMapping)rsMappingIterator.next();
                    if (!MRPUtil.convert(dsMapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue()).equals(MRPUtil.convert(nxmapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue())) || !DataBalanceUtil.isMatch(provider, dsMapping.getRequire(), nxmapping.getRequire(), true, cache) || !DataBalanceUtil.isMatch(provider, nxmapping.getRequire(), dsMapping.getRequire(), true, cache)) continue;
                    MRPUtil.doMergeWork(provider, nxmapping, dsMapping);
                    isMatch = true;
                    break;
                }
                catch (Throwable throwable11) {
                    throwable = throwable11;
                    throw throwable11;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable12) {
                            throwable.addSuppressed(throwable12);
                        }
                        continue;
                    }
                    span.close();
                }
            }
            if (!isMatch) {
                span = Tracer.create((String)"MRPUtil.dealFixedCycles-unMerged", (String)"dealFixedCycles-unMerged");
                throwable = null;
                try {
                    nxmapping.getRequire().update(DefaultField.RequireField.DATE.getName(), (Object)startTime);
                    rsMappingList.add(nxmapping);
                    current.getUnMerges().put(nxmappingKey, nxmapping);
                    continue;
                }
                catch (Throwable throwable13) {
                    throwable = throwable13;
                    throw throwable13;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable14) {
                            throwable.addSuppressed(throwable14);
                        }
                        continue;
                    }
                    span.close();
                    continue;
                }
            }
            span = Tracer.create((String)"MRPUtil.dealFixedCycles-merged", (String)"dealFixedCycles-merged");
            throwable = null;
            try {
                isMatch = false;
                current.getMerges().put(nxmappingKey, dsMapping);
            }
            catch (Throwable throwable15) {
                throwable = throwable15;
                throw throwable15;
            }
            finally {
                if (ts == null) continue;
                if (throwable2 != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable16) {
                        throwable2.addSuppressed(throwable16);
                    }
                    continue;
                }
                ts.close();
            }
        }
        Iterator iterator = rsMappingMap.entrySet().iterator();
        block100: while (iterator.hasNext()) {
            Map.Entry rsMappingListEntry = iterator.next();
            Iterator iterator2 = ((List)rsMappingListEntry.getValue()).iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block100;
                DataBalanceTable.RSMapping rsMapping = (DataBalanceTable.RSMapping)iterator2.next();
                TraceSpan ts = Tracer.create((String)"MRPUtil.dealFixedCycles-splitOrdersByDirectLotPolicy", (String)"dealFixedCycles-splitOrdersByDirectLotPolicy");
                Throwable throwable = null;
                try {
                    MRPUtil.splitOrdersByDirectLotPolicy(provider, rsMapping, cache);
                    continue;
                }
                catch (Throwable throwable17) {
                    throwable = throwable17;
                    throw throwable17;
                }
                finally {
                    if (ts == null) continue;
                    if (throwable != null) {
                        try {
                            ts.close();
                        }
                        catch (Throwable throwable18) {
                            throwable.addSuppressed(throwable18);
                        }
                        continue;
                    }
                    ts.close();
                    continue;
                }
                break;
            }
            break;
        }
        return;
    }

    private static void doMergeWork(IMRPEnvProvider provider, DataBalanceTable.RSMapping nxmapping, DataBalanceTable.RSMapping dsMapping) {
        if (dsMapping.getVirtualQty() == null) {
            dsMapping.setVirtualQty(dsMapping.getrQty());
        }
        dsMapping.setrQty(dsMapping.getrQty().add(nxmapping.getrQty()));
        nxmapping.setGenPlanOrder(false);
        nxmapping.setCreateDepentRequire(false);
        MRPUtil.addChildMapping(dsMapping, nxmapping);
    }

    public static void splitOrdersByDirectLotPolicy(IMRPEnvProvider provider, DataBalanceTable.RSMapping mapping, Map<Integer, Boolean> cache) {
        new DirectBatchProcessor(provider).splitOrdersByDirectLotPolicy(mapping, cache);
    }

    public static void splitOrdersByFixedLotPolicy(IMRPEnvProvider provider, DataBalanceTable.RSMapping mapping, Map<Integer, Boolean> cache) {
        new FixedBatchProcessor(provider).splitOrdersByFixedLotPolicy(mapping, cache);
    }

    public static Date updateDates(int orders, Date date, int intervalperiod, DataBalanceTable.RSMapping rsmapping, IMRPEnvProvider provider) {
        RequireRowData rsRequire = rsmapping.getRequire();
        Date newDate = MRPUtil.getDateByCalendar(date, rsmapping, provider);
        rsmapping.getRequire().update(DefaultField.RequireField.DATE.getName(), (Object)newDate.getTime());
        rsRequire.update(DefaultField.RequireField.__START_DATE__.getName(), null);
        rsRequire.update(DefaultField.RequireField.__END_DATE__.getName(), null);
        rsmapping.setRequire(rsRequire);
        return newDate;
    }

    public static Date getDateByCalendar(Date date, DataBalanceTable.RSMapping rsmapping, IMRPEnvProvider provider) {
        return new Date(MRPUtil.getNetRequireDateTimeByCalendar(provider, date.getTime(), rsmapping.getRequire()));
    }

    public static Long getNetRequireDateTimeByCalendar(IMRPEnvProvider ctx, Long date, RequireRowData require) {
        String supplyOrgId = String.valueOf(require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        String requireProductOrgUnitID = String.valueOf(require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        OrgBasedCalendarModel sOcm = ctx.dateManager().get(supplyOrgId, requireProductOrgUnitID);
        int mt = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIALATTR.getAlias()), MaterialAttribute.OTHER.getValue());
        if (date <= ctx.getPlanDate().getTime() && !ctx.isAllowPast()) {
            date = MaterialAttribute.PURCHASEDPART.getValue() != mt ? Long.valueOf(sOcm.getDate(ctx.getPlanDate(), false).getTimeInMillis()) : Long.valueOf(ctx.getPlanDate().getTime());
        } else if (MaterialAttribute.PURCHASEDPART.getValue() != mt) {
            date = sOcm.getDate(new Date(date), true).getTimeInMillis();
        }
        return date;
    }

    public static int getIntervalperiod(RequireRowData requireData) {
        String separatorsymbol = requireData.getString(DefaultField.RequireField.SEPARATORSYMBOL.getName());
        int intervalperiod = Math.abs(MRPUtil.convert(requireData.getValue(DefaultField.RequireField.INTERVALPERIOD.getName()), 0));
        if ("B".equals(separatorsymbol)) {
            intervalperiod = -intervalperiod;
        } else if (kd.bos.util.StringUtils.isEmpty((String)separatorsymbol)) {
            intervalperiod = 0;
        }
        return intervalperiod;
    }

    public static void updateOrderQty(IMRPEnvProvider provider, DataBalanceTable.RSMapping mapping) {
        RequireRowData require = mapping.getRequire();
        BigDecimal yield = BigDecimal.ONE;
        BigDecimal rQty = mapping.getrQty();
        if (provider.isYield()) {
            Object myield = require.getValue(DefaultField.RequireField.YIELD.getName());
            yield = MRPUtil.toBigDecimal(myield);
        }
        BigDecimal orderQty = MRPUtil.calcYield(yield, require.getValue(DefaultField.RequireField.BASEUNIT.getName()), rQty, provider, false);
        mapping.setrQty(orderQty);
    }

    public static BigDecimal calcYield(BigDecimal yield, Object unitId, BigDecimal rQty, IMRPEnvProvider provider, boolean isMultiply) {
        if (yield == null || yield.compareTo(BigDecimal.ZERO) <= 0) {
            yield = BigDecimal.ONE;
        }
        UnitPrecisionParam unitPrecisionParam = MRPUtil.getUnitPrecisionParam(unitId, provider);
        if (isMultiply) {
            return rQty.multiply(yield).setScale(unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
        }
        return rQty.divide(yield, unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
    }

    public static UnitPrecisionParam getUnitPrecisionParam(Object unitId, IMRPEnvProvider provider) {
        HashMap<Integer, String> unit = provider.getUnit(unitId);
        int precision = Integer.parseInt(unit.getOrDefault(1, "4"));
        String precisionaccount = unit.getOrDefault(2, "1");
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if (precisionaccount.equalsIgnoreCase("2")) {
            roundingMode = RoundingMode.FLOOR;
        } else if (precisionaccount.equalsIgnoreCase("3")) {
            roundingMode = RoundingMode.CEILING;
        }
        return new UnitPrecisionParam(precision, roundingMode);
    }

    public static BigDecimal calScrapRation(IMRPEnvProvider ctx, BigDecimal qty, RowData bomEntryRow) {
        boolean isScrapRation = ctx.isScrapRation();
        if (isScrapRation) {
            BigDecimal scraprate = bomEntryRow.getValue(DefaultField.BOMField.CHILDSCRAPRATE.getName()) == null ? BigDecimal.ZERO : MRPUtil.toBigDecimal(bomEntryRow.getValue(DefaultField.BOMField.CHILDSCRAPRATE.getName()));
            BigDecimal fixedscrap = bomEntryRow.getValue(DefaultField.BOMField.CHILDFIXEDSCRAP.getName()) == null ? BigDecimal.ZERO : MRPUtil.toBigDecimal(bomEntryRow.getValue(DefaultField.BOMField.CHILDFIXEDSCRAP.getName()));
            String wastagerateformula = bomEntryRow.getValue(DefaultField.BOMField.WASTAGERATEFORMULA.getName()) == null ? "B" : String.valueOf(bomEntryRow.getValue(DefaultField.BOMField.WASTAGERATEFORMULA.getName()));
            UnitPrecisionParam unitPrecisionParam = MRPUtil.getUnitPrecisionParam(bomEntryRow.getValue(DefaultField.BOMField.CHILDUNIT.getName()), ctx);
            if (wastagerateformula.equals("A")) {
                qty = qty.divide(BigDecimal.ONE.subtract(scraprate), unitPrecisionParam.scale, unitPrecisionParam.roundingMode).add(fixedscrap);
            } else if (wastagerateformula.equals("B")) {
                qty = MRPUtil.multiply(BigDecimal.ONE.add(scraprate), qty).add(fixedscrap).setScale(unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
            }
        }
        return qty;
    }

    public static void findWastageFormula(IMRPEnvProvider ctx, RowData bomEntryRow, String material, String org) {
        String wastagerateformula = bomEntryRow.getString(DefaultField.BOMField.WASTAGERATEFORMULA.getName());
        if (wastagerateformula == null) {
            Object formula;
            Map<String, Object> info = ctx.getMaterialPlanInfo(material, org, new HashMap<String, Object>(InvPlanUtil.getExtendValMap(ctx, bomEntryRow, 2)));
            Object object = formula = info == null ? null : info.get("wastagerateformula");
            if (formula == null) {
                formula = "B";
            }
            wastagerateformula = String.valueOf(formula);
            bomEntryRow.update(DefaultField.BOMField.WASTAGERATEFORMULA.getName(), (Object)wastagerateformula);
        }
    }

    public static void parseFormula(FieldMapping mapping, String condition, StringBuilder message) {
        block7: {
            String bakcondition = condition;
            if (!kd.bos.util.StringUtils.isEmpty((String)condition)) {
                if (condition.startsWith("\"") || condition.startsWith("'")) {
                    condition = condition.substring(1);
                }
                if (condition.endsWith("\"") || condition.endsWith("'")) {
                    condition = condition.substring(0, condition.length() - 1);
                }
                try {
                    mapping.setValueFormula(new Expr(condition));
                    mapping.setFormulaValue(condition);
                    if (condition.contains("@requireData.#IS_NULL_SUPPLY_MATCH")) {
                        mapping.setNullValueMatch(true);
                    }
                }
                catch (Throwable e) {
                    if (bakcondition.startsWith("'") && bakcondition.endsWith("'") && bakcondition.length() >= 2) {
                        return;
                    }
                    logger.error(String.format("\u516c\u5f0f\u89e3\u6790\u51fa\u9519:%s", e.getMessage()), e);
                    if (mapping.getValueFormula() != null && mapping.getValueFormula().isWellFormatted()) break block7;
                    message.append(Tips.getErrorParseB2rFormula());
                    message.append('\uff0c');
                    message.append('\u3010');
                    message.append(mapping.getFrom());
                    message.append('\u3011');
                    message.append('\uff0c');
                    message.append('\u3010');
                    message.append(mapping.getTo());
                    message.append('\u3011');
                }
            }
        }
    }

    public static boolean hasException(String exp) {
        return exp.contains("83") || exp.contains("84") || exp.contains("87") || exp.contains("88") || exp.contains("90") || exp.contains("95") || exp.contains("96") || exp.contains("97") || exp.contains("89") || exp.contains("101") || exp.contains("102") || exp.contains("110") || exp.contains("111") || exp.contains("112");
    }

    public static boolean hasExceptionSupply(String exp) {
        return MRPUtil.hasException(exp) || exp.contains("85") || exp.contains("86") || exp.contains("93") || exp.contains("103");
    }

    public static boolean removeException(String exp) {
        return exp.contains("83") || exp.contains("84") || exp.contains("85") || exp.contains("86");
    }

    public static Set<Long> setStringParseLong(Set<String> sets) {
        HashSet<Long> setLong = new HashSet<Long>(sets.size());
        for (String set : sets) {
            setLong.add(Long.valueOf(set));
        }
        return setLong;
    }

    public static boolean isExceededQty(BigDecimal qty) {
        return MAX_QTY.compareTo(qty == null ? BigDecimal.ZERO : qty) <= 0;
    }

    public static boolean isPlanOrderExtendEntity(String entityId) {
        String oql = String.format("select fparentid from T_META_ENTITYDESIGN where fnumber = '%s'", entityId);
        try (DataSet dataSet = DB.queryDataSet((String)MRPUtil.class.getSimpleName(), (DBRoute)DBRoute.meta, (String)oql);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                String fparentid = row.getString("fparentid");
                boolean bl = MRPUtil.isPlanOrderExtendEntityById(fparentid);
                return bl;
            }
        }
        return false;
    }

    private static boolean isPlanOrderExtendEntityById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        if ("266JL+3OF5U=".equalsIgnoreCase(id)) {
            return true;
        }
        String oql = String.format("select fparentid from T_META_ENTITYDESIGN where fid = '%s'", id);
        try (DataSet dataSet = DB.queryDataSet((String)MRPUtil.class.getSimpleName(), (DBRoute)DBRoute.meta, (String)oql);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                String fparentid = row.getString("fparentid");
                boolean bl = MRPUtil.isPlanOrderExtendEntityById(fparentid);
                return bl;
            }
        }
        return false;
    }

    public static RowData createCollaborateSupplyByRequire(IMRPEnvProvider ctx, RequireRowData require, Object billId, Object billNum) {
        ResDataModelCollection resDataModel = (ResDataModelCollection)ctx.getService(ResDataModelCollection.class);
        SupplymentDataTable supplyDatas = resDataModel.getSupply().getTable();
        RowData supply = new RowData(supplyDatas.getSrcDatas(), supplyDatas.getColIdx(), new Object[supplyDatas.getColIdx().size()], supplyDatas.size(), ResType.SUPPLY);
        supply.update(DefaultField.CommonField.__MODEL_NUMBER__.name(), (Object)ResManager.loadKDString((String)"\u65b0\u5efa\u534f\u540c\u8ba1\u5212\u5355", (String)"MRPUtil_0", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
        supply.update(DefaultField.SupplyField.BILL_ENTITY.getName(), (Object)resDataModel.getRequire().getOutputCollaborativeorder());
        supply.update(DefaultField.SupplyField.SUPPLYORGUNIT.getName(), require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        supply.update(DefaultField.SupplyField.MATERIAL.getName(), require.getValue(DefaultField.RequireField.MATERIAL.getName()));
        supply.update(DefaultField.SupplyField.QTY.getName(), require.getValue(DefaultField.RequireField.QTY.getName()));
        supply.update(DefaultField.SupplyField.DATE.getName(), require.getValue(DefaultField.RequireField.DATE.getName()));
        supply.update(DefaultField.SupplyField.BILLID.getName(), billId);
        supply.update(DefaultField.SupplyField.BILLNUMBER.getName(), billNum);
        supply.update(DefaultField.SupplyField.__IS_OCCUPIED__.getName(), (Object)true);
        supply.update(DefaultField.SupplyField.SUPPLYOPERATOR.getName(), require.getValue(DefaultField.RequireField.REQUIREOPERAOTR.getName()));
        supply.update(DefaultField.SupplyField.SUPPLANTAG.getName(), require.getValue(DefaultField.RequireField.__PLAN_TAG__.getName()));
        supply.update(DefaultField.SupplyField.MATERIALFLEXPROPS.getName(), require.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()));
        supply.update(DefaultField.SupplyField.TRACKNUMBER.getName(), require.getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
        supply.update(DefaultField.SupplyField.PROJECTNUMBER.getName(), require.getValue(DefaultField.RequireField.PROJECTNUMBER.getName()));
        supply.update(DefaultField.SupplyField.PLANSCOPE.getName(), require.getValue(DefaultField.RequireField.PLANSCOPE.getName()));
        return supply;
    }

    public static boolean isTransferRequire(HashSet<String> requireOrgs, String supplyOrgId, RequireRowData require) {
        if (!requireOrgs.contains(supplyOrgId)) {
            String msg = MRPUtil.appendExceptionMsg(require.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), ResManager.loadKDString((String)"\u8d85\u51fa\u8ba1\u7b97\u8303\u56f4\uff0c\u4ec5\u4ea7\u751f\u534f\u540c\u8ba1\u5212\u8ba2\u5355\u4f9b\u5e94\u3002", (String)"MRPUtil_1", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
            require.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)msg);
            String num = MRPUtil.appendExceptionNumber(require.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), "82");
            require.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)num);
            return false;
        }
        String rc = (String)require.getValue(DefaultField.RequireField.__REQUIRE_ORG_CHAIN__.getName());
        if (rc != null && rc.contains(MRPUtil.getWrapOrgId(supplyOrgId))) {
            String msg = MRPUtil.appendExceptionMsg(require.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), ResManager.loadKDString((String)"\u5185\u534f\u7ec4\u7ec7\u6b7b\u5faa\u73af\u3002", (String)"MRPUtil_2", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
            require.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)msg);
            String num = MRPUtil.appendExceptionNumber(require.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), "89");
            require.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)num);
            return false;
        }
        return true;
    }

    public static boolean transferRequire(HashSet<String> requireOrgs, Object originRequireOrg, String supplyOrgId, RowData supply, RequireRowData require, RequireRowData transfer, DataBalanceTable detailTbl) {
        if (!MRPUtil.isTransferRequire(requireOrgs, supplyOrgId, require)) {
            return false;
        }
        String rc = (String)require.getValue(DefaultField.RequireField.__REQUIRE_ORG_CHAIN__.getName());
        if (rc == null) {
            rc = MRPUtil.getWrapOrgId(require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        }
        rc = rc + "\u0001" + MRPUtil.getWrapOrgId(supplyOrgId);
        if (transfer.getValue(DefaultField.RequireField.ORIGIN_BILLENTITY.getName()) == null) {
            transfer.update(DefaultField.RequireField.ORIGIN_BILLENTITY.getName(), transfer.getValue(DefaultField.RequireField.BILL_ENTITY.getName()));
        }
        if (transfer.getValue(DefaultField.RequireField.ORIGIN_BILLID.getName()) == null) {
            transfer.update(DefaultField.RequireField.ORIGIN_BILLID.getName(), transfer.getValue(DefaultField.RequireField.BILLID.getName()));
        }
        if (transfer.getValue(DefaultField.RequireField.ORIGIN_BILLNUMBER.getName()) == null) {
            transfer.update(DefaultField.RequireField.ORIGIN_BILLNUMBER.getName(), transfer.getValue(DefaultField.RequireField.BILLNUMBER.getName()));
        }
        if (transfer.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYID.getName()) == null) {
            transfer.update(DefaultField.RequireField.ORIGIN_BILLENTRYID.getName(), transfer.getValue(DefaultField.RequireField.BILLENTRYID.getName()));
        }
        if (transfer.getValue(DefaultField.RequireField.ORIGIN_BILLENTRYSEQ.getName()) == null) {
            transfer.update(DefaultField.RequireField.ORIGIN_BILLENTRYSEQ.getName(), transfer.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()));
        }
        transfer.update(DefaultField.RequireField.PRODUCTIONORGUNIT.getName(), require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        transfer.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), null);
        transfer.update(DefaultField.RequireField.BILLID.getName(), supply.getValue(DefaultField.SupplyField.BILLID.getName()));
        transfer.update(DefaultField.RequireField.BILLNUMBER.getName(), supply.getValue(DefaultField.SupplyField.BILLNUMBER.getName()));
        transfer.update(DefaultField.RequireField.BILLENTRYID.getName(), null);
        transfer.update(DefaultField.RequireField.BILLENTRYSEQ.getName(), null);
        transfer.update(DefaultField.CommonField.__MODEL_NUMBER__.name(), (Object)ResManager.loadKDString((String)"\u534f\u540c\u8ba1\u5212\u8ba2\u5355", (String)"MRPUtil_3", (String)"mmc-mrp-mservice", (Object[])new Object[0]));
        transfer.update(DefaultField.RequireField.BILL_ENTITY.getName(), supply.getValue(DefaultField.SupplyField.BILL_ENTITY.getName()));
        MRPUtil.updateTransferRequire(transfer, require, rc, originRequireOrg);
        transfer.update(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName(), null);
        return true;
    }

    public static void updateTransferRequire(RequireRowData transfer, RequireRowData require, String rc, Object originRequireOrg) {
        transfer.update(DefaultField.RequireField.MATERIALATTR.getName(), null);
        DataBalanceUtil.clearRequireData(transfer);
        transfer.update(DefaultField.RequireField.__REQUIRE_ORG_CHAIN__.getName(), (Object)rc);
        transfer.update(DefaultField.RequireField.__ORIGIN_REQUIRE_ORG__.getName(), originRequireOrg);
        transfer.update(DefaultField.RequireField.DEMAND_SUPPLY_STRATEGY.getName(), require.getValue(DefaultField.RequireField.SUPPLY_STRATEGY.getName()));
        if (BillSupplyStrategy.INVENTORY.getValue().equals(require.getString(DefaultField.RequireField.SUPPLY_STRATEGY.getName()))) {
            transfer.update(DefaultField.RequireField.IN_STORAGE_ORG.getName(), require.getValue(DefaultField.RequireField.IN_STORAGE_ORG.getName()));
            transfer.update(DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName(), require.getValue(DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName()));
            transfer.update(DefaultField.RequireField.IN_STORAGE_SHIPPING.getName(), require.getValue(DefaultField.RequireField.IN_STORAGE_SHIPPING.getName()));
            transfer.update(DefaultField.RequireField.DEMANDPLANSCOPE.getName(), require.getValue(DefaultField.RequireField.PLANSCOPE.getName()));
            transfer.update(DefaultField.RequireField.DEMAND_PLANMODE.getName(), require.getValue(DefaultField.RequireField.PLANMODE.getName()));
            transfer.update(DefaultField.RequireField.__INVLEVEL_REQUIRE__.getName(), require.getValue(DefaultField.RequireField.__INVLEVEL_REQUIRE__.getName()));
            transfer.update(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName(), require.getValue(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName()));
        }
    }

    private static String getWrapOrgId(Object orgId) {
        return String.format("@%s@", orgId);
    }

    public static boolean isNeedReserve(CalEnv calEnv, RequireRowData require) {
        PlanModel planModel = (PlanModel)calEnv.getService(PlanModel.class);
        String reservedType = require.getString(DefaultField.RequireField.RESERVEDTYPE.getName());
        return planModel.isReserve() && StringUtils.isNotBlank((CharSequence)reservedType) && !StringUtils.equals((CharSequence)reservedType, (CharSequence)"C");
    }

    public static BigDecimal divide(IMRPEnvProvider provider, Object unitId, BigDecimal b1, BigDecimal b2) {
        UnitPrecisionParam unitPrecisionParam = MRPUtil.getUnitPrecisionParam(unitId, provider);
        BigDecimal bd = b1.divide(b2, unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
        return bd;
    }

    public static BigDecimal multiply2(IMRPEnvProvider provider, Object unitId, BigDecimal b1, BigDecimal b2) {
        UnitPrecisionParam unitPrecisionParam = MRPUtil.getUnitPrecisionParam(unitId, provider);
        BigDecimal bd = b1.multiply(b2).setScale(unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
        return bd;
    }

    public static void addInvPlanMaterial(CalEnv ctx, Long orgId, Long masterId, String planMode, Set<String> invPlanMaterials) {
        PlanModel pm = (PlanModel)ctx.getService(PlanModel.class);
        boolean isReorderPoint = pm.isReorderPoint();
        boolean isMaxMin = pm.isMaxMinInventory();
        HashSet<String> requireOrgs = pm.getRequirorgs();
        if (requireOrgs.contains(String.valueOf(orgId))) {
            if (isReorderPoint && MaterialPlanMode.REORDERPOINT.getValue().equalsIgnoreCase(planMode)) {
                invPlanMaterials.add(String.valueOf(masterId));
            } else if (isMaxMin && MaterialPlanMode.MAXANDMININV.getValue().equalsIgnoreCase(planMode)) {
                invPlanMaterials.add(String.valueOf(masterId));
            }
        }
    }

    public static String subExceptionMsg(String msg) {
        if (msg != null && msg.length() > 250) {
            msg = msg.substring(0, 250);
        }
        return msg;
    }

    public static boolean isRemoveHisBill(CalEnv env, Long billId, String billEntity, int llc) {
        CacheDatas cacheDatas = (CacheDatas)env.getService(CacheDatas.class);
        RequireDataModel requireDataModel = (RequireDataModel)env.getService(RequireDataModel.class);
        if (requireDataModel.getOutputType().equals(billEntity) || requireDataModel.getOutputCollaborativeorder().equals(billEntity)) {
            if (cacheDatas.isSelectBillPlan()) {
                if (requireDataModel.getOutputType().equals(billEntity) && requireDataModel.getSelectPlanDeleteOrderIds().contains(billId)) {
                    return true;
                }
                if (requireDataModel.getOutputCollaborativeorder().equals(billEntity) && requireDataModel.getSelectPlanDeleteCollIds().contains(billId)) {
                    return true;
                }
            }
            if (cacheDatas.isSelectBillPlan()) {
                --llc;
            }
            if (cacheDatas.isSelectMaterialPlan() || cacheDatas.isSelectBillPlan()) {
                for (int l = llc; l >= 0; --l) {
                    Set<Long> bills = cacheDatas.getDeleteBillsByLlc(l, billEntity);
                    if (bills == null || !bills.contains(billId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Long getExpendBomTime(IMRPEnvProvider ctx, RowData parent) {
        String bomExpandSettings = (String)ctx.getCfgValue(EnvCfgItem.BOM_EXPAND_SETTINGS);
        Long bomTime = MRPUtil.convert(parent.getValue(DefaultField.RequireField.__START_DATE__.getName()), ctx.getPlanDate().getTime());
        if ("GET_NOW".equals(bomExpandSettings) && bomTime < ctx.getPlanDate().getTime()) {
            bomTime = ctx.getPlanDate().getTime();
        }
        bomTime = bomTime + ctx.getPlanTs();
        return bomTime;
    }

    public static void isUseEnableOrder(IMRPEnvProvider ctx, SupplymentDataTable supplyTbl, List<Integer> supplys, RequireRowData require) {
        Iterator<Integer> it = supplys.iterator();
        List<String> supplyBills = Arrays.asList("pom_mftorder", "om_mftorder", "mrp_planorder", "pm_om_purorderbill");
        while (it.hasNext()) {
            Integer idx = it.next();
            RowData supplyRow = supplyTbl.fetchRow(idx);
            String entity = MRPUtil.convert(supplyRow.get(DefaultField.SupplyField.BILL_ENTITY.getName()), "");
            if (supplyBills.contains(entity) && ctx.getCustomParams("is_use_" + entity) != null) {
                it.remove();
                continue;
            }
            if (DataBalanceUtil.isInPeriod1(require, supplyRow, ctx)) continue;
            it.remove();
        }
    }

    public static Integer findSupOrReqIndex(IMRPEnvProvider ctx, boolean isRequire, Integer idx) {
        RequirementDataTable requireTbl = ctx.requireDatas();
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        if (isRequire) {
            Object billId = requireTbl.getValue(DefaultField.RequireField.BILLID.getName(), idx);
            Object billEntryId = requireTbl.getValue(DefaultField.RequireField.BILLENTRYID.getName(), idx);
            List<Integer> idList = supplyTbl.getCol(DefaultField.RequireField.BILLID.getName()).get(billId);
            List<Integer> entryIdList = supplyTbl.getCol(DefaultField.RequireField.BILLENTRYID.getName()).get(billEntryId);
            idList.retainAll(entryIdList);
            return idList.get(0);
        }
        Object billId = supplyTbl.getValue(DefaultField.SupplyField.BILLID.getName(), idx);
        Object billEntryId = supplyTbl.getValue(DefaultField.SupplyField.BILLENTRYID.getName(), idx);
        List<Integer> idList = requireTbl.getCol(DefaultField.RequireField.BILLID.getName()).get(billId);
        List<Integer> entryIdList = requireTbl.getCol(DefaultField.RequireField.BILLENTRYID.getName()).get(billEntryId);
        idList.retainAll(entryIdList);
        return idList.get(0);
    }

    public static class UnitPrecisionParam {
        public final int scale;
        public final RoundingMode roundingMode;

        public UnitPrecisionParam(int scale, RoundingMode roundingMode) {
            this.scale = scale;
            this.roundingMode = roundingMode;
        }
    }

    public static class MergeCache {
        private Map<Integer, DataBalanceTable.RSMapping> unMerges;
        private Map<Integer, DataBalanceTable.RSMapping> merges;

        public MergeCache(int initCapacity) {
            this.unMerges = new HashMap<Integer, DataBalanceTable.RSMapping>(initCapacity);
            this.merges = new HashMap<Integer, DataBalanceTable.RSMapping>(initCapacity);
        }

        public Map<Integer, DataBalanceTable.RSMapping> getUnMerges() {
            return this.unMerges;
        }

        public Map<Integer, DataBalanceTable.RSMapping> getMerges() {
            return this.merges;
        }
    }
}

