/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.utils;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RunLogModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.vo.DynamicCycleVo;

public class QuotaAllocationUtil {
    private static final Log logger = LogFactory.getLog(QuotaAllocationUtil.class);

    public static void mergeCycleRsMapping(IMRPEnvProvider provider, Date mergeDate, Map<Long, List<DataBalanceTable.RSMapping>> rsMappingMap, DataBalanceTable.RSMapping nxmapping, Map<Integer, Boolean> cache) {
        long cycleTime = mergeDate.getTime();
        nxmapping.getRequire().update(DefaultField.RequireField.DATE.getName(), (Object)MRPUtil.getDateByCalendar(mergeDate, nxmapping, provider).getTime());
        List rsMappingList = rsMappingMap.computeIfAbsent(cycleTime, k -> new ArrayList(16));
        if (!rsMappingList.isEmpty()) {
            boolean isMatch = false;
            for (DataBalanceTable.RSMapping rsMapping : rsMappingList) {
                if (rsMapping.getBeforeMergedQty() == null) {
                    rsMapping.setBeforeMergedQty(rsMapping.getrQty());
                }
                if (!QuotaAllocationUtil.requireMatch(provider, rsMapping, nxmapping, cache)) continue;
                isMatch = true;
                break;
            }
            if (!isMatch) {
                rsMappingList.add(nxmapping);
            }
        } else {
            rsMappingList.add(nxmapping);
        }
    }

    public static boolean requireMatch(IMRPEnvProvider provider, DataBalanceTable.RSMapping rsMapping, DataBalanceTable.RSMapping nxmapping, Map<Integer, Boolean> cache) {
        if (!MRPUtil.convert(rsMapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getAlias()), MaterialAttribute.OTHER.getValue()).equals(MRPUtil.convert(nxmapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getAlias()), MaterialAttribute.OTHER.getValue()))) {
            return false;
        }
        if (DataBalanceUtil.isMatch(provider, rsMapping.getRequire(), nxmapping.getRequire(), true, cache) && DataBalanceUtil.isMatch(provider, nxmapping.getRequire(), rsMapping.getRequire(), true, cache)) {
            rsMapping.setrQty(rsMapping.getrQty().add(nxmapping.getrQty()));
            nxmapping.setGenPlanOrder(false);
            nxmapping.setCreateDepentRequire(false);
            MRPUtil.addChildMapping(rsMapping, nxmapping, 2);
            return true;
        }
        return false;
    }

    public static void addNewDynamicVo(Date date, Map<Long, List<DataBalanceTable.RSMapping>> rsMappingMap, List<DynamicCycleVo> dynamicCycleVos, DataBalanceTable.RSMapping nxMapping) {
        DynamicCycleVo dynamicCycleVo = new DynamicCycleVo(nxMapping, 1);
        dynamicCycleVos.add(dynamicCycleVo);
        List rsMappingList = rsMappingMap.computeIfAbsent(date.getTime(), k -> new ArrayList(16));
        rsMappingList.add(nxMapping);
    }

    public static BigDecimal richMappingSupply(IMRPEnvProvider ctx, DataBalanceTable.RSMapping mapping, List<DataBalanceTable.RSMapping> purQuotaRich, Map<Integer, Boolean> cache) {
        RequireRowData require = mapping.getRequire();
        BigDecimal rQty = mapping.getrQty();
        ListIterator<DataBalanceTable.RSMapping> richIts = purQuotaRich.listIterator();
        while (richIts.hasNext()) {
            RowData rowData;
            DataBalanceTable.RSMapping xsMapping = (DataBalanceTable.RSMapping)richIts.next();
            if (!MRPUtil.convert(xsMapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue()).equals(MRPUtil.convert(mapping.getRequire().getValue(DefaultField.RequireField.MATERIALATTR.getName()), MaterialAttribute.OTHER.getValue())) || !DataBalanceUtil.isMatch(ctx, require, rowData = DataMatchUtils.rsMappingToSupply(ctx, xsMapping), cache)) continue;
            BigDecimal richQty = xsMapping.getrQty();
            if (richQty.compareTo(rQty) >= 0) {
                richQty = richQty.subtract(rQty);
                mapping.setrQty(rQty);
                xsMapping.setrQty(richQty);
                if (QuotaAllocationUtil.isHaveChild(mapping, false)) {
                    if (QuotaAllocationUtil.checkMergeQtyUpZero(mapping)) {
                        mapping.setrQty(mapping.getBeforeMergedQty());
                    }
                    for (DataBalanceTable.RSMapping child : mapping.getChildMappings()) {
                        QuotaAllocationUtil.setOnlyDetailRSMapping(child, xsMapping);
                    }
                }
                QuotaAllocationUtil.setOnlyDetailRSMapping(mapping, xsMapping);
                if (richQty.compareTo(BigDecimal.ZERO) <= 0) {
                    richIts.remove();
                }
                return BigDecimal.ZERO;
            }
            rQty = rQty.subtract(richQty);
            if (QuotaAllocationUtil.isHaveChild(mapping, true)) {
                DataBalanceTable.RSMapping newnxMapping;
                if (QuotaAllocationUtil.checkMergeQtyUpZero(mapping) && richQty.compareTo(mapping.getBeforeMergedQty()) >= 0) {
                    newnxMapping = mapping.clone();
                    newnxMapping.setrQty(mapping.getBeforeMergedQty());
                    QuotaAllocationUtil.setOnlyDetailRSMapping(newnxMapping, xsMapping, true);
                    ctx.calcBalanceDetails().getUnVisitedMappings().add(newnxMapping);
                    xsMapping.setrQty(richQty.subtract(mapping.getBeforeMergedQty()));
                    mapping.setBeforeMergedQty(BigDecimal.ZERO);
                    mapping.setCalDetail(false);
                    QuotaAllocationUtil.richSupplyChildMappings(ctx, mapping, xsMapping);
                } else {
                    mapping.setBeforeMergedQty(mapping.getBeforeMergedQty().subtract(richQty));
                    newnxMapping = mapping.clone();
                    newnxMapping.setrQty(richQty);
                    QuotaAllocationUtil.setOnlyDetailRSMapping(newnxMapping, xsMapping, true);
                    ctx.calcBalanceDetails().getUnVisitedMappings().add(newnxMapping);
                }
            } else if (QuotaAllocationUtil.isHaveChild(mapping, false)) {
                QuotaAllocationUtil.richSupplyChildMappings(ctx, mapping, xsMapping);
            } else {
                mapping.setBeforeMergedQty(rQty);
                DataBalanceTable.RSMapping splitMapping = mapping.clone();
                splitMapping.setrQty(richQty);
                QuotaAllocationUtil.setOnlyDetailRSMapping(splitMapping, xsMapping, true);
                ctx.calcBalanceDetails().getUnVisitedMappings().add(splitMapping);
            }
            richIts.remove();
        }
        return rQty;
    }

    private static void richSupplyChildMappings(IMRPEnvProvider ctx, DataBalanceTable.RSMapping mapping, DataBalanceTable.RSMapping richMapping) {
        BigDecimal richQty = richMapping.getrQty();
        Iterator<DataBalanceTable.RSMapping> childMappingIterator = mapping.getChildMappings().iterator();
        while (richQty.compareTo(BigDecimal.ZERO) > 0 && childMappingIterator.hasNext()) {
            DataBalanceTable.RSMapping child = childMappingIterator.next();
            if (richQty.compareTo(child.getrQty()) >= 0) {
                richQty = richQty.subtract(child.getrQty());
                childMappingIterator.remove();
                QuotaAllocationUtil.setOnlyDetailRSMapping(child, richMapping);
                continue;
            }
            if (richQty.compareTo(child.getrQty()) >= 0) continue;
            child.setrQty(child.getrQty().subtract(richQty));
            DataBalanceTable.RSMapping newChildMapping = child.clone();
            newChildMapping.setrQty(richQty);
            QuotaAllocationUtil.setOnlyDetailRSMapping(newChildMapping, richMapping, true);
            ctx.calcBalanceDetails().getUnVisitedMappings().add(newChildMapping);
            break;
        }
    }

    public static void setOnlyDetailRSMapping(DataBalanceTable.RSMapping mapping, DataBalanceTable.RSMapping richMapping) {
        QuotaAllocationUtil.setOnlyDetailRSMapping(mapping, richMapping, false);
    }

    public static void setOnlyDetailRSMapping(DataBalanceTable.RSMapping mapping, DataBalanceTable.RSMapping richMapping, boolean isClearSupply) {
        String poNum = richMapping.getRequire().getString(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName());
        Long poId = richMapping.getRequire().getLong(DefaultField.RequireField.__PO_ID__.getName());
        mapping.setGenPlanOrder(false);
        mapping.getRequire().update(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName(), (Object)poNum);
        mapping.getRequire().update(DefaultField.RequireField.__PO_ID__.getName(), (Object)poId);
        mapping.getRequire().update(DefaultField.RequireField.SUPPLY_MATERIALFLEXPROPS.getName(), richMapping.getRequire().getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()));
        mapping.getRequire().update(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName(), richMapping.getRequire().getValue(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName()));
        mapping.getRequire().update(DefaultField.RequireField.BATCHPOLICYRICHDATE.getName(), richMapping.getRequire().getValue(DefaultField.RequireField.BATCHPOLICYRICHDATE.getName()));
        mapping.getRequire().update(DefaultField.RequireField.SUPPLY_TRACKNUMBER.getName(), richMapping.getRequire().getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
        mapping.setCreateDepentRequire(false);
        if (isClearSupply) {
            mapping.setSupplys(new ArrayList<RowData>());
        }
        if (mapping.getPoList() != null) {
            mapping.getPoList().clear();
        }
    }

    public static boolean isHaveChild(DataBalanceTable.RSMapping mapping, boolean checkMergeQtyUpZero) {
        boolean havChild;
        boolean bl = havChild = mapping.getChildMappings() != null && !mapping.getChildMappings().isEmpty();
        if (checkMergeQtyUpZero) {
            havChild = havChild && QuotaAllocationUtil.checkMergeQtyUpZero(mapping);
        }
        return havChild;
    }

    public static boolean checkMergeQtyUpZero(DataBalanceTable.RSMapping mapping) {
        return mapping.getBeforeMergedQty() != null && mapping.getBeforeMergedQty().compareTo(BigDecimal.ZERO) > 0;
    }

    public static void setSupplierRSMapping(DataBalanceTable.RSMapping mapping, Long supplier, Long poId, String poNum) {
        mapping.getRequire().update(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName(), (Object)supplier);
        mapping.getRequire().update(DefaultField.RequireField.__BATCHPOLICY_BILLNUMBER__.getName(), (Object)poNum);
        mapping.getRequire().update(DefaultField.RequireField.__PO_ID__.getName(), (Object)poId);
    }

    public static void setSupplierAndOnlyDetailRSMapping(DataBalanceTable.RSMapping mapping, Long supplier, Long poId, String poNum, boolean isClearSupply) {
        mapping.setGenPlanOrder(false);
        mapping.setCreateDepentRequire(false);
        if (isClearSupply) {
            mapping.setSupplys(new ArrayList<RowData>(0));
        }
        if (mapping.getPoList() != null) {
            mapping.getPoList().clear();
        }
        QuotaAllocationUtil.setSupplierRSMapping(mapping, supplier, poId, poNum);
    }

    public static void setSupplierChildMappings(IMRPEnvProvider ctx, DataBalanceTable.RSMapping mapping, BigDecimal qty, Long supplier, Long poId, String poNum) {
        Iterator<DataBalanceTable.RSMapping> childMappingIterator = mapping.getChildMappings().iterator();
        while (qty.compareTo(BigDecimal.ZERO) > 0 && childMappingIterator.hasNext()) {
            DataBalanceTable.RSMapping child = childMappingIterator.next();
            if (qty.compareTo(child.getrQty()) >= 0) {
                qty = qty.subtract(child.getrQty());
                childMappingIterator.remove();
                QuotaAllocationUtil.setSupplierAndOnlyDetailRSMapping(child, supplier, poId, poNum, false);
                continue;
            }
            if (qty.compareTo(child.getrQty()) >= 0) continue;
            child.setrQty(child.getrQty().subtract(qty));
            DataBalanceTable.RSMapping newChildMapping = child.clone();
            newChildMapping.setrQty(qty);
            QuotaAllocationUtil.setSupplierAndOnlyDetailRSMapping(newChildMapping, supplier, poId, poNum, true);
            ctx.calcBalanceDetails().getUnVisitedMappings().add(newChildMapping);
            break;
        }
    }

    public static DataBalanceTable.RSMapping createRichEmptyRequire(IMRPEnvProvider ctx, DataBalanceTable.RSMapping mapping, BigDecimal qty, Long supplier, boolean isGenPlanOrder) {
        DataBalanceTable.RSMapping clone = mapping.clone();
        clone.setGenPlanOrder(isGenPlanOrder);
        clone.setCreateDepentRequire(isGenPlanOrder);
        clone.setClearRequire(true);
        clone.setrQty(qty);
        clone.setBeforeMergedQty(qty);
        clone.setSupplys(new ArrayList<RowData>(0));
        clone.setChildMappings(null);
        clone.getRequire().update(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName(), (Object)supplier);
        ctx.calcBalanceDetails().getUnVisitedMappings().add(clone);
        return clone;
    }

    public static boolean isPurchaseQuota(IMRPEnvProvider ctx, RequireRowData require) {
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        boolean ispurquota = (Boolean)planModel.getPlanDataByParam("ispurquota", false);
        if (ispurquota) {
            Long outquotaschemeid = (Long)planModel.getPlanDataByParam("outquotaschemeid", 0L);
            Long outsourcequotaid = (Long)planModel.getPlanDataByParam("outsourcequotaid", 0L);
            String materialAttr = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIALATTR.getName()), "");
            Long supplier = MRPUtil.convert(require.getValue(DefaultField.RequireField.SUPPLIER.getName()), 0L);
            boolean ifCalc = StringUtils.equals((CharSequence)"10050", (CharSequence)materialAttr) && outsourcequotaid > 0L || StringUtils.equals((CharSequence)"10040", (CharSequence)materialAttr) && outquotaschemeid > 0L;
            ispurquota = ifCalc && supplier <= 0L;
        }
        return ispurquota;
    }

    public static Map<Long, BigDecimal> getSupplierRatio(IMRPEnvProvider ctx, RequireRowData require, BigDecimal rQty, Map<String, Map<String, BigDecimal>> historySupplierQty) {
        RunLogModel runLogModel = (RunLogModel)ctx.getService(RunLogModel.class);
        CacheDatas cacheDatas = (CacheDatas)ctx.getService(CacheDatas.class);
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        Long material = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIAL.getName()), 0L);
        Long org = MRPUtil.convert(require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()), 0L);
        String matter = MRPUtil.convert(require.getValue(DefaultField.RequireField.MATERIALATTR.getName()), "");
        long quotaSchemeID = 0L;
        quotaSchemeID = "10040".equals(matter) ? ((Long)planModel.getPlanDataByParam("outquotaschemeid", 0L)).longValue() : ((Long)planModel.getPlanDataByParam("outsourcequotaid", 0L)).longValue();
        LinkedHashMap<Long, BigDecimal> supplierRatio = new LinkedHashMap<Long, BigDecimal>(16);
        Long uuID = ID.genLongId();
        org = cacheDatas.getPurOrgBySupplyOrg(org);
        HashMap<String, Serializable> first = new HashMap<String, Serializable>();
        first.put("quotaSchemeID", Long.valueOf(quotaSchemeID));
        HashMap second = new HashMap();
        HashMap<String, Object> third = new HashMap<String, Object>();
        third.put("org", org);
        third.put("material", material);
        Date planDate = runLogModel.getPlanDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = sdf.format(planDate);
        third.put("validdate", format);
        third.put("baseQty", rQty);
        String orgAndMid = String.format("%s\u0001%s", org, material);
        Map supplierBaseQty = historySupplierQty.computeIfAbsent(orgAndMid, k -> new HashMap(2));
        if (!supplierBaseQty.isEmpty()) {
            third.put("supplierBaseQty", supplierBaseQty);
        }
        second.put(String.valueOf(uuID), third);
        first.put("dataInfos", second);
        if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-Quota-getSupplierRatio-param: %s", ctx.getMRPContextId(), JSON.toJSONString(first)));
        }
        Map result = null;
        TraceSpan ts = Tracer.create((String)"MRPDataBalanceResolver.getSupplierRatio", (String)"getSupplierRatio");
        Object object = null;
        try {
            result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"msbdQuotaService", (String)"quotaCalculateService", (Object[])new Object[]{first});
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ts != null) {
                if (object != null) {
                    try {
                        ts.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ts.close();
                }
            }
        }
        if (result != null && ((Boolean)result.get("success")).booleanValue()) {
            List data = (List)result.get("quotaRecordDetails");
            if (data != null) {
                for (Map map : data) {
                    Boolean dataSuccess = (Boolean)map.get("dataSuccess");
                    if (dataSuccess.booleanValue()) {
                        Map quotaCalculateResultInfos = (Map)map.get("quotaCalculateResultInfos");
                        for (List o : quotaCalculateResultInfos.values()) {
                            for (Map values : o) {
                                Long supplierId = MRPUtil.convert(values.get("supplier"), 0L);
                                BigDecimal quotaBaseQty = MRPUtil.convert(values.get("srcAdjustBaseQty"), BigDecimal.ZERO);
                                if (quotaBaseQty.compareTo(BigDecimal.ZERO) <= 0 || supplierId <= 0L) continue;
                                supplierRatio.put(supplierId, quotaBaseQty);
                                supplierBaseQty.put(supplierId.toString(), supplierBaseQty.getOrDefault(supplierId.toString(), BigDecimal.ZERO).add(quotaBaseQty));
                            }
                        }
                        continue;
                    }
                    String recordDetail = (String)map.get("recordDetail");
                    logger.warn(String.format("ctxid: %s, mrprunner-getSupplierRatio-fail, recordDetail: %s", ctx.getMRPContextId(), recordDetail));
                }
            }
        } else if (result != null && !((Boolean)result.get("success")).booleanValue()) {
            String detail = (String)result.get("detail");
            if (StringUtils.isBlank((CharSequence)detail)) {
                StringBuilder sb = new StringBuilder();
                List data = (List)result.get("quotaRecordDetails");
                if (data != null) {
                    for (Map map : data) {
                        Boolean dataSuccess = (Boolean)map.get("dataSuccess");
                        if (dataSuccess.booleanValue()) continue;
                        sb.append(map.get("recordDetail")).append(',');
                    }
                }
                detail = sb.toString();
            }
            logger.warn(String.format("ctxid: %s, mrprunner-getSupplierRatio-fail, recordDetail: %s", ctx.getMRPContextId(), detail));
        }
        if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG)) && result != null) {
            logger.warn(String.format("ctxid: %s, mrprunner-Quota-getSupplierRatio-result: %s", ctx.getMRPContextId(), JSON.toJSONString((Object)result)));
        }
        return supplierRatio;
    }
}

