/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.utils;

import kd.bos.algo.AlgoException;
import kd.bos.algo.sql.Parser;
import kd.bos.algo.sql.g.GLexer;
import kd.bos.algo.sql.g.GParser;
import kd.bos.algo.sql.parser.ASTBuilder;
import kd.bos.algo.sql.parser.NoCaseStringStream;
import kd.bos.algo.sql.parser.ParseErrorListener;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.util.AlgoSystemInit;
import kd.bos.exception.KDBizException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;

public class SqlExprParser
extends Parser {
    private ParseErrorListener errorListener = new ParseErrorListener();

    public Expr parseExpr(String expr) {
        try {
            GParser parser = this.parse(expr);
            ASTBuilder visitor = new ASTBuilder(expr);
            Expr result = (Expr)visitor.visitExpression(parser.expression());
            int type = parser.getCurrentToken().getType();
            if (type != -1) {
                String text = parser.getCurrentToken().getText();
                throw new KDBizException("unexpected '" + text + "'");
            }
            return result;
        }
        catch (Throwable e) {
            throw new AlgoException("Parser '" + expr + "' error:" + e.getMessage(), e);
        }
    }

    public Expr parseSortList(String s) {
        throw new KDBizException("not supported");
    }

    private GParser parse(String sql) {
        GLexer lexer = new GLexer((CharStream)new NoCaseStringStream(sql));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)this.errorListener);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        GParser parser = new GParser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)this.errorListener);
        try {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return parser;
        }
        catch (Exception e) {
            throw new AlgoException("Error parse " + sql, (Throwable)e);
        }
    }

    static {
        AlgoSystemInit.init();
    }
}

