/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.algox.function;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.CustomizedOutput;
import kd.bos.algo.RowMeta;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.mmc.mrp.algox.util.IDGen;
import kd.mmc.mrp.algox.util.MRPAlgoxCache;

public class PegInfoOutPut
implements CustomizedOutput {
    private static final long serialVersionUID = 1553432677433L;
    private static final String route = "scm";
    private static final int BATCH_SIZE = 5000;
    private static final String CACHE_CNT = "peginfocnt";
    private RowMeta rowMeta;
    private String sql;
    private List<Object[]> batchData;
    private int count;
    private MRPAlgoxCache cache;
    private int entryIdx;
    private int seqIdx;
    private IDGen idGen;
    private int rowSize;

    public PegInfoOutPut(String contextId, String sql, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.sql = sql;
        this.entryIdx = rowMeta.getFieldIndex("entryid");
        this.seqIdx = rowMeta.getFieldIndex("seq");
        this.cache = new MRPAlgoxCache(contextId);
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public boolean isSingleParallel() {
        return false;
    }

    public void open() {
        this.batchData = new ArrayList<Object[]>(5000);
        this.idGen = new IDGen(1000);
        this.rowSize = 0;
    }

    public void write(Object[] row) {
        ++this.count;
        ++this.rowSize;
        this.batchData.add(row);
        row[this.seqIdx] = this.rowSize;
        row[this.entryIdx] = this.idGen.next();
        if (this.count == 5000) {
            DB.executeBatch((DBRoute)DBRoute.of((String)route), (String)this.sql, this.batchData);
            this.batchData.clear();
            this.count = 0;
        }
    }

    public void close() {
        if (this.count > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)route), (String)this.sql, this.batchData);
            this.batchData.clear();
        }
        this.cache.incrBy(CACHE_CNT, this.rowSize);
    }

    public int getRowSize() {
        long l = this.cache.incrBy(CACHE_CNT, 0);
        return (int)l;
    }

    public void removeCache() {
        this.cache.remove(CACHE_CNT);
    }
}

