/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.algox.job;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.Collector;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.algox.function.PegInfoOutPut;
import kd.mmc.mrp.algox.util.TimeLog;

public class MRPCreatePegInfoJob {
    private static final Log logger = LogFactory.getLog(MRPCreatePegInfoJob.class);
    private static final String TB_PEG = "mrp_peginfodata";
    private static final String TB_DETAIL = "mrp_calcdetail";
    private static final String TB_MT = "bd_material";
    private static String DETAIL_FIELD;
    private static String[] FIELD_NEED_CHANGE;
    private static String INSERT_SQL;
    private Date planDate;
    private JobSession session;
    private static String[] rmvs;

    public MRPCreatePegInfoJob(Date planDate) {
        this.planDate = planDate;
        this.init();
    }

    public int execute(String contextId, String runLogNumber) {
        return this.execute(contextId, runLogNumber, 120, 120, TimeUnit.MINUTES);
    }

    public int execute(String contextId, String runLogNumber, int commitTimeout, int runningTimeout, TimeUnit timeUnit) {
        QFilter logFilter = new QFilter("caculatelog", "=", (Object)runLogNumber);
        QFilter demandFilter = new QFilter("entryentity.demandqty", ">", (Object)0);
        QFilter supplyFilter = new QFilter("entryentity.supplyqty", ">", (Object)0);
        QFilter typeFilter = new QFilter("entryentity.supplybilltype", "!=", (Object)Character.valueOf(' '));
        QFilter[] filters = new QFilter[]{logFilter, demandFilter, supplyFilter, typeFilter};
        String sel = DETAIL_FIELD + ",entryentity.llc llc,entryentity.billid billid,entryentity.billentryid billentryid";
        DataSetX dataSetX = this.getDataSetX(filters, sel, runLogNumber);
        RowMeta rowMeta = dataSetX.getRowMeta();
        PegInfoOutPut output = new PegInfoOutPut(contextId, INSERT_SQL, rowMeta);
        dataSetX.output((Output)output);
        try (TimeLog timeLog = TimeLog.get("CreatePegInfoTimeLog");){
            this.session.getContext().setParallelism(4);
            this.session.commit(commitTimeout, runningTimeout, timeUnit);
            int rowSize = output.getRowSize();
            output.removeCache();
            timeLog.cost();
            int n = rowSize;
            return n;
        }
    }

    private DataSetX getDataSetX(QFilter[] filters, String sel, String runLog) {
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)TB_PEG);
        dyn.set("billno", (Object)runLog);
        dyn.set("billstatus", (Object)"C");
        dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
        dyn.set("createtime", (Object)new Date());
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        Object id = ((DynamicObject)save[0]).getPkValue();
        String billKey = "reqsourcebillno";
        String eBillKey = "entryentity." + billKey;
        String eeKey = "entryentity.id";
        QFilter hasBillno = new QFilter(eBillKey, "!=", (Object)Character.valueOf(' '));
        QFilter noBillno = new QFilter(eBillKey, "=", (Object)Character.valueOf(' '));
        QFilter ekF1 = QFilter.of((String)(eeKey + " % 4 = 0"), (Object[])new Object[0]);
        QFilter ekF2 = QFilter.of((String)(eeKey + " % 4 = 1"), (Object[])new Object[0]);
        QFilter ekF3 = QFilter.of((String)(eeKey + " % 4 = 2"), (Object[])new Object[0]);
        QFilter ekF4 = QFilter.of((String)(eeKey + " % 4 = 3"), (Object[])new Object[0]);
        this.session = AlgoX.createSession((String)this.getClass().getName());
        ArrayList<QFilter> hasFilters = new ArrayList<QFilter>(Arrays.asList(filters));
        hasFilters.add(hasBillno);
        ArrayList<QFilter> noFilters = new ArrayList<QFilter>(Arrays.asList(filters));
        noFilters.add(noBillno);
        Field[] fields = new Field[]{new Field("requireunit", (DataType)DataType.LongType), new Field("supplyunit", (DataType)DataType.LongType), new Field("configuredcodedem", (DataType)DataType.LongType), new Field("id", (DataType)DataType.LongType), new Field("entryid", (DataType)DataType.LongType), new Field("seq", (DataType)DataType.IntegerType)};
        Object[] vals = new Object[]{0L, 0L, 0L, id, 0L, 0};
        OrmInput input11 = new OrmInput("CreatePegInfoDataStep1", TB_DETAIL, sel, this.toArray(hasFilters, ekF1));
        OrmInput input12 = new OrmInput("CreatePegInfoDataStep2", TB_DETAIL, sel, this.toArray(hasFilters, ekF2));
        OrmInput input13 = new OrmInput("CreatePegInfoDataStep3", TB_DETAIL, sel, this.toArray(hasFilters, ekF3));
        OrmInput input14 = new OrmInput("CreatePegInfoDataStep4", TB_DETAIL, sel, this.toArray(hasFilters, ekF4));
        DataSetX ds1 = this.session.fromInput(new Input[]{input11, input12, input13, input14});
        ds1 = ds1.addFields(fields, vals);
        ds1 = ds1.groupBy(new String[]{billKey}).reduceGroup((GroupReduceFunction)new PegInfoReduceFunction(ds1.getRowMeta(), this.planDate.getTime()));
        ds1 = ds1.removeFields(rmvs);
        OrmInput input2 = new OrmInput("CreatePegInfoDataStep2", TB_DETAIL, sel, noFilters.toArray(new QFilter[0]));
        DataSetX ds2 = this.session.fromInput((Input)input2);
        ds2 = ds2.addFields(fields, vals);
        ds2 = ds2.groupBy(new String[]{"billid", "billentryid"}).reduceGroup((GroupReduceFunction)new PegInfoReduceFunction(ds2.getRowMeta(), this.planDate.getTime()));
        ds2 = ds2.removeFields(rmvs);
        return ds1.union(ds2);
    }

    private QFilter[] toArray(List<QFilter> hasFilters, QFilter ekF1) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(hasFilters.size() + 1);
        list.addAll(hasFilters);
        list.add(ekF1);
        return list.toArray(new QFilter[0]);
    }

    private void init() {
        LinkedHashMap<String, String> DETAIL_PEG_FIELDS = new LinkedHashMap<String, String>(32);
        DETAIL_PEG_FIELDS.put("requireorg", "requireorg");
        DETAIL_PEG_FIELDS.put("demandbilltype", "requirebilltpye");
        DETAIL_PEG_FIELDS.put("material", "requirematerial");
        DETAIL_PEG_FIELDS.put("demandauxpty", "demandauxpty");
        DETAIL_PEG_FIELDS.put("requireoperator", "requireoperator");
        DETAIL_PEG_FIELDS.put("reqsourcebillno", "requirebillno");
        DETAIL_PEG_FIELDS.put("billno", "reqbillno");
        DETAIL_PEG_FIELDS.put("billentryseq", "requirebillseq");
        DETAIL_PEG_FIELDS.put("demandqty", "requireqty");
        DETAIL_PEG_FIELDS.put("origindemanddate", "requiredate");
        DETAIL_PEG_FIELDS.put("reqpriority", "requirepriority");
        DETAIL_PEG_FIELDS.put("supplybillno", "supplybillno");
        DETAIL_PEG_FIELDS.put("supplybillentryseq", "supplybillentryseq");
        DETAIL_PEG_FIELDS.put("supmaterial", "supplymaterial");
        DETAIL_PEG_FIELDS.put("supplyauxpty", "supplyauxpty");
        DETAIL_PEG_FIELDS.put("supplybilltype", "supplybilltpye");
        DETAIL_PEG_FIELDS.put("supplyoperator", "supplyoperator");
        DETAIL_PEG_FIELDS.put("supplyqty", "supplyqty");
        DETAIL_PEG_FIELDS.put("demanddate", "supplydate");
        DETAIL_PEG_FIELDS.put("supplydate", "actualdate");
        DETAIL_PEG_FIELDS.put("supplyorg", "supplyorg");
        DETAIL_PEG_FIELDS.put("supplydetail", "supplydetail");
        DETAIL_PEG_FIELDS.put("demandbillf7", "demandbillf7");
        DETAIL_PEG_FIELDS.put("supplybillf7", "supplybillf7");
        DETAIL_PEG_FIELDS.put("supplantag", "supplantag");
        DETAIL_PEG_FIELDS.put("configuredcode", "configuredcodesup");
        DETAIL_PEG_FIELDS.put("tracknumber", "tracknumberdem");
        DETAIL_PEG_FIELDS.put("suptracknumber", "tracknumbersup");
        DETAIL_PEG_FIELDS.put("demandproject", "demandproject");
        DETAIL_PEG_FIELDS.put("supplyproject", "supplyproject");
        DETAIL_PEG_FIELDS.put("demandplanscope", "demandplanscope");
        DETAIL_PEG_FIELDS.put("supplyplanscope", "supplyplanscope");
        DETAIL_PEG_FIELDS.put("materialattr", "materialattr");
        FIELD_NEED_CHANGE = new String[]{"requireorg", "demandbilltype", "material", "requireoperator", "billno", "billentryseq", "origindemanddate", "reqpriority", "demanddate", "requireunit", "configuredcodedem", "tracknumber", "demandauxpty"};
        Set keys = DETAIL_PEG_FIELDS.keySet();
        StringBuilder sb = new StringBuilder(256);
        for (String key : keys) {
            sb.append("entryentity.").append(key).append(' ').append(key).append(',');
        }
        String s = sb.toString();
        DETAIL_FIELD = s.substring(0, s.length() - 1);
        MainEntityType pegType = MetadataServiceHelper.getDataEntityType((String)TB_PEG);
        EntryProp pegEntry = (EntryProp)pegType.getProperty("entryentity");
        DataEntityPropertyCollection pegProps = pegEntry.getItemType().getProperties();
        ArrayList values = new ArrayList(DETAIL_PEG_FIELDS.values());
        values.add("requireunit");
        values.add("supplyunit");
        values.add("configuredcodedem");
        StringBuilder sql = new StringBuilder(128);
        StringBuilder qes = new StringBuilder(64);
        sql.append("INSERT INTO T_MRP_PEGINFODATAENTRY(");
        qes.append('(');
        for (String value : values) {
            IDataEntityProperty property = (IDataEntityProperty)pegProps.get((Object)value);
            String alias = property.getAlias().toUpperCase();
            sql.append(alias).append(',');
            qes.append("?,");
        }
        qes.append("?,?,?)");
        sql.append("FID,FENTRYID,FSEQ) VALUES ").append((CharSequence)qes);
        INSERT_SQL = sql.toString();
    }

    static {
        rmvs = new String[]{"llc", "billid", "billentryid"};
    }

    private static class PegInfoReduceFunction
    extends GroupReduceFunction
    implements Serializable {
        static final long serialVersionUID = 42L;
        RowMeta rowMeta;
        int[] changeIndexes;
        int qtyIndex;
        int llcIndex;
        int dateIdx;
        int mtIdx;
        int supMtIdx;
        int requireUnitIdx;
        int supplyUnitIdx;
        int configuredcodesupIdx;
        int configuredcodedemIdx;
        Timestamp planDateStamp;
        transient Map<Long, Long> mtUnitMap;

        PegInfoReduceFunction(RowMeta rowMeta, long planDate) {
            this.rowMeta = rowMeta;
            this.planDateStamp = new Timestamp(planDate);
            this.changeIndexes = new int[FIELD_NEED_CHANGE.length];
            int i = 0;
            for (String changeField : FIELD_NEED_CHANGE) {
                this.changeIndexes[i++] = rowMeta.getFieldIndex(changeField);
            }
            this.qtyIndex = rowMeta.getFieldIndex("demandqty");
            this.llcIndex = rowMeta.getFieldIndex("llc");
            this.dateIdx = rowMeta.getFieldIndex("origindemanddate");
            this.mtIdx = rowMeta.getFieldIndex("material");
            this.supMtIdx = rowMeta.getFieldIndex("supmaterial");
            this.requireUnitIdx = rowMeta.getFieldIndex("requireunit");
            this.supplyUnitIdx = rowMeta.getFieldIndex("supplyunit");
            this.configuredcodesupIdx = rowMeta.getFieldIndex("configuredcode");
            this.configuredcodedemIdx = rowMeta.getFieldIndex("configuredcodedem");
        }

        private void fetchUnit() {
            if (this.mtUnitMap != null) {
                return;
            }
            logger.warn("mrprrunner-peginfo-algox, initialize material unit");
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fetchUnit", (String)MRPCreatePegInfoJob.TB_MT, (String)"id,baseunit", null, null);){
                this.mtUnitMap = new HashMap<Long, Long>(1024);
                for (Row d : ds) {
                    this.mtUnitMap.put(d.getLong(0), d.getLong(1));
                }
            }
        }

        public void reduce(Iterable<RowX> iterable, Collector collector) {
            this.fetchUnit();
            RowX minLLCRow = null;
            Integer minLLC = Integer.MAX_VALUE;
            HashMap<Integer, BigDecimal> llcToQty = new HashMap<Integer, BigDecimal>(16);
            ArrayList<RowX> result = new ArrayList<RowX>(128);
            for (RowX rowX : iterable) {
                Integer llc = rowX.getInteger(this.llcIndex);
                if (minLLC.compareTo(llc) > 0) {
                    minLLCRow = rowX;
                    minLLC = llc;
                }
                BigDecimal qty = rowX.getBigDecimal(this.qtyIndex);
                BigDecimal qtySum = llcToQty.getOrDefault(llc, BigDecimal.ZERO);
                qtySum = qtySum.add(qty);
                llcToQty.put(llc, qtySum);
                result.add(rowX);
            }
            if (minLLCRow == null) {
                return;
            }
            Date date = minLLCRow.getDate(this.dateIdx);
            if (date == null || date.compareTo(this.planDateStamp) < 0) {
                minLLCRow.set(this.dateIdx, (Object)this.planDateStamp);
            }
            BigDecimal qtySum = llcToQty.getOrDefault(minLLC, BigDecimal.ZERO);
            Long reqUid = this.mtUnitMap.get(minLLCRow.getLong(this.mtIdx));
            if (reqUid == null || reqUid == 0L) {
                logger.error(String.format("mrprrunner-peginfo-algox-empty-unit-main, mId: %s", reqUid));
                return;
            }
            minLLCRow.set(this.requireUnitIdx, (Object)reqUid);
            minLLCRow.set(this.configuredcodedemIdx, minLLCRow.get(this.configuredcodesupIdx));
            for (RowX rowX : result) {
                Long supUid;
                if (rowX != minLLCRow) {
                    for (int idx : this.changeIndexes) {
                        rowX.set(idx, minLLCRow.get(idx));
                    }
                }
                if ((supUid = this.mtUnitMap.get(rowX.getLong(this.supMtIdx))) == null || supUid == 0L) {
                    logger.error(String.format("mrprrunner-peginfo-algox-empty-unit-sub, mId: %s", supUid));
                    continue;
                }
                rowX.set(this.supplyUnitIdx, (Object)supUid);
                rowX.set(this.qtyIndex, (Object)qtySum);
                collector.collect(rowX);
            }
        }

        public RowMeta getResultRowMeta() {
            return this.rowMeta;
        }
    }
}

