/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cps;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CPSDetailRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        FilterInfo filter = param.getFilter();
        QFilter[] qFilter = this.getQFilter(filter);
        String detailSQL = this.getDetailSQL();
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_cps_detail", (String)detailSQL, (QFilter[])qFilter, null);
        detailDataSet = detailDataSet.where("exceptionnumber not like '%101%'");
        detailDataSet = detailDataSet.where("exceptionnumber not like '%87%'");
        String shortageSQL = this.getShortageSQL();
        DataSet shortageDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_cps_shortage", (String)shortageSQL, (QFilter[])qFilter, null);
        shortageDataSet = shortageDataSet.where("exceptionnumber not like '%101%'");
        shortageDataSet = shortageDataSet.where("exceptionnumber not like '%87%'");
        DataSet detailTopDataSet = detailDataSet.where("e_level = '0'").select("e_billid e_billid1,e_billentryid e_billentryid1,e_material e_topmaterial,e_requireqty,e_configuredcode,e_tracknumber,e_auxpty");
        shortageDataSet = shortageDataSet.updateField("e_supplybilltype", String.format("case when e_supplybilltype = '' then (case when e_supplyqty > 0 then '%s' else '' end) else e_supplybilltype end", ResManager.loadKDString((String)"\u9f50\u5957\u5efa\u8bae\u8ba1\u5212", (String)"CPSDetailRptQuery_0", (String)"mmc-mrp-report", (Object[])new Object[0])));
        DataSet shortageTopDataSet = shortageDataSet.where("e_level = '0'").select("e_billid e_billid1,e_billentryid e_billentryid1,e_material e_topmaterial,e_requireqty,e_configuredcode,e_tracknumber,e_auxpty");
        DataSet topUnionDataSet = detailTopDataSet.union(shortageTopDataSet);
        DataSet topDataSet = topUnionDataSet.groupBy(new String[]{"e_billid1", "e_billentryid1"}).max("e_topmaterial").sum("e_requireqty", "e_cpsqty").max("e_configuredcode", "e_topconfiguredcode").max("e_tracknumber", "e_toptracknumber").max("e_auxpty", "e_topauxpty").finish();
        DataSet union = detailDataSet.union(shortageDataSet);
        final RowMeta rowMeta = union.getRowMeta();
        union = union.groupBy(new String[]{"e_billid", "e_billentryid"}).reduceGroup(new ReduceGroupFunction(){

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }

            public Iterator<Object[]> reduce(Iterator<Row> iterator) {
                ArrayList<Object[]> arrays = new ArrayList<Object[]>(8);
                Date date = null;
                while (iterator.hasNext()) {
                    Object[] arr = new Object[rowMeta.getFieldCount()];
                    Row row = iterator.next();
                    for (int i = 0; i < rowMeta.getFields().length; ++i) {
                        arr[i] = row.get(rowMeta.getFields()[i].getName());
                    }
                    if (!"0".equals(row.getString("e_level")) && row.getDate("e_supplydate") != null && (date == null || date.before(row.getDate("e_supplydate")))) {
                        date = row.getDate("e_supplydate");
                    }
                    arrays.add(arr);
                }
                for (Object[] arr : arrays) {
                    if (!"0".equals(arr[rowMeta.getFieldIndex("e_level")]) || date == null) continue;
                    arr[rowMeta.getFieldIndex((String)"e_supplydate")] = date;
                }
                return arrays.iterator();
            }
        });
        HashSet materialSet = new HashSet(16);
        union.copy().forEach(row -> materialSet.add(row.getLong("e_material")));
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,baseunit e_unit", (QFilter[])new QFilter[]{new QFilter("id", "in", materialSet)}, null);
        DataSet dataSet = union.leftJoin(materialDataSet).on("e_material", "id").select(union.getRowMeta().getFieldNames(), materialDataSet.getRowMeta().getFieldNames()).finish();
        DataSet finish = dataSet.leftJoin(topDataSet).on("e_billid", "e_billid1").on("e_billentryid", "e_billentryid1").select(dataSet.getRowMeta().getFieldNames(), topDataSet.getRowMeta().getFieldNames()).finish();
        if (filter.getValue("filter_material") != null) {
            finish = finish.where("e_topmaterial = " + filter.getDynamicObject("filter_material").getPkValue());
        }
        if (filter.getValue("filter_childmaterial") != null) {
            finish = finish.where("e_material = " + filter.getDynamicObject("filter_childmaterial").getPkValue());
        }
        return finish.orderBy(new String[]{"e_billid", "e_billentryid", "e_level"});
    }

    private QFilter[] getQFilter(FilterInfo filter) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        DynamicObject runlog = filter.getDynamicObject("filter_log");
        qfList.add(new QFilter("caculatelog", "=", (Object)runlog.getString("number")));
        qfList.add(new QFilter("entryentity.id", "!=", (Object)0L));
        if (filter.getValue("filter_requireorg") != null) {
            qfList.add(new QFilter("entryentity.requireorg", "=", filter.getDynamicObject("filter_requireorg").getPkValue()));
        }
        if (filter.getValue("filter_billtype") != null && !"".equals(filter.getString("filter_billtype"))) {
            qfList.add(new QFilter("entryentity.demandbilltype", "=", (Object)filter.getString("filter_billtype")));
        }
        if (filter.getValue("filter_billno") != null && !"".equals(filter.getString("filter_billno"))) {
            qfList.add(new QFilter("entryentity.billno", "=", (Object)filter.getString("filter_billno")));
        }
        if (filter.getValue("filter_rowno") != null) {
            qfList.add(new QFilter("entryentity.billentryseq", "=", (Object)filter.getInt("filter_rowno")));
        }
        if (filter.getValue("filter_supplier") != null) {
            qfList.add(new QFilter("entryentity.supplier", "=", filter.getDynamicObject("filter_supplier").getPkValue()));
        }
        return qfList.toArray(new QFilter[0]);
    }

    private String getDetailSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("caculatelog e_lognumber,entryentity.requireorg e_requireorg,");
        sql.append("entryentity.demandbilltype e_billtype,");
        sql.append("entryentity.billid e_billid,entryentity.billentryid e_billentryid,");
        sql.append("entryentity.billno e_billno,entryentity.billentryseq e_billrow,");
        sql.append("entryentity.llc e_level,entryentity.supmaterial e_material,");
        sql.append("entryentity.supmaterialattr e_materialattr,entryentity.supconfigcode e_configuredcode,");
        sql.append("entryentity.suptracknumber e_tracknumber,entryentity.supplyauxpty e_auxpty,");
        sql.append("entryentity.demandqty e_requireqty,entryentity.demanddate e_requiredate,");
        sql.append("entryentity.supplyqty e_supplyqty,entryentity.supplydate e_supplydate,");
        sql.append("entryentity.supplybilltype e_supplybilltype,entryentity.supplybillno e_supplybillno,");
        sql.append("entryentity.supplybillentryseq e_supplybillrow,");
        sql.append("entryentity.demandqty - entryentity.supplyqty e_shortageqty,entryentity.supplydetail e_supplydetail,");
        sql.append("entryentity.origindemanddate e_origindemanddate,entryentity.exceptionnumber exceptionnumber,");
        sql.append("entryentity.iskeypart e_iskeypart,entryentity.existkeypart e_existkeypart,");
        sql.append("entryentity.isreseve e_isreseve,entryentity.demandbillf7 e_billtypef7,");
        sql.append("entryentity.supplybillf7 e_supplybilltypef7,entryentity.supplybillid e_supplybillid,");
        sql.append("entryentity.supplybillentryid e_supplybillentryid,entryentity.supplier e_supplier,");
        sql.append("entryentity.replaceplan e_replaceplan,entryentity.isreplace e_isreplace,");
        sql.append("entryentity.replacepriority e_replacepriority,entryentity.ismainreplace e_ismainreplace");
        return sql.toString();
    }

    private String getShortageSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("caculatelog e_lognumber,entryentity.requireorg e_requireorg,");
        sql.append("entryentity.demandbilltype e_billtype,");
        sql.append("entryentity.billid e_billid,entryentity.billentryid e_billentryid,");
        sql.append("entryentity.billno e_billno,entryentity.billentryseq e_billrow,");
        sql.append("entryentity.llc e_level,entryentity.material e_material,");
        sql.append("entryentity.materialattr e_materialattr,entryentity.configuredcode e_configuredcode,");
        sql.append("entryentity.tracknumber e_tracknumber,entryentity.demandauxpty e_auxpty,");
        sql.append("entryentity.srcdemandqty e_requireqty,entryentity.demanddate e_requiredate,");
        sql.append("entryentity.srcdemandqty - entryentity.adjustqty e_supplyqty,entryentity.supplydate e_supplydate,");
        sql.append("entryentity.supplybilltype e_supplybilltype,entryentity.supplybillno e_supplybillno,");
        sql.append("entryentity.supplybillentryseq e_supplybillrow,");
        sql.append("0-entryentity.adjustqty e_shortageqty,entryentity.supplydetail e_supplydetail,");
        sql.append("entryentity.origindemanddate e_origindemanddate,entryentity.exceptionnumber exceptionnumber,");
        sql.append("entryentity.iskeypart e_iskeypart,entryentity.existkeypart e_existkeypart,");
        sql.append("entryentity.isreseve e_isreseve,entryentity.demandbillf7 e_billtypef7,");
        sql.append("entryentity.supplybillf7 e_supplybilltypef7,entryentity.supplybillid e_supplybillid,");
        sql.append("entryentity.supplybillentryid e_supplybillentryid,entryentity.supplier e_supplier,");
        sql.append("entryentity.replaceplan e_replaceplan,entryentity.isreplace e_isreplace,");
        sql.append("entryentity.replacepriority e_replacepriority,entryentity.ismainreplace e_ismainreplace");
        return sql.toString();
    }
}

