/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cps;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.business.custom.ext.CPSResultGetDataSetImpl;
import kd.mmc.mrp.business.custom.ext.ICPSResultGetDataSet;
import kd.mmc.mrp.report.cps.CPSResultRptQuery;

public class CPSResultDetailRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        CPSResultGetDataSetImpl defPlugin = new CPSResultGetDataSetImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ICPSResultGetDataSet.class, (String)"MRP_CPS_RESULT_DETAIL_EXT", null);
        List dataSets = pluginProxy.callReplaceIfPresent(p -> p.getDetailDataSet(param, arg1));
        if (!dataSets.isEmpty() && dataSets.get(0) != null) {
            return (DataSet)dataSets.get(0);
        }
        FilterInfo filter = param.getFilter();
        DynamicObject runlog = filter.getDynamicObject("filter_log");
        QFilter qf = new QFilter("caculatelog", "=", (Object)runlog.getString("number"));
        if (arg1 != null) {
            DynamicObject obj = (DynamicObject)arg1;
            qf.and(new QFilter("entryentity.billid", "=", (Object)obj.getString("e_billid")));
            qf.and(new QFilter("entryentity.billentryid", "=", (Object)obj.getString("e_billentryid")));
        } else {
            CPSResultRptQuery query = new CPSResultRptQuery();
            DataSet query2 = query.query(param, arg1);
            HashSet<String> ids = new HashSet<String>();
            HashSet<String> entryIds = new HashSet<String>();
            for (Row row2 : query2) {
                ids.add(row2.getString("e_billid"));
                entryIds.add(row2.getString("e_billentryid"));
            }
            qf.and(new QFilter("entryentity.billid", "in", ids));
            qf.and(new QFilter("entryentity.billentryid", "in", entryIds));
            param.getCustomParam().clear();
        }
        String detailSQL = this.getDetailSQL();
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_cps_detail", (String)detailSQL, (QFilter[])new QFilter[]{qf}, null);
        detailDataSet = detailDataSet.where("exceptionnumber not like '%101%'");
        detailDataSet = detailDataSet.where("exceptionnumber not like '%87%'");
        detailDataSet = detailDataSet.updateField("s_planqty", "case when editreason = 'PLAN' then s_supplyqty else 0 end");
        detailDataSet = detailDataSet.addFields(new String[]{"case when editreason = 'PLAN' then 0 else (case when ishandle then s_supplyqty else 0 end) end", "case when editreason = 'PLAN' then 0 else (case when ishandle then 0 else s_supplyqty end) end"}, new String[]{"s_invqty", "s_wayqty"});
        String shortageSQL = this.getShortageSQL();
        DataSet shortageDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_cps_shortage", (String)shortageSQL, (QFilter[])new QFilter[]{qf}, null);
        shortageDataSet = shortageDataSet.where("exceptionnumber not like '%101%'");
        shortageDataSet = shortageDataSet.where("exceptionnumber not like '%87%'");
        shortageDataSet = shortageDataSet.updateField("s_planqty", "case when NullToZero(s_planqty) = 0 then s_requireqty - abs(s_shortageqty) else s_requireqty - abs(s_shortageqty) - s_planqty end");
        shortageDataSet = shortageDataSet.addFields(new String[]{"case when ishandle then s_supplyqty - s_planqty else 0 end", "case when ishandle then 0 else s_supplyqty - s_planqty end"}, new String[]{"s_invqty", "s_wayqty"});
        DataSet union = detailDataSet.union(shortageDataSet);
        union = union.updateFields(new String[]{"s_iskeypart", "s_existkeypart", "s_isreplace", "s_ismainreplace"}, new String[]{"case when s_iskeypart then 1 else 0 end", "case when s_existkeypart then 1 else 0 end", "case when s_isreplace then 1 else 0 end", "case when s_ismainreplace then 1 else 0 end"});
        DataSet finish = union.groupBy(new String[]{"s_billno", "s_billtypef7", "s_billid", "s_billentryid", "s_billrow", "s_material", "s_materialattr", "llc"}).max("s_configuredcode").max("s_tracknumber").max("s_auxpty").sum("s_requireqty").max("s_requiredate").sum("s_supplyqty").sum("s_invqty").sum("s_wayqty").sum("s_planqty").max("s_supplydate").sum("s_shortageqty").max("s_origindemanddate").max("s_iskeypart").max("s_existkeypart").max("s_replaceplan").max("s_replacepriority").max("s_isreplace").max("s_ismainreplace").finish();
        final RowMeta rowMeta = finish.getRowMeta();
        finish = finish.reduceGroup(new ReduceGroupFunction(){

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }

            public Iterator<Object[]> reduce(Iterator<Row> iterator) {
                ArrayList<Object[]> arrays = new ArrayList<Object[]>(8);
                Date date = null;
                while (iterator.hasNext()) {
                    Object[] arr = new Object[rowMeta.getFieldCount()];
                    Row row = iterator.next();
                    for (int i = 0; i < rowMeta.getFields().length; ++i) {
                        arr[i] = row.get(rowMeta.getFields()[i].getName());
                    }
                    if (!"0".equals(row.getString("llc")) && row.getDate("s_supplydate") != null && (date == null || date.before(row.getDate("s_supplydate")))) {
                        date = row.getDate("s_supplydate");
                    }
                    if (date == null) {
                        date = row.getDate("s_supplydate");
                    }
                    arrays.add(arr);
                }
                for (Object[] arr : arrays) {
                    if (!"0".equals(arr[rowMeta.getFieldIndex("llc")]) || new BigDecimal(arr[rowMeta.getFieldIndex("s_requireqty")].toString()).add(new BigDecimal(arr[rowMeta.getFieldIndex("s_shortageqty")].toString())).compareTo(BigDecimal.ZERO) <= 0) continue;
                    arr[rowMeta.getFieldIndex((String)"s_supplydate")] = date;
                }
                return arrays.iterator();
            }
        });
        HashSet materialSet = new HashSet(16);
        finish.copy().forEach(row -> materialSet.add(row.getLong("s_material")));
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,baseunit s_unit", (QFilter[])new QFilter[]{new QFilter("id", "in", materialSet)}, null);
        DataSet dataSet = finish.leftJoin(materialDataSet).on("s_material", "id").select(finish.getRowMeta().getFieldNames(), materialDataSet.getRowMeta().getFieldNames()).finish();
        if (arg1 == null) {
            return dataSet.orderBy(new String[]{"s_billid", "s_billentryid", "llc asc"});
        }
        return dataSet.orderBy(new String[]{"llc asc"});
    }

    private String getDetailSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("entryentity.billno s_billno,entryentity.billentryseq s_billrow,");
        sql.append("entryentity.billid s_billid,entryentity.billentryid s_billentryid,entryentity.demandbillf7 s_billtypef7,");
        sql.append("entryentity.supmaterial s_material,entryentity.configuredcode s_configuredcode,");
        sql.append("entryentity.tracknumber s_tracknumber,entryentity.demandauxpty s_auxpty,");
        sql.append("entryentity.demandqty s_requireqty,entryentity.demanddate s_requiredate,");
        sql.append("entryentity.supplyqty s_supplyqty,entryentity.supplydate s_supplydate,");
        sql.append("entryentity.ishandle ishandle,entryentity.supmaterialattr s_materialattr,");
        sql.append("entryentity.demandqty - entryentity.supplyqty s_shortageqty,entryentity.supplyqty s_planqty,");
        sql.append("entryentity.editreason editreason,entryentity.llc llc,");
        sql.append("entryentity.origindemanddate s_origindemanddate,entryentity.exceptionnumber exceptionnumber,");
        sql.append("entryentity.iskeypart s_iskeypart,entryentity.existkeypart s_existkeypart,");
        sql.append("entryentity.replaceplan s_replaceplan,entryentity.isreplace s_isreplace,");
        sql.append("entryentity.replacepriority s_replacepriority,entryentity.ismainreplace s_ismainreplace");
        return sql.toString();
    }

    private String getShortageSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("entryentity.billno s_billno,entryentity.billentryseq s_billrow,");
        sql.append("entryentity.billid s_billid,entryentity.billentryid s_billentryid,entryentity.demandbillf7 s_billtypef7,");
        sql.append("entryentity.material s_material,entryentity.configuredcode s_configuredcode,");
        sql.append("entryentity.tracknumber s_tracknumber,entryentity.demandauxpty s_auxpty,");
        sql.append("entryentity.srcdemandqty s_requireqty,entryentity.demanddate s_requiredate,");
        sql.append("entryentity.srcdemandqty - entryentity.adjustqty s_supplyqty,entryentity.supplydate s_supplydate,");
        sql.append("entryentity.ishandle ishandle,entryentity.materialattr s_materialattr,");
        sql.append("0-entryentity.adjustqty s_shortageqty,entryentity.supplyqty s_planqty,");
        sql.append("entryentity.editreason editreason,entryentity.llc llc,");
        sql.append("entryentity.origindemanddate s_origindemanddate,entryentity.exceptionnumber exceptionnumber,");
        sql.append("entryentity.iskeypart s_iskeypart,entryentity.existkeypart s_existkeypart,");
        sql.append("entryentity.replaceplan s_replaceplan,entryentity.isreplace s_isreplace,");
        sql.append("entryentity.replacepriority s_replacepriority,entryentity.ismainreplace s_ismainreplace");
        return sql.toString();
    }
}

