/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cps;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.report.util.FilterDUtils;

public class CPSShortageRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        FilterInfo filter = param.getFilter();
        QFilter[] qFilter = this.getQFilter(filter);
        String detailSQL = this.getDetailSQL();
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_cps_detail", (String)detailSQL, (QFilter[])qFilter, null);
        detailDataSet = detailDataSet.where("exceptionnumber not like '%101%'");
        detailDataSet = detailDataSet.where("exceptionnumber not like '%87%'");
        detailDataSet = detailDataSet.updateField("e_planqty", "case when editreason = 'PLAN' then e_supplyqty else 0 end");
        detailDataSet = detailDataSet.addFields(new String[]{"case when editreason = 'PLAN' then 0 else (case when ishandle then e_supplyqty else 0 end) end", "case when editreason = 'PLAN' then 0 else (case when ishandle then 0 else e_supplyqty end) end"}, new String[]{"e_invqty", "e_wayqty"});
        String shortageSQL = this.getShortageSQL();
        DataSet shortageDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_cps_shortage", (String)shortageSQL, (QFilter[])qFilter, null);
        shortageDataSet = shortageDataSet.where("exceptionnumber not like '%101%'");
        shortageDataSet = shortageDataSet.where("exceptionnumber not like '%87%'");
        shortageDataSet = shortageDataSet.updateField("e_planqty", "case when NullToZero(e_planqty) = 0 then e_requireqty - abs(e_shortageqty) else e_requireqty - abs(e_shortageqty) - e_planqty end");
        shortageDataSet = shortageDataSet.addFields(new String[]{"case when ishandle then e_supplyqty - e_planqty else 0 end", "case when ishandle then 0 else e_supplyqty - e_planqty end"}, new String[]{"e_invqty", "e_wayqty"});
        DataSet detailTopDataSet = detailDataSet.where("e_level = '0'").select("e_billid e_billid1,e_billentryid e_billentryid1,e_material e_topmaterial,e_requireqty,e_configuredcode,e_tracknumber,e_auxpty");
        DataSet shortageTopDataSet = shortageDataSet.where("e_level = '0'").select("e_billid e_billid1,e_billentryid e_billentryid1,e_material e_topmaterial,e_requireqty,e_configuredcode,e_tracknumber,e_auxpty");
        DataSet topUnionDataSet = detailTopDataSet.union(shortageTopDataSet);
        DataSet topDataSet = topUnionDataSet.groupBy(new String[]{"e_billid1", "e_billentryid1"}).max("e_topmaterial").sum("e_requireqty", "e_cpsqty").max("e_configuredcode", "e_topconfiguredcode").max("e_tracknumber", "e_toptracknumber").max("e_auxpty", "e_topauxpty").finish();
        DataSet union = detailDataSet.union(shortageDataSet);
        final RowMeta rowMeta = union.getRowMeta();
        union = union.groupBy(new String[]{"e_billid", "e_billentryid"}).reduceGroup(new ReduceGroupFunction(){

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }

            public Iterator<Object[]> reduce(Iterator<Row> iterator) {
                ArrayList<Object[]> arrays = new ArrayList<Object[]>(8);
                Date date = null;
                while (iterator.hasNext()) {
                    Object[] arr = new Object[rowMeta.getFieldCount()];
                    Row row = iterator.next();
                    for (int i = 0; i < rowMeta.getFields().length; ++i) {
                        arr[i] = row.get(rowMeta.getFields()[i].getName());
                    }
                    if (!"0".equals(row.getString("e_level")) && row.getDate("e_supplydate") != null && (date == null || date.before(row.getDate("e_supplydate")))) {
                        date = row.getDate("e_supplydate");
                    }
                    arrays.add(arr);
                }
                for (Object[] arr : arrays) {
                    if (!"0".equals(arr[rowMeta.getFieldIndex("e_level")])) continue;
                    arr[rowMeta.getFieldIndex((String)"e_supplydate")] = date;
                }
                return arrays.iterator();
            }
        });
        HashSet materialSet = new HashSet(16);
        union.copy().forEach(row -> materialSet.add(row.getLong("e_material")));
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,baseunit e_unit", (QFilter[])new QFilter[]{new QFilter("id", "in", materialSet)}, null);
        DataSet dataSet = union.leftJoin(materialDataSet).on("e_material", "id").select(union.getRowMeta().getFieldNames(), materialDataSet.getRowMeta().getFieldNames()).finish();
        String groyptype = filter.getString("groyptype");
        dataSet = dataSet.updateFields(new String[]{"e_iskeypart", "e_existkeypart", "e_isreplace", "e_ismainreplace"}, new String[]{"case when e_iskeypart then 1 else 0 end", "case when e_existkeypart then 1 else 0 end", "case when e_isreplace then 1 else 0 end", "case when e_ismainreplace then 1 else 0 end"});
        dataSet = "A".equals(groyptype) ? this.group4Summary(dataSet) : this.group4Layered(dataSet);
        DataSet finish = dataSet.leftJoin(topDataSet).on("e_billid", "e_billid1").on("e_billentryid", "e_billentryid1").select(dataSet.getRowMeta().getFieldNames(), topDataSet.getRowMeta().getFieldNames()).finish();
        if ("A".equals(filter.getString("filter_showtype"))) {
            finish = finish.filter("e_shortageqty<0");
        } else if ("B".equals(filter.getString("filter_showtype"))) {
            finish = finish.filter("e_shortageqty<0 and e_iskeypart = 1");
        }
        DataSet dataSet2 = finish = "A".equals(groyptype) ? finish.orderBy(new String[]{"e_billid", "e_billentryid"}) : finish.orderBy(new String[]{"e_billid", "e_billentryid", "e_level"});
        if (filter.getValue("filter_material") != null) {
            finish = finish.where("e_topmaterial = " + filter.getDynamicObject("filter_material").getPkValue());
        }
        if (filter.getValue("filter_childmaterial") != null) {
            finish = finish.where("e_material = " + filter.getDynamicObject("filter_childmaterial").getPkValue());
        }
        return this.headFilter(finish);
    }

    public DataSet headFilter(DataSet set) {
        ReportQueryParam queryParam = this.getQueryParam();
        List headFilters = queryParam.getFilter().getHeadFilters();
        String s = "";
        boolean flag = false;
        ArrayList<Long> eTopmaterialList = new ArrayList<Long>();
        ArrayList<Long> eMaterialList = new ArrayList<Long>();
        DataSet copySet = set.copy();
        for (Row row : copySet) {
            Long eTopmaterial = row.getLong("e_topmaterial");
            eTopmaterialList.add(eTopmaterial);
            Long eMaterial = row.getLong("e_material");
            eMaterialList.add(eMaterial);
        }
        QFilter eTopmaterialFilter = new QFilter("id", "in", eTopmaterialList);
        QFilter eMaterialFilter = new QFilter("id", "in", eMaterialList);
        if (!headFilters.isEmpty()) {
            for (QFilter qFilter2 : headFilters) {
                String partSql = "";
                String field = qFilter2.getProperty();
                if ("e_materialattr".equals(field)) {
                    partSql = qFilter2.toString();
                } else if ("e_topmaterial".equals(field)) {
                    partSql = this.getMaterialSql(qFilter2, "bd_material", "e_topmaterial", eTopmaterialFilter);
                } else if ("e_material".equals(field)) {
                    partSql = this.getMaterialSql(qFilter2, "bd_material", "e_material", eMaterialFilter);
                } else {
                    if ("e_requiredate".equals(field)) {
                        set = this.timeAndDateFilter(set, qFilter2);
                        continue;
                    }
                    if ("e_supplydate".equals(field)) {
                        set = this.timeAndDateFilter(set, qFilter2);
                        continue;
                    }
                    if ("e_shortageqty".equals(field)) {
                        String cp = qFilter2.getCP();
                        Object value = qFilter2.getValue();
                        String property = qFilter2.getProperty();
                        String val = value.toString();
                        BigDecimal bigDecimal = new BigDecimal(val);
                        QFilter bigDecimalQFilter = new QFilter(property, cp, (Object)bigDecimal);
                        partSql = bigDecimalQFilter.toString();
                    }
                }
                if ("".equals(partSql)) {
                    flag = true;
                    break;
                }
                if (!"".equals(s)) {
                    s = s + " AND " + partSql;
                    continue;
                }
                s = partSql;
            }
        }
        if (flag) {
            set = set.filter("e_topmaterial = 0 ");
        } else if (!"".equals(s)) {
            set = set.filter(s);
        }
        if (queryParam.getSortInfo() != null) {
            return set.orderBy(new String[]{queryParam.getSortInfo()});
        }
        return set;
    }

    private DataSet timeAndDateFilter(DataSet set, QFilter qFilter) {
        String cp = qFilter.getCP();
        Object value = qFilter.getValue();
        String property = qFilter.getProperty();
        String val = value.toString();
        set = FilterDUtils.changFiledDataType(set, property, String.class);
        if (cp.equals("=")) {
            QFilter dateFilter = new QFilter(property, "like", (Object)("%" + val + "%"));
            set = set.filter(dateFilter.toString());
        } else {
            String startStr = qFilter.toString().split(">=")[1].split("AND")[0];
            String endStr = qFilter.toString().split("<")[1];
            Date startDate = FilterDUtils.getDate(startStr);
            Date endDate = FilterDUtils.getDate(endStr);
            QFilter dateFilter = new QFilter(property, ">=", (Object)startDate).and(new QFilter(property, "<", (Object)endDate));
            set = set.filter(dateFilter.toString());
        }
        set = FilterDUtils.changFiledDataType(set, property, Timestamp.class);
        return set;
    }

    public String getMaterialSql(QFilter qFilter, String entityName, String filed, QFilter materialFilter) {
        StringBuilder partSql = new StringBuilder();
        if (qFilter.getCP().contains("null")) {
            return filed + " " + qFilter.getCP();
        }
        qFilter.__setProperty("number");
        List nests = qFilter.getNests(true);
        if (nests != null) {
            qFilter.clearNests();
            for (QFilter.QFilterNest qFilterNest : nests) {
                QFilter filter = qFilterNest.getFilter();
                filter.__setProperty("number");
                qFilter.addFirstNest(filter, "and");
            }
        }
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilter.and(materialFilter).toArray());
        Iterator iterator = dynamicObject.iterator();
        ArrayList<String> strings = new ArrayList<String>();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            strings.add(next.getString("id"));
        }
        if (!strings.isEmpty()) {
            partSql.append(filed).append(" in (");
            if (strings.size() == 1) {
                partSql.append((String)strings.get(0));
            } else {
                for (String string : strings) {
                    partSql.append(string).append(',');
                }
                partSql.setLength(partSql.length() - 1);
            }
            partSql.append(')');
        }
        return partSql.toString();
    }

    private DataSet group4Layered(DataSet dataSet) {
        dataSet = dataSet.groupBy(new String[]{"e_lognumber", "e_requireorg", "e_billtype", "e_billtypef7", "e_billno", "e_billrow", "e_billid", "e_billentryid", "e_material", "e_materialattr", "e_level"}).max("e_unit").max("e_configuredcode").max("e_tracknumber").max("e_auxpty").sum("e_requireqty").max("e_requiredate").sum("e_supplyqty").sum("e_invqty").sum("e_wayqty").sum("e_planqty").max("e_supplydate").sum("e_shortageqty").max("e_origindemanddate").max("e_iskeypart").max("e_existkeypart").max("e_replaceplan").max("e_replacepriority").max("e_isreplace").max("e_ismainreplace").finish();
        return dataSet;
    }

    private DataSet group4Summary(DataSet dataSet) {
        dataSet = dataSet.groupBy(new String[]{"e_lognumber", "e_requireorg", "e_billtype", "e_billtypef7", "e_billno", "e_billrow", "e_billid", "e_billentryid", "e_material", "e_materialattr"}).max("e_unit").max("e_configuredcode").max("e_tracknumber").max("e_auxpty").sum("e_requireqty").max("e_requiredate").sum("e_supplyqty").sum("e_invqty").sum("e_wayqty").sum("e_planqty").max("e_supplydate").sum("e_shortageqty").max("e_origindemanddate").max("e_iskeypart").max("e_existkeypart").max("e_replaceplan").max("e_replacepriority").max("e_isreplace").max("e_ismainreplace").finish();
        return dataSet;
    }

    private QFilter[] getQFilter(FilterInfo filter) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        DynamicObject runlog = filter.getDynamicObject("filter_log");
        qfList.add(new QFilter("caculatelog", "=", (Object)runlog.getString("number")));
        qfList.add(new QFilter("entryentity.id", "!=", (Object)0L));
        if (filter.getValue("filter_requireorg") != null) {
            qfList.add(new QFilter("entryentity.requireorg", "=", filter.getDynamicObject("filter_requireorg").getPkValue()));
        }
        if (filter.getValue("filter_billtype") != null && !"".equals(filter.getString("filter_billtype"))) {
            qfList.add(new QFilter("entryentity.demandbilltype", "=", (Object)filter.getString("filter_billtype")));
        }
        if (filter.getValue("filter_billno") != null && !"".equals(filter.getString("filter_billno"))) {
            qfList.add(new QFilter("entryentity.billno", "=", (Object)filter.getString("filter_billno")));
        }
        if (filter.getValue("filter_rowno") != null) {
            qfList.add(new QFilter("entryentity.billentryseq", "=", (Object)filter.getInt("filter_rowno")));
        }
        return qfList.toArray(new QFilter[0]);
    }

    private String getDetailSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("caculatelog e_lognumber,entryentity.requireorg e_requireorg,");
        sql.append("entryentity.demandbilltype e_billtype,entryentity.demandbillf7 e_billtypef7,");
        sql.append("entryentity.billid e_billid,entryentity.billentryid e_billentryid,");
        sql.append("entryentity.billno e_billno,entryentity.billentryseq e_billrow,");
        sql.append("entryentity.llc e_level,entryentity.supmaterial e_material,");
        sql.append("entryentity.materialattr e_materialattr,entryentity.configuredcode e_configuredcode,");
        sql.append("entryentity.tracknumber e_tracknumber,entryentity.demandauxpty e_auxpty,");
        sql.append("entryentity.demandqty e_requireqty,entryentity.demanddate e_requiredate,");
        sql.append("entryentity.supplyqty e_supplyqty,entryentity.supplydate e_supplydate,");
        sql.append("entryentity.ishandle ishandle,entryentity.editreason editreason,");
        sql.append("entryentity.demandqty - entryentity.supplyqty e_shortageqty,entryentity.supplyqty e_planqty,");
        sql.append("entryentity.origindemanddate e_origindemanddate,entryentity.exceptionnumber exceptionnumber,");
        sql.append("entryentity.iskeypart e_iskeypart,entryentity.existkeypart e_existkeypart,");
        sql.append("entryentity.replaceplan e_replaceplan,entryentity.isreplace e_isreplace,");
        sql.append("entryentity.replacepriority e_replacepriority,entryentity.ismainreplace e_ismainreplace");
        return sql.toString();
    }

    private String getShortageSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("caculatelog e_lognumber,entryentity.requireorg e_requireorg,");
        sql.append("entryentity.demandbilltype e_billtype,entryentity.demandbillf7 e_billtypef7,");
        sql.append("entryentity.billid e_billid,entryentity.billentryid e_billentryid,");
        sql.append("entryentity.billno e_billno,entryentity.billentryseq e_billrow,");
        sql.append("entryentity.llc e_level,entryentity.material e_material,");
        sql.append("entryentity.materialattr e_materialattr,entryentity.configuredcode e_configuredcode,");
        sql.append("entryentity.tracknumber e_tracknumber,entryentity.demandauxpty e_auxpty,");
        sql.append("entryentity.srcdemandqty e_requireqty,entryentity.demanddate e_requiredate,");
        sql.append("entryentity.srcdemandqty - entryentity.adjustqty e_supplyqty,entryentity.supplydate e_supplydate,");
        sql.append("entryentity.ishandle ishandle,entryentity.editreason editreason,");
        sql.append("0 - entryentity.adjustqty e_shortageqty,entryentity.supplyqty e_planqty,");
        sql.append("entryentity.origindemanddate e_origindemanddate,entryentity.exceptionnumber exceptionnumber,");
        sql.append("entryentity.iskeypart e_iskeypart,entryentity.existkeypart e_existkeypart,");
        sql.append("entryentity.replaceplan e_replaceplan,entryentity.isreplace e_isreplace,");
        sql.append("entryentity.replacepriority e_replacepriority,entryentity.ismainreplace e_ismainreplace");
        return sql.toString();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        String type = filter.getString("groyptype");
        if ("A".equals(type)) {
            Iterator<AbstractReportColumn> iterator = columns.iterator();
            while (iterator.hasNext()) {
                ReportColumn next = (ReportColumn)iterator.next();
                if (!"e_level".contains(next.getFieldKey())) continue;
                iterator.remove();
                break;
            }
        }
        return columns;
    }
}

