/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cpstrack;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.report.cpstrack.CpsTrackRptUtil;

public class CpsTrackPomMFTOrderRptQuery
extends AbstractReportListDataPlugin {
    private static ThreadLocal<List<String>> threadLocal = new ThreadLocal();
    private static final String BILL_POM_MFTORDER = "pom_mftorder";
    private static final String BILL_SM_SALORDER = "sm_salorder";
    private static final String BILL_MRP_PLANORDER = "mrp_planorder";
    private static final String SMENTRYID = "smentryid";
    private static final String BILL_POM_ = "pom_";
    private static final Log logger = LogFactory.getLog(CpsTrackPomMFTOrderRptQuery.class);

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        long starttime = System.currentTimeMillis();
        Map customParam = param.getCustomParam();
        ArrayList<QFilter> qfFilters = new ArrayList<QFilter>(customParam.size());
        QFilter salorderFilter = null;
        if (customParam.get(SMENTRYID) != null) {
            List ids = (List)customParam.get(SMENTRYID);
            salorderFilter = new QFilter("billentry.id", "in", (Object)ids);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BILL_POM_MFTORDER);
        FilterInfo filter = param.getFilter();
        List qFilters = filter.getQFilters();
        ArrayList<String> exprs = new ArrayList<String>(qFilters.size());
        ArrayList<String> wheres = new ArrayList<String>(qFilters.size());
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            String property = qFilter.getProperty();
            if (!property.startsWith(BILL_POM_)) {
                iterator.remove();
                continue;
            }
            this.analysisDealQFilter(qFilter, exprs, dataEntityType, wheres);
            CpsTrackRptUtil.setProperty(qFilter, dataEntityType, BILL_POM_);
            List list = qFilter.getNests(true);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                QFilter.QFilterNest qFilterNest = (QFilter.QFilterNest)iterator2.next();
                QFilter qf = qFilterNest.getFilter();
                this.analysisDealQFilter(qf, exprs, dataEntityType, wheres);
                CpsTrackRptUtil.setProperty(qf, dataEntityType, BILL_POM_);
            }
        }
        qfFilters.addAll(qFilters);
        DataSet allData = this.getAllData(qfFilters, exprs, salorderFilter);
        DataSet dealData = this.dealData(allData);
        for (String expr : wheres) {
            dealData = dealData.where(expr);
        }
        long endtime = System.currentTimeMillis();
        logger.info("\u67e5\u8be2\u751f\u4ea7\u5de5\u5355\u8017\u65f6" + (endtime - starttime) + "ms");
        return CpsTrackRptUtil.sortAndFilter(param, dealData, "mrp_cps_tracks", BILL_POM_MFTORDER);
    }

    private void analysisDealQFilter(QFilter qFilter, List<String> exprs, MainEntityType dataEntityType, List<String> whereFilters) {
        String property;
        switch (property = qFilter.getProperty()) {
            case "pom_cpstatus": {
                qFilter.__setProperty("1");
                qFilter.__setCP("=");
                qFilter.__setValue((Object)1);
                break;
            }
            default: {
                CpsTrackRptUtil.setWhereFilter(qFilter, BILL_POM_, whereFilters, dataEntityType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet dealData(DataSet dataSet) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map = new HashMap<String, Object>(28);
                BigDecimal qty = row.getBigDecimal("pom_qty") != null ? row.getBigDecimal("pom_qty") : BigDecimal.ZERO;
                BigDecimal planqty = row.getBigDecimal("pom_planqty") != null ? row.getBigDecimal("pom_planqty") : BigDecimal.ZERO;
                BigDecimal baseqty = row.getBigDecimal("pom_baseqty") != null ? row.getBigDecimal("pom_baseqty") : BigDecimal.ZERO;
                if (baseqty.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal reportqty = row.getBigDecimal("pom_reportqty") != null ? row.getBigDecimal("pom_reportqty") : BigDecimal.ZERO;
                BigDecimal quainwaqty = row.getBigDecimal("pom_quainwaqty") != null ? row.getBigDecimal("pom_quainwaqty") : BigDecimal.ZERO;
                BigDecimal unquainwaqty = row.getBigDecimal("pom_unquainwaqty") != null ? row.getBigDecimal("pom_unquainwaqty") : BigDecimal.ZERO;
                BigDecimal scrinwaqty = row.getBigDecimal("pom_scrinwaqty") != null ? row.getBigDecimal("pom_scrinwaqty") : BigDecimal.ZERO;
                BigDecimal inwaqty = quainwaqty.add(unquainwaqty).add(scrinwaqty).multiply(qty).divide(baseqty, 10, 4);
                map.put("pomid", row.getLong("pomid"));
                map.put("pomentryid", row.getLong("pomentryid"));
                map.put("pom_billno", row.getString("pom_billno"));
                map.put("pom_billdate", row.getDate("pom_billdate"));
                map.put("pom_billstatus", row.get("pom_billstatus"));
                map.put("pom_transactiontype", row.get("pom_transactiontype"));
                map.put("pom_transactiontype.name", row.get("pom_transactiontype.name"));
                map.put("pom_org", row.get("pom_org"));
                map.put("pom_org.name", row.get("pom_org.name"));
                map.put("pom_entrustdept", row.get("pom_entrustdept"));
                map.put("pom_entrustdept.name", row.get("pom_entrustdept.name"));
                map.put("pom_material", row.get("pom_material"));
                map.put("pom_material.number", row.get("pom_material.number"));
                map.put("pom_auxproperty", row.get("pom_auxproperty"));
                map.put("pom_unit", row.get("pom_unit"));
                map.put("pom_unit.name", row.get("pom_unit.name"));
                map.put("pom_qty", qty);
                map.put("pom_planqty", planqty);
                map.put("pom_planbegintime", row.getDate("pom_planbegintime"));
                map.put("pom_planendtime", row.getDate("pom_planendtime"));
                map.put("pom_producedept", row.get("pom_producedept"));
                map.put("pom_producedept.name", row.get("pom_producedept.name"));
                map.put("pom_bomid", row.get("pom_bomid"));
                map.put("pom_bomid.number", row.get("pom_bomid.number"));
                map.put("pom_planstatus", row.getString("pom_planstatus"));
                map.put("pom_taskstatus", row.getString("pom_taskstatus"));
                map.put("pom_pickstatus", row.getString("pom_pickstatus"));
                map.put("pom_bizstatus", row.getString("pom_bizstatus"));
                map.put("pom_reportqty", reportqty);
                map.put("pom_unreportqty", qty.subtract(reportqty));
                map.put("pom_inwaqty", inwaqty);
                map.put("pom_uninwaqty", qty.subtract(inwaqty));
                map.put("pom_batchno", row.getString("pom_batchno"));
                map.put("pom_configuredcode", row.get("pom_configuredcode"));
                map.put("pom_configuredcode.number", row.get("pom_configuredcode.number"));
                map.put("pom_tracknumber", row.get("pom_tracknumber"));
                map.put("pom_tracknumber.number", row.get("pom_tracknumber.number"));
                Date now = new Date();
                now = CpsTrackRptUtil.getCompDate(now);
                Date planendtime = row.getDate("pom_planendtime");
                planendtime = CpsTrackRptUtil.getCompDate(planendtime);
                if (planendtime != null && now.compareTo(planendtime) > 0) {
                    if (qty.compareTo(reportqty) > 0 && qty.compareTo(inwaqty) > 0) {
                        map.put("pom_excutexception", ResManager.loadKDString((String)"\u672a\u6309\u65f6\u5b8c\u5de5", (String)"CpsTrackPomMFTOrderRptQuery_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    } else {
                        map.put("pom_excutexception", "");
                    }
                } else {
                    map.put("pom_excutexception", "");
                }
                Integer integer = row.getInteger("pom_priority");
                if (integer == null) {
                    map.put("pom_priority", 100);
                } else {
                    map.put("pom_priority", integer);
                }
                map.put("pom_cpqty", BigDecimal.ZERO);
                map.put("pom_cpstatus", "");
                map.put("pom_llc", 0);
                map.put("pom_project", 0L);
                list.add(map);
            }
        }
        finally {
            dataSet.close();
        }
        return this.getReturnData(list);
    }

    private DataSet getReturnData(List<Map<String, Object>> list) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("pomid", (DataType)DateType.LongType, true));
        fields.add(new Field("pomentryid", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_billno", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_billdate", (DataType)DateType.DateType, true));
        fields.add(new Field("pom_billstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_transactiontype", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_transactiontype.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_org", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_org.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_entrustdept", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_entrustdept.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_material", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_material.number", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_auxproperty", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_unit", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_unit.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_qty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pom_planqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pom_planbegintime", (DataType)DateType.DateType, true));
        fields.add(new Field("pom_planendtime", (DataType)DateType.DateType, true));
        fields.add(new Field("pom_producedept", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_producedept.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_bomid", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_bomid.number", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_planstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_taskstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_pickstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_bizstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_reportqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pom_unreportqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pom_inwaqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pom_uninwaqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pom_batchno", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_configuredcode", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_configuredcode.number", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_tracknumber", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_tracknumber.number", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_project", (DataType)DateType.LongType, true));
        fields.add(new Field("pom_project.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_excutexception", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_priority", (DataType)DateType.IntegerType, true));
        fields.add(new Field("pom_cpqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pom_cpstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("pom_llc", (DataType)DateType.IntegerType, true));
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        for (Map<String, Object> entry : list) {
            Object[] values = new Object[fields.size()];
            Field[] field = metas.getFields();
            for (int i = 0; i < field.length; ++i) {
                values[i] = entry.get(field[i].getName());
            }
            builder.append(values);
        }
        return builder.build();
    }

    private DataSet getAllData(List<QFilter> qfFilters, List<String> exprs, QFilter qFilter) {
        StringBuilder sql = new StringBuilder();
        sql.append("id pomid,");
        sql.append("treeentryentity.id pomentryid,");
        sql.append("'").append(BILL_POM_MFTORDER).append("' pom_billname,");
        sql.append("billno pom_billno,");
        sql.append("billdate pom_billdate,");
        sql.append("billstatus pom_billstatus,");
        sql.append("transactiontype pom_transactiontype,");
        sql.append("transactiontype.name pom_transactiontype.name,");
        sql.append("org pom_org,");
        sql.append("org.name pom_org.name,");
        sql.append("entrustdept pom_entrustdept,");
        sql.append("entrustdept.name pom_entrustdept.name,");
        sql.append("treeentryentity.material.masterid pom_material,");
        sql.append("treeentryentity.material.masterid.number pom_material.number,");
        sql.append("treeentryentity.auxproperty pom_auxproperty,");
        sql.append("treeentryentity.unit pom_unit,");
        sql.append("treeentryentity.unit.name pom_unit.name,");
        sql.append("treeentryentity.baseqty pom_baseqty,");
        sql.append("treeentryentity.qty pom_qty,");
        sql.append("treeentryentity.planqty pom_planqty,");
        sql.append("treeentryentity.planbegintime pom_planbegintime,");
        sql.append("treeentryentity.planendtime pom_planendtime,");
        sql.append("treeentryentity.producedept pom_producedept,");
        sql.append("treeentryentity.producedept.name pom_producedept.name,");
        sql.append("treeentryentity.bomid pom_bomid,");
        sql.append("treeentryentity.bomid.number pom_bomid.number,");
        sql.append("treeentryentity.planstatus pom_planstatus,");
        sql.append("treeentryentity.taskstatus pom_taskstatus,");
        sql.append("treeentryentity.pickstatus pom_pickstatus,");
        sql.append("treeentryentity.bizstatus pom_bizstatus,");
        sql.append("treeentryentity.reportqty pom_reportqty,");
        sql.append("treeentryentity.sourceentryseq pom_sourceentryseq,");
        sql.append("treeentryentity.quainwaqty pom_quainwaqty,");
        sql.append("treeentryentity.unquainwaqty pom_unquainwaqty,");
        sql.append("treeentryentity.scrinwaqty pom_scrinwaqty,");
        sql.append("treeentryentity.batchno pom_batchno,");
        sql.append("treeentryentity.configuredcode pom_configuredcode,");
        sql.append("treeentryentity.configuredcode.number pom_configuredcode.number,");
        sql.append("treeentryentity.tracknumber pom_tracknumber,");
        sql.append("treeentryentity.tracknumber.number pom_tracknumber.number ");
        qfFilters.add(new QFilter("treeentryentity.bizstatus", "!=", (Object)"C"));
        if (qFilter != null) {
            qfFilters.add(new QFilter("treeentryentity.sourcebilltype", "=", (Object)BILL_MRP_PLANORDER));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)BILL_POM_MFTORDER, (String)sql.toString(), (QFilter[])qfFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"pom_billno"});
        DataSet priorityRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "mrp_cps_priority", "orderid,orderentryid,billentity,priority pom_priority", null);
        dataSet = dataSet.join(priorityRows, JoinType.LEFT).on("pomid", "orderid").on("pomentryid", "orderentryid").on("pom_billname", "billentity").select(dataSet.getRowMeta().getFieldNames(), priorityRows.getRowMeta().getFieldNames()).finish();
        for (String expr : exprs) {
            dataSet = dataSet.where(expr);
        }
        if (qFilter == null) {
            return dataSet;
        }
        DataSet planorderRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), BILL_MRP_PLANORDER, "to_char(id) planid,demandbillid,demandbillentryid", new QFilter[]{new QFilter("demandbillentity", "=", (Object)BILL_SM_SALORDER)});
        DataSet salorderRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), BILL_SM_SALORDER, "id smid, to_char(billentry.id) smentryid", new QFilter[]{qFilter});
        dataSet = dataSet.join(planorderRows, JoinType.INNER).on("pom_sourceentryseq", "planid").select(dataSet.getRowMeta().getFieldNames(), planorderRows.getRowMeta().getFieldNames()).finish();
        dataSet = dataSet.join(salorderRows, JoinType.INNER).on("demandbillentryid", SMENTRYID).select(dataSet.getRowMeta().getFieldNames(), salorderRows.getRowMeta().getFieldNames()).finish();
        return dataSet;
    }
}

