/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cpstrack;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.filter.CommonDateFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.filter.SchemeBaseDataFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.format.FlexValueFormatter;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.userconfig.GridConfigDAO;
import kd.mmc.mrp.common.util.DateUtils;
import kd.mmc.mrp.common.util.FilePermissionUtil;
import kd.mmc.mrp.report.cpstrack.CpsTrackRptUtil;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CpsTrackRptPlugin
extends AbstractReportFormPlugin
implements TabSelectListener,
HyperLinkClickListener,
CellClickListener {
    private static final Log logger = LogFactory.getLog(CpsTrackRptPlugin.class);
    public static final String PGCACHE_CURSELTABKEY = "CurSelTabKey";
    public static final String PGCACHE_CURSELROW = "CurSelRow";
    public static final String PGCACHE_TABKEY = "TabKey";
    private static final String USEORG_FILEDNAME = "org";
    private static final String PROP_NAME = "name";
    private static final String PROP_ID = "id";
    private static final String BILL_SM_SALORDER = "sm_salorder";
    private static final String BILL_POM_MFTORDER = "pom_mftorder";
    private static final String BILL_PM_OM_PURORDERBILL = "pm_om_purorderbill";
    private static final String BILL_OM_MFTORDER = "om_mftorder";
    private static final String BILL_SM_ = "sm_";
    private static final String BILL_POM_ = "pom_";
    private static final String BILL_OM_ = "om_";
    private static final String BILL_PM_ = "pm_";
    private static final String SHIPMENTSTATUS = "sm_shipmentstatus";
    private static final String OUTBOUNDSTATUS = "sm_outboundstatus";
    private static final String OP_BIZSMQUERY = "bizsmquery";
    private static final String OP_BIZPOMQUERY = "bizpomquery";
    private static final String OP_BIZOMQUERY = "bizomquery";
    private static final String OP_EXPORT = "export";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getPageCache().put(PGCACHE_CURSELTABKEY, "smtabpageap");
    }

    public void initialize() {
        super.initialize();
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            if (event.getColumnName() == null || event.getColumnName().contains("bomversion") || event.getColumnName().contains("auxp") || event.getColumnName().contains("materialattr") || event.getColumnName().contains("materialname") || event.getColumnName().contains("materialmodel")) continue;
            event.setFilter(true);
            event.setSort(true);
        }
    }

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        Tab biztab = (Tab)this.getView().getControl("tabap1");
        biztab.addTabSelectListener((TabSelectListener)this);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        reportList.addCellClickListener((CellClickListener)this);
        ReportList pomreportList = (ReportList)this.getControl("pomreportlistap");
        pomreportList.addHyperClickListener((HyperLinkClickListener)this);
        pomreportList.addCellClickListener((CellClickListener)this);
        ReportList omreportList = (ReportList)this.getControl("omreportlistap");
        omreportList.addHyperClickListener((HyperLinkClickListener)this);
        omreportList.addCellClickListener((CellClickListener)this);
        ReportList pmreportList = (ReportList)this.getControl("pmreportlistap");
        pmreportList.addHyperClickListener((HyperLinkClickListener)this);
        ReportList mftstockreportlist = (ReportList)this.getControl("mftstockreportlistap");
        mftstockreportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        String curSelTabKey = this.getPageCache().get(PGCACHE_CURSELTABKEY);
        LocaleString orgPropertyName = new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"CpsTrackRptPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
        String entity = "";
        String appId = "";
        Long viewId = 0L;
        String fieldName = "";
        MainEntityType dataEntityType = null;
        String customfilterStr = this.getPageCache().get("customfilter");
        HashMap<String, List> customfilter = null;
        if (customfilterStr != null) {
            customfilter = (HashMap<String, List>)SerializationUtils.fromJsonString((String)customfilterStr, Map.class);
        }
        if ("smtabpageap".equals(curSelTabKey)) {
            orgPropertyName = new LocaleString(ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7", (String)"CpsTrackRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
            entity = BILL_SM_SALORDER;
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
            appId = dataEntityType.getAppId();
            viewId = 3L;
            fieldName = "sm_org";
        } else if ("pomtabpageap".equals(curSelTabKey) || "omtabpageap".equals(curSelTabKey)) {
            String prefix = this.getPrefix(curSelTabKey);
            orgPropertyName = new LocaleString(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"CpsTrackRptPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
            entity = BILL_POM_MFTORDER;
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
            appId = dataEntityType.getAppId();
            viewId = 4L;
            fieldName = prefix + USEORG_FILEDNAME;
        }
        ArrayList<FilterColumn> filterColumnList = contInitEvent.getCommonFilterColumns();
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setCaption(orgPropertyName);
        orgColumn.setFieldName(fieldName);
        if (filterColumnList == null) {
            filterColumnList = new ArrayList<FilterColumn>(4);
        }
        if (filterColumnList != null && filterColumnList.contains(orgColumn)) {
            return;
        }
        DynamicObjectCollection col = this.getGroupOrgSet(entity, appId, viewId);
        String defaultOrg = this.getDefaultUseOrg(col);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(col.size());
        for (DynamicObject org : col) {
            if (org == null) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(org.getString(PROP_NAME)));
            item.setValue(String.valueOf(org.get(PROP_ID)));
            combos.add(item);
        }
        orgColumn.setComboItems(combos);
        orgColumn.setType("enum");
        orgColumn.setMulti(true);
        orgColumn.setDefaultValue(defaultOrg);
        filterColumnList.add(0, (FilterColumn)orgColumn);
        this.getPageCache().put(orgColumn.getFieldName(), defaultOrg);
        this.setfilterColumns(curSelTabKey, filterColumnList);
        for (FilterColumn filterColumn : filterColumnList) {
            if (customfilter != null) {
                List value = (List)customfilter.get(filterColumn.getFieldName());
                if (value != null && value.size() > 0) {
                    filterColumn.setDefaultValues(value);
                    continue;
                }
            } else {
                customfilter = new HashMap<String, List>(filterColumnList.size());
            }
            customfilter.put(filterColumn.getFieldName(), filterColumn.getDefaultValues());
        }
        String customfilterSer = SerializationUtils.toJsonString((Object)customfilter);
        this.getPageCache().put("customfilter", customfilterSer);
        List schemeFilterColumns = contInitEvent.getSchemeFilterColumns();
        this.setSchemefilterColumns(curSelTabKey, schemeFilterColumns);
    }

    private void setSchemefilterColumns(String curSelTabKey, List<FilterColumn> schemeFilterColumns) {
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        String reportListAp = CpsTrackRptUtil.getReportListAp(curSelTabKey);
        if (reportListAp == null) {
            return;
        }
        ReportList reportList = (ReportList)this.getControl(reportListAp);
        List columns = reportList.getColumns();
        List<String> excludeFields = this.getExcludeFields();
        for (AbstractReportColumn column : columns) {
            DecimalReportColumn col;
            String fieldType = "";
            String fieldKey = "";
            if (column instanceof DecimalReportColumn) {
                col = (DecimalReportColumn)column;
                fieldType = col.getFieldType();
                fieldKey = col.getFieldKey();
            } else if (column instanceof ReportColumn) {
                col = (ReportColumn)column;
                fieldType = col.getFieldType();
                fieldKey = col.getFieldKey();
            } else if (column instanceof ComboReportColumn) {
                col = (ComboReportColumn)column;
                fieldType = col.getFieldType();
                fieldKey = col.getFieldKey();
            }
            if (fieldKey.endsWith("owner")) {
                SchemeBaseDataFilterColumn basedataColumn = new SchemeBaseDataFilterColumn();
                basedataColumn.setCaption(column.getCaption());
                IDataEntityProperty findProperty = dataEntityType.findProperty(fieldKey);
                String displayProp = ((BasedataProp)findProperty).getDisplayProp();
                basedataColumn.setFieldName(fieldKey + '.' + displayProp);
                schemeFilterColumns.add((FilterColumn)basedataColumn);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)fieldType) || excludeFields.contains(fieldKey)) continue;
            switch (fieldType) {
                case "text": 
                case "integer": 
                case "decimal": 
                case "qty": 
                case "date": {
                    SchemeFilterColumn filterColumn = new SchemeFilterColumn();
                    filterColumn.setCaption(column.getCaption());
                    filterColumn.setFieldName(fieldKey);
                    schemeFilterColumns.add((FilterColumn)filterColumn);
                    break;
                }
                case "combofield": {
                    SchemeFilterColumn combofilterColumn = new SchemeFilterColumn();
                    combofilterColumn.setCaption(column.getCaption());
                    combofilterColumn.setFieldName(fieldKey);
                    List<ComboItem> comboItems = this.getComboItems(fieldKey, dataEntityType);
                    combofilterColumn.setComboItems(comboItems);
                    schemeFilterColumns.add((FilterColumn)combofilterColumn);
                    break;
                }
                case "basedata": {
                    SchemeBaseDataFilterColumn basedataColumn = new SchemeBaseDataFilterColumn();
                    basedataColumn.setCaption(column.getCaption());
                    IDataEntityProperty findProperty = dataEntityType.findProperty(fieldKey);
                    String displayProp = ((BasedataProp)findProperty).getDisplayProp();
                    basedataColumn.setFieldName(fieldKey + '.' + displayProp);
                    schemeFilterColumns.add((FilterColumn)basedataColumn);
                    break;
                }
                case "flex": {
                    break;
                }
            }
        }
    }

    private List<String> getExcludeFields() {
        ArrayList<String> excludeFields = new ArrayList<String>(10);
        excludeFields.add("smid");
        excludeFields.add("pomid");
        excludeFields.add("omid");
        excludeFields.add("pmid");
        excludeFields.add("stockid");
        excludeFields.add("smentryid");
        excludeFields.add("pomentryid");
        excludeFields.add("omentryid");
        excludeFields.add("pmentryid");
        excludeFields.add("stockentryid");
        excludeFields.add("om_project");
        excludeFields.add("pom_project");
        excludeFields.add("om_orderid");
        excludeFields.add("om_bomid");
        excludeFields.add("om_bomversionid");
        return excludeFields;
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        int rowIndex = e.getRowIndex();
        if ("sm_billno".equals(e.getFieldName())) {
            this.showForm("reportlistap", BILL_SM_SALORDER, "smid", rowIndex);
        } else if ("pom_billno".equals(e.getFieldName())) {
            this.showForm("pomreportlistap", BILL_POM_MFTORDER, "pomid", rowIndex);
        } else if ("pom_bomid".equals(e.getFieldName())) {
            this.showBOMForwardSearch("pomreportlistap", "pdm_bomforwardsearch", "pom_bomid", rowIndex);
        } else if ("om_billno".equals(e.getFieldName())) {
            this.showForm("omreportlistap", BILL_OM_MFTORDER, "omid", rowIndex);
        } else if ("om_bom".equals(e.getFieldName())) {
            this.showBOMForwardSearch("omreportlistap", "pdm_bomforwardsearch", "om_bomid", rowIndex);
        } else if ("om_pmbillno".equals(e.getFieldName())) {
            this.showForm("omreportlistap", "pm_purorderbill", "om_orderid", rowIndex);
        } else if ("pm_billno".equals(e.getFieldName())) {
            this.showForm("pmreportlistap", "pm_purorderbill", "pmid", rowIndex);
        } else if ("stock_billno".equals(e.getFieldName())) {
            ReportList list = (ReportList)this.getControl("mftstockreportlistap");
            DynamicObject rowData = list.getReportModel().getRowData(rowIndex);
            if (rowData == null) {
                return;
            }
            DynamicObject entity = rowData.getDynamicObject("stock_billname");
            this.showForm("mftstockreportlistap", entity.getString("number"), "stockid", rowIndex);
        } else if ("sm_priority".equals(e.getFieldName())) {
            this.showPriorityForm("reportlistap", BILL_SM_SALORDER, "smid", "smentryid", rowIndex);
        } else if ("pom_priority".equals(e.getFieldName())) {
            this.showPriorityForm("pomreportlistap", BILL_POM_MFTORDER, "pomid", "pomentryid", rowIndex);
        } else if ("om_priority".equals(e.getFieldName())) {
            this.showPriorityForm("omreportlistap", BILL_OM_MFTORDER, "omid", "omentryid", rowIndex);
        } else if ("pm_priority".equals(e.getFieldName())) {
            this.showPriorityForm("pmreportlistap", "pm_purorderbill", "pmid", "pmentryid", rowIndex);
        }
    }

    private void showPriorityForm(String reportlistap, String entityNumber, String idKey, String idEntryKey, int rowIndex) {
        ReportList list = (ReportList)this.getControl(reportlistap);
        DynamicObject rowData = list.getReportModel().getRowData(rowIndex);
        HashMap<String, String> para = new HashMap<String, String>(2);
        if (rowData == null) {
            return;
        }
        DynamicObjectType entityType = rowData.getDynamicObjectType();
        entityNumber = this.getEntityNumber(reportlistap, rowData, entityNumber, entityType);
        para.put("formId", "mrp_cps_priority");
        Long orderid = 0L;
        Long orderentryid = 0L;
        Object value = rowData.get(idKey);
        if (value instanceof DynamicObject) {
            orderid = ((DynamicObject)value).getLong(PROP_ID);
        } else if (value instanceof Long) {
            orderid = (Long)value;
        }
        Object entryvalue = rowData.get(idEntryKey);
        if (entryvalue instanceof DynamicObject) {
            orderentryid = ((DynamicObject)entryvalue).getLong(PROP_ID);
        } else if (entryvalue instanceof Long) {
            orderentryid = (Long)entryvalue;
        }
        if (orderentryid == 0L) {
            return;
        }
        OperationStatus status = OperationStatus.ADDNEW;
        DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)"mrp_cps_priority", (String)PROP_ID, (QFilter[])new QFilter[]{new QFilter("orderid", "=", (Object)orderid), new QFilter("orderentryid", "=", (Object)orderentryid), new QFilter("billentity", "=", (Object)entityNumber)});
        if (data != null) {
            para.put("pkId", data.getPkValue().toString());
            status = OperationStatus.EDIT;
        }
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setStatus(status);
        showParameter.setCustomParam("orderid", (Object)orderid);
        showParameter.setCustomParam("orderentryid", (Object)orderentryid);
        showParameter.setCustomParam("billentity", (Object)entityNumber);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh_" + reportlistap));
        this.getView().showForm(showParameter);
    }

    private String getEntityNumber(String reportlistap, DynamicObject rowData, String entityNumber, DynamicObjectType entityType) {
        String prefix = this.getPrefix(reportlistap);
        DynamicProperty property = entityType.getProperty(prefix + "billname");
        if (property == null) {
            return entityNumber;
        }
        DynamicObject billname = rowData.getDynamicObject(prefix + "billname");
        if (billname != null) {
            entityNumber = billname.getString("number");
        }
        return entityNumber;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object obj;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.startsWith("refresh_") && (obj = closedCallBackEvent.getReturnData()) != null) {
            String reportlistap = actionId.replace("refresh_", "");
            ReportList list = (ReportList)this.getControl(reportlistap);
            list.refresh();
        }
    }

    private void showBOMForwardSearch(String reportlistap, String entity, String idKey, int rowIndex) {
        ReportList list = (ReportList)this.getControl(reportlistap);
        DynamicObject rowData = list.getReportModel().getRowData(rowIndex);
        Long bomid = 0L;
        String prefix = this.getPrefix(idKey);
        Object value = rowData.get(idKey);
        DynamicObject material = null;
        DynamicObject createorg = null;
        DynamicObject bomtype = null;
        DynamicObject bom = null;
        DynamicObject configcode = null;
        if (value instanceof DynamicObject) {
            bom = (DynamicObject)value;
            bomid = ((DynamicObject)value).getLong(PROP_ID);
        } else if (value instanceof Long) {
            bomid = (Long)value;
            bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bomid, (String)"pdm_mftbom");
        }
        if (bom != null) {
            material = bom.getDynamicObject("material");
            createorg = bom.getDynamicObject("createorg");
            bomtype = bom.getDynamicObject("type");
            configcode = bom.getDynamicObject("configuredcode");
        }
        if (bomid == 0L) {
            return;
        }
        BigDecimal qty = rowData.getBigDecimal(prefix + "qty");
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryparam = new ReportQueryParam();
        FilterInfo filter = queryparam.getFilter();
        Date date = new Date();
        filter.addFilterItem("materialno", material != null ? material.getDynamicObject("masterid") : null);
        filter.addFilterItem(USEORG_FILEDNAME, (Object)createorg);
        filter.addFilterItem("bomno", (Object)bom);
        filter.addFilterItem("bomtype", (Object)bomtype);
        filter.addFilterItem("searchdate", (Object)date);
        filter.addFilterItem("showtype", (Object)"A");
        filter.addFilterItem("demandcount", (Object)qty);
        filter.addFilterItem("configcode", (Object)configcode);
        showParameter.setFormId(entity);
        showParameter.setQueryParam(queryparam);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showForm(String reportlistap, String entityNumber, String idKey, int rowIndex) {
        DynamicObject billname;
        ReportList list = (ReportList)this.getControl(reportlistap);
        DynamicObject rowData = list.getReportModel().getRowData(rowIndex);
        HashMap<String, String> para = new HashMap<String, String>(2);
        if ("pmreportlistap".equals(reportlistap)) {
            billname = rowData.getDynamicObject("pm_billname");
            entityNumber = billname.getString("number");
        } else if ("omreportlistap".equals(reportlistap)) {
            billname = rowData.getDynamicObject("om_billname");
            entityNumber = billname.getString("number");
        }
        para.put("formId", entityNumber);
        Long orderid = 0L;
        Object value = rowData.get(idKey);
        if (value instanceof DynamicObject) {
            orderid = ((DynamicObject)value).getLong(PROP_ID);
        } else if (value instanceof Long) {
            orderid = (Long)value;
        }
        if (orderid == 0L) {
            return;
        }
        para.put("pkId", orderid.toString());
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(showParameter);
    }

    private void setfilterColumns(String curSelTabKey, List<FilterColumn> filterColumnList) {
        CommonDateFilterColumn dateColumn = null;
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        switch (curSelTabKey) {
            case "smtabpageap": {
                dateColumn = new CommonDateFilterColumn();
                dateColumn.setDefaultValue("73");
                dateColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d1\u8d27\u65f6\u95f4", (String)"CpsTrackRptPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0])));
                dateColumn.setFieldName("sm_deliverydate");
                dateColumn.setType("date");
                dateColumn.setKey("deliverydate");
                dateColumn.setCustom(true);
                this.getDateComboItems((CommonFilterColumn)dateColumn);
                filterColumnList.add(1, (FilterColumn)dateColumn);
                CommonFilterColumn statusColumn = new CommonFilterColumn();
                statusColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53d1\u8d27\u72b6\u6001", (String)"CpsTrackRptPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0])));
                statusColumn.setFieldName(SHIPMENTSTATUS);
                statusColumn.setType("enum");
                statusColumn.setDefaultValue("0");
                List<ComboItem> comboItems = this.getComboItems(SHIPMENTSTATUS, dataEntityType);
                statusColumn.setComboItems(comboItems);
                filterColumnList.add(2, (FilterColumn)statusColumn);
                CommonFilterColumn outboundColumn = new CommonFilterColumn();
                outboundColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u51fa\u5e93\u72b6\u6001", (String)"CpsTrackRptPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0])));
                outboundColumn.setFieldName(OUTBOUNDSTATUS);
                outboundColumn.setType("date");
                outboundColumn.setDefaultValue("0");
                List<ComboItem> comboItems1 = this.getComboItems(OUTBOUNDSTATUS, dataEntityType);
                outboundColumn.setComboItems(comboItems1);
                filterColumnList.add(3, (FilterColumn)outboundColumn);
                break;
            }
            case "pomtabpageap": 
            case "omtabpageap": {
                String prefix = this.getPrefix(curSelTabKey);
                dateColumn = new CommonDateFilterColumn();
                dateColumn.setDefaultValue("10");
                dateColumn.setType("date");
                dateColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4", (String)"CpsTrackRptPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0])));
                dateColumn.setFieldName(prefix + "planbegintime");
                dateColumn.setKey("planbegintime");
                dateColumn.setCustom(true);
                this.getDateComboItems((CommonFilterColumn)dateColumn);
                filterColumnList.add(1, (FilterColumn)dateColumn);
                CommonFilterColumn cpColumn = new CommonFilterColumn();
                cpColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9f50\u5957\u72b6\u6001", (String)"CpsTrackRptPlugin_7", (String)"mmc-mrp-report", (Object[])new Object[0])));
                cpColumn.setFieldName(prefix + "cpstatus");
                cpColumn.setType("enum");
                cpColumn.setDefaultValue("");
                List<ComboItem> comboItems2 = this.getComboItems(prefix + "cpstatus", dataEntityType);
                cpColumn.setComboItems(comboItems2);
                filterColumnList.add(2, (FilterColumn)cpColumn);
                CommonFilterColumn billStatusColumn = new CommonFilterColumn();
                billStatusColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"CpsTrackRptPlugin_8", (String)"mmc-mrp-report", (Object[])new Object[0])));
                billStatusColumn.setFieldName(prefix + "billstatus");
                billStatusColumn.setType("enum");
                billStatusColumn.setDefaultValue("");
                List<ComboItem> comboItems3 = this.getComboItems(prefix + "billstatus", dataEntityType);
                billStatusColumn.setComboItems(comboItems3);
                filterColumnList.add(3, (FilterColumn)billStatusColumn);
                break;
            }
        }
    }

    private void getDateComboItems(CommonFilterColumn dateColumn) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(5);
        ComboItem item1 = new ComboItem();
        item1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4eca\u5929", (String)"CpsTrackRptPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0])));
        item1.setValue("13");
        combos.add(item1);
        ComboItem item2 = new ComboItem();
        item2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u5468", (String)"CpsTrackRptPlugin_10", (String)"mmc-mrp-report", (Object[])new Object[0])));
        item2.setValue("10");
        combos.add(item2);
        ComboItem item3 = new ComboItem();
        item3.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u6708", (String)"CpsTrackRptPlugin_11", (String)"mmc-mrp-report", (Object[])new Object[0])));
        item3.setValue("63");
        combos.add(item3);
        ComboItem item4 = new ComboItem();
        item4.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0b\u5468", (String)"CpsTrackRptPlugin_12", (String)"mmc-mrp-report", (Object[])new Object[0])));
        item4.setValue("73");
        combos.add(item4);
        ComboItem item5 = new ComboItem();
        item5.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8fd1\u4e09\u6708", (String)"CpsTrackRptPlugin_13", (String)"mmc-mrp-report", (Object[])new Object[0])));
        item5.setValue("24");
        combos.add(item5);
        dateColumn.setComboItems(combos);
    }

    private List<ComboItem> getComboItems(String Combo, MainEntityType dataEntityType) {
        ComboProp planordertplOrdertype = (ComboProp)dataEntityType.getProperty(Combo);
        List comboItems = planordertplOrdertype.getComboItems();
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(comboItems.size());
        for (ValueMapItem comboItem : comboItems) {
            ComboItem item = new ComboItem();
            item.setCaption(comboItem.getName());
            item.setValue(comboItem.getValue());
            combos.add(item);
        }
        return combos;
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    private DynamicObjectCollection getGroupOrgSet(String entity, String appId, Long viewId) {
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entity, (String)"47150e89000000ac");
        DynamicObjectCollection col = CpsTrackRptPlugin.getOrgByViewAndPermOrg(viewId, result);
        return col;
    }

    public static Set<Long> getOrgIdByViewAndPermOrg(Object pkValue, HasPermOrgResult result) {
        ORM ormOv = ORM.create();
        QFilter f1 = new QFilter("view.id", "=", pkValue);
        QFilter f2 = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        QFilter[] qfilters = null;
        if (result.hasAllOrgPerm()) {
            qfilters = new QFilter[]{f1, f2};
        } else {
            QFilter idsFilter = new QFilter(USEORG_FILEDNAME, "in", (Object)result.getHasPermOrgs());
            qfilters = new QFilter[]{f1, f2, idsFilter};
        }
        HashSet<Long> orgSets = new HashSet<Long>();
        try (DataSet ds = ormOv.queryDataSet(CpsTrackRptPlugin.class.getName(), "bos_org_structure", USEORG_FILEDNAME, qfilters);){
            for (Row row : ds) {
                if (row.getLong(USEORG_FILEDNAME) == null) continue;
                orgSets.add(row.getLong(USEORG_FILEDNAME));
            }
        }
        return orgSets;
    }

    public static DynamicObjectCollection getOrgByViewAndPermOrg(Object pkValue, HasPermOrgResult result) {
        Set<Long> orgSets = CpsTrackRptPlugin.getOrgIdByViewAndPermOrg(pkValue, result);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "in", orgSets)}, (String)"number asc");
        return col;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Set<String> columns = this.getReportlistapColumns("reportlistap");
        this.initColumns("reportlistap", columns);
        Set<String> pomcolumns = this.getReportlistapColumns("pomreportlistap");
        this.initColumns("pomreportlistap", pomcolumns);
        Set<String> omcolumns = this.getReportlistapColumns("omreportlistap");
        this.initColumns("omreportlistap", omcolumns);
        Set<String> pmcolumns = this.getReportlistapColumns("pmreportlistap");
        this.initColumns("pmreportlistap", pmcolumns);
        Set<String> stockcolumns = this.getReportlistapColumns("mftstockreportlistap");
        this.initColumns("mftstockreportlistap", stockcolumns);
    }

    private Set<String> getReportlistapColumns(String reportlistap) {
        HashSet<String> set = new HashSet<String>(30);
        if ("reportlistap".equals(reportlistap)) {
            set.add("sm_billtype");
            set.add("sm_biztype");
            set.add("sm_bizdate");
            set.add("sm_org");
            set.add("sm_dept");
            set.add("sm_auxpty");
            set.add("sm_e_stockorg");
            set.add("sm_ownertype");
            set.add("sm_owner");
            set.add("sm_lotnumber");
            set.add("sm_configuredcode");
            set.add("sm_tracknumber");
            set.add("sm_d_plandate");
            set.add("sm_d_plandeliverydate");
            set.add("sm_d_planqty");
        } else if ("pomreportlistap".equals(reportlistap)) {
            set.add("pom_billdate");
            set.add("pom_transactiontype");
            set.add("pom_entrustdept");
            set.add("pom_auxproperty");
            set.add("pom_planqty");
            set.add("pom_bomid");
            set.add("pom_bomversion");
            set.add("pom_pickstatus");
            set.add("pom_batchno");
            set.add("pom_configuredcode");
            set.add("pom_tracknumber");
        } else if ("omreportlistap".equals(reportlistap)) {
            set.add("om_billdate");
            set.add("om_transactiontype");
            set.add("om_transouttypeid");
            set.add("om_auxproperty");
            set.add("om_planqty");
            set.add("om_bom");
            set.add("om_bomversion");
            set.add("om_producedept");
            set.add("om_pickstatus");
            set.add("om_batchno");
            set.add("om_configuredcode");
            set.add("om_tracknumber");
        } else if ("pmreportlistap".equals(reportlistap)) {
            set.add("pm_billtype");
            set.add("pm_biztype");
            set.add("pm_biztime");
            set.add("pm_org");
            set.add("pm_dept");
            set.add("pm_bizuser");
            set.add("pm_supplier");
            set.add("pm_entryreqorg");
            set.add("pm_entryrecorg");
            set.add("pm_ownertype");
            set.add("pm_owner");
            set.add("pm_auxpty");
            set.add("pm_tracknumber");
        } else if ("mftstockreportlistap".equals(reportlistap)) {
            set.add("stock_orderno");
            set.add("stock_childauxpropertyid");
            set.add("stock_useqty");
            set.add("stock_wipqty");
            set.add("stock_batchno");
            set.add("stock_entryconfiguredcode");
            set.add("stock_bomreversion");
            set.add("stock_supplymode");
            set.add("stock_supplierid");
            set.add("stock_supplyorgid");
            set.add("stock_warehouseid");
            set.add("stock_location");
            set.add("stock_isbackflush");
            set.add("stock_iskeypart");
        }
        return set;
    }

    protected void initColumns(String reportlistap, Set<String> hidecolumns) {
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        ArrayList<GridConfigurationRow> gridConfig = gridConfigDAO.getGridConfig(this.getView().getFormShowParameter().getFormId(), reportlistap);
        if (gridConfig.isEmpty()) {
            ReportList re = (ReportList)this.getControl(reportlistap);
            List columns = re.getColumns();
            gridConfig = new ArrayList<GridConfigurationRow>(10);
            for (AbstractReportColumn co : columns) {
                GridConfigurationRow gridConfigurationRow;
                LocaleString header;
                if (co instanceof ReportColumnGroup) {
                    ReportColumnGroup groupCo = (ReportColumnGroup)co;
                    header = groupCo.getCaption();
                    if (StringUtils.isBlank((CharSequence)header.getLocaleValue())) continue;
                    gridConfigurationRow = new GridConfigurationRow();
                    gridConfigurationRow.setFieldKey(groupCo.getFieldKey());
                    gridConfigurationRow.setFieldName(header);
                    gridConfigurationRow.setColWidth(50);
                    gridConfigurationRow.setFreeze(false);
                    gridConfigurationRow.setTextAlign("default");
                    gridConfigurationRow.setHide(false);
                    gridConfig.add(gridConfigurationRow);
                    continue;
                }
                ReportColumn rptCo = (ReportColumn)co;
                header = rptCo.getCaption();
                if (StringUtils.isBlank((CharSequence)header.getLocaleValue())) continue;
                gridConfigurationRow = new GridConfigurationRow();
                gridConfigurationRow.setFieldKey(rptCo.getFieldKey());
                gridConfigurationRow.setFieldName(header);
                gridConfigurationRow.setColWidth(50);
                gridConfigurationRow.setFreeze(rptCo.isFreeze());
                gridConfigurationRow.setTextAlign("default");
                gridConfigurationRow.setHide(false);
                gridConfig.add(gridConfigurationRow);
            }
            gridConfigDAO.saveGridConfig(this.getView().getFormShowParameter().getFormId(), reportlistap, gridConfig);
        }
        boolean flag = false;
        for (GridConfigurationRow row : gridConfig) {
            if (!row.isHide()) continue;
            flag = true;
            break;
        }
        if (!flag) {
            for (GridConfigurationRow row : gridConfig) {
                if (!hidecolumns.contains(row.getFieldKey())) continue;
                row.setHide(true);
            }
            gridConfigDAO.saveGridConfig(this.getView().getFormShowParameter().getFormId(), reportlistap, gridConfig);
        }
    }

    private String getDefaultUseOrg(DynamicObjectCollection col) {
        String defaultUseOrg = null;
        if (!col.isEmpty()) {
            defaultUseOrg = String.valueOf(((DynamicObject)col.get(0)).get(PROP_ID));
        }
        long longinOrg = RequestContext.get().getOrgId();
        for (DynamicObject obj : col) {
            if (longinOrg != obj.getLong(PROP_ID)) continue;
            defaultUseOrg = String.valueOf(longinOrg);
        }
        return defaultUseOrg;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        String customfilterStr = this.getPageCache().get("customfilter");
        Map customfilter = null;
        if (customfilterStr != null) {
            customfilter = (Map)SerializationUtils.fromJsonString((String)customfilterStr, Map.class);
        }
        if (currentCommonFilter == null) {
            return;
        }
        List fieldNames = (List)currentCommonFilter.get("FieldName");
        List value = (List)currentCommonFilter.get("Value");
        if (customfilter != null) {
            for (String key : customfilter.keySet()) {
                if (!fieldNames.contains(key) && !fieldNames.contains(key + ".id")) continue;
                customfilter.put(key, value);
                break;
            }
        }
        String customfilterSer = SerializationUtils.toJsonString((Object)customfilter);
        this.getPageCache().put("customfilter", customfilterSer);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String curseltabkey = this.getPageCache().get(PGCACHE_CURSELTABKEY);
        if ("smtabpageap".equals(curseltabkey)) {
            return true;
        }
        if ("pomtabpageap".equals(curseltabkey)) {
            ReportList srcRpt = (ReportList)this.getControl("pomreportlistap");
            srcRpt.clearEntryState();
            this.queryReportList("pomreportlistap", queryParam);
        } else if ("omtabpageap".equals(curseltabkey)) {
            ReportList srcRpt = (ReportList)this.getControl("omreportlistap");
            srcRpt.clearEntryState();
            this.queryReportList("omreportlistap", queryParam);
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String prefix = this.getPrefix(operateKey);
        if (!this.checkOperateKey(operateKey)) {
            return;
        }
        String reportListAp = "";
        String entityNumber = "";
        if (operateKey.startsWith(BILL_POM_)) {
            reportListAp = "pomreportlistap";
            entityNumber = BILL_POM_MFTORDER;
        } else if (operateKey.startsWith(BILL_OM_)) {
            reportListAp = "omreportlistap";
            entityNumber = BILL_OM_MFTORDER;
        }
        ReportList report = (ReportList)this.getControl(reportListAp);
        int[] selectedRows = report.getEntryState().getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>(selectedRows.length);
        String idPrefix = this.getIdPrefix(reportListAp);
        for (int row : selectedRows) {
            DynamicObject rowData = report.getReportModel().getRowData(row);
            if (rowData == null) continue;
            Long id = rowData.getLong(idPrefix + PROP_ID);
            ids.add(id);
        }
        if (ids.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"CpsTrackRptPlugin_21", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return;
        }
        OperateOption option = OperateOption.create();
        String operateNumber = operateKey.replace(prefix, "");
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)operateNumber, (String)entityNumber, (Object[])ids.toArray(new Long[0]), (OperateOption)option);
        if (executeOperate.isSuccess()) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"CpsTrackRptPlugin_23", (String)"mmc-mrp-report", (Object[])new Object[0]), operate.getOperateName().getLocaleValue()));
            report.refresh();
        } else {
            this.getView().showOperationResult(executeOperate);
        }
    }

    private boolean checkOperateKey(String operateKey) {
        return Stream.of("pom_submit", "om_submit", "pom_audit", "om_audit").anyMatch(tenantCode -> StringUtils.equals((CharSequence)operateKey, (CharSequence)tenantCode));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (OP_BIZSMQUERY.equals(operateKey)) {
            String reportListAp = "reportlistap";
            if (!this.checkChooseData(reportListAp)) {
                return;
            }
            this.bizQueryData(reportListAp, false);
        } else if (OP_BIZPOMQUERY.equals(operateKey)) {
            String reportListAp = "pomreportlistap";
            if (!this.checkChooseData(reportListAp)) {
                return;
            }
            this.bizQueryData(reportListAp, false);
        } else if (OP_BIZOMQUERY.equals(operateKey)) {
            String reportListAp = "omreportlistap";
            if (!this.checkChooseData(reportListAp)) {
                return;
            }
            this.bizQueryData(reportListAp, false);
        } else if (OP_EXPORT.equals(operateKey)) {
            try {
                this.exportExcel();
            }
            catch (IOException ex) {
                logger.error("\u5bfc\u51fa\u9f50\u5957\u8ddf\u8e2a\u6570\u636e\u62a5\u9519\uff1a", (Throwable)ex);
            }
        }
    }

    private boolean checkChooseData(String reportListAp) {
        ReportList report = (ReportList)this.getControl(reportListAp);
        int[] selectedRows = report.getEntryState().getSelectedRows();
        if (selectedRows.length > 0) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"CpsTrackRptPlugin_21", (String)"mmc-mrp-report", (Object[])new Object[0]));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void exportExcel() throws IOException {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4e2d,\u8bf7\u7a0d\u7b49\u3002", (String)"CpsTrackRptPlugin_15", (String)"mmc-mrp-report", (Object[])new Object[0])));
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        SXSSFWorkbook workbook = null;
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        List<String> reportKeys = this.getExportReportKey();
        List<String> excludeFields = this.getExcludeFields();
        try {
            workbook = new SXSSFWorkbook();
            for (int x = 0; x < reportKeys.size(); ++x) {
                void var17_22;
                String reportKey = reportKeys.get(x);
                ReportList list = (ReportList)this.getControl(reportKey);
                SXSSFSheet sheet = workbook.createSheet();
                String reportName = this.getReportName(reportKey);
                workbook.setSheetName(x, reportName);
                List columns = list.getReportModel().getColumns();
                SXSSFRow firstrow = sheet.createRow(0);
                int n = 0;
                for (int i = 0; i < columns.size(); ++i) {
                    ReportColumn reportColumn = (ReportColumn)columns.get(i);
                    if (excludeFields.contains(reportColumn.getFieldKey())) continue;
                    String string = reportColumn.getCaption().getLocaleValue();
                    firstrow.createCell(n).setCellValue(string);
                    ++n;
                }
                int rowNum = 1;
                int[] selectedRows = list.getEntryState().getSelectedRows();
                if (selectedRows.length > 0) {
                    for (int i : selectedRows) {
                        this.dealData(i, n, sheet, rowNum, list, columns, excludeFields, dataEntityType);
                        ++rowNum;
                    }
                    continue;
                }
                boolean bl = true;
                while (var17_22 <= list.getReportModel().getRowCount()) {
                    this.dealData((int)var17_22, n, sheet, rowNum, list, columns, excludeFields, dataEntityType);
                    ++rowNum;
                    ++var17_22;
                }
            }
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u9f50\u5957\u8ddf\u8e2a.xlsx", (String)"CpsTrackRptPlugin_14", (String)"mmc-mrp-report", (Object[])new Object[0]), (InputStream)inStream, timeout);
            FilePermissionUtil.addFilePermission((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)"mrp_cps_tracks", (String)"4730fc9f000004ae");
            this.getView().download(tempUrl);
            outStream.close();
            inStream.close();
            workbook.close();
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (workbook != null) {
                workbook.close();
            }
            this.getView().hideLoading();
        }
    }

    private void dealData(int i, int n, SXSSFSheet sheet, int rowNum, ReportList list, List<AbstractReportColumn> columns, List<String> excludeFields, MainEntityType dataEntityType) {
        DynamicObject rowData = list.getReportModel().getRowData(i);
        SXSSFRow row = sheet.createRow(rowNum);
        n = 0;
        int m = columns.size();
        for (int k = 0; k < m; ++k) {
            ReportColumn column = (ReportColumn)columns.get(k);
            String fieldType = column.getFieldType();
            String fieldKey = column.getFieldKey();
            if (excludeFields.contains(fieldKey)) continue;
            if (fieldType == null) {
                String value = this.dealNofieldTypeData(column, rowData, fieldKey);
                row.createCell(n).setCellValue(value);
                ++n;
                continue;
            }
            switch (fieldType) {
                case "text": 
                case "integer": {
                    row.createCell(n).setCellValue(rowData.getString(fieldKey));
                    break;
                }
                case "decimal": 
                case "qty": {
                    Double qty = new Double(rowData.getString(fieldKey));
                    row.createCell(n).setCellValue(qty.doubleValue());
                    break;
                }
                case "date": {
                    String val = this.getDateValue(rowData, fieldKey);
                    row.createCell(n).setCellValue(val);
                    break;
                }
                case "combofield": {
                    ComboProp planordertplOrdertype = (ComboProp)dataEntityType.getProperty(fieldKey);
                    List comboItems = planordertplOrdertype.getComboItems();
                    String fieldvalue = rowData.getString(fieldKey);
                    String fieldname = "";
                    for (ValueMapItem comboItem : comboItems) {
                        String value = comboItem.getValue();
                        if (!value.equals(fieldvalue)) continue;
                        fieldname = comboItem.getName().getLocaleValue();
                        break;
                    }
                    row.createCell(n).setCellValue(fieldname);
                    break;
                }
                case "basedata": 
                case "unit": {
                    String displayVal = this.getBaseDataDisplayValue(rowData, fieldKey, dataEntityType);
                    row.createCell(n).setCellValue(displayVal);
                    break;
                }
                case "flex": {
                    String value = "";
                    FlexValueFormatter flexValueFormat = new FlexValueFormatter();
                    ReportColumn reportColumn = (ReportColumn)columns.get(k);
                    FlexProp flex = (FlexProp)reportColumn.getFieldProperty();
                    Object srcValue = flexValueFormat.getDisplayValueForReport(rowData, flex, flex.getBasePropertyKey());
                    value = srcValue instanceof ArrayList ? String.join((CharSequence)";", (ArrayList)srcValue) : srcValue.toString();
                    row.createCell(n).setCellValue(value);
                    break;
                }
                default: {
                    row.createCell(n).setCellValue(rowData.getString(fieldKey));
                }
            }
            ++n;
        }
    }

    private String getDateValue(DynamicObject rowData, String fieldKey) {
        String val = "";
        Date date = rowData.getDate(fieldKey);
        if (date == null) {
            return val;
        }
        val = DateUtils.formatDate((Date)date);
        return val;
    }

    private String getReportName(String reportKey) {
        String reportName = "";
        switch (reportKey) {
            case "reportlistap": {
                reportName = ResManager.loadKDString((String)"\u72ec\u7acb\u9700\u6c42", (String)"CpsTrackRptPlugin_16", (String)"mmc-mrp-report", (Object[])new Object[0]);
                break;
            }
            case "pomreportlistap": {
                reportName = ResManager.loadKDString((String)"\u751f\u4ea7\u4e1a\u52a1", (String)"CpsTrackRptPlugin_17", (String)"mmc-mrp-report", (Object[])new Object[0]);
                break;
            }
            case "omreportlistap": {
                reportName = ResManager.loadKDString((String)"\u59d4\u5916\u4e1a\u52a1", (String)"CpsTrackRptPlugin_18", (String)"mmc-mrp-report", (Object[])new Object[0]);
                break;
            }
            case "pmreportlistap": {
                reportName = ResManager.loadKDString((String)"\u91c7\u8d2d\u4e1a\u52a1", (String)"CpsTrackRptPlugin_19", (String)"mmc-mrp-report", (Object[])new Object[0]);
                break;
            }
            case "mftstockreportlistap": {
                reportName = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355", (String)"CpsTrackRptPlugin_20", (String)"mmc-mrp-report", (Object[])new Object[0]);
                break;
            }
        }
        return reportName;
    }

    private String dealNofieldTypeData(ReportColumn column, DynamicObject rowData, String fieldKey) {
        String value = null;
        String refBasedataProp = column.getRefBasedataProp();
        String displayProp = column.getDisplayProp();
        if (refBasedataProp == null) {
            Object object = rowData.get(fieldKey);
            if (object instanceof DynamicObject) {
                DynamicObject data = (DynamicObject)object;
                value = this.getBaseDataDisplayVal(data, displayProp);
            } else if (object instanceof String) {
                value = object.toString();
            }
            return value;
        }
        DynamicObject data = rowData.getDynamicObject(refBasedataProp);
        value = this.getBaseDataDisplayVal(data, displayProp);
        return value;
    }

    private String getBaseDataDisplayVal(DynamicObject data, String displayProp) {
        String value = "";
        if (data == null) {
            return value;
        }
        value = data.getString(displayProp);
        return value;
    }

    private String getBaseDataDisplayValue(DynamicObject rowData, String fieldKey, MainEntityType dataEntityType) {
        String displayVal = "";
        DynamicObject bsedata = rowData.getDynamicObject(fieldKey);
        if (bsedata == null) {
            return displayVal;
        }
        IDataEntityProperty fieldProperty = dataEntityType.findProperty(fieldKey);
        if (fieldProperty instanceof BasedataProp) {
            String displayProp = ((BasedataProp)fieldProperty).getDisplayProp();
            displayVal = bsedata.getString(displayProp);
        }
        return displayVal;
    }

    private List<String> getExportReportKey() {
        ArrayList<String> reports = new ArrayList<String>(5);
        String curseltabkey = this.getPageCache().get(PGCACHE_CURSELTABKEY);
        if ("smtabpageap".equals(curseltabkey)) {
            reports.add("reportlistap");
            reports.add("pomreportlistap");
            reports.add("omreportlistap");
            reports.add("pmreportlistap");
        } else if ("pomtabpageap".equals(curseltabkey)) {
            reports.add("pomreportlistap");
        } else if ("omtabpageap".equals(curseltabkey)) {
            reports.add("omreportlistap");
        }
        reports.add("mftstockreportlistap");
        return reports;
    }

    private void bizQueryData(String reportListAp, boolean isVerifyQueryQuantity) {
        ReportList report = (ReportList)this.getControl(reportListAp);
        String entryKey = report.getEntryKey();
        ReportQueryParam queryParam = this.getQueryParam();
        int[] selectedRows = report.getEntryState().getSelectedRows();
        List<String> reportListaps = this.getLinkedReport(entryKey);
        String prefix = this.getIdPrefix(entryKey);
        Map customParam = queryParam.getCustomParam();
        ArrayList<Long> ids = new ArrayList<Long>(selectedRows.length);
        HashMap<String, List> map = new HashMap<String, List>(selectedRows.length);
        for (int row : selectedRows) {
            DynamicObject rowData = report.getReportModel().getRowData(row);
            if (rowData == null) continue;
            Long id = rowData.getLong(prefix + "entryid");
            ids.add(id);
            if ("omreportlistap".equals(entryKey)) {
                DynamicObject billname = rowData.getDynamicObject("om_billname");
                String billNumber = billname.getString("number");
                String enityNumber = this.getstockKey(billNumber);
                List entryIds = map.computeIfAbsent(enityNumber, k -> new ArrayList(10));
                entryIds.add(id);
                continue;
            }
            if (!"pomreportlistap".equals(entryKey)) continue;
            String enityNumber = this.getstockKey(BILL_POM_MFTORDER);
            List entryIds = map.computeIfAbsent(enityNumber, k -> new ArrayList(10));
            entryIds.add(id);
        }
        if ("reportlistap".equals(entryKey)) {
            ReportList srcRpt = (ReportList)this.getControl("mftstockreportlistap");
            srcRpt.initEmptyGrid();
            this.updateReportCache(srcRpt, queryParam);
        }
        Object object = reportListaps.iterator();
        while (object.hasNext()) {
            String reportListap = (String)object.next();
            if (ids.size() != 1 && isVerifyQueryQuantity) {
                ReportList srcRpt = (ReportList)this.getControl(reportListap);
                srcRpt.initEmptyGrid();
                this.updateReportCache(srcRpt, queryParam);
                continue;
            }
            customParam.put(prefix + "entryid", ids);
            if ("pom".equals(prefix)) {
                customParam.remove("omentryid");
                customParam.put(prefix + "entryid", map);
            } else if ("om".equals(prefix)) {
                customParam.remove("pomentryid");
                customParam.put(prefix + "entryid", map);
            }
            this.queryReportList(reportListap, queryParam);
        }
    }

    private String getstockKey(String billNumber) {
        String enityNumber = "";
        if (BILL_OM_MFTORDER.equals(billNumber)) {
            enityNumber = "om_mftstock";
        } else if (BILL_POM_MFTORDER.equals(billNumber)) {
            enityNumber = "pom_mftstock";
        } else if (BILL_PM_OM_PURORDERBILL.equals(billNumber)) {
            enityNumber = "om_componentlist";
        }
        return enityNumber;
    }

    private void updateReportCache(ReportList srcRpt, ReportQueryParam queryParam) {
        String ctrlId;
        ReportListModel model;
        String pageId;
        IReportCache cache = ReportCacheManager.getInstance().getCache();
        ReportTaskResult reportTaskResult = cache.getReportTaskResult(pageId = (model = (ReportListModel)srcRpt.getReportModel()).getPageId(), ctrlId = srcRpt.getEntryKey());
        if (reportTaskResult != null) {
            List reportColumns = reportTaskResult.getReportColumns();
            try {
                CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)reportTaskResult.getResultId());
                RowMeta rowMeta = cacheDataSet.getRowMeta();
                Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
                DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
                DataSet dataset = builder.build();
                CachedDataSet cacheDataSet2 = dataset.cache(CacheHint.getDefault());
                ReportTaskResult rtr = new ReportTaskResult(cacheDataSet2.getCacheId(), reportColumns);
                cache.setReportTaskResult(pageId, ctrlId, rtr);
            }
            catch (Exception ex) {
                logger.error("\u5237\u65b0\u6570\u636e\u5931\u8d25", (Throwable)ex);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field == null || !field.contains("sm_org") && !field.contains("pom_org") && !field.contains("om_org")) {
            return;
        }
        String entity = "";
        String appId = "";
        Long viewId = 0L;
        MainEntityType dataEntityType = null;
        switch (field) {
            case "sm_org.id": 
            case "sm_org.name": {
                entity = BILL_SM_SALORDER;
                dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                appId = dataEntityType.getAppId();
                viewId = 3L;
                break;
            }
            case "sm_dept.id": 
            case "sm_dept.name": {
                entity = BILL_SM_SALORDER;
                dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                appId = dataEntityType.getAppId();
                viewId = 1L;
                break;
            }
            case "sm_e_stockorg.id": 
            case "sm_e_stockorg.name": {
                entity = BILL_SM_SALORDER;
                dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                appId = dataEntityType.getAppId();
                viewId = 5L;
                break;
            }
            case "pom_org.id": 
            case "pom_org.name": {
                entity = BILL_POM_MFTORDER;
                dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                appId = dataEntityType.getAppId();
                viewId = 4L;
                break;
            }
            case "pom_entrustdept.id": 
            case "pom_entrustdept.name": {
                entity = BILL_POM_MFTORDER;
                dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                appId = dataEntityType.getAppId();
                viewId = 15L;
                break;
            }
            case "pom_producedept.id": 
            case "pom_producedept.name": {
                entity = BILL_POM_MFTORDER;
                dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                appId = dataEntityType.getAppId();
                viewId = 1L;
                break;
            }
            case "om_org.id": 
            case "om_org.name": {
                entity = BILL_OM_MFTORDER;
                dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                appId = dataEntityType.getAppId();
                viewId = 4L;
                break;
            }
            case "om_producedept.id": 
            case "om_producedept.name": {
                entity = BILL_OM_MFTORDER;
                dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                appId = dataEntityType.getAppId();
                viewId = 1L;
                break;
            }
        }
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entity, (String)"47150e89000000ac");
        Set<Long> orgIds = CpsTrackRptPlugin.getOrgIdByViewAndPermOrg(viewId, result);
        QFilter orgFilter = new QFilter(PROP_ID, "in", orgIds);
        args.addCustomParam("orgFuncId", (Object)viewId.toString());
        Map orgViewSchemeNumber = OrgServiceHelper.getViewSchemaInfoByBizId((long)viewId);
        args.addCustomParam("orgViewSchemeNumber", orgViewSchemeNumber.get("number"));
        args.addCustomQFilter(orgFilter);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String curseltabkey = this.getPageCache().get(PGCACHE_CURSELTABKEY);
        if ("smtabpageap".equals(curseltabkey)) {
            this.bizQueryData("reportlistap", true);
        } else if ("pomtabpageap".equals(curseltabkey)) {
            this.bizQueryData("pomreportlistap", true);
        } else if ("omtabpageap".equals(curseltabkey)) {
            this.bizQueryData("omreportlistap", true);
        }
    }

    public void tabSelected(TabSelectEvent args) {
        String tabKey = args.getTabKey();
        List<String> tabKeys = this.getTabKeys();
        Tab tab1 = (Tab)this.getControl("tabap1");
        Container control = (Container)this.getControl("flexpanelap");
        if (tabKeys.contains(tabKey)) {
            if ("pomtabpageap".equals(tabKey)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap", "om_mftordertab", "pm_purorderbilltab"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"pom_mftordertab"});
                tab1.activeTab("pom_mftordertab");
                control.setCollapse(false);
            } else if ("omtabpageap".equals(tabKey)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap", "pom_mftordertab", "pm_purorderbilltab"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"om_mftordertab"});
                tab1.activeTab("om_mftordertab");
                control.setCollapse(false);
            } else {
                control.setCollapse(true);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap", "pom_mftordertab", "om_mftordertab", "pm_purorderbilltab"});
            }
            this.getPageCache().put(PGCACHE_CURSELTABKEY, tabKey);
            FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
            FilterContainerFilterValues cachedFilterValues = new FilterContainerFilterValues();
            filterContainer.setCachedFilterValues(cachedFilterValues);
            BindingContext bctx = new BindingContext((Object)this.getModel().getDataEntityType());
            filterContainer.bindData(bctx);
        }
    }

    private List<String> getTabKeys() {
        ArrayList<String> tabKeys = new ArrayList<String>(3);
        tabKeys.add("smtabpageap");
        tabKeys.add("pomtabpageap");
        tabKeys.add("omtabpageap");
        return tabKeys;
    }

    public void cellClick(CellClickEvent e) {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"CpsTrackRptPlugin_24", (String)"mmc-mrp-report", (Object[])new Object[0])));
        ReportList report = (ReportList)e.getSource();
        String fieldKey = e.getFieldKey();
        String entryKey = report.getEntryKey();
        String curSelRow = this.getPageCache().get(PGCACHE_CURSELROW + entryKey);
        List<String> allowMulSelList = this.getAllowMulSelected();
        String prefix = this.getIdPrefix(entryKey);
        fieldKey = fieldKey.replace(prefix, "");
        fieldKey = fieldKey.replace("_", "");
        boolean isUpdate = false;
        if (!allowMulSelList.contains(fieldKey) && StringUtils.isNotBlank((CharSequence)curSelRow)) {
            int[] selectedRows;
            AbstractGrid.GridState entryState = report.getEntryState();
            for (int selectedRow : selectedRows = entryState.getSelectedRows()) {
                if (Integer.parseInt(curSelRow) != selectedRow) continue;
                isUpdate = true;
                report.selectRows(entryState.getFocusRow());
            }
        }
        if (StringUtils.isBlank((CharSequence)curSelRow) || isUpdate) {
            this.getPageCache().put(PGCACHE_CURSELROW + entryKey, Integer.toString(e.getRow()));
        }
        try {
            this.bizQueryData(entryKey, true);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private List<String> getAllowMulSelected() {
        ArrayList<String> allowMulSelList = new ArrayList<String>();
        allowMulSelList.add("0");
        allowMulSelList.add("fseq");
        allowMulSelList.add("billno");
        allowMulSelList.add("priority");
        allowMulSelList.add("bomid");
        allowMulSelList.add("pmbillno");
        return allowMulSelList;
    }

    private String getIdPrefix(String entryKey) {
        String prefix = "";
        if ("reportlistap".equals(entryKey)) {
            prefix = "sm";
        } else if ("pomreportlistap".equals(entryKey)) {
            prefix = "pom";
        } else if ("omreportlistap".equals(entryKey)) {
            prefix = "om";
        }
        return prefix;
    }

    private String getPrefix(String key) {
        String prefix = "";
        if (key.startsWith("sm")) {
            prefix = BILL_SM_;
        } else if (key.startsWith("pom")) {
            prefix = BILL_POM_;
        } else if (key.startsWith("om")) {
            prefix = BILL_OM_;
        } else if (key.startsWith("pm")) {
            prefix = BILL_PM_;
        }
        return prefix;
    }

    private List<String> getLinkedReport(String entryKey) {
        ArrayList<String> reportListap = new ArrayList<String>(3);
        if ("reportlistap".equals(entryKey)) {
            reportListap.add("pomreportlistap");
            reportListap.add("omreportlistap");
            reportListap.add("pmreportlistap");
        } else if ("pomreportlistap".equals(entryKey) || "omreportlistap".equals(entryKey)) {
            reportListap.add("mftstockreportlistap");
        }
        return reportListap;
    }

    private void queryReportList(String reportListap, ReportQueryParam queryParam) {
        IReportCache cache = ReportCacheManager.getInstance().getCache();
        ReportList srcRpt = (ReportList)this.getControl(reportListap);
        ReportListModel model = (ReportListModel)srcRpt.getReportModel();
        String pageId = model.getPageId();
        String ctrlId = reportListap;
        ReportTaskParam tp = new ReportTaskParam();
        tp.setPluginClassName(srcRpt.getReportPluginClassName());
        tp.setDataSource(srcRpt.getDataSource());
        tp.setQueryDataSource(srcRpt.getDataSourceId());
        tp.setOtherParam((Object)queryParam);
        cache.setReportTaskParam(pageId, ctrlId, tp);
        srcRpt.submitTask(queryParam, null);
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

