/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cpstrack;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.mmc.mrp.common.util.DateUtils;

public class CpsTrackRptUtil {
    private static final Log logger = LogFactory.getLog(CpsTrackRptUtil.class);
    private static final String BILL_POM_MFTORDER = "pom_mftorder";
    private static final String BILL_SM_SALORDER = "sm_salorder";
    private static final String BILL_OM_MFTORDER = "om_mftorder";
    private static final String BILL_PM_PURAPPLYBILL = "pm_purapplybill";
    private static final String BILL_POM_MFTSTOCK = "pom_mftstock";
    private static final String BILL_OM_MFTSTOCK = "om_mftstock";

    public static String getAbsolutePropertyName(IDataEntityProperty property) {
        StringBuilder fieldName = new StringBuilder();
        Stack<String> stack = new Stack<String>();
        if (property != null) {
            stack.push(property.getName());
            if (property.getParent() != null && property.getParent() instanceof EntryType) {
                EntryType parent = (EntryType)property.getParent();
                stack.push(parent.getName());
                while (parent.getParent() != null && parent.getParent() instanceof EntryType) {
                    parent = (EntryType)parent.getParent();
                    stack.push(parent.getName());
                }
            }
        }
        while (!stack.isEmpty()) {
            fieldName.append((String)stack.pop()).append('.');
        }
        if (fieldName.length() > 0) {
            return fieldName.substring(0, fieldName.length() - 1);
        }
        return fieldName.toString();
    }

    public static void setProperty(QFilter qFilter, MainEntityType dataEntityType, String split) {
        String property = qFilter.getProperty();
        if (property.startsWith(split)) {
            property = property.replace(split, "");
            qFilter.__setProperty(property);
        }
        IDataEntityProperty findProperty = dataEntityType.findProperty(property);
        String[] propertys = property.split("\\.");
        if (findProperty == null && propertys.length != 2) {
            return;
        }
        findProperty = dataEntityType.findProperty(propertys[0]);
        if (findProperty == null) {
            return;
        }
        String absolutePropertyName = CpsTrackRptUtil.getAbsolutePropertyName(findProperty);
        if (propertys.length == 2) {
            if ("material".equals(findProperty.getName())) {
                absolutePropertyName = absolutePropertyName + ".masterid";
            }
            absolutePropertyName = absolutePropertyName + '.' + propertys[1];
        }
        qFilter.__setProperty(absolutePropertyName);
    }

    public static void setWhereFilter(QFilter qFilter, String split, List<String> whereFilters, MainEntityType dataEntityType) {
        String property;
        String propertyStr = property = qFilter.getProperty();
        Object value = qFilter.getValue();
        String cp = qFilter.getCP();
        if (property.startsWith(split)) {
            property = property.replace(split, "");
        }
        IDataEntityProperty findProperty = dataEntityType.findProperty(property);
        String[] propertys = property.split("\\.");
        if (findProperty != null) {
            return;
        }
        findProperty = dataEntityType.findProperty(propertys[0]);
        if (findProperty != null) {
            return;
        }
        if (value instanceof QEmptyValue) {
            value = "";
        }
        if (value instanceof String) {
            value = "'" + value + "'";
        } else if (value instanceof ArrayList) {
            ArrayList values = (ArrayList)value;
            StringBuilder valStr = new StringBuilder();
            valStr.append("(");
            for (int i = 0; i < values.size(); ++i) {
                Object val;
                if (i != 0) {
                    valStr.append(",");
                }
                if ((val = values.get(i)) instanceof String) {
                    valStr.append("'").append(val).append("'");
                    continue;
                }
                if (!(val instanceof Long)) continue;
                valStr.append(val);
            }
            valStr.append(")");
            value = valStr.toString();
        } else if (value instanceof Date) {
            StringBuilder str = new StringBuilder();
            CpsTrackRptUtil.getStringDate(qFilter, null, str);
            value = str.toString();
        }
        if ("ftlike".equals(cp)) {
            cp = "like";
        }
        qFilter.__setProperty("1");
        qFilter.__setCP("=");
        qFilter.__setValue((Object)1);
        StringBuilder filterStr = new StringBuilder();
        filterStr.append(propertyStr).append(' ').append(cp).append(' ').append(value);
        if (!whereFilters.contains(filterStr.toString())) {
            whereFilters.add(filterStr.toString());
        }
    }

    private static void getStringDate(QFilter qf, String op, StringBuilder str) {
        Object value = qf.getValue();
        String date = "";
        if (value instanceof Date) {
            date = DateUtils.formatDateTime((Date)((Date)value));
        } else if (value instanceof String) {
            Date da = CpsTrackRptUtil.getDate((String)value);
            date = DateUtils.formatDateTime((Date)da);
        }
        if (StringUtils.isNotBlank((CharSequence)op)) {
            str.append(" ").append(op).append(" ");
        }
        str.append("to_date('").append(date).append("','yyyy/MM/dd HH:mm:ss')");
    }

    public static Date getCompDate(Date date) {
        if (date == null) {
            return date;
        }
        Calendar fromDate = Calendar.getInstance();
        fromDate.setTime(date);
        fromDate.clear(12);
        fromDate.clear(13);
        fromDate.clear(14);
        fromDate.set(11, 0);
        return fromDate.getTime();
    }

    public static DataSet sortAndFilter(ReportQueryParam queryParam, DataSet dataSet, String entityNumber, String billEntity) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String prefix = CpsTrackRptUtil.getPrefix(billEntity);
        if (queryParam.getFilter().getHeadFilters() != null && !queryParam.getFilter().getHeadFilters().isEmpty()) {
            QFilter qfilter = new QFilter("1", "=", (Object)1);
            for (QFilter qf : queryParam.getFilter().getHeadFilters()) {
                String val;
                QFilter qFilter;
                List list;
                String property = qf.getProperty();
                if (!property.startsWith(prefix)) continue;
                DataType dataType = dataSet.getRowMeta().getField(property).getDataType();
                IDataEntityProperty findProperty = dataEntityType.findProperty(qf.getProperty());
                if (dataType.getName().equals("Timestamp") || dataType.getName().equals("Date")) {
                    CpsTrackRptUtil.dealDate(qf, null, qfilter);
                    list = qf.getNests(true);
                    for (QFilter.QFilterNest qFilterNest : list) {
                        qFilter = qFilterNest.getFilter();
                        CpsTrackRptUtil.dealDate(qFilter, qFilterNest.getOp(), qfilter);
                    }
                    continue;
                }
                if (dataType.getName().equals("BigDecimal")) {
                    val = qf.getValue().toString();
                    try {
                        BigDecimal bigDecimal = new BigDecimal(val);
                        qf.__setValue((Object)bigDecimal);
                        qfilter.and(qf);
                    }
                    catch (Exception e) {
                        logger.error("\u9f50\u5957\u8ddf\u8e2a\u8f6c\u6362\u6570\u503c\u67e5\u8be2\u5f02\u5e38\uff1a\u8f6c\u6362\u503c\u4e3a" + val, (Throwable)e);
                    }
                    continue;
                }
                if (dataType.getName().equals("Integer")) {
                    val = qf.getValue().toString();
                    try {
                        Integer integer = Integer.valueOf(val);
                        qf.__setValue((Object)integer);
                        qfilter.and(qf);
                    }
                    catch (Exception e) {
                        logger.error("\u9f50\u5957\u8ddf\u8e2a\u8f6c\u6362\u6570\u5b57\u67e5\u8be2\u5f02\u5e38\uff1a\u8f6c\u6362\u503c\u4e3a" + val, (Throwable)e);
                    }
                    continue;
                }
                CpsTrackRptUtil.dealHeadFilter(qf, findProperty);
                list = qf.getNests(true);
                for (QFilter.QFilterNest qFilterNest : list) {
                    qFilter = qFilterNest.getFilter();
                    CpsTrackRptUtil.dealHeadFilter(qFilter, findProperty);
                }
                qfilter.and(qf);
            }
            String ft = qfilter.toString();
            if (ft.indexOf("null ''") != -1) {
                ft = ft.replace("null ''", "null");
            }
            if (ft.indexOf("'to_date(''") != -1) {
                ft = ft.replace("'to_date(''", "to_date('");
            }
            if (ft.indexOf("'')'") != -1) {
                ft = ft.replace("'')'", "')");
            }
            if (ft.indexOf("'',''") != -1) {
                ft = ft.replace("'',''", "','");
            }
            dataSet = dataSet.filter(ft);
        }
        if (queryParam.getSortInfo() != null) {
            if (!queryParam.getSortInfo().startsWith(prefix)) {
                return dataSet;
            }
            dataSet = dataSet.orderBy(new String[]{queryParam.getSortInfo()});
        }
        return dataSet;
    }

    private static void dealDate(QFilter qf, String op, QFilter qfilter) {
        Object value = qf.getValue();
        String date = "";
        if (value instanceof Date) {
            date = DateUtils.formatDateTime((Date)((Date)value));
        } else if (value instanceof String) {
            Date da = CpsTrackRptUtil.getDate((String)value);
            date = DateUtils.formatDateTime((Date)da);
        }
        StringBuilder str = new StringBuilder();
        str.append("to_date('").append(date).append("','yyyy/MM/dd HH:mm:ss')");
        if (StringUtils.isNotBlank((CharSequence)op)) {
            qfilter.addFirstNest(new QFilter(qf.getProperty(), qf.getCP(), (Object)str.toString()), op);
        } else {
            qfilter.and(qf.getProperty(), qf.getCP(), (Object)str.toString());
        }
    }

    public static Date getDate(String date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (date.contains("'")) {
                date = date.replaceAll("'", "").trim();
            }
            return simpleDateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u5f02\u5e38\u3002", (String)"CpsTrackRptUtil_0", (String)"mmc-mrp-report", (Object[])new Object[0])), new Object[0]);
        }
    }

    private static void dealHeadFilter(QFilter qf, IDataEntityProperty findProperty) {
        if (findProperty instanceof BasedataProp) {
            String displayProp = ((BasedataProp)findProperty).getDisplayProp();
            qf.__setProperty(findProperty.getName() + '.' + displayProp);
        }
    }

    public static String getReportListAp(String curSelTabKey) {
        String reportListAp = "";
        if ("smtabpageap".equals(curSelTabKey)) {
            reportListAp = "reportlistap";
        } else if ("pomtabpageap".equals(curSelTabKey)) {
            reportListAp = "pomreportlistap";
        } else if ("omtabpageap".equals(curSelTabKey)) {
            reportListAp = "omreportlistap";
        }
        return reportListAp;
    }

    private static String getPrefix(String billEntity) {
        String prefix = "";
        if (BILL_SM_SALORDER.equals(billEntity)) {
            prefix = "sm";
        } else if (BILL_POM_MFTORDER.equals(billEntity)) {
            prefix = "pom";
        } else if (BILL_OM_MFTORDER.equals(billEntity)) {
            prefix = "om";
        } else if (BILL_PM_PURAPPLYBILL.equals(billEntity)) {
            prefix = "pm";
        } else if (BILL_POM_MFTSTOCK.equals(billEntity) || BILL_OM_MFTSTOCK.equals(billEntity)) {
            prefix = "stock";
        }
        return prefix;
    }
}

