/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cpstrack;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.report.cpstrack.CpsTrackRptUtil;

public class CpsTrackStockRptQuery
extends AbstractReportListDataPlugin {
    private static final String BILL_OM_MFTSTOCK = "om_mftstock";
    private static final String POMENTRYID = "pomentryid";
    private static final String OMENTRYID = "omentryid";
    private static final String BILL_STOCK_ = "stock_";

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        Map customParam = param.getCustomParam();
        ArrayList<QFilter> qfFilters = new ArrayList<QFilter>(customParam.size());
        QFilter salorderFilter = null;
        Map map = new HashMap(2);
        if (customParam.get(POMENTRYID) != null) {
            map = (Map)customParam.get(POMENTRYID);
        } else if (customParam.get(OMENTRYID) != null) {
            map = (Map)customParam.get(OMENTRYID);
        }
        FilterInfo filter = param.getFilter();
        List qFilters = filter.getQFilters();
        ArrayList<String> exprs = new ArrayList<String>(qFilters.size());
        ArrayList<String> wheres = new ArrayList<String>(qFilters.size());
        DataSet allData = null;
        for (Map.Entry entry : map.entrySet()) {
            String entityNumber = (String)entry.getKey();
            List ids = (List)entry.getValue();
            salorderFilter = new QFilter("orderentryid", "in", (Object)ids);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Iterator iterator = qFilters.iterator();
            while (iterator.hasNext()) {
                QFilter qFilter = (QFilter)iterator.next();
                String property = qFilter.getProperty();
                if (!property.startsWith(BILL_STOCK_)) {
                    iterator.remove();
                    continue;
                }
                this.analysisDealQFilter(qFilter, dataEntityType, wheres);
                CpsTrackRptUtil.setProperty(qFilter, dataEntityType, BILL_STOCK_);
                List list = qFilter.getNests(true);
                for (QFilter.QFilterNest qFilterNest : list) {
                    QFilter qf = qFilterNest.getFilter();
                    this.analysisDealQFilter(qf, dataEntityType, wheres);
                    CpsTrackRptUtil.setProperty(qf, dataEntityType, BILL_STOCK_);
                }
            }
            qfFilters.addAll(qFilters);
            if (allData == null) {
                allData = this.getAllData(qfFilters, exprs, salorderFilter, entityNumber);
                continue;
            }
            allData = allData.union(this.getAllData(qfFilters, exprs, salorderFilter, entityNumber));
        }
        DataSet dealData = this.dealData(allData);
        for (String expr : wheres) {
            dealData = dealData.where(expr);
        }
        return CpsTrackRptUtil.sortAndFilter(param, dealData, "mrp_cps_tracks", BILL_OM_MFTSTOCK);
    }

    private void analysisDealQFilter(QFilter qFilter, MainEntityType dataEntityType, List<String> whereFilters) {
        String property;
        switch (property = qFilter.getProperty()) {
            case "stock_cpstatus": {
                qFilter.__setProperty("1");
                qFilter.__setCP("=");
                qFilter.__setValue((Object)1);
                break;
            }
            default: {
                CpsTrackRptUtil.setWhereFilter(qFilter, BILL_STOCK_, whereFilters, dataEntityType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet dealData(DataSet dataSet) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map = new HashMap<String, Object>(28);
                BigDecimal demandqty = row.getBigDecimal("stock_demandqty") != null ? row.getBigDecimal("stock_demandqty") : BigDecimal.ZERO;
                BigDecimal actissueqty = row.getBigDecimal("stock_actissueqty") != null ? row.getBigDecimal("stock_actissueqty") : BigDecimal.ZERO;
                BigDecimal unactissueqty = demandqty.subtract(actissueqty);
                BigDecimal useqty = row.getBigDecimal("stock_useqty") != null ? row.getBigDecimal("stock_useqty") : BigDecimal.ZERO;
                BigDecimal wipqty = row.getBigDecimal("stock_wipqty") != null ? row.getBigDecimal("stock_wipqty") : BigDecimal.ZERO;
                map.put("stockid", row.getLong("stockid"));
                map.put("stockentryid", row.getLong("stockentryid"));
                map.put("stock_billname", row.getString("stock_billname"));
                map.put("stock_billno", row.getString("stock_billno"));
                map.put("stock_orderno", row.getString("stock_orderno"));
                map.put("stock_materialid", row.get("stock_materialid"));
                map.put("stock_materialnumber", row.get("stock_materialnumber"));
                map.put("stock_materialnumber.number", row.get("stock_materialnumber.number"));
                map.put("stock_childauxpropertyid", row.getLong("stock_childauxpropertyid"));
                map.put("stock_materialunitid", row.getLong("stock_materialunitid"));
                map.put("stock_materialunitid.name", row.get("stock_materialunitid.name"));
                map.put("stock_demandqty", demandqty);
                map.put("stock_demanddate", row.getDate("stock_demanddate"));
                map.put("stock_actissueqty", actissueqty);
                map.put("stock_unactissueqty", unactissueqty);
                map.put("stock_useqty", useqty);
                map.put("stock_wipqty", wipqty);
                map.put("stock_batchno", row.getString("stock_batchno"));
                map.put("stock_entryconfiguredcode", row.getLong("stock_entryconfiguredcode"));
                map.put("stock_entryconfiguredcode.number", row.get("stock_entryconfiguredcode.number"));
                map.put("stock_bomreversion", row.getLong("stock_bomreversion"));
                map.put("stock_bomreversion.name", row.get("stock_bomreversion.name"));
                map.put("stock_supplymode", row.getString("stock_supplymode"));
                map.put("stock_supplierid", row.getLong("stock_supplierid"));
                map.put("stock_supplierid.name", row.get("stock_supplierid.name"));
                map.put("stock_supplyorgid", row.getLong("stock_supplyorgid"));
                map.put("stock_supplyorgid.name", row.get("stock_supplyorgid.name"));
                map.put("stock_warehouseid", row.getLong("stock_warehouseid"));
                map.put("stock_warehouseid.name", row.get("stock_warehouseid.name"));
                map.put("stock_location", row.getLong("stock_location"));
                map.put("stock_location.name", row.get("stock_location.name"));
                map.put("stock_isbackflush", row.get("stock_isbackflush"));
                map.put("stock_iskeypart", row.get("stock_iskeypart"));
                map.put("stock_cpqty", BigDecimal.ZERO);
                map.put("stock_reserveqty", BigDecimal.ZERO);
                map.put("stock_invavaqty", BigDecimal.ZERO);
                map.put("stock_intranavaqty", BigDecimal.ZERO);
                map.put("stock_othdemqty", BigDecimal.ZERO);
                map.put("stock_expdemqty", BigDecimal.ZERO);
                map.put("stock_expreminvqty", BigDecimal.ZERO);
                map.put("stock_shortagemark", "");
                map.put("stock_csrep", "");
                map.put("stock_cpstatus", "");
                list.add(map);
            }
        }
        finally {
            dataSet.close();
        }
        return this.getReturnData(list);
    }

    private DataSet getReturnData(List<Map<String, Object>> list) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("stockid", (DataType)DateType.LongType, true));
        fields.add(new Field("stockentryid", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_billname", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_billno", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_orderno", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_materialid", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_materialnumber", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_materialnumber.number", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_childauxpropertyid", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_materialunitid", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_materialunitid.name", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_demandqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_demanddate", (DataType)DateType.DateType, true));
        fields.add(new Field("stock_actissueqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_unactissueqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_useqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_wipqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_batchno", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_entryconfiguredcode", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_entryconfiguredcode.number", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_bomreversion", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_bomreversion.name", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_supplymode", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_supplierid", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_supplierid.name", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_supplyorgid", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_supplyorgid.name", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_warehouseid", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_warehouseid.name", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_location", (DataType)DateType.LongType, true));
        fields.add(new Field("stock_location.name", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_isbackflush", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_iskeypart", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_cpqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_reserveqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_invavaqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_intranavaqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_othdemqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_expdemqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_expreminvqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("stock_shortagemark", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_csrep", (DataType)DateType.StringType, true));
        fields.add(new Field("stock_cpstatus", (DataType)DateType.StringType, true));
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        for (Map<String, Object> entry : list) {
            Object[] values = new Object[fields.size()];
            Field[] field = metas.getFields();
            for (int i = 0; i < field.length; ++i) {
                values[i] = entry.get(field[i].getName());
            }
            builder.append(values);
        }
        return builder.build();
    }

    private DataSet getAllData(List<QFilter> qfFilters, List<String> exprs, QFilter qFilter, String entityNumber) {
        StringBuilder sql = new StringBuilder();
        sql.append("id stockid,");
        sql.append("stockentry.id stockentryid,");
        sql.append("billno stock_billno,");
        sql.append("orderno stock_orderno,");
        sql.append("'").append(entityNumber).append("' stock_billname,");
        sql.append("orderentryid stock_orderentryid,");
        sql.append("stockentry.materialid stock_materialid,");
        sql.append("stockentry.materialid.masterid stock_materialnumber,");
        sql.append("stockentry.materialid.masterid.number stock_materialnumber.number,");
        sql.append("stockentry.childauxpropertyid stock_childauxpropertyid,");
        sql.append("stockentry.materialunitid stock_materialunitid,");
        sql.append("stockentry.materialunitid.name stock_materialunitid.name,");
        sql.append("stockentry.demandqty stock_demandqty,");
        sql.append("stockentry.demanddate stock_demanddate,");
        sql.append("stockentry.actissueqty stock_actissueqty,");
        sql.append("stockentry.useqty stock_useqty,");
        sql.append("stockentry.wipqty stock_wipqty,");
        sql.append("stockentry.batchno stock_batchno,");
        sql.append("stockentry.entryconfiguredcode stock_entryconfiguredcode,");
        sql.append("stockentry.entryconfiguredcode.number stock_entryconfiguredcode.number,");
        sql.append("stockentry.bomreversion stock_bomreversion,");
        sql.append("stockentry.bomreversion.name stock_bomreversion.name,");
        sql.append("stockentry.supplymode stock_supplymode,");
        sql.append("stockentry.supplierid stock_supplierid,");
        sql.append("stockentry.supplierid.name stock_supplierid.name,");
        sql.append("stockentry.supplyorgid stock_supplyorgid,");
        sql.append("stockentry.supplyorgid.name stock_supplyorgid.name,");
        sql.append("stockentry.warehouseid stock_warehouseid,");
        sql.append("stockentry.warehouseid.name stock_warehouseid.name,");
        sql.append("stockentry.location stock_location,");
        sql.append("stockentry.location.name stock_location.name,");
        sql.append("stockentry.isbackflush stock_isbackflush,");
        sql.append("stockentry.iskeypart stock_iskeypart");
        qfFilters.add(qFilter);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityNumber, (String)sql.toString(), (QFilter[])qfFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"stock_materialnumber.number"});
        for (String expr : exprs) {
            dataSet = dataSet.where(expr);
        }
        return dataSet;
    }
}

