/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.gross;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.format.FlexValueFormatter;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.entity.gross.MaterialGroupEntity;
import kd.mmc.mrp.common.entity.gross.MaterialInfo;
import kd.mmc.mrp.common.entity.gross.RequireTypeSummaryEntity;
import kd.mmc.mrp.common.util.FilePermissionUtil;
import kd.mmc.mrp.common.util.ShowTipsUtil;
import kd.mmc.mrp.report.util.ReportUtil;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class GrossDemandRptPlugin
extends AbstractReportFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static final int DEFAULT_TIME_COUNT = 300;
    private static final Log logger = LogFactory.getLog(GrossDemandRptPlugin.class);
    private static final String FILTER_OPERATION = "caculatelogs";

    public void afterCreateNewData(EventObject e) {
        QFilter[] filters = new QFilter[]{new QFilter("runtype", "=", (Object)"A"), new QFilter("calculatestatus", "=", (Object)"A"), new QFilter("clearstatus", "!=", (Object)Character.valueOf('B')), new QFilter("operatmodekey", "!=", (Object)"mrp_simulation")};
        String number = null;
        try (DataSet rows = ORM.create().queryDataSet(this.getPluginName(), "mrp_caculate_log", "id,number", filters, "startdate desc", 1);){
            if (rows.hasNext()) {
                Row row = rows.next();
                this.getModel().setValue(FILTER_OPERATION, (Object)row.getLong(0));
                number = row.getString(1);
            }
        }
        DynamicObject[] arr = BusinessDataServiceHelper.load((String)"mrp_peginfodata", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (arr.length != 0) {
            this.getModel().setValue("id", (Object)arr[0].getLong("id"));
        }
        ComboEdit starttime = (ComboEdit)this.getView().getControl("starttime");
        ComboEdit endtime = (ComboEdit)this.getView().getControl("endtime");
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(300);
        ComboItem comboItem = null;
        for (int i = 0; i < 300; ++i) {
            String week = "W" + (i + 1);
            comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(week));
            comboItem.setValue(i + 1 + "");
            propertyItems.add(comboItem);
        }
        starttime.setComboItems(propertyItems);
        endtime.setComboItems(propertyItems);
        this.getModel().setValue("starttime", (Object)"1");
        this.getModel().setValue("endtime", (Object)"90");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit operationEdit = (BasedataEdit)this.getControl(FILTER_OPERATION);
        if (operationEdit != null) {
            operationEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        if ("export1".equals(operate.getOperateKey())) {
            if (this.getModel().getValue("id") == null || this.getModel().getValue("id").equals(0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GrossDemandRptPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("export2".equals(operate.getOperateKey())) {
            ReportList list = (ReportList)this.getControl("reportparentlistap");
            int rowCount = list.getReportModel().getRowCount();
            if (rowCount == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"GrossDemandRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("export3".equals(operate.getOperateKey())) {
            ReportList list = (ReportList)this.getControl("reportparentlistap");
            int rowCount = list.getReportModel().getRowCount();
            if (rowCount == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"GrossDemandRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("export4".equals(operate.getOperateKey())) {
            if (this.getModel().getEntryRowCount("entryentity_1") == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"GrossDemandRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("export5".equals(operate.getOperateKey())) {
            if (this.getModel().getEntryRowCount("entryentity_2") == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"GrossDemandRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("export6".equals(operate.getOperateKey()) && (this.getModel().getValue("id") == null || this.getModel().getValue("id").equals(0L))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GrossDemandRptPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        try {
            if ("export1".equals(args.getOperateKey())) {
                ReportList list = (ReportList)this.getControl("reportllistap");
                this.exportExcel1(list);
            } else if ("export2".equals(args.getOperateKey())) {
                ReportList list = (ReportList)this.getControl("reportllistap");
                this.exportExcel2(list);
            } else if ("export3".equals(args.getOperateKey())) {
                ReportList list = (ReportList)this.getControl("reportparentlistap");
                this.exportExcel3(list);
            } else if ("export5".equals(args.getOperateKey())) {
                this.exportExcel5();
            } else if ("export6".equals(args.getOperateKey())) {
                ReportList list = (ReportList)this.getControl("reportllistap");
                this.exportExcel6(list);
            }
        }
        catch (IOException e1) {
            logger.error("\u5bfc\u51fa\u6bdb\u9700\u6c42\u6570\u636e\u62a5\u9519\uff1a", (Throwable)e1);
        }
    }

    private void exportExcel6(ReportList list) {
        Long id = (Long)this.getModel().getValue("id");
        String type = (String)this.getModel().getValue("radiogroupfield");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mrp_showprogress");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "export"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("id", (Object)id);
        showParameter.setCustomParam("radiogroupfield", (Object)type);
        showParameter.addCustPlugin("kd.mmc.mrp.report.gross.GrossDemandAllExport");
        this.getView().showForm(showParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcel5() throws IOException {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"GrossDemandRptPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0])));
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook();
            SXSSFSheet sheet = workbook.createSheet();
            SXSSFRow firstrow = sheet.createRow(0);
            firstrow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u7269\u6599", (String)"GrossDemandRptPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]));
            firstrow.createCell(1).setCellValue(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"GrossDemandRptPlugin_19", (String)"mmc-mrp-report", (Object[])new Object[0]));
            firstrow.createCell(2).setCellValue(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"GrossDemandRptPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]));
            firstrow.createCell(3).setCellValue(ResManager.loadKDString((String)"\u6c47\u603b\u9879", (String)"GrossDemandRptPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0]));
            firstrow.createCell(4).setCellValue(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"GrossDemandRptPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0]));
            firstrow.createCell(5).setCellValue(ResManager.loadKDString((String)"\u5360\u6bd4", (String)"GrossDemandRptPlugin_7", (String)"mmc-mrp-report", (Object[])new Object[0]));
            int n = this.getModel().getEntryRowCount("entryentity_2");
            for (int i = 0; i < n; ++i) {
                String totalStr = " ";
                SXSSFRow row = sheet.createRow(i + 1);
                row.createCell(0).setCellValue(((DynamicObject)this.getModel().getValue("pmaterial_4", i)).getString("number"));
                String value = "";
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity_2", i);
                IDataEntityProperty dataEntityProperty = (IDataEntityProperty)entryRowEntity.getDataEntityType().getProperties().get((Object)"auxproperty_4");
                FlexValueFormatter flexValueFormat = new FlexValueFormatter();
                FlexProp fieldProperty = (FlexProp)dataEntityProperty;
                Object srcValue = flexValueFormat.getDisplayValueForReport(entryRowEntity, fieldProperty, fieldProperty.getBasePropertyKey());
                value = srcValue instanceof ArrayList ? String.join((CharSequence)";", (ArrayList)srcValue) : srcValue.toString();
                row.createCell(1).setCellValue(value);
                DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode_4", i);
                String configuredcodeNumber = configuredcode == null ? "" : configuredcode.getString("number");
                row.createCell(2).setCellValue(configuredcodeNumber);
                DynamicObject user = (DynamicObject)this.getModel().getValue("summary_4", i);
                if (user != null) {
                    totalStr = user.getLocaleString("name").getLocaleValue();
                }
                row.createCell(3).setCellValue(totalStr);
                row.createCell(4).setCellValue(new Double(this.getModel().getValue("qty_4", i).toString()).doubleValue());
                row.createCell(5).setCellValue(this.getModel().getValue("pct_4", i).toString());
            }
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u6bdb\u9700\u6c42\u67e5\u8be2-\u6c47\u603b.xlsx", (String)"GrossDemandRptPlugin_8", (String)"mmc-mrp-report", (Object[])new Object[0]), (InputStream)inStream, timeout);
            FilePermissionUtil.addFilePermission((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"4730fc9f000004ae");
            this.getView().download(tempUrl);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (workbook != null) {
                workbook.close();
            }
        }
        this.getView().hideLoading();
    }

    private void exportExcel1(ReportList list) {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"GrossDemandRptPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0])));
        this.getAllDatas();
        this.getView().hideLoading();
    }

    private void getAllDatas() {
        Long id = (Long)this.getModel().getValue("id");
        String type = (String)this.getModel().getValue("radiogroupfield");
        HashSet<Long> materialSet = new HashSet<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"scm"), (String)"select distinct fsupplymaterialid from t_mrp_peginfodataentry where fid = ?", (Object[])new Object[]{id});){
            for (Row row : dataSet) {
                materialSet.add(row.getLong("fsupplymaterialid"));
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("entryentity.supplymaterial cmaterial_1,");
        sql.append("entryentity.supplyauxpty auxproperty_1,");
        sql.append("entryentity.configuredcodesup configuredcode_1,");
        sql.append("entryentity.requirebilltpye requiresource_1,");
        sql.append("entryentity.supplyqty supplyqty,");
        sql.append("entryentity.supplydate supplydate");
        QFilter qf1 = new QFilter("id", "=", (Object)id);
        QFilter qf2 = new QFilter("entryentity.supplydate", "is not null", (Object)"");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_peginfodata", (String)sql.toString(), (QFilter[])new QFilter[]{qf1, qf2}, null).groupBy(new String[]{"cmaterial_1", "configuredcode_1", "auxproperty_1", "requiresource_1", "supplydate"}).sum("supplyqty").finish();){
            if (dataSet.hasNext()) {
                try {
                    this.dealData(materialSet, dataSet, id, type);
                }
                catch (IOException e) {
                    logger.error("\u5bfc\u51fa\u6bdb\u9700\u6c42\u6570\u636e\u62a5\u9519\uff1a", (Throwable)e);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"GrossDemandRptPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealData(Set<Long> materialIdSet, DataSet dataSet, Long id, String type) throws IOException {
        boolean isWeek = "1".equals(type);
        Calendar calcreatime = Calendar.getInstance();
        HashMap<Long, String> numberMap = new HashMap<Long, String>(materialIdSet.size());
        try (DataSet datas = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIdSet)}, null);){
            for (Row row : datas) {
                numberMap.put(row.getLong("id"), row.getString("number"));
            }
        }
        ReportList list = (ReportList)this.getControl("reportllistap");
        List columns = list.getReportModel().getColumns();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"mrp_peginfodata", (String)"id,createtime,entryentity.supplydate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}, (String)"entryentity.supplydate asc", (int)1);
        Date createTime = ((DynamicObject)datas.get(0)).getDate("createtime");
        Date supplydate = ((DynamicObject)datas.get(0)).getDate("entryentity.supplydate");
        if (supplydate == null) {
            return;
        }
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook();
            SXSSFSheet sheet = workbook.createSheet();
            SXSSFRow firstrow = sheet.createRow(0);
            ArrayList<String> times = new ArrayList<String>(columns.size());
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                ReportColumn column = (ReportColumn)columns.get(i);
                SXSSFCell cell = firstrow.createCell(i, CellType.STRING);
                cell.setCellValue(column.getCaption().toString());
                times.add(column.getFieldKey());
            }
            int rowNum = 1;
            Integer starttime = Integer.valueOf((String)this.getModel().getValue("starttime"));
            Integer endtime = Integer.valueOf((String)this.getModel().getValue("endtime"));
            if (createTime != null && supplydate != null && createTime.compareTo(supplydate) < 0) {
                calcreatime.setTime(createTime);
            } else {
                calcreatime.setTime(supplydate);
            }
            HashMap<Long, String> configuredcodeMaps = new HashMap<Long, String>(materialIdSet.size());
            try (DataSet configuredcodedatas = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_configuredcode", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("material", "in", materialIdSet)}, null);){
                Iterator iterator = configuredcodedatas.iterator();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    configuredcodeMaps.put(row.getLong("id"), row.getString("number"));
                }
            }
            calcreatime.add(3, starttime - 1);
            for (Long materialId : materialIdSet) {
                DataSet da = dataSet.copy().filter("cmaterial_1 = " + materialId);
                HashMap sumEntityMap = Maps.newHashMapWithExpectedSize((int)materialIdSet.size());
                for (Row row : da) {
                    Long auxproperty;
                    Date date = row.getDate("supplydate");
                    Long configuredcode = row.getLong("configuredcode_1");
                    MaterialInfo materialInfo = new MaterialInfo(materialId, configuredcode, auxproperty = row.getLong("auxproperty_1"));
                    RequireTypeSummaryEntity sumEntity = (RequireTypeSummaryEntity)sumEntityMap.get(materialInfo);
                    if (sumEntity == null) {
                        sumEntity = new RequireTypeSummaryEntity(isWeek, endtime - starttime, calcreatime.getTime(), materialId, configuredcode, ResManager.loadKDString((String)"\u5408\u8ba1", (String)"GrossDemandRptPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    }
                    BigDecimal qty = row.getBigDecimal("supplyqty");
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    if (isWeek) {
                        cal.setFirstDayOfWeek(2);
                        int day = cal.get(7);
                        if (day == 1) {
                            day = 8;
                        }
                        cal.add(5, cal.getFirstDayOfWeek() - day);
                        String dateString = cal.get(1) + "/" + (cal.get(2) + 1) + "/" + cal.get(5);
                        if (sumEntity.getQtyMap().containsKey(dateString)) {
                            sumEntity.getQtyMap().put(dateString, qty.add((BigDecimal)sumEntity.getQtyMap().get(dateString)));
                            sumEntity.getQtyMap().put("total", qty.add((BigDecimal)sumEntity.getQtyMap().get("total")));
                        }
                    } else {
                        String monthOfYear = cal.get(1) + "/" + (cal.get(2) + 1);
                        if (sumEntity.getQtyMap().containsKey(monthOfYear) && times.contains(monthOfYear)) {
                            sumEntity.getQtyMap().put(monthOfYear, qty.add((BigDecimal)sumEntity.getQtyMap().get(monthOfYear)));
                            sumEntity.getQtyMap().put("total", qty.add((BigDecimal)sumEntity.getQtyMap().get("total")));
                        }
                    }
                    sumEntityMap.put(materialInfo, sumEntity);
                }
                da.close();
                DynamicObject peginfodata = BusinessDataServiceHelper.newDynamicObject((String)"mrp_peginfodata");
                DynamicObjectCollection entryentitys = peginfodata.getDynamicObjectCollection("entryentity");
                for (Map.Entry entry : sumEntityMap.entrySet()) {
                    DynamicObject entryentity = new DynamicObject(entryentitys.getDynamicObjectType());
                    RequireTypeSummaryEntity sumEntity = (RequireTypeSummaryEntity)entry.getValue();
                    MaterialInfo materialInfo = (MaterialInfo)entry.getKey();
                    Long configuredcode = materialInfo.getConfiguredcode();
                    Long auxproperty = materialInfo.getAuxproperty();
                    String auxpropertyStr = ReportUtil.getDisplayValueForReport(entryentity, "supplymaterial", "supplyauxpty", materialId, auxproperty);
                    SXSSFRow row = sheet.createRow(rowNum);
                    int m = columns.size();
                    for (int k = 0; k < m; ++k) {
                        ReportColumn column = (ReportColumn)columns.get(k);
                        if ("cmaterial_1".equals(column.getFieldKey())) {
                            row.createCell(k).setCellValue((String)numberMap.get(materialId));
                            continue;
                        }
                        if ("auxproperty_1".equals(column.getFieldKey())) {
                            row.createCell(k).setCellValue(auxpropertyStr);
                            continue;
                        }
                        if ("configuredcode_1".equals(column.getFieldKey())) {
                            row.createCell(k).setCellValue((String)configuredcodeMaps.get(configuredcode));
                            continue;
                        }
                        if ("requiresource_1".equals(column.getFieldKey())) {
                            row.createCell(k).setCellValue(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"GrossDemandRptPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0]));
                            continue;
                        }
                        if ("fseq".equals(column.getFieldKey())) {
                            row.createCell(k).setCellValue((double)rowNum);
                            continue;
                        }
                        BigDecimal qty = (BigDecimal)sumEntity.getQtyMap().get(column.getFieldKey());
                        if (qty == null) {
                            qty = BigDecimal.ZERO;
                        }
                        row.createCell(k).setCellValue(new Double(qty.toString()).doubleValue());
                    }
                    ++rowNum;
                }
            }
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u6bdb\u9700\u6c42\u67e5\u8be2-\u9700\u6c42\u7c7b\u578b\u6c47\u603b-\u6279\u91cf\u5bfc\u51fa.xlsx", (String)"GrossDemandRptPlugin_10", (String)"mmc-mrp-report", (Object[])new Object[0]), (InputStream)inStream, timeout);
            FilePermissionUtil.addFilePermission((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"4730fc9f000004ae");
            this.getView().download(tempUrl);
            outStream.close();
            inStream.close();
            workbook.close();
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (workbook != null) {
                workbook.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcel2(ReportList list) throws IOException {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"GrossDemandRptPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0])));
        List columns = list.getReportModel().getColumns();
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook();
            SXSSFSheet sheet = workbook.createSheet();
            SXSSFRow firstrow = sheet.createRow(0);
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                AbstractReportColumn abstractReportColumn = (AbstractReportColumn)columns.get(i);
                firstrow.createCell(i).setCellValue(abstractReportColumn.getCaption().toString());
            }
            int rowNum = 1;
            int n2 = list.getReportModel().getRowCount();
            for (int i = 1; i <= n2; ++i) {
                DynamicObject rowData = list.getReportModel().getRowData(i);
                SXSSFRow row = sheet.createRow(rowNum);
                int m = columns.size();
                for (int k = 0; k < m; ++k) {
                    ReportColumn column = (ReportColumn)columns.get(k);
                    if ("cmaterial_1".equals(column.getFieldKey())) {
                        row.createCell(k).setCellValue(rowData.getDynamicObject(column.getFieldKey()).getString("number"));
                        continue;
                    }
                    if ("configuredcode_1".equals(column.getFieldKey())) {
                        DynamicObject configuredcode = rowData.getDynamicObject(column.getFieldKey());
                        String number = "";
                        if (configuredcode != null) {
                            number = configuredcode.getString("number");
                        }
                        row.createCell(k).setCellValue(number);
                        continue;
                    }
                    if ("auxproperty_1".equals(column.getFieldKey())) {
                        String value = "";
                        FlexValueFormatter flexValueFormat = new FlexValueFormatter();
                        ReportColumn reportColumn = (ReportColumn)columns.get(k);
                        FlexProp fieldProperty = (FlexProp)reportColumn.getFieldProperty();
                        Object srcValue = flexValueFormat.getDisplayValueForReport(rowData, fieldProperty, fieldProperty.getBasePropertyKey());
                        value = srcValue instanceof ArrayList ? String.join((CharSequence)";", (ArrayList)srcValue) : srcValue.toString();
                        row.createCell(k).setCellValue(value);
                        continue;
                    }
                    if ("requiresource_1".equals(column.getFieldKey())) {
                        row.createCell(k).setCellValue(rowData.getString(column.getFieldKey()));
                        continue;
                    }
                    row.createCell(k).setCellValue(new Double(rowData.getString(column.getFieldKey())).doubleValue());
                }
                ++rowNum;
            }
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u6bdb\u9700\u6c42\u67e5\u8be2-\u9700\u6c42\u7c7b\u578b\u6c47\u603b.xlsx", (String)"GrossDemandRptPlugin_11", (String)"mmc-mrp-report", (Object[])new Object[0]), (InputStream)inStream, timeout);
            FilePermissionUtil.addFilePermission((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"4730fc9f000004ae");
            this.getView().download(tempUrl);
            outStream.close();
            inStream.close();
            workbook.close();
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (workbook != null) {
                workbook.close();
            }
        }
        this.getView().hideLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcel3(ReportList list) throws IOException {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"GrossDemandRptPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0])));
        List columns = list.getReportModel().getColumns();
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        SXSSFWorkbook workbook = null;
        try {
            int i;
            workbook = new SXSSFWorkbook();
            SXSSFSheet sheet = workbook.createSheet();
            SXSSFRow firstrow = sheet.createRow(0);
            int ce = 0;
            int n = columns.size();
            for (i = 0; i < n; ++i) {
                AbstractReportColumn abstractReportColumn = (AbstractReportColumn)columns.get(i);
                firstrow.createCell(ce).setCellValue(abstractReportColumn.getCaption().toString());
                ++ce;
            }
            n = list.getReportModel().getRowCount();
            for (i = 1; i <= n; ++i) {
                DynamicObject rowData = list.getReportModel().getRowData(i);
                SXSSFRow row = sheet.createRow(i);
                int cell = 0;
                for (AbstractReportColumn c : columns) {
                    ReportColumn column = (ReportColumn)c;
                    switch (column.getFieldKey()) {
                        case "cmaterial_2": 
                        case "configuredcode_2": 
                        case "pmaterial_2": 
                        case "pconfiguredcode_2": {
                            DynamicObject data = rowData.getDynamicObject(column.getFieldKey());
                            String dataNumber = data == null ? "" : data.getString("number");
                            row.createCell(cell).setCellValue(dataNumber);
                            break;
                        }
                        case "auxproperty_2": 
                        case "pauxproperty_2": {
                            String value = "";
                            FlexValueFormatter flexValueFormat = new FlexValueFormatter();
                            FlexProp fieldProperty = (FlexProp)column.getFieldProperty();
                            Object srcValue = flexValueFormat.getDisplayValueForReport(rowData, fieldProperty, fieldProperty.getBasePropertyKey());
                            value = srcValue instanceof ArrayList ? String.join((CharSequence)";", (ArrayList)srcValue) : srcValue.toString();
                            row.createCell(cell).setCellValue(value);
                            break;
                        }
                        case "pmaterialname_2": {
                            row.createCell(cell).setCellValue(rowData.getDynamicObject("pmaterial_2").getString("name"));
                            break;
                        }
                        case "demuser_2": {
                            if (rowData.getDynamicObject(column.getFieldKey()) == null) {
                                row.createCell(cell).setCellValue("");
                                break;
                            }
                            row.createCell(cell).setCellValue(rowData.getDynamicObject("demuser_2").getString("name"));
                            break;
                        }
                        case "supuser_2": {
                            if (rowData.getDynamicObject(column.getFieldKey()) == null) {
                                row.createCell(cell).setCellValue("");
                                break;
                            }
                            row.createCell(cell).setCellValue(rowData.getDynamicObject("supuser_2").getString("name"));
                            break;
                        }
                        case "pct_1": {
                            row.createCell(cell).setCellValue(rowData.getString("pct_1"));
                            break;
                        }
                        default: {
                            row.createCell(cell).setCellValue(new Double(rowData.getString(column.getFieldKey())).doubleValue());
                        }
                    }
                    ++cell;
                }
            }
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u6bdb\u9700\u6c42\u67e5\u8be2-\u7236\u9879\u9700\u6c42\u6e05\u5355.xlsx", (String)"GrossDemandRptPlugin_12", (String)"mmc-mrp-report", (Object[])new Object[0]), (InputStream)inStream, timeout);
            FilePermissionUtil.addFilePermission((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"4730fc9f000004ae");
            this.getView().download(tempUrl);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (workbook != null) {
                workbook.close();
            }
        }
        this.getView().hideLoading();
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        IReportCache cache = ReportCacheManager.getInstance().getCache();
        ReportList srcRpt = (ReportList)this.getControl("reportparentlistap");
        ReportListModel model = (ReportListModel)srcRpt.getReportModel();
        String pageId = model.getPageId();
        String ctrlId = "reportparentlistap";
        ReportTaskParam tp = new ReportTaskParam();
        tp.setPluginClassName(srcRpt.getReportPluginClassName());
        tp.setDataSource(srcRpt.getDataSource());
        tp.setQueryDataSource(srcRpt.getDataSourceId());
        tp.setOtherParam((Object)queryParam);
        cache.setReportTaskParam(pageId, ctrlId, tp);
        srcRpt.submitTask(queryParam, null);
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"GrossDemandRptPlugin_13", (String)"mmc-mrp-report", (Object[])new Object[0])));
        this.fillSummary2();
        this.getView().hideLoading();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)FILTER_OPERATION)) {
            listShowParameter.setShowApproved(false);
            listShowParameter.setUseOrgId(0L);
            listShowParameter.setIsolationOrg(false);
            listShowParameter.setShowUsed(false);
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            QFilter qFilter2 = new QFilter("runtype", "=", (Object)"A");
            QFilter qFilter3 = new QFilter("calculatestatus", "=", (Object)"A");
            qFilters.add(qFilter2);
            qFilters.add(qFilter3);
            qFilters.add(new QFilter("operatmodekey", "!=", (Object)"mrp_simulation"));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        ReportList srcRpt = (ReportList)this.getControl("reportparentlistap");
        ReportListModel model = (ReportListModel)srcRpt.getReportModel();
        String pageId = model.getPageId();
        String ctrlId = "reportparentlistap";
        IReportCache cache = ReportCacheManager.getInstance().getCache();
        cache.clear(pageId, ctrlId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("type2".equals(propertyName)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"GrossDemandRptPlugin_13", (String)"mmc-mrp-report", (Object[])new Object[0])));
            this.fillSummary2();
            this.getView().hideLoading();
        } else if (FILTER_OPERATION.equals(propertyName)) {
            DynamicObject caculateLog = (DynamicObject)this.getModel().getValue(FILTER_OPERATION);
            if (caculateLog == null) {
                return;
            }
            String number = caculateLog.getString("number");
            DynamicObject[] arr = BusinessDataServiceHelper.load((String)"mrp_peginfodata", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
            if (arr.length != 0) {
                this.getModel().setValue("id", (Object)arr[0].getLong("id"));
            }
        }
    }

    private void fillSummary2() {
        ReportList list = (ReportList)this.getControl("reportparentlistap");
        int rowCount = list.getReportModel().getRowCount();
        String value2 = this.getModel().getValue("type2").toString();
        HashMap<MaterialInfo, MaterialGroupEntity> materialInfoMap = new HashMap<MaterialInfo, MaterialGroupEntity>();
        for (int i = 1; i <= rowCount; ++i) {
            BigDecimal sumQty;
            DynamicObject user;
            DynamicObject rowData = list.getReportModel().getRowData(i);
            BigDecimal qty = rowData.getBigDecimal("total_1");
            DynamicObject material = rowData.getDynamicObject("cmaterial_2");
            DynamicObject auxproperty = rowData.getDynamicObject("auxproperty_2");
            DynamicObject configuredcode = rowData.getDynamicObject("configuredcode_2");
            Long auxpropertyId = this.getDataId(auxproperty);
            Long configuredcodeId = this.getDataId(configuredcode);
            MaterialInfo materialInfo = new MaterialInfo(Long.valueOf(material.getLong("id")), configuredcodeId, auxpropertyId);
            MaterialGroupEntity entity = materialInfoMap.computeIfAbsent(materialInfo, k -> new MaterialGroupEntity());
            entity.setSumQty(entity.getSumQty().add(qty));
            Map qtyMap = entity.getMap();
            if ("A".contains(value2)) {
                user = rowData.getDynamicObject("supuser_2");
                if (user == null) {
                    sumQty = qtyMap.computeIfAbsent("", k -> BigDecimal.ZERO);
                    qtyMap.put("", sumQty.add(qty));
                } else {
                    sumQty = qtyMap.computeIfAbsent(user.getPkValue().toString(), k -> BigDecimal.ZERO);
                    qtyMap.put(user.getPkValue().toString(), sumQty.add(qty));
                }
            }
            if (!"B".contains(value2)) continue;
            user = rowData.getDynamicObject("demuser_2");
            if (user == null) {
                sumQty = qtyMap.computeIfAbsent("", k -> BigDecimal.ZERO);
                qtyMap.put("", sumQty.add(qty));
                continue;
            }
            sumQty = qtyMap.computeIfAbsent(user.getPkValue().toString(), k -> BigDecimal.ZERO);
            qtyMap.put(user.getPkValue().toString(), sumQty.add(qty));
        }
        AbstractFormDataModel modelData = (AbstractFormDataModel)this.getModel();
        modelData.deleteEntryData("entryentity_2");
        modelData.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowNumber = 0;
        for (Map.Entry entry : materialInfoMap.entrySet()) {
            MaterialInfo materialInfo = (MaterialInfo)entry.getKey();
            Long materialId = materialInfo.getMaterialId();
            Long configuredcodeId = materialInfo.getConfiguredcode();
            Long auxpropertyId = materialInfo.getAuxproperty();
            MaterialGroupEntity entity = (MaterialGroupEntity)entry.getValue();
            for (Map.Entry e : entity.getMap().entrySet()) {
                vs.set("pmaterial_4", (Object)materialId, rowNumber);
                vs.set("auxproperty_4", (Object)auxpropertyId, rowNumber);
                vs.set("configuredcode_4", (Object)configuredcodeId, rowNumber);
                vs.set("summary_4", e.getKey(), rowNumber);
                vs.set("qty_4", (Object)((BigDecimal)e.getValue()).stripTrailingZeros().toPlainString(), rowNumber);
                if (entity.getSumQty().compareTo(BigDecimal.ZERO) == 0) {
                    vs.set("pct_4", (Object)"0%", rowNumber);
                } else {
                    vs.set("pct_4", (Object)(((BigDecimal)e.getValue()).multiply(new BigDecimal(100)).divide(entity.getSumQty(), 2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString() + "%"), rowNumber);
                }
                ++rowNumber;
            }
        }
        modelData.batchCreateNewEntryRow("entryentity_2", vs);
        modelData.endInit();
        this.getView().updateView("entryentity_2");
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity_2"});
    }

    private Long getDataId(DynamicObject auxproperty) {
        Long auxpropertyId = 0L;
        if (auxproperty != null) {
            auxpropertyId = auxproperty.getLong("id");
        }
        return auxpropertyId;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        ArrayList<String> list = new ArrayList<String>(2);
        Integer starttime = Integer.valueOf(filter.getString("starttime"));
        Integer endtime = Integer.valueOf(filter.getString("endtime"));
        if (filter.getValue(FILTER_OPERATION) == null) {
            list.add(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7", (String)"GrossDemandRptPlugin_14", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        if (filter.getValue("material") == null) {
            list.add(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"GrossDemandRptPlugin_15", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        if (!list.isEmpty()) {
            this.getView().showTipNotification(ShowTipsUtil.appendShowTips((String[])list.toArray(new String[0])));
            return false;
        }
        DynamicObject caculateLog = (DynamicObject)filter.getValue(FILTER_OPERATION);
        String number = caculateLog.getString("number");
        DynamicObject[] arr = BusinessDataServiceHelper.load((String)"mrp_peginfodata", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (arr.length != 0) {
            this.getModel().setValue("id", (Object)arr[0].getLong("id"));
        }
        if (filter.getDynamicObjectCollection("material").size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u3002", (String)"GrossDemandRptPlugin_16", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        if (endtime < starttime) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"GrossDemandRptPlugin_17", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        ReportList reportparentlistap = (ReportList)this.getControl("reportparentlistap");
        ReportList reportllistap = (ReportList)this.getControl("reportllistap");
        reportllistap.setHasSettingRow(Boolean.FALSE.booleanValue());
        reportparentlistap.setHasSettingRow(Boolean.FALSE.booleanValue());
        return true;
    }
}

