/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.gross;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.entity.gross.MaterialInfo;
import kd.mmc.mrp.common.entity.gross.RequireTypeSummaryEntity2;

public class GrossDemandRptQuery
extends AbstractReportListDataPlugin {
    private static ThreadLocal<List<String>> threadLocal = new ThreadLocal();

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        FilterInfo filter = param.getFilter();
        DynamicObjectCollection dynamicObjectCollection = filter.getDynamicObjectCollection("material");
        HashSet<Long> materialIdSet = new HashSet<Long>();
        for (DynamicObject obj : dynamicObjectCollection) {
            materialIdSet.add(obj.getLong("id"));
        }
        HashSet<MaterialInfo> materialInfos = new HashSet<MaterialInfo>(materialIdSet.size());
        DataSet dataSet = this.getAllData(filter, materialIdSet);
        Integer starttime = Integer.valueOf(filter.getString("starttime"));
        Integer endtime = Integer.valueOf(filter.getString("endtime"));
        ArrayList<String> columns = new ArrayList<String>();
        HashMap<MaterialInfo, Set<String>> requireTypeMap = new HashMap<MaterialInfo, Set<String>>();
        HashMap<MaterialInfo, BigDecimal> qtyMap = new HashMap<MaterialInfo, BigDecimal>();
        Map<MaterialInfo, Map<String, RequireTypeSummaryEntity2>> map = this.dealData(filter, materialIdSet, dataSet, columns, requireTypeMap, materialInfos, qtyMap, starttime, endtime);
        threadLocal.set(columns);
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("cmaterial_2", (DataType)DateType.StringType, true));
        fields.add(new Field("auxproperty_2", (DataType)DateType.StringType, true));
        fields.add(new Field("configuredcode_2", (DataType)DateType.StringType, true));
        fields.add(new Field("pmaterial_2", (DataType)DateType.StringType, true));
        fields.add(new Field("pauxproperty_2", (DataType)DateType.StringType, true));
        fields.add(new Field("pconfiguredcode_2", (DataType)DateType.StringType, true));
        fields.add(new Field("demuser_2", (DataType)DateType.StringType, true));
        fields.add(new Field("supuser_2", (DataType)DateType.StringType, true));
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            fields.add(new Field((String)columns.get(i), (DataType)DateType.StringType, true));
        }
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        for (MaterialInfo materialInfo : materialInfos) {
            if (!map.containsKey(materialInfo)) continue;
            BigDecimal qty = (BigDecimal)qtyMap.get(materialInfo);
            Set requireTypes = (Set)requireTypeMap.get(materialInfo);
            Map<String, RequireTypeSummaryEntity2> materialInfoMap = map.get(materialInfo);
            Long materialId = materialInfo.getMaterialId();
            for (String key : requireTypes) {
                RequireTypeSummaryEntity2 requireTypeSummaryEntity = materialInfoMap.get(materialId + key);
                Object[] values = new Object[fields.size()];
                values[0] = requireTypeSummaryEntity.getChildMaterialId();
                values[1] = materialInfo.getAuxproperty();
                values[2] = requireTypeSummaryEntity.getConfiguredcode();
                values[3] = requireTypeSummaryEntity.getParentMaterialId();
                values[4] = requireTypeSummaryEntity.getPauxproperty();
                values[5] = requireTypeSummaryEntity.getPconfiguredcode();
                values[6] = requireTypeSummaryEntity.getDemuser();
                values[7] = requireTypeSummaryEntity.getSupuser();
                int n2 = requireTypeSummaryEntity.getDateList().size();
                for (int i = 0; i < n2; ++i) {
                    if (i == 0) {
                        if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
                            values[8 + i] = "0%";
                            continue;
                        }
                        values[8 + i] = ((BigDecimal)requireTypeSummaryEntity.getQtyMap().get("total_1")).multiply(new BigDecimal(100)).divide(qty, 2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString() + "%";
                        continue;
                    }
                    String name = (String)requireTypeSummaryEntity.getDateList().get(i);
                    values[8 + i] = ((BigDecimal)requireTypeSummaryEntity.getQtyMap().get(name)).setScale(2, RoundingMode.HALF_DOWN).stripTrailingZeros().toPlainString();
                }
                builder.append(values);
            }
        }
        return builder.build();
    }

    private Map<MaterialInfo, Map<String, RequireTypeSummaryEntity2>> dealData(FilterInfo filter, Set<Long> materialIdSet, DataSet dataSet, List<String> columns, Map<MaterialInfo, Set<String>> requireTypeMap, Set<MaterialInfo> materialInfos, Map<MaterialInfo, BigDecimal> qtyMap, Integer starttime, Integer endtime) {
        HashMap<MaterialInfo, Map<String, RequireTypeSummaryEntity2>> map = new HashMap<MaterialInfo, Map<String, RequireTypeSummaryEntity2>>();
        boolean isWeek = "1".equals(filter.getString("radiogroupfield"));
        Calendar calcreateTime = Calendar.getInstance();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"mrp_peginfodata", (String)"id,createtime,entryentity.supplydate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)filter.getLong("id"))}, (String)"entryentity.supplydate asc", (int)1);
        if (datas == null || datas.size() <= 0) {
            return map;
        }
        Date createTime = ((DynamicObject)datas.get(0)).getDate("createtime");
        Date supplydate = ((DynamicObject)datas.get(0)).getDate("entryentity.supplydate");
        if (supplydate == null) {
            return map;
        }
        if (createTime != null && supplydate != null && createTime.compareTo(supplydate) < 0) {
            calcreateTime.setTime(createTime);
        } else {
            calcreateTime.setTime(supplydate);
        }
        calcreateTime.add(3, starttime - 1);
        try (DataSet d = dataSet.copy();){
            for (Long materialId : materialIdSet) {
                DataSet da = d.copy().filter("cmaterial_2 = " + materialId);
                if (da.hasNext()) {
                    for (Row row : da) {
                        Long parentMaterial = row.getLong("pmaterial_2");
                        Long configuredcode = row.getLong("configuredcode_2");
                        Long pconfiguredcode = row.getLong("pconfiguredcode_2");
                        Long auxproperty = row.getLong("auxproperty_2");
                        Long pauxproperty = row.getLong("pauxproperty_2");
                        MaterialInfo materialInfo = new MaterialInfo(materialId, configuredcode, auxproperty);
                        materialInfos.add(materialInfo);
                        BigDecimal qty = row.getBigDecimal("total_2");
                        Date date = row.getDate("supplydate");
                        Map materialInfoMap = map.computeIfAbsent(materialInfo, k -> new HashMap());
                        Set requireTypes = requireTypeMap.computeIfAbsent(materialInfo, k -> new HashSet());
                        requireTypes.add(parentMaterial + "");
                        BigDecimal q = qtyMap.computeIfAbsent(materialInfo, k -> BigDecimal.ZERO);
                        String demuser = row.getString("demuser_2");
                        String supuser = row.getString("supuser_2");
                        RequireTypeSummaryEntity2 requireEntity = (RequireTypeSummaryEntity2)materialInfoMap.get(materialId + "" + parentMaterial);
                        if (requireEntity == null) {
                            requireEntity = materialInfoMap.computeIfAbsent(materialId + "" + parentMaterial, k -> new RequireTypeSummaryEntity2(isWeek, endtime - (starttime - 1), calcreateTime.getTime(), materialId, configuredcode, parentMaterial, pconfiguredcode, demuser, supuser, pauxproperty));
                        }
                        if (StringUtils.isNotBlank((CharSequence)demuser)) {
                            requireEntity.setDemuser(demuser);
                        }
                        if (StringUtils.isNotBlank((CharSequence)supuser)) {
                            requireEntity.setSupuser(supuser);
                        }
                        requireEntity.setConfiguredcode(configuredcode);
                        requireEntity.setPconfiguredcode(pconfiguredcode);
                        if (columns.size() == 0) {
                            columns.addAll(requireEntity.getDateList());
                        }
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(date);
                        if (isWeek) {
                            cal.setFirstDayOfWeek(2);
                            int day = cal.get(7);
                            if (day == 1) {
                                day = 8;
                            }
                            cal.add(5, cal.getFirstDayOfWeek() - day);
                            String dateString = cal.get(1) + "/" + (cal.get(2) + 1) + "/" + cal.get(5);
                            if (!requireEntity.getQtyMap().containsKey(dateString)) continue;
                            qtyMap.put(materialInfo, q.add(qty));
                            requireEntity.getQtyMap().put(dateString, qty.add((BigDecimal)requireEntity.getQtyMap().get(dateString)));
                            requireEntity.getQtyMap().put("total_1", qty.add((BigDecimal)requireEntity.getQtyMap().get("total_1")));
                            continue;
                        }
                        String monthOfYear = cal.get(1) + "/" + (cal.get(2) + 1);
                        if (!requireEntity.getQtyMap().containsKey(monthOfYear)) continue;
                        qtyMap.put(materialInfo, q.add(qty));
                        requireEntity.getQtyMap().put(monthOfYear, qty.add((BigDecimal)requireEntity.getQtyMap().get(monthOfYear)));
                        requireEntity.getQtyMap().put("total_1", qty.add((BigDecimal)requireEntity.getQtyMap().get("total_1")));
                    }
                }
                da.close();
            }
        }
        return map;
    }

    private DataSet getAllData(FilterInfo filter, Set<Long> materialIdSet) {
        StringBuilder sql = new StringBuilder();
        sql.append("entryentity.supplymaterial cmaterial_2,");
        sql.append("entryentity.supplyauxpty auxproperty_2,");
        sql.append("entryentity.configuredcodesup configuredcode_2,");
        sql.append("entryentity.requirematerial pmaterial_2,");
        sql.append("entryentity.demandauxpty pauxproperty_2,");
        sql.append("entryentity.configuredcodedem pconfiguredcode_2,");
        sql.append("entryentity.requireorg requireorg_2,");
        sql.append("entryentity.requireoperator demuser_2,");
        sql.append("entryentity.supplyoperator supuser_2,");
        sql.append("entryentity.supplyqty supplyqty,");
        sql.append("entryentity.supplydate supplydate");
        long id = filter.getLong("id");
        QFilter qf1 = new QFilter("id", "=", (Object)id);
        QFilter qf2 = new QFilter("entryentity.supplydate", "is not null", (Object)"");
        QFilter qf3 = new QFilter("entryentity.supplymaterial", "in", materialIdSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_peginfodata", (String)sql.toString(), (QFilter[])new QFilter[]{qf1, qf2, qf3}, null).groupBy(new String[]{"cmaterial_2", "pmaterial_2", "requireorg_2", "demuser_2", "configuredcode_2", "pconfiguredcode_2", "supuser_2", "supplyqty", "auxproperty_2", "pauxproperty_2", "supplydate"}).sum("supplyqty", "total_2").finish();
        return dataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List<String> list = threadLocal.get();
        List columns2 = super.getColumns(columns);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ReportColumn qty = new ReportColumn();
            if ("total_1".equals(list.get(i))) {
                qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"GrossDemandRptQuery_0", (String)"mmc-mrp-report", (Object[])new Object[0])));
            } else if ("pct_1".equals(list.get(i))) {
                qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5360\u6bd4", (String)"GrossDemandRptQuery_1", (String)"mmc-mrp-report", (Object[])new Object[0])));
            } else {
                qty.setCaption(new LocaleString(list.get(i)));
            }
            qty.setFieldKey(list.get(i));
            qty.setWidth(new LocaleString("80px"));
            qty.setFieldType("text");
            qty.setZeroShow(true);
            ColumnStyle c = new ColumnStyle();
            c.setTextAlign("right");
            qty.setStyle(c);
            columns2.add(qty);
        }
        threadLocal.remove();
        return columns2;
    }
}

