/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.plananalysis;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.util.ShowTipsUtil;
import kd.mmc.mrp.report.plananalysis.AbstractMRPRptPlugin;

public class DetailedListRptPlugin
extends AbstractMRPRptPlugin
implements HyperLinkClickListener {
    private static final String CALCLOGNO = "calclogno";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getControl(CALCLOGNO);
        if (edit != null) {
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit base;
        super.beforeF7Select(e);
        if (e.getSource() != null && e.getSource() instanceof BasedataEdit && CALCLOGNO.equals((base = (BasedataEdit)e.getSource()).getFieldKey())) {
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter filter = new QFilter("clearstatus", "!=", (Object)Character.valueOf('B'));
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("operatmodekey", "!=", (Object)"mrp_simulation"));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map param = this.getView().getFormShowParameter().getCustomParams();
        if (!param.isEmpty() && param.containsKey(CALCLOGNO)) {
            this.getModel().setValue("planorg", param.get("planorg"));
            this.getModel().setValue(CALCLOGNO, param.get(CALCLOGNO));
            this.getModel().setValue("materialnumber", param.get("materialnumber"));
            this.getModel().setValue("materialattr", param.get("materialattr"));
            ReportFilter filter = (ReportFilter)this.getView().getControl("reportfilterap");
            filter.search();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.verifyData(queryParam);
    }

    private boolean verifyData(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        ArrayList<String> list = new ArrayList<String>(3);
        if (filter.getValue(CALCLOGNO) == null) {
            list.add(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7", (String)"DetailedListRptPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        if (filter.getValue("materialnumber") == null) {
            list.add(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"DetailedListRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)filter.getString("materialattr"))) {
            list.add(ResManager.loadKDString((String)"\u7269\u6599\u5c5e\u6027", (String)"DetailedListRptPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        if (!list.isEmpty()) {
            this.getView().showTipNotification(ShowTipsUtil.appendShowTips((String[])list.toArray(new String[0])));
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if ("billno".equals(e.getFieldName()) || "source".equals(e.getFieldName())) {
            HashMap<String, Object> para = new HashMap<String, Object>();
            String entity = e.getRowData().getString("billentity");
            DynamicObject obj = QueryServiceHelper.queryOne((String)entity, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(e.getRowData().getString("billid")))});
            if (obj == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u5df2\u5220\u9664\u3002", (String)"DetailedListRptPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]), e.getRowData().getString("billtype")));
                return;
            }
            if ("mds_data".equals(entity)) {
                this.getMDSData(obj.getString("id"), para);
            } else {
                para.put("formId", entity);
                para.put("pkId", obj.getString("id"));
            }
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        }
    }

    private void getMDSData(String id, Map<String, Object> para) {
        Long cvrNumId = 0L;
        String formId = "";
        String newId = id;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"mds_data", (String)"id,fcvrnnum,fcvrnnum.vertype vertype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(id))}, null, (int)1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                cvrNumId = row.getLong("fcvrnnum");
                String vertype = row.getString("vertype");
                formId = "0".equals(vertype) ? "mds_forecastplandata" : ("1".equals(vertype) ? "mds_mdsplandata" : "mds_dpsplandata");
            }
        }
        dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"mds_plandata", (String)"id", (QFilter[])new QFilter[]{new QFilter("fcvrnnum", "=", (Object)cvrNumId)}, null, (int)1);
        var7_7 = null;
        try {
            if (dataSet.hasNext()) {
                newId = dataSet.next().getString("id");
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var7_7 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        para.put("pkId", newId);
        para.put("formId", formId);
    }
}

