/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.plananalysis;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DetailedListRptQuery
extends AbstractReportListDataPlugin {
    private String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final Log logger = LogFactory.getLog(DetailedListRptQuery.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        StringBuilder selectStr = new StringBuilder();
        selectStr.append("caculatelog caculatelog,");
        selectStr.append("entryentity.material material,");
        selectStr.append("entryentity.materialattr materialattr,");
        selectStr.append("entryentity.supplydate supplydate,");
        selectStr.append("entryentity.origindemanddate demanddate,");
        selectStr.append("entryentity.supplybillf7 supplybillf7,");
        selectStr.append("entryentity.demandbillf7 demandbillf7,");
        selectStr.append("entryentity.supplybillno supplybillno,");
        selectStr.append("entryentity.billno billno,");
        selectStr.append("entryentity.supplybillid supplybillid,");
        selectStr.append("entryentity.billid billid,");
        selectStr.append("entryentity.supplybillentryseq supplybillentryseq,");
        selectStr.append("entryentity.billentryseq billentryseq,");
        selectStr.append("entryentity.bomversion bomversion,");
        selectStr.append("entryentity.supplyqty supplyqty,");
        selectStr.append("entryentity.demandqty demandqty,");
        selectStr.append("entryentity.supplyorg supplyorg,");
        selectStr.append("entryentity.requireorg requireorg,");
        selectStr.append("entryentity.reqpriority reqpriority,");
        selectStr.append("entryentity.suppriority suppriority,");
        selectStr.append("entryentity.supplybilltype supplybilltype,");
        selectStr.append("entryentity.demandbilltype demandbilltype,");
        selectStr.append("entryentity.exceptionnumber exceptionnumber,");
        selectStr.append("entryentity.billentryid billentryid,");
        selectStr.append("entryentity.configuredcode configuredcode,");
        selectStr.append("entryentity.demandplanscope demandplanscope,");
        selectStr.append("entryentity.supplyplanscope supplyplanscope,");
        selectStr.append("entryentity.tracknumber tracknumber,");
        selectStr.append("entryentity.suptracknumber suptracknumber,");
        selectStr.append("entryentity.demandproject demandproject,");
        selectStr.append("entryentity.supplyproject supplyproject,");
        selectStr.append("entryentity.demandauxpty demandauxpty,");
        selectStr.append("entryentity.supplyauxpty supplyauxpty,");
        selectStr.append("entryentity.supplybillentryid supplybillentryid");
        QFilter qFilter = new QFilter("caculatelog", "=", (Object)filterInfo.getDynamicObject("calclogno").getString("number"));
        qFilter.and(new QFilter("entryentity.material", "=", filterInfo.getDynamicObject("materialnumber").getPkValue()));
        String materialattr = filterInfo.getString("materialattr");
        String[] attrs = materialattr.split(",");
        attrs = (String[])Arrays.stream(attrs).filter(StringUtils::isNotBlank).toArray(String[]::new);
        qFilter.and(new QFilter("entryentity.materialattr", "in", (Object)attrs));
        QFilter qFilterPlanScope = null;
        DynamicObject filter_planscope = filterInfo.getDynamicObject("filter_planscope");
        if (filter_planscope != null) {
            qFilterPlanScope = new QFilter("entryentity.demandplanscope", "=", filter_planscope.getPkValue());
            qFilterPlanScope.or(new QFilter("entryentity.supplyplanscope", "=", filter_planscope.getPkValue()));
        }
        DataSet calDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"mrp_calcdetail", (String)selectStr.toString(), (QFilter[])new QFilter[]{qFilter, qFilterPlanScope}, null);
        Object unit = filterInfo.getDynamicObject("materialnumber").getDynamicObject("baseunit").getPkValue();
        return this.mergeRowData(calDataSet, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet mergeRowData(DataSet dataSet, Object unit) {
        HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            while (dataSet.hasNext()) {
                PutData putData;
                boolean isSupplyInv;
                Row row = dataSet.next();
                Long material = row.getLong("material");
                String string = row.getString("demandbillf7");
                String dtype = row.getString("demandbilltype");
                String requireDate = row.getDate("demanddate") != null ? sdf.format(row.getDate("demanddate")) : "";
                String supplyBillType = row.getString("supplybillf7");
                String stype = row.getString("supplybilltype");
                String billentryid = row.getString("billentryid");
                String billid = row.getString("billid");
                String supplybillentryid = row.getString("supplybillentryid");
                String supplybillid = row.getString("supplybillid");
                String supplyDate = row.getDate("supplydate") != null ? sdf.format(row.getDate("supplydate")) : null;
                boolean isRequireInv = this.isInvData(string);
                if (isRequireInv) {
                    billid = row.get("requireorg") + "\u0001" + row.get("materialattr") + "\u0001" + row.get("configuredcode");
                    billentryid = row.get("tracknumber") + "\u0001" + row.get("demandauxpty") + "\u0001" + row.get("demandproject") + "\u0001" + row.get("demandplanscope");
                }
                if (isSupplyInv = this.isInvData(supplyBillType)) {
                    supplybillid = row.get("supplyorg") + "\u0001" + row.get("materialattr") + "\u0001" + row.get("configuredcode");
                    supplybillentryid = row.get("suptracknumber") + "\u0001" + row.get("supplyauxpty") + "\u0001" + row.get("supplyproject") + "\u0001" + row.get("supplyplanscope");
                }
                String requireKey = String.format("%s\u0001%s\u0001%s\u0001%s", dtype, requireDate, billid, billentryid);
                String supplyKey = String.format("%s\u0001%s\u0001%s\u0001%s", stype, supplyDate, supplybillid, supplybillentryid);
                BigDecimal supplyQty = row.get("supplyqty") == null ? BigDecimal.ZERO : row.getBigDecimal("supplyqty");
                BigDecimal requireQty = row.get("demandqty") == null ? BigDecimal.ZERO : row.getBigDecimal("demandqty");
                BigDecimal qty = BigDecimal.ZERO;
                qty = requireQty.compareTo(supplyQty) > 0 || requireQty.compareTo(BigDecimal.ZERO) <= 0 ? supplyQty : requireQty;
                if (BigDecimal.ZERO.compareTo(qty) == 0 && row.get("exceptionnumber") != null && !"".equals(row.getString("exceptionnumber").trim())) continue;
                if (!"tmp_safe_inv".equals(string) && !this.isInvLevelEmptyRequire(dtype)) {
                    putData = new PutData();
                    putData.key = requireKey;
                    putData.date = row.getDate("demanddate");
                    putData.type = "B";
                    putData.priority = row.getString("reqpriority");
                    putData.billType = dtype;
                    putData.billno = row.getString("billno");
                    putData.entryseq = row.getString("billentryseq");
                    putData.bomversion = row.get("bomversion");
                    putData.qty = requireQty;
                    putData.org = row.get("requireorg");
                    putData.unit = unit;
                    putData.material = material;
                    putData.attr = row.get("materialattr");
                    putData.planscope = row.get("demandplanscope");
                    putData.tracknumber = row.get("tracknumber");
                    putData.project = row.get("demandproject");
                    putData.configuredcode = row.get("configuredcode");
                    putData.auxpty = row.get("demandauxpty");
                    putData.billid = row.get("billid");
                    putData.billentity = string;
                    this.putMapData(putData, dataMap);
                }
                if ("tmp_safe_inv".equals(supplyBillType)) continue;
                putData = new PutData();
                putData.key = supplyKey;
                putData.date = row.getDate("supplydate");
                putData.type = "A";
                putData.priority = row.getString("suppriority");
                putData.billType = stype;
                putData.billno = row.getString("supplybillno");
                putData.entryseq = row.getString("supplybillentryseq");
                putData.bomversion = row.get("bomversion");
                putData.qty = qty;
                putData.org = row.get("supplyorg");
                putData.unit = unit;
                putData.material = material;
                putData.attr = row.get("materialattr");
                putData.planscope = row.get("supplyplanscope");
                putData.tracknumber = row.get("suptracknumber");
                putData.project = row.get("supplyproject");
                putData.configuredcode = row.get("configuredcode");
                putData.auxpty = row.get("supplyauxpty");
                putData.billid = row.get("supplybillid");
                putData.billentity = supplyBillType;
                this.putMapData(putData, dataMap);
            }
        }
        finally {
            dataSet.close();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(dataMap.size());
        for (Map.Entry entry : dataMap.entrySet()) {
            list.add((Map<String, Object>)entry.getValue());
        }
        list.sort((map1, map2) -> {
            Date date1 = (Date)map1.get("date");
            Date date2 = (Date)map2.get("date");
            String type1 = (String)map1.get("type");
            String type2 = (String)map2.get("type");
            if (date1.after(date2)) {
                return 1;
            }
            if (date1.before(date2)) {
                return -1;
            }
            if (StringUtils.equals((CharSequence)type1, (CharSequence)type2)) {
                return 0;
            }
            if (StringUtils.equals((CharSequence)"A", (CharSequence)type1)) {
                return 1;
            }
            return -1;
        });
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            if (i == 0) {
                map.put("useqty", map.get("qty"));
                continue;
            }
            BigDecimal bigDecimal = ((BigDecimal)((Map)list.get(i - 1)).get("useqty")).add((BigDecimal)map.get("qty"));
            map.put("useqty", bigDecimal);
        }
        return this.getReturnData(list);
    }

    private boolean isInvData(String billType) {
        return "im_inv_realbalance".equalsIgnoreCase(billType);
    }

    private boolean isInvLevelEmptyRequire(String dType) {
        return dType.equals(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d", (String)"DetailedListRptQuery_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
    }

    private void putMapData(PutData putData, Map<String, Map<String, Object>> dataMap) {
        if (putData == null || putData.date == null) {
            return;
        }
        Map<String, Object> map = dataMap.get(putData.key);
        boolean isRequire = "B".equals(putData.type);
        if (isRequire) {
            putData.qty = BigDecimal.ZERO.subtract(putData.qty);
        }
        String source = putData.billno;
        if (StringUtils.isNotBlank((CharSequence)putData.entryseq) && StringUtils.isNotBlank((CharSequence)putData.billno)) {
            source = String.format("%s_%s", putData.billno, putData.entryseq);
        }
        if (map == null) {
            map = new HashMap<String, Object>(13);
            map.put("date", putData.date);
            map.put("type", putData.type);
            map.put("priority", putData.priority);
            map.put("billtype", putData.billType);
            map.put("billno", putData.billno);
            map.put("entryseq", putData.entryseq);
            map.put("bomversion", putData.bomversion);
            map.put("qty", putData.qty);
            map.put("useqty", BigDecimal.ZERO);
            map.put("org", putData.org);
            map.put("unit", putData.unit);
            map.put("material", putData.material);
            map.put("source", source);
            map.put("materialattribute", putData.attr);
            map.put("planscope", putData.planscope);
            map.put("configuredcode", putData.configuredcode);
            map.put("tracknumber", putData.tracknumber);
            map.put("project", putData.project);
            map.put("auxpty", putData.auxpty);
            map.put("billid", putData.billid);
            map.put("billentity", putData.billentity);
            dataMap.put(putData.key, map);
        } else {
            map.put("qty", putData.qty.add((BigDecimal)map.get("qty")));
        }
    }

    private DataSet getReturnData(List<Map<String, Object>> list) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("date", (DataType)DateType.DateType, true));
        fields.add(new Field("type", (DataType)DateType.StringType, true));
        fields.add(new Field("priority", (DataType)DateType.StringType, true));
        fields.add(new Field("billtype", (DataType)DateType.StringType, true));
        fields.add(new Field("billno", (DataType)DateType.StringType, true));
        fields.add(new Field("entryseq", (DataType)DateType.StringType, true));
        fields.add(new Field("bomversion", (DataType)DateType.StringType, true));
        fields.add(new Field("unit", (DataType)DateType.StringType, true));
        fields.add(new Field("qty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("useqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("org", (DataType)DateType.StringType, true));
        fields.add(new Field("material", (DataType)DateType.LongType, true));
        fields.add(new Field("source", (DataType)DateType.StringType, true));
        fields.add(new Field("materialattribute", (DataType)DateType.StringType, true));
        fields.add(new Field("planscope", (DataType)DateType.LongType, true));
        fields.add(new Field("configuredcode", (DataType)DateType.LongType, true));
        fields.add(new Field("tracknumber", (DataType)DateType.LongType, true));
        fields.add(new Field("project", (DataType)DateType.LongType, true));
        fields.add(new Field("auxpty", (DataType)DateType.LongType, true));
        fields.add(new Field("billid", (DataType)DateType.StringType, true));
        fields.add(new Field("billentity", (DataType)DateType.StringType, true));
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)this.algoKey);
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        for (Map<String, Object> entry : list) {
            Object[] values = new Object[fields.size()];
            Field[] field = metas.getFields();
            for (int i = 0; i < field.length; ++i) {
                values[i] = entry.get(field[i].getName());
            }
            builder.append(values);
        }
        return builder.build();
    }

    private static class PutData {
        public String key;
        public Date date;
        public String type;
        public String priority;
        public String billType;
        public String billno;
        public String entryseq;
        public Object bomversion;
        public BigDecimal qty;
        public Object org;
        public Object unit;
        public Object material;
        public Object attr;
        public Object planscope;
        public Object tracknumber;
        public Object project;
        public Object configuredcode;
        public Object auxpty;
        public Object billid;
        public Object billentity;
    }
}

